      MODULE LA_XLASQX
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 19, 2002
!     11-04-02:  Change INTENT of SIGMA to INOUT in xLADQ3 (eca)
!
!  Purpose
!  =======
!
!  LA_XLASQX defines generic interfaces for xLASQ1 and xLADQ2--xLADQ6,
!  which are renamed from xLASQ2--xLASQ6 to avoid incompatibilities with
!  the LAPACK 2 interface.
!
!-----Interface for xLASQ1
!
      INTERFACE LA_LASQ1

      SUBROUTINE SLASQ1( N, D, E, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SLASQ1

      SUBROUTINE DLASQ1( N, D, E, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DLASQ1

      END INTERFACE ! LA_LASQ1
!
!-----Interface for xLADQ2
!
      INTERFACE LA_LADQ2

      SUBROUTINE SLADQ2( N, Z, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Z(*)
      END SUBROUTINE SLADQ2

      SUBROUTINE DLADQ2( N, Z, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Z(*)
      END SUBROUTINE DLADQ2

      END INTERFACE ! LA_LADQ2
!
!-----Interface for xLADQ3
!
      INTERFACE LA_LADQ3

      SUBROUTINE SLADQ3( I0, N0, Z, PP, DMIN, SIGMA, DESIG, QMAX, NFAIL,
     $                   ITER, NDIV, IEEE, TTYPE, DMIN1, DMIN2, DN, DN1,
     $                   DN2, TAU )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: IEEE
         INTEGER, INTENT(IN) :: I0, N0, PP
         INTEGER, INTENT(INOUT) :: TTYPE
         INTEGER, INTENT(OUT) :: ITER, NDIV, NFAIL
         REAL(WP), INTENT(IN) :: QMAX
         REAL(WP), INTENT(INOUT) :: DESIG, DMIN1, DMIN2, DN, DN1, DN2,
     $                              SIGMA, TAU
         REAL(WP), INTENT(OUT) :: DMIN
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE SLADQ3

      SUBROUTINE DLADQ3( I0, N0, Z, PP, DMIN, SIGMA, DESIG, QMAX, NFAIL,
     $                   ITER, NDIV, IEEE, TTYPE, DMIN1, DMIN2, DN, DN1,
     $                   DN2, TAU )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: IEEE
         INTEGER, INTENT(IN) :: I0, N0, PP
         INTEGER, INTENT(INOUT) :: TTYPE
         INTEGER, INTENT(OUT) :: ITER, NDIV, NFAIL
         REAL(WP), INTENT(IN) :: QMAX
         REAL(WP), INTENT(INOUT) :: DESIG, DMIN1, DMIN2, DN, DN1, DN2,
     $                              SIGMA, TAU
         REAL(WP), INTENT(OUT) :: DMIN
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE DLADQ3

      END INTERFACE ! LA_LADQ3
!
!-----Interface for xLADQ4
!
      INTERFACE LA_LADQ4

      SUBROUTINE SLADQ4( I0, N0, Z, PP, N0IN, DMIN, DMIN1, DMIN2, DN,
     $                   DN1, DN2, TAU, TTYPE, G )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: I0, N0, N0IN, PP
         INTEGER, INTENT(OUT) :: TTYPE
         REAL(WP), INTENT(IN) :: DMIN, DMIN1, DMIN2, DN, DN1, DN2
         REAL(WP), INTENT(INOUT) :: G
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE SLADQ4

      SUBROUTINE DLADQ4( I0, N0, Z, PP, N0IN, DMIN, DMIN1, DMIN2, DN,
     $                   DN1, DN2, TAU, TTYPE, G )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I0, N0, N0IN, PP
         INTEGER, INTENT(OUT) :: TTYPE
         REAL(WP), INTENT(IN) :: DMIN, DMIN1, DMIN2, DN, DN1, DN2
         REAL(WP), INTENT(INOUT) :: G
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE DLADQ4

      END INTERFACE ! LA_LADQ4
!
!-----Interface for xLADQ5
!
      INTERFACE LA_LADQ5

      SUBROUTINE SLADQ5( I0, N0, Z, PP, TAU, DMIN, DMIN1, DMIN2, DN,
     $                   DNM1, DNM2, IEEE )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: IEEE
         INTEGER, INTENT(IN) :: I0, N0, PP
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: DMIN, DMIN1, DMIN2, DN, DNM1, DNM2
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE SLADQ5

      SUBROUTINE DLADQ5( I0, N0, Z, PP, TAU, DMIN, DMIN1, DMIN2, DN,
     $                   DNM1, DNM2, IEEE )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: IEEE
         INTEGER, INTENT(IN) :: I0, N0, PP
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: DMIN, DMIN1, DMIN2, DN, DNM1, DNM2
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE DLADQ5

      END INTERFACE ! LA_LADQ5
!
!-----Interface for xLADQ6
!
      INTERFACE LA_LADQ6

      SUBROUTINE SLADQ6( I0, N0, Z, PP, DMIN, DMIN1, DMIN2, DN,
     $                   DNM1, DNM2 )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: I0, N0, PP
         REAL(WP), INTENT(OUT) :: DMIN, DMIN1, DMIN2, DN, DNM1, DNM2
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE SLADQ6

      SUBROUTINE DLADQ6( I0, N0, Z, PP, DMIN, DMIN1, DMIN2, DN,
     $                   DNM1, DNM2 )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I0, N0, PP
         REAL(WP), INTENT(OUT) :: DMIN, DMIN1, DMIN2, DN, DNM1, DNM2
         REAL(WP), INTENT(IN) :: Z(*)
      END SUBROUTINE DLADQ6

      END INTERFACE ! LA_LADQ6

      END MODULE LA_XLASQX
