      MODULE LA_XLARRX
!
!  -- LAPACK 3E module --
!     E. Anderson
!     August 30, 2002
!
!  Purpose
!  =======
!
!  LA_XLARRX defines generic interfaces for xLARRV, xLARRB, xLARRE,
!  xLARRF, and xLAR1V.
!
!-----Interface for xLAR1V
!
      INTERFACE LA_LAR1V

      SUBROUTINE SLAR1V( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                   GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ
         REAL(WP), INTENT(IN) :: D, GERSCH, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLAR1V

      SUBROUTINE DLAR1V( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                   GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ
         REAL(WP), INTENT(IN) :: D, GERSCH, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLAR1V

      SUBROUTINE CLAR1V( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                   GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ
         REAL(WP), INTENT(IN) :: D, GERSCH, L, LD, LLD
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE CLAR1V

      SUBROUTINE ZLAR1V( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                   GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ
         REAL(WP), INTENT(IN) :: D, GERSCH, L, LD, LLD
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE ZLAR1V

      MODULE PROCEDURE SLAR1V_D1Z1W1
      MODULE PROCEDURE DLAR1V_D1Z1W1
      MODULE PROCEDURE CLAR1V_D1Z1W1
      MODULE PROCEDURE ZLAR1V_D1Z1W1

      END INTERFACE ! LA_LAR1V
      PRIVATE SLAR1V_D1Z1W1, DLAR1V_D1Z1W1, CLAR1V_D1Z1W1, ZLAR1V_D1Z1W1
!
!-----Interface for xLARRB
!
      INTERFACE LA_LARRB

      SUBROUTINE SLARRB( N, D, L, LD, LLD, IFIRST, ILAST, RTOL1, RTOL2,
     $                   OFFSET, W, WGAP, WERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N, OFFSET
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RTOL1, RTOL2
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: D, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: W, WERR, WGAP
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARRB

      SUBROUTINE DLARRB( N, D, L, LD, LLD, IFIRST, ILAST, RTOL1, RTOL2,
     $                   OFFSET, W, WGAP, WERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N, OFFSET
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RTOL1, RTOL2
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: D, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: W, WERR, WGAP
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLARRB

      MODULE PROCEDURE SLARRB_D1E1W1
      MODULE PROCEDURE DLARRB_D1E1W1

      END INTERFACE ! LA_LARRB
      PRIVATE SLARRB_D1E1W1, DLARRB_D1E1W1
!
!-----Interface for xLARRE
!
      INTERFACE LA_LARRE

      SUBROUTINE SLARRE( RANGE, N, VL, VU, IL, IU, D, E, TOL, NSPLIT,
     $                   ISPLIT, M, W, IBLOCK, INDEXW, GERSCH, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: TOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK, INDEXW, ISPLIT, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: GERSCH, W, WORK
      END SUBROUTINE SLARRE

      SUBROUTINE DLARRE( RANGE, N, VL, VU, IL, IU, D, E, TOL, NSPLIT,
     $                   ISPLIT, M, W, IBLOCK, INDEXW, GERSCH, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: TOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK, INDEXW, ISPLIT, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: GERSCH, W, WORK
      END SUBROUTINE DLARRE

      MODULE PROCEDURE SLARRE_D1I1W1
      MODULE PROCEDURE DLARRE_D1I1W1

      END INTERFACE ! LA_LARRE
      PRIVATE SLARRE_D1I1W1, DLARRE_D1I1W1
!
!-----Interface for xLARRF
!
      INTERFACE LA_LARRF

      SUBROUTINE SLARRF( N, D, L, LD, LLD, IFIRST, ILAST, W, SIGMA,
     $                   DPLUS, LPLUS, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: W
         REAL(WP), INTENT(OUT) :: DPLUS, LPLUS, WORK
      END SUBROUTINE SLARRF

      SUBROUTINE DLARRF( N, D, L, LD, LLD, IFIRST, ILAST, W, SIGMA,
     $                   DPLUS, LPLUS, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D, L, LD, LLD
         REAL(WP), INTENT(INOUT) :: W
         REAL(WP), INTENT(OUT) :: DPLUS, LPLUS, WORK
      END SUBROUTINE DLARRF

      MODULE PROCEDURE SLARRF_D1L1
      MODULE PROCEDURE DLARRF_D1L1

      END INTERFACE ! LA_LARRF
      PRIVATE SLARRF_D1L1, DLARRF_D1L1
!
!-----Interface for xLARRV
!
      INTERFACE LA_LARRV

      SUBROUTINE SLARRV( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW, GERSCH,
     $                   TOL, Z, LDZ, ISUPPZ, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK, INDEXW, ISPLIT
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: GERSCH, W
         REAL(WP), INTENT(INOUT) :: D, L
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SLARRV

      SUBROUTINE DLARRV( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW, GERSCH,
     $                   TOL, Z, LDZ, ISUPPZ, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK, INDEXW, ISPLIT
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: GERSCH, W
         REAL(WP), INTENT(INOUT) :: D, L
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DLARRV

      SUBROUTINE CLARRV( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW, GERSCH,
     $                   TOL, Z, LDZ, ISUPPZ, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK, INDEXW, ISPLIT
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: GERSCH, W
         REAL(WP), INTENT(INOUT) :: D, L
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE CLARRV

      SUBROUTINE ZLARRV( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW, GERSCH,
     $                   TOL, Z, LDZ, ISUPPZ, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK, INDEXW, ISPLIT
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: GERSCH, W
         REAL(WP), INTENT(INOUT) :: D, L
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE ZLARRV

      MODULE PROCEDURE SLARRV_D1Z2W1
      MODULE PROCEDURE DLARRV_D1Z2W1
      MODULE PROCEDURE CLARRV_D1Z2W1
      MODULE PROCEDURE ZLARRV_D1Z2W1

      END INTERFACE ! LA_LARRV
      PRIVATE SLARRV_D1Z2W1, DLARRV_D1Z2W1, CLARRV_D1Z2W1, ZLARRV_D1Z2W1

      CONTAINS
!
!-----Natural interface for xLAR1V
!
      SUBROUTINE SLAR1V_D1Z1W1( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                          GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK)
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ(*)
         REAL(WP), INTENT(IN) :: D(*), GERSCH(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: Z(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLAR1V( N, B1, BN, SIGMA, D(1), L(1), LD(1), LLD(1),
     $                EVAL, GERSCH(1), Z(1), ZTZ, MINGMA, R, ISUPPZ(1),
     $                WORK(1) )
      END SUBROUTINE SLAR1V_D1Z1W1

      SUBROUTINE DLAR1V_D1Z1W1( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                          GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK)
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ(*)
         REAL(WP), INTENT(IN) :: D(*), GERSCH(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: Z(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLAR1V( N, B1, BN, SIGMA, D(1), L(1), LD(1), LLD(1),
     $                EVAL, GERSCH(1), Z(1), ZTZ, MINGMA, R, ISUPPZ(1),
     $                WORK(1) )
      END SUBROUTINE DLAR1V_D1Z1W1

      SUBROUTINE CLAR1V_D1Z1W1( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                          GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK)
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ(*)
         REAL(WP), INTENT(IN) :: D(*), GERSCH(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(*)
         CALL CLAR1V( N, B1, BN, SIGMA, D(1), L(1), LD(1), LLD(1),
     $                EVAL, GERSCH(1), Z(1), ZTZ, MINGMA, R, ISUPPZ(1),
     $                WORK(1) )
      END SUBROUTINE CLAR1V_D1Z1W1

      SUBROUTINE ZLAR1V_D1Z1W1( N, B1, BN, SIGMA, D, L, LD, LLD, EVAL,
     $                          GERSCH, Z, ZTZ, MINGMA, R, ISUPPZ, WORK)
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: B1, BN, N
         INTEGER, INTENT(INOUT) :: R
         REAL(WP), INTENT(IN) :: EVAL, SIGMA
         REAL(WP), INTENT(OUT) :: MINGMA, ZTZ
         INTEGER, INTENT(OUT) :: ISUPPZ(*)
         REAL(WP), INTENT(IN) :: D(*), GERSCH(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(*)
         CALL ZLAR1V( N, B1, BN, SIGMA, D(1), L(1), LD(1), LLD(1),
     $                EVAL, GERSCH(1), Z(1), ZTZ, MINGMA, R, ISUPPZ(1),
     $                WORK(1) )
      END SUBROUTINE ZLAR1V_D1Z1W1
!
!-----Natural interface for xLARRB
!
      SUBROUTINE SLARRB_D1E1W1( N, D, L, LD, LLD, IFIRST, ILAST, RTOL1,
     $                          RTOL2, OFFSET, W, WGAP, WERR, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N, OFFSET
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RTOL1, RTOL2
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: W(*), WERR(*), WGAP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLARRB( N, D(1), L(1), LD(1), LLD(1), IFIRST, ILAST,
     $                RTOL1, RTOL2, OFFSET, W(1), WGAP(1), WERR(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLARRB_D1E1W1

      SUBROUTINE DLARRB_D1E1W1( N, D, L, LD, LLD, IFIRST, ILAST, RTOL1,
     $                          RTOL2, OFFSET, W, WGAP, WERR, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N, OFFSET
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RTOL1, RTOL2
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: W(*), WERR(*), WGAP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLARRB( N, D(1), L(1), LD(1), LLD(1), IFIRST, ILAST,
     $                RTOL1, RTOL2, OFFSET, W(1), WGAP(1), WERR(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLARRB_D1E1W1
!
!-----Natural interface for xLARRE
!
      SUBROUTINE SLARRE_D1I1W1( RANGE, N, VL, VU, IL, IU, D, E, TOL,
     $                          NSPLIT, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: TOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK(*), INDEXW(*), ISPLIT(*),
     $                           IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: GERSCH(*), W(*), WORK(*)
         CALL SLARRE( RANGE, N, VL, VU, IL, IU, D(1), E(1), TOL, NSPLIT,
     $                ISPLIT(1), M, W(1), IBLOCK(1), INDEXW(1),
     $                GERSCH(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLARRE_D1I1W1

      SUBROUTINE DLARRE_D1I1W1( RANGE, N, VL, VU, IL, IU, D, E, TOL,
     $                          NSPLIT, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: TOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK(*), INDEXW(*), ISPLIT(*),
     $                           IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: GERSCH(*), W(*), WORK(*)
         CALL DLARRE( RANGE, N, VL, VU, IL, IU, D(1), E(1), TOL, NSPLIT,
     $                ISPLIT(1), M, W(1), IBLOCK(1), INDEXW(1),
     $                GERSCH(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLARRE_D1I1W1
!
!-----Natural interface for xLARRF
!
      SUBROUTINE SLARRF_D1L1( N, D, L, LD, LLD, IFIRST, ILAST, W,
     $                        SIGMA, DPLUS, LPLUS, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: W(*)
         REAL(WP), INTENT(OUT) :: DPLUS(*), LPLUS(*), WORK(*)
         CALL SLARRF( N, D(1), L(1), LD(1), LLD(1), IFIRST, ILAST, W(1),
     $                SIGMA, DPLUS(1), LPLUS(1), WORK(1), INFO )
      END SUBROUTINE SLARRF_D1L1

      SUBROUTINE DLARRF_D1L1( N, D, L, LD, LLD, IFIRST, ILAST, W,
     $                        SIGMA, DPLUS, LPLUS, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IFIRST, ILAST, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), L(*), LD(*), LLD(*)
         REAL(WP), INTENT(INOUT) :: W(*)
         REAL(WP), INTENT(OUT) :: DPLUS(*), LPLUS(*), WORK(*)
         CALL DLARRF( N, D(1), L(1), LD(1), LLD(1), IFIRST, ILAST, W(1),
     $                SIGMA, DPLUS(1), LPLUS(1), WORK(1), INFO )
      END SUBROUTINE DLARRF_D1L1
!
!-----Natural interface for xLARRV
!
      SUBROUTINE SLARRV_D1Z2W1( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, TOL, Z, LDZ, ISUPPZ, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK(*), INDEXW(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GERSCH(*), W(*)
         REAL(WP), INTENT(INOUT) :: D(*), L(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SLARRV( N, D(1), L(1), ISPLIT(1), M, W(1), IBLOCK(1),
     $                INDEXW(1), GERSCH(1), TOL, Z(1,1), LDZ, ISUPPZ(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLARRV_D1Z2W1

      SUBROUTINE DLARRV_D1Z2W1( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, TOL, Z, LDZ, ISUPPZ, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK(*), INDEXW(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GERSCH(*), W(*)
         REAL(WP), INTENT(INOUT) :: D(*), L(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DLARRV( N, D(1), L(1), ISPLIT(1), M, W(1), IBLOCK(1),
     $                INDEXW(1), GERSCH(1), TOL, Z(1,1), LDZ, ISUPPZ(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLARRV_D1Z2W1

      SUBROUTINE CLARRV_D1Z2W1( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, TOL, Z, LDZ, ISUPPZ, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK(*), INDEXW(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GERSCH(*), W(*)
         REAL(WP), INTENT(INOUT) :: D(*), L(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL CLARRV( N, D(1), L(1), ISPLIT(1), M, W(1), IBLOCK(1),
     $                INDEXW(1), GERSCH(1), TOL, Z(1,1), LDZ, ISUPPZ(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE CLARRV_D1Z2W1

      SUBROUTINE ZLARRV_D1Z2W1( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW,
     $                          GERSCH, TOL, Z, LDZ, ISUPPZ, WORK,
     $                          IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TOL
         INTEGER, INTENT(IN) :: IBLOCK(*), INDEXW(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GERSCH(*), W(*)
         REAL(WP), INTENT(INOUT) :: D(*), L(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL ZLARRV( N, D(1), L(1), ISPLIT(1), M, W(1), IBLOCK(1),
     $                INDEXW(1), GERSCH(1), TOL, Z(1,1), LDZ, ISUPPZ(1),
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE ZLARRV_D1Z2W1

      END MODULE LA_XLARRX
