      MODULE LA_XLAQGE
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 9, 2002
!
!  Purpose
!  =======
!
!  LA_XLAQGE defines a generic interface for xLAQGE.
!
      INTERFACE LA_LAQGE

      SUBROUTINE SLAQGE( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     $                   EQUED )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(OUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: C(*), R(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE SLAQGE

      SUBROUTINE DLAQGE( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     $                   EQUED )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(OUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: C(*), R(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE DLAQGE

      SUBROUTINE CLAQGE( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     $                   EQUED )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(OUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: C(*), R(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE CLAQGE

      SUBROUTINE ZLAQGE( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     $                   EQUED )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(OUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: C(*), R(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE ZLAQGE

      END INTERFACE ! LA_LAQGE

      END MODULE LA_XLAQGE
