      MODULE LA_XLALSD
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 19, 2002
!
!  Purpose
!  =======
!
!  LA_XLALSD defines generic interfaces for xLALSD.
!
      INTERFACE LA_LALSD

      SUBROUTINE SLALSD( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                   RANK, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: B, D, E
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLALSD

      SUBROUTINE DLALSD( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                   RANK, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: B, D, E
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLALSD

      SUBROUTINE CLALSD( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                   RANK, WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLALSD

      SUBROUTINE ZLALSD( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                   RANK, WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZLALSD

      MODULE PROCEDURE SLALSD_NAT
      MODULE PROCEDURE DLALSD_NAT
      MODULE PROCEDURE CLALSD_NAT
      MODULE PROCEDURE ZLALSD_NAT

      END INTERFACE ! LA_LALSD
      PRIVATE SLALSD_NAT, DLALSD_NAT, CLALSD_NAT, ZLALSD_NAT

      CONTAINS
!
!-----Natural interface for xLALSD
!
      SUBROUTINE SLALSD_NAT( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                       RANK, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLALSD( UPLO, SMLSIZ, N, NRHS, D(1), E(1), B(1,1), LDB,
     $                RCOND, RANK, WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLALSD_NAT

      SUBROUTINE DLALSD_NAT( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                       RANK, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLALSD( UPLO, SMLSIZ, N, NRHS, D(1), E(1), B(1,1), LDB,
     $                RCOND, RANK, WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLALSD_NAT

      SUBROUTINE CLALSD_NAT( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                       RANK, WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLALSD( UPLO, SMLSIZ, N, NRHS, D(1), E(1), B(1,1), LDB,
     $                RCOND, RANK, WORK(1), RWORK(1), IWORK(1), INFO )
      END SUBROUTINE CLALSD_NAT

      SUBROUTINE ZLALSD_NAT( UPLO, SMLSIZ, N, NRHS, D, E, B, LDB, RCOND,
     $                       RANK, WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS, SMLSIZ
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZLALSD( UPLO, SMLSIZ, N, NRHS, D(1), E(1), B(1,1), LDB,
     $                RCOND, RANK, WORK(1), RWORK(1), IWORK(1), INFO )
      END SUBROUTINE ZLALSD_NAT

      END MODULE LA_XLALSD
