      MODULE LA_XLALSA
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 19, 2002
!
!  Purpose
!  =======
!
!  LA_XLALSA defines generic interfaces for xLALSA.
!
      INTERFACE LA_LALSA

      SUBROUTINE SLALSA( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX, U,
     $                   LDU, VT, K, DIFL, DIFR, Z, POLES, GIVPTR,
     $                   GIVCOL, LDGCOL, PERM, GIVNUM, C, S, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, K, PERM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: B, C, DIFL, DIFR, GIVNUM, POLES, S, U,
     $                           VT, Z
         REAL(WP), INTENT(OUT) :: BX, WORK
      END SUBROUTINE SLALSA

      SUBROUTINE DLALSA( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX, U,
     $                   LDU, VT, K, DIFL, DIFR, Z, POLES, GIVPTR,
     $                   GIVCOL, LDGCOL, PERM, GIVNUM, C, S, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, K, PERM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: B, C, DIFL, DIFR, GIVNUM, POLES, S, U,
     $                           VT, Z
         REAL(WP), INTENT(OUT) :: BX, WORK
      END SUBROUTINE DLALSA

      SUBROUTINE CLALSA( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX, U,
     $                   LDU, VT, K, DIFL, DIFR, Z, POLES, GIVPTR,
     $                   GIVCOL, LDGCOL, PERM, GIVNUM, C, S, RWORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, K, PERM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: C, DIFL, DIFR, GIVNUM, POLES, S, U, VT,
     $                           Z
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: B
         COMPLEX(WP), INTENT(OUT) :: BX
      END SUBROUTINE CLALSA

      SUBROUTINE ZLALSA( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX, U,
     $                   LDU, VT, K, DIFL, DIFR, Z, POLES, GIVPTR,
     $                   GIVCOL, LDGCOL, PERM, GIVNUM, C, S, RWORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, K, PERM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: C, DIFL, DIFR, GIVNUM, POLES, S, U, VT,
     $                           Z
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: B
         COMPLEX(WP), INTENT(OUT) :: BX
      END SUBROUTINE ZLALSA

      MODULE PROCEDURE SLALSA_NAT
      MODULE PROCEDURE DLALSA_NAT
      MODULE PROCEDURE CLALSA_NAT
      MODULE PROCEDURE ZLALSA_NAT

      END INTERFACE ! LA_LALSA
      PRIVATE SLALSA_NAT, DLALSA_NAT, CLALSA_NAT, ZLALSA_NAT

      CONTAINS
!
!-----Natural interface for xLALSA
!
      SUBROUTINE SLALSA_NAT( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX,
     $                       U, LDU, VT, K, DIFL, DIFR, Z, POLES,
     $                       GIVPTR, GIVCOL, LDGCOL, PERM, GIVNUM, C, S,
     $                       WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), GIVPTR(*), K(*),
     $                          PERM(LDGCOL,*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), C(*), DIFL(LDU,*),
     $                           DIFR(LDU,*), GIVNUM(LDU,*),
     $                           POLES(LDU,*), S(*), U(LDU,*),
     $                           VT(LDU,*), Z(LDU,*)
         REAL(WP), INTENT(OUT) :: BX(LDBX,*), WORK(*)
         CALL SLALSA( ICOMPQ, SMLSIZ, N, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, U(1,1), LDU, VT(1,1), K(1), DIFL(1,1),
     $                DIFR(1,1), Z(1,1), POLES(1,1), GIVPTR(1),
     $                GIVCOL(1,1), LDGCOL, PERM(1,1), GIVNUM(1,1),
     $                C(1), S(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLALSA_NAT

      SUBROUTINE DLALSA_NAT( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX,
     $                       U, LDU, VT, K, DIFL, DIFR, Z, POLES,
     $                       GIVPTR, GIVCOL, LDGCOL, PERM, GIVNUM, C, S,
     $                       WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), GIVPTR(*), K(*),
     $                          PERM(LDGCOL,*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), C(*), DIFL(LDU,*),
     $                           DIFR(LDU,*), GIVNUM(LDU,*),
     $                           POLES(LDU,*), S(*), U(LDU,*),
     $                           VT(LDU,*), Z(LDU,*)
         REAL(WP), INTENT(OUT) :: BX(LDBX,*), WORK(*)
         CALL DLALSA( ICOMPQ, SMLSIZ, N, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, U(1,1), LDU, VT(1,1), K(1), DIFL(1,1),
     $                DIFR(1,1), Z(1,1), POLES(1,1), GIVPTR(1),
     $                GIVCOL(1,1), LDGCOL, PERM(1,1), GIVNUM(1,1),
     $                C(1), S(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLALSA_NAT

      SUBROUTINE CLALSA_NAT( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX,
     $                       U, LDU, VT, K, DIFL, DIFR, Z, POLES,
     $                       GIVPTR, GIVCOL, LDGCOL, PERM, GIVNUM, C, S,
     $                       RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), GIVPTR(*), K(*),
     $                          PERM(LDGCOL,*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: C(*), DIFL(LDU,*), DIFR(LDU,*),
     $                           GIVNUM(LDU,*), POLES(LDU,*), S(*),
     $                           U(LDU,*), VT(LDU,*), Z(LDU,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: BX(LDBX,*)
         CALL CLALSA( ICOMPQ, SMLSIZ, N, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, U(1,1), LDU, VT(1,1), K(1), DIFL(1,1),
     $                DIFR(1,1), Z(1,1), POLES(1,1), GIVPTR(1),
     $                GIVCOL(1,1), LDGCOL, PERM(1,1), GIVNUM(1,1),
     $                C(1), S(1), RWORK(1), IWORK(1), INFO )
      END SUBROUTINE CLALSA_NAT

      SUBROUTINE ZLALSA_NAT( ICOMPQ, SMLSIZ, N, NRHS, B, LDB, BX, LDBX,
     $                       U, LDU, VT, K, DIFL, DIFR, Z, POLES,
     $                       GIVPTR, GIVCOL, LDGCOL, PERM, GIVNUM, C, S,
     $                       RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDB, LDBX, LDGCOL, LDU, N, NRHS,
     $                          SMLSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), GIVPTR(*), K(*),
     $                          PERM(LDGCOL,*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: C(*), DIFL(LDU,*), DIFR(LDU,*),
     $                           GIVNUM(LDU,*), POLES(LDU,*), S(*),
     $                           U(LDU,*), VT(LDU,*), Z(LDU,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: BX(LDBX,*)
         CALL ZLALSA( ICOMPQ, SMLSIZ, N, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, U(1,1), LDU, VT(1,1), K(1), DIFL(1,1),
     $                DIFR(1,1), Z(1,1), POLES(1,1), GIVPTR(1),
     $                GIVCOL(1,1), LDGCOL, PERM(1,1), GIVNUM(1,1),
     $                C(1), S(1), RWORK(1), IWORK(1), INFO )
      END SUBROUTINE ZLALSA_NAT

      END MODULE LA_XLALSA
