      MODULE LA_XLAIC1
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 10, 2002
!
!  Purpose
!  =======
!
!  LA_XLAIC1 defines a generic interface for xLAIC1.
!
      INTERFACE LA_LAIC1

      SUBROUTINE SLAIC1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: GAMMA, SEST
         REAL(WP), INTENT(OUT) :: C, S, SESTPR
         REAL(WP), INTENT(IN) :: W, X
      END SUBROUTINE SLAIC1

      SUBROUTINE DLAIC1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: GAMMA, SEST
         REAL(WP), INTENT(OUT) :: C, S, SESTPR
         REAL(WP), INTENT(IN) :: W, X
      END SUBROUTINE DLAIC1

      SUBROUTINE CLAIC1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: SEST
         COMPLEX(WP), INTENT(IN) :: GAMMA
         REAL(WP), INTENT(OUT) :: SESTPR
         COMPLEX(WP), INTENT(OUT) :: C, S
         COMPLEX(WP), INTENT(IN) :: W, X
      END SUBROUTINE CLAIC1

      SUBROUTINE ZLAIC1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: SEST
         COMPLEX(WP), INTENT(IN) :: GAMMA
         REAL(WP), INTENT(OUT) :: SESTPR
         COMPLEX(WP), INTENT(OUT) :: C, S
         COMPLEX(WP), INTENT(IN) :: W, X
      END SUBROUTINE ZLAIC1

      MODULE PROCEDURE SLAIC1_X1W1
      MODULE PROCEDURE DLAIC1_X1W1
      MODULE PROCEDURE CLAIC1_X1W1
      MODULE PROCEDURE ZLAIC1_X1W1

      END INTERFACE ! LA_LAIC1
      PRIVATE SLAIC1_X1W1, DLAIC1_X1W1, CLAIC1_X1W1, ZLAIC1_X1W1

      CONTAINS
!
!-----Natural interface for xLAIC1
!
      SUBROUTINE SLAIC1_X1W1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: GAMMA, SEST
         REAL(WP), INTENT(OUT) :: C, S, SESTPR
         REAL(WP), INTENT(IN) :: W(J), X(J)
         CALL SLAIC1( JOB, J, X(1), SEST, W(1), GAMMA, SESTPR, S, C )
      END SUBROUTINE SLAIC1_X1W1

      SUBROUTINE DLAIC1_X1W1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: GAMMA, SEST
         REAL(WP), INTENT(OUT) :: C, S, SESTPR
         REAL(WP), INTENT(IN) :: W(J), X(J)
         CALL DLAIC1( JOB, J, X(1), SEST, W(1), GAMMA, SESTPR, S, C )
      END SUBROUTINE DLAIC1_X1W1

      SUBROUTINE CLAIC1_X1W1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: SEST
         COMPLEX(WP), INTENT(IN) :: GAMMA
         REAL(WP), INTENT(OUT) :: SESTPR
         COMPLEX(WP), INTENT(OUT) :: C, S
         COMPLEX(WP), INTENT(IN) :: W(J), X(J)
         CALL CLAIC1( JOB, J, X(1), SEST, W(1), GAMMA, SESTPR, S, C )
      END SUBROUTINE CLAIC1_X1W1

      SUBROUTINE ZLAIC1_X1W1( JOB, J, X, SEST, W, GAMMA, SESTPR, S, C )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: J, JOB
         REAL(WP), INTENT(IN) :: SEST
         COMPLEX(WP), INTENT(IN) :: GAMMA
         REAL(WP), INTENT(OUT) :: SESTPR
         COMPLEX(WP), INTENT(OUT) :: C, S
         COMPLEX(WP), INTENT(IN) :: W(J), X(J)
         CALL ZLAIC1( JOB, J, X(1), SEST, W(1), GAMMA, SESTPR, S, C )
      END SUBROUTINE ZLAIC1_X1W1

      END MODULE LA_XLAIC1
