      MODULE LA_XLAEIN
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 03, 2002
!
!  Purpose
!  =======
!
!  LA_XLAEIN defines generic interfaces for xLAEIN.
!
      INTERFACE LA_LAEIN

      SUBROUTINE SLAEIN( RIGHTV, NOINIT, N, H, LDH, WR, WI, VR, VI,
     $                   B, LDB, WORK, EPS3, SMLDUM, BIGDUM, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BIGDUM, EPS3, SMLDUM, WI, WR
         REAL(WP), INTENT(IN) :: H
         REAL(WP), INTENT(INOUT) :: VI, VR
         REAL(WP), INTENT(OUT) :: B, WORK
      END SUBROUTINE SLAEIN

      SUBROUTINE DLAEIN( RIGHTV, NOINIT, N, H, LDH, WR, WI, VR, VI,
     $                   B, LDB, WORK, EPS3, SMLDUM, BIGDUM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BIGDUM, EPS3, SMLDUM, WI, WR
         REAL(WP), INTENT(IN) :: H
         REAL(WP), INTENT(INOUT) :: VI, VR
         REAL(WP), INTENT(OUT) :: B, WORK
      END SUBROUTINE DLAEIN

      SUBROUTINE CLAEIN( RIGHTV, NOINIT, N, H, LDH, W, V, B, LDB,
     $                   RWORK, EPS3, SMLDUM, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: EPS3, SMLDUM
         COMPLEX(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: H
         COMPLEX(WP), INTENT(INOUT) :: V
         COMPLEX(WP), INTENT(OUT) :: B
      END SUBROUTINE CLAEIN

      SUBROUTINE ZLAEIN( RIGHTV, NOINIT, N, H, LDH, W, V, B, LDB,
     $                   RWORK, EPS3, SMLDUM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: EPS3, SMLDUM
         COMPLEX(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: H
         COMPLEX(WP), INTENT(INOUT) :: V
         COMPLEX(WP), INTENT(OUT) :: B
      END SUBROUTINE ZLAEIN

      MODULE PROCEDURE SLAEIN_H2V1B2
      MODULE PROCEDURE DLAEIN_H2V1B2
      MODULE PROCEDURE CLAEIN_H2V1B2
      MODULE PROCEDURE ZLAEIN_H2V1B2

      END INTERFACE ! LA_LAEIN
      PRIVATE SLAEIN_H2V1B2, DLAEIN_H2V1B2, CLAEIN_H2V1B2, ZLAEIN_H2V1B2

      CONTAINS
!
!-----Natural interface for xLAEIN
!
      SUBROUTINE SLAEIN_H2V1B2( RIGHTV, NOINIT, N, H, LDH, WR, WI, VR,
     $                          VI, B, LDB, WORK, EPS3, SMLDUM, BIGDUM,
     $                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BIGDUM, EPS3, SMLDUM, WI, WR
         REAL(WP), INTENT(IN) :: H(LDH,*)
         REAL(WP), INTENT(INOUT) :: VI(*), VR(*)
         REAL(WP), INTENT(OUT) :: B(LDB,*), WORK(*)
         CALL SLAEIN( RIGHTV, NOINIT, N, H(1,1), LDH, WR, WI, VR(1),
     $                VI(1), B(1,1), LDB, WORK(1), EPS3, SMLDUM, BIGDUM,
     $                INFO )
      END SUBROUTINE SLAEIN_H2V1B2

      SUBROUTINE DLAEIN_H2V1B2( RIGHTV, NOINIT, N, H, LDH, WR, WI, VR,
     $                          VI, B, LDB, WORK, EPS3, SMLDUM, BIGDUM,
     $                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BIGDUM, EPS3, SMLDUM, WI, WR
         REAL(WP), INTENT(IN) :: H(LDH,*)
         REAL(WP), INTENT(INOUT) :: VI(*), VR(*)
         REAL(WP), INTENT(OUT) :: B(LDB,*), WORK(*)
         CALL DLAEIN( RIGHTV, NOINIT, N, H(1,1), LDH, WR, WI, VR(1),
     $                VI(1), B(1,1), LDB, WORK(1), EPS3, SMLDUM, BIGDUM,
     $                INFO )
      END SUBROUTINE DLAEIN_H2V1B2

      SUBROUTINE CLAEIN_H2V1B2( RIGHTV, NOINIT, N, H, LDH, W, V, B, LDB,
     $                          RWORK, EPS3, SMLDUM, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: EPS3, SMLDUM
         COMPLEX(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: H(LDH,*)
         COMPLEX(WP), INTENT(INOUT) :: V(*)
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL CLAEIN( RIGHTV, NOINIT, N, H(1,1), LDH, W, V(1),
     $                B(1,1), LDB, RWORK(1), EPS3, SMLDUM, INFO)
      END SUBROUTINE CLAEIN_H2V1B2

      SUBROUTINE ZLAEIN_H2V1B2( RIGHTV, NOINIT, N, H, LDH, W, V, B, LDB,
     $                          RWORK, EPS3, SMLDUM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: NOINIT, RIGHTV
         INTEGER, INTENT(IN) :: LDB, LDH, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: EPS3, SMLDUM
         COMPLEX(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: H(LDH,*)
         COMPLEX(WP), INTENT(INOUT) :: V(*)
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL ZLAEIN( RIGHTV, NOINIT, N, H(1,1), LDH, W, V(1),
     $                B(1,1), LDB, RWORK(1), EPS3, SMLDUM, INFO)
      END SUBROUTINE ZLAEIN_H2V1B2

      END MODULE LA_XLAEIN
