      MODULE LA_XHPTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 23, 2002
!
!  Purpose
!  =======
!
!  LA_XHPTS2 defines a generic interface for xHPTS2.
!
      INTERFACE LA_HPTS2

      SUBROUTINE CHPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CHPTS2

      SUBROUTINE ZHPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZHPTS2

      MODULE PROCEDURE CHPTS2_A1I1B2
      MODULE PROCEDURE ZHPTS2_A1I1B2

      MODULE PROCEDURE CHPTS2_A1I1B1
      MODULE PROCEDURE ZHPTS2_A1I1B1

      END INTERFACE ! LA_HPTS2
      PRIVATE CHPTS2_A1I1B2, ZHPTS2_A1I1B2, CHPTS2_A1I1B1, ZHPTS2_A1I1B1

      CONTAINS

      SUBROUTINE CHPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CHPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE CHPTS2_A1I1B2

      SUBROUTINE ZHPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZHPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE ZHPTS2_A1I1B2

      SUBROUTINE CHPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CHPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE CHPTS2_A1I1B1

      SUBROUTINE ZHPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZHPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE ZHPTS2_A1I1B1

      END MODULE LA_XHPTS2
