      MODULE LA_XHETF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 22, 2002
!
!  Purpose
!  =======
!
!  LA_XHETF2 defines generic interfaces for xHETF2 and xLAHEF.
!
      INTERFACE LA_LAHEF

      SUBROUTINE CLAHEF( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, W
      END SUBROUTINE CLAHEF

      SUBROUTINE ZLAHEF( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, W
      END SUBROUTINE ZLAHEF

      MODULE PROCEDURE CLAHEF_A2I1W2
      MODULE PROCEDURE ZLAHEF_A2I1W2

      END INTERFACE ! LA_LAHEF
      PRIVATE CLAHEF_A2I1W2, ZLAHEF_A2I1W2

      INTERFACE LA_HETF2

      SUBROUTINE CHETF2( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CHETF2

      SUBROUTINE ZHETF2( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE ZHETF2

      MODULE PROCEDURE CHETF2_A2I1
      MODULE PROCEDURE ZHETF2_A2I1

      END INTERFACE ! LA_HETF2
      PRIVATE CHETF2_A2I1, ZHETF2_A2I1

      CONTAINS

      SUBROUTINE CLAHEF_A2I1W2( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW,
     $                          INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), W(LDW,*)
         CALL CLAHEF( UPLO, N, NB, KB, A(1,1), LDA, IPIV(1), W(1,1),
     $                LDW, INFO )
      END SUBROUTINE CLAHEF_A2I1W2

      SUBROUTINE ZLAHEF_A2I1W2( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW,
     $                          INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), W(LDW,*)
         CALL ZLAHEF( UPLO, N, NB, KB, A(1,1), LDA, IPIV(1), W(1,1),
     $                LDW, INFO )
      END SUBROUTINE ZLAHEF_A2I1W2

      SUBROUTINE CHETF2_A2I1( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CHETF2( UPLO, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE CHETF2_A2I1

      SUBROUTINE ZHETF2_A2I1( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL ZHETF2( UPLO, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE ZHETF2_A2I1

      END MODULE LA_XHETF2
