      MODULE LA_XGETF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 11, 2002
!
!  Purpose
!  =======
!
!  LA_XGETF2 defines a generic interface for xGETF2.
!
      INTERFACE LA_GETF2

      SUBROUTINE SGETF2( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE SGETF2

      SUBROUTINE DGETF2( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE DGETF2

      SUBROUTINE CGETF2( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE CGETF2

      SUBROUTINE ZGETF2( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE ZGETF2

      MODULE PROCEDURE SGETF2_A2I1
      MODULE PROCEDURE DGETF2_A2I1
      MODULE PROCEDURE CGETF2_A2I1
      MODULE PROCEDURE ZGETF2_A2I1

      END INTERFACE ! LA_GETF2
      PRIVATE SGETF2_A2I1, DGETF2_A2I1, CGETF2_A2I1, ZGETF2_A2I1

      CONTAINS

      SUBROUTINE SGETF2_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL SGETF2( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE SGETF2_A2I1

      SUBROUTINE DGETF2_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL DGETF2( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE DGETF2_A2I1

      SUBROUTINE CGETF2_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL CGETF2( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE CGETF2_A2I1

      SUBROUTINE ZGETF2_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL ZGETF2( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE ZGETF2_A2I1

      END MODULE LA_XGETF2
