      MODULE LA_XGERQ2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 26, 2002
!
!  Purpose
!  =======
!
!  LA_XGERQ2 defines generic interfaces for xGERQ2, xORGR2/xUNGR2,
!  and xORMR2/xUNMR2.
!
      INTERFACE LA_GERQ2

      SUBROUTINE SGERQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGERQ2

      SUBROUTINE DGERQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGERQ2

      SUBROUTINE CGERQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGERQ2

      SUBROUTINE ZGERQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGERQ2

      MODULE PROCEDURE SGERQ2_A2T1W1
      MODULE PROCEDURE DGERQ2_A2T1W1
      MODULE PROCEDURE CGERQ2_A2T1W1
      MODULE PROCEDURE ZGERQ2_A2T1W1

      END INTERFACE ! LA_GERQ2
      PRIVATE SGERQ2_A2T1W1, DGERQ2_A2T1W1, CGERQ2_A2T1W1, ZGERQ2_A2T1W1

      INTERFACE LA_ORGR2

      SUBROUTINE SORGR2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGR2

      SUBROUTINE DORGR2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGR2

      MODULE PROCEDURE SORGR2_A2T1W1
      MODULE PROCEDURE DORGR2_A2T1W1

      END INTERFACE ! LA_ORGR2

      INTERFACE LA_UNGR2

      SUBROUTINE CUNGR2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGR2

      SUBROUTINE ZUNGR2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGR2

      MODULE PROCEDURE CUNGR2_A2T1W1
      MODULE PROCEDURE ZUNGR2_A2T1W1

      END INTERFACE ! LA_UNGR2
      PRIVATE SORGR2_A2T1W1, DORGR2_A2T1W1, CUNGR2_A2T1W1, ZUNGR2_A2T1W1

      INTERFACE LA_ORMR2

      SUBROUTINE SORMR2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMR2

      SUBROUTINE DORMR2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMR2

      MODULE PROCEDURE SORMR2_A2T1W1
      MODULE PROCEDURE DORMR2_A2T1W1

      END INTERFACE ! LA_ORMR2

      INTERFACE LA_UNMR2

      SUBROUTINE CUNMR2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMR2

      SUBROUTINE ZUNMR2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMR2

      MODULE PROCEDURE CUNMR2_A2T1W1
      MODULE PROCEDURE ZUNMR2_A2T1W1

      END INTERFACE ! LA_UNMR2
      PRIVATE SORMR2_A2T1W1, DORMR2_A2T1W1, CUNMR2_A2T1W1, ZUNMR2_A2T1W1

      CONTAINS
!
!-----Natural interface for xGERQ2
!
      SUBROUTINE SGERQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGERQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SGERQ2_A2T1W1

      SUBROUTINE DGERQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGERQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DGERQ2_A2T1W1

      SUBROUTINE CGERQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGERQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CGERQ2_A2T1W1

      SUBROUTINE ZGERQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZGERQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZGERQ2_A2T1W1
!
!-----Natural interface for xORGR2/xUNGR2
!
      SUBROUTINE SORGR2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGR2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SORGR2_A2T1W1

      SUBROUTINE DORGR2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGR2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DORGR2_A2T1W1

      SUBROUTINE CUNGR2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGR2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CUNGR2_A2T1W1

      SUBROUTINE ZUNGR2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGR2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZUNGR2_A2T1W1
!
!-----Natural interface for xORMR2/xUNMR2
!
      SUBROUTINE SORMR2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMR2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE SORMR2_A2T1W1

      SUBROUTINE DORMR2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMR2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE DORMR2_A2T1W1

      SUBROUTINE CUNMR2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMR2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE CUNMR2_A2T1W1

      SUBROUTINE ZUNMR2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMR2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE ZUNMR2_A2T1W1

      END MODULE LA_XGERQ2
