      MODULE LA_XGEQL2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 26, 2002
!
!  Purpose
!  =======
!
!  LA_XGEQL2 defines generic interfaces for xGEQL2, xORG2L/xUNG2L,
!  and xORM2L/xUNM2L.
!
      INTERFACE LA_GEQL2

      SUBROUTINE SGEQL2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQL2

      SUBROUTINE DGEQL2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEQL2

      SUBROUTINE CGEQL2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEQL2

      SUBROUTINE ZGEQL2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGEQL2

      MODULE PROCEDURE SGEQL2_A2T1W1
      MODULE PROCEDURE DGEQL2_A2T1W1
      MODULE PROCEDURE CGEQL2_A2T1W1
      MODULE PROCEDURE ZGEQL2_A2T1W1

      END INTERFACE ! LA_GEQL2
      PRIVATE SGEQL2_A2T1W1, DGEQL2_A2T1W1, CGEQL2_A2T1W1, ZGEQL2_A2T1W1

      INTERFACE LA_ORG2L

      SUBROUTINE SORG2L( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORG2L

      SUBROUTINE DORG2L( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORG2L

      MODULE PROCEDURE SORG2L_A2T1W1
      MODULE PROCEDURE DORG2L_A2T1W1

      END INTERFACE ! LA_ORG2L

      INTERFACE LA_UNG2L

      SUBROUTINE CUNG2L( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNG2L

      SUBROUTINE ZUNG2L( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNG2L

      MODULE PROCEDURE CUNG2L_A2T1W1
      MODULE PROCEDURE ZUNG2L_A2T1W1

      END INTERFACE ! LA_UNG2L
      PRIVATE SORG2L_A2T1W1, DORG2L_A2T1W1, CUNG2L_A2T1W1, ZUNG2L_A2T1W1

      INTERFACE LA_ORM2L

      SUBROUTINE SORM2L( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORM2L

      SUBROUTINE DORM2L( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORM2L

      MODULE PROCEDURE SORM2L_A2T1W1
      MODULE PROCEDURE DORM2L_A2T1W1

      END INTERFACE ! LA_ORM2L

      INTERFACE LA_UNM2L

      SUBROUTINE CUNM2L( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNM2L

      SUBROUTINE ZUNM2L( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNM2L

      MODULE PROCEDURE CUNM2L_A2T1W1
      MODULE PROCEDURE ZUNM2L_A2T1W1

      END INTERFACE ! LA_UNM2L
      PRIVATE SORM2L_A2T1W1, DORM2L_A2T1W1, CUNM2L_A2T1W1, ZUNM2L_A2T1W1

      CONTAINS
!
!-----Natural interface for xGEQL2
!
      SUBROUTINE SGEQL2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGEQL2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SGEQL2_A2T1W1

      SUBROUTINE DGEQL2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGEQL2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DGEQL2_A2T1W1

      SUBROUTINE CGEQL2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGEQL2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CGEQL2_A2T1W1

      SUBROUTINE ZGEQL2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZGEQL2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZGEQL2_A2T1W1
!
!-----Natural interface for xORG2L/xUNG2L
!
      SUBROUTINE SORG2L_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORG2L( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SORG2L_A2T1W1

      SUBROUTINE DORG2L_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORG2L( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DORG2L_A2T1W1

      SUBROUTINE CUNG2L_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNG2L( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CUNG2L_A2T1W1

      SUBROUTINE ZUNG2L_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNG2L( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZUNG2L_A2T1W1
!
!-----Natural interface for xORM2L/xUNM2L
!
      SUBROUTINE SORM2L_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORM2L( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE SORM2L_A2T1W1

      SUBROUTINE DORM2L_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORM2L( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE DORM2L_A2T1W1

      SUBROUTINE CUNM2L_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNM2L( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE CUNM2L_A2T1W1

      SUBROUTINE ZUNM2L_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNM2L( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE ZUNM2L_A2T1W1

      END MODULE LA_XGEQL2
