      MODULE LA_LAPACK
!
!  -- LAPACK 3E module --
!     E. Anderson
!     July 19, 2002
!
!  Purpose
!  =======
!
!  LA_LAPACK defines interfaces for the LAPACK computational and driver
!  routines.  Many of these have been copied from LAPACK 95.
!
!-----Interface for xBDSDC
!
      INTERFACE LA_BDSDC

      SUBROUTINE SBDSDC( UPLO, COMPQ, N, D, E, U, LDU, VT, LDVT, Q,
     &                   IQ, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, UPLO
         INTEGER, INTENT(IN) :: LDU, LDVT, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IQ, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: Q, U, VT, WORK
      END SUBROUTINE SBDSDC

      SUBROUTINE DBDSDC( UPLO, COMPQ, N, D, E, U, LDU, VT, LDVT, Q,
     &                   IQ, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, UPLO
         INTEGER, INTENT(IN) :: LDU, LDVT, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IQ, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: Q, U, VT, WORK
      END SUBROUTINE DBDSDC

      MODULE PROCEDURE SBDSDC_NAT
      MODULE PROCEDURE DBDSDC_NAT

      END INTERFACE ! LA_BDSDC
      PRIVATE SBDSDC_NAT, DBDSDC_NAT
!
!-----Interface for xBDSQR
!
      INTERFACE LA_BDSQR

      SUBROUTINE SBDSQR( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT, U,
     &                   LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C, D, E, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SBDSQR

      SUBROUTINE DBDSQR( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT, U,
     &                   LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C, D, E, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DBDSQR

      SUBROUTINE CBDSQR( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT, U,
     &                   LDU, C, LDC, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: C, U, VT
         REAL(WP), INTENT(OUT) :: RWORK
      END SUBROUTINE CBDSQR

      SUBROUTINE ZBDSQR( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT, U,
     &                   LDU, C, LDC, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: C, U, VT
         REAL(WP), INTENT(OUT) :: RWORK
      END SUBROUTINE ZBDSQR

      MODULE PROCEDURE SBDSQR_V2C2W1
      MODULE PROCEDURE DBDSQR_V2C2W1
      MODULE PROCEDURE CBDSQR_V2C2W1
      MODULE PROCEDURE ZBDSQR_V2C2W1

      END INTERFACE ! LA_BDSQR
      PRIVATE SBDSQR_V2C2W1, DBDSQR_V2C2W1, CBDSQR_V2C2W1, ZBDSQR_V2C2W1
!
!-----Interface for xDISNA
!
      INTERFACE LA_DISNA

      SUBROUTINE SDISNA( JOB, M, N, D, SEP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(OUT) :: SEP
      END SUBROUTINE SDISNA

      SUBROUTINE DDISNA( JOB, M, N, D, SEP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(OUT) :: SEP
      END SUBROUTINE DDISNA

      MODULE PROCEDURE SDISNA_D1S1
      MODULE PROCEDURE DDISNA_D1S1

      END INTERFACE ! LA_DISNA
      PRIVATE SDISNA_D1S1, DDISNA_D1S1
!
!-----Interface for xGBBRD
!
      INTERFACE LA_GBBRD

      SUBROUTINE SGBBRD( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E, Q,
     &                   LDQ, PT, LDPT, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, C
         REAL(WP), INTENT(OUT) :: D, E, PT, Q, WORK
      END SUBROUTINE SGBBRD

      SUBROUTINE DGBBRD( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E, Q,
     &                   LDQ, PT, LDPT, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, C
         REAL(WP), INTENT(OUT) :: D, E, PT, Q, WORK
      END SUBROUTINE DGBBRD

      SUBROUTINE CGBBRD( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E, Q,
     &                   LDQ, PT, LDPT, C, LDC, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, C
         COMPLEX(WP), INTENT(OUT) :: PT, Q, WORK
      END SUBROUTINE CGBBRD

      SUBROUTINE ZGBBRD( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E, Q,
     &                   LDQ, PT, LDPT, C, LDC, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, C
         COMPLEX(WP), INTENT(OUT) :: PT, Q, WORK
      END SUBROUTINE ZGBBRD

      MODULE PROCEDURE SGBBRD_A2C2W1
      MODULE PROCEDURE DGBBRD_A2C2W1
      MODULE PROCEDURE CGBBRD_A2C2W1
      MODULE PROCEDURE ZGBBRD_A2C2W1

      END INTERFACE ! LA_GBBRD
      PRIVATE SGBBRD_A2C2W1, DGBBRD_A2C2W1, CGBBRD_A2C2W1, ZGBBRD_A2C2W1
!
!-----Interface for xGBCON
!
      INTERFACE LA_GBCON

      SUBROUTINE SGBCON( NORM, N, KL, KU, AB, LDAB, IPIV, ANORM, RCOND,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: KL, KU, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SGBCON

      SUBROUTINE DGBCON( NORM, N, KL, KU, AB, LDAB, IPIV, ANORM, RCOND,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: KL, KU, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DGBCON

      SUBROUTINE CGBCON( NORM, N, KL, KU, AB, LDAB, IPIV, ANORM, RCOND,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: KL, KU, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CGBCON

      SUBROUTINE ZGBCON( NORM, N, KL, KU, AB, LDAB, IPIV, ANORM, RCOND,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: KL, KU, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZGBCON

      END INTERFACE ! LA_GBCON
!
!-----Interface for xGBEQU
!
      INTERFACE LA_GBEQU

      SUBROUTINE SGBEQU( M, N, KL, KU, AB, LDAB, R, C, ROWCND, COLCND,
     &                   AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(OUT) :: C(*), R(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE SGBEQU

      SUBROUTINE DGBEQU( M, N, KL, KU, AB, LDAB, R, C, ROWCND, COLCND,
     &                   AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(OUT) :: C(*), R(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE DGBEQU

      SUBROUTINE CGBEQU( M, N, KL, KU, AB, LDAB, R, C, ROWCND, COLCND,
     &                   AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(OUT) :: C(*), R(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE CGBEQU

      SUBROUTINE ZGBEQU( M, N, KL, KU, AB, LDAB, R, C, ROWCND, COLCND,
     &                   AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(OUT) :: C(*), R(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE ZGBEQU

      END INTERFACE ! LA_GBEQU
!
!-----Interface for xGBRFS
!
      INTERFACE LA_GBRFS

      SUBROUTINE SGBRFS( TRANS, N, KL, KU, NRHS, AB, LDAB, AFB, LDAFB,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE SGBRFS

      SUBROUTINE DGBRFS( TRANS, N, KL, KU, NRHS, AB, LDAB, AFB, LDAFB,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE DGBRFS

      SUBROUTINE CGBRFS( TRANS, N, KL, KU, NRHS, AB, LDAB, AFB, LDAFB,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*), AFB(LDAFB,*),
     &                              B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE CGBRFS

      SUBROUTINE ZGBRFS( TRANS, N, KL, KU, NRHS, AB, LDAB, AFB, LDAFB,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*), AFB(LDAFB,*),
     &                              B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE ZGBRFS

      END INTERFACE ! LA_GBRFS
!
!-----Interface for xGBSV
!
      INTERFACE LA_GBSV

      SUBROUTINE SGBSV( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE SGBSV

      SUBROUTINE DGBSV( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE DGBSV

      SUBROUTINE CGBSV( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE CGBSV

      SUBROUTINE ZGBSV( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE ZGBSV

      MODULE PROCEDURE SGBSV_A2I1B2
      MODULE PROCEDURE DGBSV_A2I1B2
      MODULE PROCEDURE CGBSV_A2I1B2
      MODULE PROCEDURE ZGBSV_A2I1B2

      END INTERFACE ! LA_GBSV
      PRIVATE SGBSV_A2I1B2, DGBSV_A2I1B2, CGBSV_A2I1B2, ZGBSV_A2I1B2
!
!-----Interface for xGBSVX
!
      INTERFACE LA_GBSVX

      SUBROUTINE SGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB, AFB,
     &                   LDAFB, IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, AFB, B, C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SGBSVX

      SUBROUTINE DGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB, AFB,
     &                   LDAFB, IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, AFB, B, C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DGBSVX

      SUBROUTINE CGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB, AFB,
     &                   LDAFB, IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, AFB, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CGBSVX

      SUBROUTINE ZGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB, AFB,
     &                   LDAFB, IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, AFB, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZGBSVX

      MODULE PROCEDURE SGBSVX_A2I1B2
      MODULE PROCEDURE DGBSVX_A2I1B2
      MODULE PROCEDURE CGBSVX_A2I1B2
      MODULE PROCEDURE ZGBSVX_A2I1B2

      END INTERFACE ! LA_GBSVX
      PRIVATE SGBSVX_A2I1B2, DGBSVX_A2I1B2, CGBSVX_A2I1B2, ZGBSVX_A2I1B2
!
!-----Interface for xGBTRF
!
      INTERFACE LA_GBTRF

      SUBROUTINE SGBTRF( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE SGBTRF

      SUBROUTINE DGBTRF( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE DGBTRF

      SUBROUTINE CGBTRF( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE CGBTRF

      SUBROUTINE ZGBTRF( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE ZGBTRF

      MODULE PROCEDURE SGBTRF_A2I1
      MODULE PROCEDURE DGBTRF_A2I1
      MODULE PROCEDURE CGBTRF_A2I1
      MODULE PROCEDURE ZGBTRF_A2I1

      END INTERFACE ! LA_GBTRF
      PRIVATE SGBTRF_A2I1, DGBTRF_A2I1, CGBTRF_A2I1, ZGBTRF_A2I1
!
!-----Interface for xGBTRS
!
      INTERFACE LA_GBTRS

      SUBROUTINE SGBTRS( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SGBTRS

      SUBROUTINE DGBTRS( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DGBTRS

      SUBROUTINE CGBTRS( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AB
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CGBTRS

      SUBROUTINE ZGBTRS( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AB
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZGBTRS

      MODULE PROCEDURE SGBTRS_A2I1B2
      MODULE PROCEDURE DGBTRS_A2I1B2
      MODULE PROCEDURE CGBTRS_A2I1B2
      MODULE PROCEDURE ZGBTRS_A2I1B2

      MODULE PROCEDURE SGBTRS_A2I1B1
      MODULE PROCEDURE DGBTRS_A2I1B1
      MODULE PROCEDURE CGBTRS_A2I1B1
      MODULE PROCEDURE ZGBTRS_A2I1B1

      END INTERFACE ! LA_GBTRS
      PRIVATE SGBTRS_A2I1B2, DGBTRS_A2I1B2, CGBTRS_A2I1B2, ZGBTRS_A2I1B2
      PRIVATE SGBTRS_A2I1B1, DGBTRS_A2I1B1, CGBTRS_A2I1B1, ZGBTRS_A2I1B1
!
!-----Interface for xGEBAK
!
      INTERFACE LA_GEBAK

      SUBROUTINE SGEBAK( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE
         REAL(WP), INTENT(INOUT) :: V
      END SUBROUTINE SGEBAK

      SUBROUTINE DGEBAK( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE
         REAL(WP), INTENT(INOUT) :: V
      END SUBROUTINE DGEBAK

      SUBROUTINE CGEBAK( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE
         COMPLEX(WP), INTENT(INOUT) :: V
      END SUBROUTINE CGEBAK

      SUBROUTINE ZGEBAK( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE
         COMPLEX(WP), INTENT(INOUT) :: V
      END SUBROUTINE ZGEBAK

      MODULE PROCEDURE SGEBAK_S1V2
      MODULE PROCEDURE DGEBAK_S1V2
      MODULE PROCEDURE CGEBAK_S1V2
      MODULE PROCEDURE ZGEBAK_S1V2

      END INTERFACE ! LA_GEBAK
      PRIVATE SGEBAK_S1V2, DGEBAK_S1V2, CGEBAK_S1V2, ZGEBAK_S1V2
!
!-----Interface for xGEBAL
!
      INTERFACE LA_GEBAL

      SUBROUTINE SGEBAL( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE
      END SUBROUTINE SGEBAL

      SUBROUTINE DGEBAL( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE
      END SUBROUTINE DGEBAL

      SUBROUTINE CGEBAL( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE
      END SUBROUTINE CGEBAL

      SUBROUTINE ZGEBAL( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE
      END SUBROUTINE ZGEBAL

      MODULE PROCEDURE SGEBAL_A2S1
      MODULE PROCEDURE DGEBAL_A2S1
      MODULE PROCEDURE CGEBAL_A2S1
      MODULE PROCEDURE ZGEBAL_A2S1

      END INTERFACE ! LA_GEBAL
      PRIVATE SGEBAL_A2S1, DGEBAL_A2S1, CGEBAL_A2S1, ZGEBAL_A2S1
!
!-----Interface for xGEBRD
!
      INTERFACE LA_GEBRD

      SUBROUTINE SGEBRD( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE SGEBRD

      SUBROUTINE DGEBRD( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE DGEBRD

      SUBROUTINE CGEBRD( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE CGEBRD

      SUBROUTINE ZGEBRD( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE ZGEBRD

      MODULE PROCEDURE SGEBRD_A2T1W1
      MODULE PROCEDURE DGEBRD_A2T1W1
      MODULE PROCEDURE CGEBRD_A2T1W1
      MODULE PROCEDURE ZGEBRD_A2T1W1

      END INTERFACE ! LA_GEBRD
      PRIVATE SGEBRD_A2T1W1, DGEBRD_A2T1W1, CGEBRD_A2T1W1, ZGEBRD_A2T1W1
!
!-----Interface for xGECON
!
      INTERFACE LA_GECON

      SUBROUTINE SGECON( NORM, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SGECON

      SUBROUTINE DGECON( NORM, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DGECON

      SUBROUTINE CGECON( NORM, N, A, LDA, ANORM, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CGECON

      SUBROUTINE ZGECON( NORM, N, A, LDA, ANORM, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZGECON

      END INTERFACE ! LA_GECON
!
!-----Interface for xGEES
!
      INTERFACE LA_GEES

      SUBROUTINE SGEES( JOBVS, SORT, SELECT, N, A, LDA, SDIM, WR, WI,
     &                  VS, LDVS, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VS, WI, WORK, WR
         INTERFACE
            LOGICAL FUNCTION SELECT( WR, WI )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE SGEES

      SUBROUTINE DGEES( JOBVS, SORT, SELECT, N, A, LDA, SDIM, WR, WI,
     &                  VS, LDVS, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VS, WI, WORK, WR
         INTERFACE
            LOGICAL FUNCTION SELECT( WR, WI )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE DGEES

      SUBROUTINE CGEES( JOBVS, SORT, SELECT, N, A, LDA, SDIM, W, VS,
     &                  LDVS, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VS, W, WORK
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE CGEES

      SUBROUTINE ZGEES( JOBVS, SORT, SELECT, N, A, LDA, SDIM, W, VS,
     &                  LDVS, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VS, W, WORK
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE ZGEES

      MODULE PROCEDURE SGEES_NAT
      MODULE PROCEDURE DGEES_NAT
      MODULE PROCEDURE CGEES_NAT
      MODULE PROCEDURE ZGEES_NAT

      END INTERFACE ! LA_GEES
      PRIVATE SGEES_NAT, DGEES_NAT, CGEES_NAT, ZGEES_NAT
!
!-----Interface for xGEESX
!
      INTERFACE LA_GEESX

      SUBROUTINE SGEESX( JOBVS, SORT, SELECT, SENSE, N, A, LDA, SDIM,
     &                   WR, WI, VS, LDVS, RCONDE, RCONDV, WORK, LWORK,
     &                   IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VS, WI, WORK, WR
         INTERFACE
            LOGICAL FUNCTION SELECT(WR, WI)
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE SGEESX

      SUBROUTINE DGEESX( JOBVS, SORT, SELECT, SENSE, N, A, LDA, SDIM,
     &                   WR, WI, VS, LDVS, RCONDE, RCONDV, WORK, LWORK,
     &                   IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VS, WI, WORK, WR
         INTERFACE
            LOGICAL FUNCTION SELECT(WR, WI)
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE DGEESX

      SUBROUTINE CGEESX( JOBVS, SORT, SELECT, SENSE, N, A, LDA, SDIM,
     &                   W, VS, LDVS, RCONDE, RCONDV, WORK, LWORK,
     &                   RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VS, W, WORK
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE CGEESX

      SUBROUTINE ZGEESX( JOBVS, SORT, SELECT, SENSE, N, A, LDA, SDIM,
     &                   W, VS, LDVS, RCONDE, RCONDV, WORK, LWORK,
     &                   RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VS, W, WORK
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
      END SUBROUTINE ZGEESX

      MODULE PROCEDURE SGEESX_NAT
      MODULE PROCEDURE DGEESX_NAT
      MODULE PROCEDURE CGEESX_NAT
      MODULE PROCEDURE ZGEESX_NAT

      END INTERFACE ! LA_GEESX
      PRIVATE SGEESX_NAT, DGEESX_NAT, CGEESX_NAT, ZGEESX_NAT
!
!-----Interface for xGEEQU
!
      INTERFACE LA_GEEQU

      SUBROUTINE SGEEQU( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: C(*), R(*)
      END SUBROUTINE SGEEQU

      SUBROUTINE DGEEQU( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: C(*), R(*)
      END SUBROUTINE DGEEQU

      SUBROUTINE CGEEQU( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: C(*), R(*)
      END SUBROUTINE CGEEQU

      SUBROUTINE ZGEEQU( M, N, A, LDA, R, C, ROWCND, COLCND, AMAX,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, COLCND, ROWCND
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: C(*), R(*)
      END SUBROUTINE ZGEEQU

      END INTERFACE ! LA_GEEQU
!
!-----Interface for xGEEV
!
      INTERFACE LA_GEEV

      SUBROUTINE SGEEV( JOBVL, JOBVR, N, A, LDA, WR, WI, VL, LDVL, VR,
     &                  LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VL, VR, WI, WORK, WR
      END SUBROUTINE SGEEV

      SUBROUTINE DGEEV( JOBVL, JOBVR, N, A, LDA, WR, WI, VL, LDVL, VR,
     &                  LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: VL, VR, WI, WORK, WR
      END SUBROUTINE DGEEV

      SUBROUTINE CGEEV( JOBVL, JOBVR, N, A, LDA, W, VL, LDVL, VR, LDVR,
     &                  WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VL, VR, W, WORK
      END SUBROUTINE CGEEV

      SUBROUTINE ZGEEV( JOBVL, JOBVR, N, A, LDA, W, VL, LDVL, VR, LDVR,
     &                  WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VL, VR, W, WORK
      END SUBROUTINE ZGEEV

      MODULE PROCEDURE SGEEV_NAT
      MODULE PROCEDURE DGEEV_NAT
      MODULE PROCEDURE CGEEV_NAT
      MODULE PROCEDURE ZGEEV_NAT

      END INTERFACE ! LA_GEEV
      PRIVATE SGEEV_NAT, DGEEV_NAT, CGEEV_NAT, ZGEEV_NAT
!
!-----Interface for xGEEVX
!
      INTERFACE LA_GEEVX

      SUBROUTINE SGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, WR,
     &                   WI, VL, LDVL, VR, LDVR, ILO, IHI, SCALE,
     &                   ABNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE, RCONDE, RCONDV, VL, VR, WR, WI,
     &                            WORK
      END SUBROUTINE SGEEVX

      SUBROUTINE DGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, WR,
     &                   WI, VL, LDVL, VR, LDVR, ILO, IHI, SCALE,
     &                   ABNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: SCALE, RCONDE, RCONDV, VL, VR, WR, WI,
     &                            WORK
      END SUBROUTINE DGEEVX

      SUBROUTINE CGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, W, VL,
     &                   LDVL, VR, LDVR, ILO, IHI, SCALE, ABNRM,
     &                   RCONDE, RCONDV, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         REAL(WP), INTENT(OUT) :: SCALE, RCONDE, RCONDV, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VL, VR, W, WORK
      END SUBROUTINE CGEEVX

      SUBROUTINE ZGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, W, VL,
     &                   LDVL, VR, LDVR, ILO, IHI, SCALE, ABNRM,
     &                   RCONDE, RCONDV, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         REAL(WP), INTENT(OUT) :: SCALE, RCONDE, RCONDV, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: VL, VR, W, WORK
      END SUBROUTINE ZGEEVX

      MODULE PROCEDURE SGEEVX_NAT
      MODULE PROCEDURE DGEEVX_NAT
      MODULE PROCEDURE CGEEVX_NAT
      MODULE PROCEDURE ZGEEVX_NAT

      END INTERFACE ! LA_GEEVX
      PRIVATE SGEEVX_NAT, DGEEVX_NAT, CGEEVX_NAT, ZGEEVX_NAT
!
!-----Interface for xGEGS
!
      INTERFACE LA_GEGS

      SUBROUTINE SGEGS( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHAR,
     &                  ALPHAI, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAR, ALPHAI, BETA, VSL, VSR, WORK
      END SUBROUTINE SGEGS

      SUBROUTINE DGEGS( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHAR,
     &                  ALPHAI, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAR, ALPHAI, BETA, VSL, VSR, WORK
      END SUBROUTINE DGEGS

      SUBROUTINE CGEGS( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VSL, LDVSL, VSR, LDVSR, WORK, LWORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
      END SUBROUTINE CGEGS

      SUBROUTINE ZGEGS( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VSL, LDVSL, VSR, LDVSR, WORK, LWORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
      END SUBROUTINE ZGEGS

      MODULE PROCEDURE SGEGS_NAT
      MODULE PROCEDURE DGEGS_NAT
      MODULE PROCEDURE CGEGS_NAT
      MODULE PROCEDURE ZGEGS_NAT

      END INTERFACE ! LA_GEGS
      PRIVATE SGEGS_NAT, DGEGS_NAT, CGEGS_NAT, ZGEGS_NAT
!
!-----Interface for xGEGV
!
      INTERFACE LA_GEGV

      SUBROUTINE SGEGV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                  ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VL, VR, WORK
      END SUBROUTINE SGEGV

      SUBROUTINE DGEGV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                  ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VL, VR, WORK
      END SUBROUTINE DGEGV

      SUBROUTINE CGEGV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VL, LDVL, VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE CGEGV

      SUBROUTINE ZGEGV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VL, LDVL, VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE ZGEGV

      MODULE PROCEDURE SGEGV_NAT
      MODULE PROCEDURE DGEGV_NAT
      MODULE PROCEDURE CGEGV_NAT
      MODULE PROCEDURE ZGEGV_NAT

      END INTERFACE ! LA_GEGV
      PRIVATE SGEGV_NAT, DGEGV_NAT, CGEGV_NAT, ZGEGV_NAT
!
!-----Interface for xGEHRD
!
      INTERFACE LA_GEHRD

      SUBROUTINE SGEHRD( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEHRD

      SUBROUTINE DGEHRD( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEHRD

      SUBROUTINE CGEHRD( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEHRD

      SUBROUTINE ZGEHRD( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGEHRD

      MODULE PROCEDURE SGEHRD_A2T1W1
      MODULE PROCEDURE DGEHRD_A2T1W1
      MODULE PROCEDURE CGEHRD_A2T1W1
      MODULE PROCEDURE ZGEHRD_A2T1W1

      END INTERFACE ! LA_GEHRD
      PRIVATE SGEHRD_A2T1W1, DGEHRD_A2T1W1, CGEHRD_A2T1W1, ZGEHRD_A2T1W1
!
!-----Interface for xGELQF
!
      INTERFACE LA_GELQF

      SUBROUTINE SGELQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGELQF

      SUBROUTINE DGELQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGELQF

      SUBROUTINE CGELQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGELQF

      SUBROUTINE ZGELQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGELQF

      MODULE PROCEDURE SGELQF_A2T1W1
      MODULE PROCEDURE DGELQF_A2T1W1
      MODULE PROCEDURE CGELQF_A2T1W1
      MODULE PROCEDURE ZGELQF_A2T1W1

      END INTERFACE ! LA_GELQF
      PRIVATE SGELQF_A2T1W1, DGELQF_A2T1W1, CGELQF_A2T1W1, ZGELQF_A2T1W1
!
!-----Interface for xGELS
!
      INTERFACE LA_GELS

      SUBROUTINE SGELS( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SGELS

      SUBROUTINE DGELS( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DGELS

      SUBROUTINE CGELS( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CGELS

      SUBROUTINE ZGELS( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZGELS

      MODULE PROCEDURE SGELS_A2B2W1
      MODULE PROCEDURE DGELS_A2B2W1
      MODULE PROCEDURE CGELS_A2B2W1
      MODULE PROCEDURE ZGELS_A2B2W1

      END INTERFACE ! LA_GELS
      PRIVATE SGELS_A2B2W1, DGELS_A2B2W1, CGELS_A2B2W1, ZGELS_A2B2W1
!
!-----Interface for xGELSD
!
      INTERFACE LA_GELSD

      SUBROUTINE SGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, IWORK, INFO )
          USE LA_CONSTANTS32, ONLY: WP
          INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
          INTEGER, INTENT(OUT) :: INFO, RANK
          REAL(WP), INTENT(IN) :: RCOND
          INTEGER, INTENT(OUT) :: IWORK
          REAL(WP), INTENT(INOUT) :: A, B
          REAL(WP), INTENT(OUT) :: S, WORK
      END SUBROUTINE SGELSD

      SUBROUTINE DGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, IWORK, INFO )
          USE LA_CONSTANTS, ONLY: WP
          INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
          INTEGER, INTENT(OUT) :: INFO, RANK
          REAL(WP), INTENT(IN) :: RCOND
          INTEGER, INTENT(OUT) :: IWORK
          REAL(WP), INTENT(INOUT) :: A, B
          REAL(WP), INTENT(OUT) :: S, WORK
      END SUBROUTINE DGELSD

      SUBROUTINE CGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CGELSD

      SUBROUTINE ZGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZGELSD

      MODULE PROCEDURE SGELSD_NAT
      MODULE PROCEDURE DGELSD_NAT
      MODULE PROCEDURE CGELSD_NAT
      MODULE PROCEDURE ZGELSD_NAT

      END INTERFACE ! LA_GELSD
      PRIVATE SGELSD_NAT, DGELSD_NAT, CGELSD_NAT, ZGELSD_NAT
!
!-----Interface for xGELSS
!
      INTERFACE LA_GELSS

      SUBROUTINE SGELSS( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: S, WORK
      END SUBROUTINE SGELSS

      SUBROUTINE DGELSS( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: S, WORK
      END SUBROUTINE DGELSS

      SUBROUTINE CGELSS( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(OUT) :: S, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CGELSS

      SUBROUTINE ZGELSS( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                   WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(OUT) :: S, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZGELSS

      MODULE PROCEDURE SGELSS_A2B2W1
      MODULE PROCEDURE DGELSS_A2B2W1
      MODULE PROCEDURE CGELSS_A2B2W1
      MODULE PROCEDURE ZGELSS_A2B2W1

      END INTERFACE ! LA_GELSS
      PRIVATE SGELSS_A2B2W1, DGELSS_A2B2W1, CGELSS_A2B2W1, ZGELSS_A2B2W1
!
!-----Interface for xGELSX
!
      INTERFACE LA_GELSX

      SUBROUTINE SGELSX( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SGELSX

      SUBROUTINE DGELSX( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DGELSX

      SUBROUTINE CGELSX( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CGELSX

      SUBROUTINE ZGELSX( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZGELSX

      MODULE PROCEDURE SGELSX_A2B2W1
      MODULE PROCEDURE DGELSX_A2B2W1
      MODULE PROCEDURE CGELSX_A2B2W1
      MODULE PROCEDURE ZGELSX_A2B2W1

      END INTERFACE ! LA_GELSX
      PRIVATE SGELSX_A2B2W1, DGELSX_A2B2W1, CGELSX_A2B2W1, ZGELSX_A2B2W1
!
!-----Interface for xGELSY
!
      INTERFACE LA_GELSY

      SUBROUTINE SGELSY( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SGELSY

      SUBROUTINE DGELSY( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DGELSY

      SUBROUTINE CGELSY( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CGELSY

      SUBROUTINE ZGELSY( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND, RANK,
     &                   WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZGELSY

      MODULE PROCEDURE SGELSY_A2B2W1
      MODULE PROCEDURE DGELSY_A2B2W1
      MODULE PROCEDURE CGELSY_A2B2W1
      MODULE PROCEDURE ZGELSY_A2B2W1

      END INTERFACE ! LA_GELSY
      PRIVATE SGELSY_A2B2W1, DGELSY_A2B2W1, CGELSY_A2B2W1, ZGELSY_A2B2W1
!
!-----Interface for xGEQLF
!
      INTERFACE LA_GEQLF

      SUBROUTINE SGEQLF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQLF

      SUBROUTINE DGEQLF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEQLF

      SUBROUTINE CGEQLF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEQLF

      SUBROUTINE ZGEQLF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGEQLF

      MODULE PROCEDURE SGEQLF_A2T1W1
      MODULE PROCEDURE DGEQLF_A2T1W1
      MODULE PROCEDURE CGEQLF_A2T1W1
      MODULE PROCEDURE ZGEQLF_A2T1W1

      END INTERFACE ! LA_GEQLF
      PRIVATE SGEQLF_A2T1W1, DGEQLF_A2T1W1, CGEQLF_A2T1W1, ZGEQLF_A2T1W1
!
!-----Interface for xGEQP3
!
      INTERFACE LA_GEQP3

      SUBROUTINE SGEQP3( M, N, A, LDA, JPVT, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQP3

      SUBROUTINE DGEQP3( M, N, A, LDA, JPVT, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEQP3

      SUBROUTINE CGEQP3( M, N, A, LDA, JPVT, TAU, WORK, LWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
         REAL(WP), INTENT(OUT) :: RWORK
      END SUBROUTINE CGEQP3

      SUBROUTINE ZGEQP3( M, N, A, LDA, JPVT, TAU, WORK, LWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
         REAL(WP), INTENT(OUT) :: RWORK
      END SUBROUTINE ZGEQP3

      MODULE PROCEDURE SGEQP3_A2T1W1
      MODULE PROCEDURE DGEQP3_A2T1W1
      MODULE PROCEDURE CGEQP3_A2T1W1
      MODULE PROCEDURE ZGEQP3_A2T1W1

      END INTERFACE ! LA_GEQP3
      PRIVATE SGEQP3_A2T1W1, DGEQP3_A2T1W1, CGEQP3_A2T1W1, ZGEQP3_A2T1W1
!
!-----Interface for xGEQPF
!
      INTERFACE LA_GEQPF

      SUBROUTINE SGEQPF( M, N, A, LDA, JPVT, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQPF

      SUBROUTINE DGEQPF( M, N, A, LDA, JPVT, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEQPF

      SUBROUTINE CGEQPF( M, N, A, LDA, JPVT, TAU, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEQPF

      SUBROUTINE ZGEQPF( M, N, A, LDA, JPVT, TAU, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGEQPF

      MODULE PROCEDURE SGEQPF_A2T1W1
      MODULE PROCEDURE DGEQPF_A2T1W1
      MODULE PROCEDURE CGEQPF_A2T1W1
      MODULE PROCEDURE ZGEQPF_A2T1W1

      END INTERFACE ! LA_GEQPF
      PRIVATE SGEQPF_A2T1W1, DGEQPF_A2T1W1, CGEQPF_A2T1W1, ZGEQPF_A2T1W1
!
!-----Interface for xGEQRF
!
      INTERFACE LA_GEQRF

      SUBROUTINE SGEQRF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQRF

      SUBROUTINE DGEQRF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGEQRF

      SUBROUTINE CGEQRF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEQRF

      SUBROUTINE ZGEQRF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGEQRF

      MODULE PROCEDURE SGEQRF_A2T1W1
      MODULE PROCEDURE DGEQRF_A2T1W1
      MODULE PROCEDURE CGEQRF_A2T1W1
      MODULE PROCEDURE ZGEQRF_A2T1W1

      END INTERFACE ! LA_GEQRF
      PRIVATE SGEQRF_A2T1W1, DGEQRF_A2T1W1, CGEQRF_A2T1W1, ZGEQRF_A2T1W1
!
!-----Interface for xGERFS
!
      INTERFACE LA_GERFS

      SUBROUTINE SGERFS( TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                    X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: FERR(*), BERR(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE SGERFS

      SUBROUTINE DGERFS( TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                    X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: FERR(*), BERR(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE DGERFS

      SUBROUTINE CGERFS( TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                    X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: FERR(*), BERR(*), RWORK(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE CGERFS

      SUBROUTINE ZGERFS( TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                    X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: FERR(*), BERR(*), RWORK(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
      END SUBROUTINE ZGERFS

      END INTERFACE ! LA_GERFS
!
!-----Interface for xGERQF
!
      INTERFACE LA_GERQF

      SUBROUTINE SGERQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGERQF

      SUBROUTINE DGERQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGERQF

      SUBROUTINE CGERQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGERQF

      SUBROUTINE ZGERQF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGERQF

      MODULE PROCEDURE SGERQF_A2T1W1
      MODULE PROCEDURE DGERQF_A2T1W1
      MODULE PROCEDURE CGERQF_A2T1W1
      MODULE PROCEDURE ZGERQF_A2T1W1

      END INTERFACE ! LA_GERQF
      PRIVATE SGERQF_A2T1W1, DGERQF_A2T1W1, CGERQF_A2T1W1, ZGERQF_A2T1W1
!
!-----Interface for xGESDD
!
      INTERFACE LA_GESDD

      SUBROUTINE SGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                   WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: S, U, VT, WORK
      END SUBROUTINE SGESDD

      SUBROUTINE DGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                   WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: S, U, VT, WORK
      END SUBROUTINE DGESDD

      SUBROUTINE CGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                   WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE CGESDD

      SUBROUTINE ZGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                   WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE ZGESDD

      MODULE PROCEDURE SGESDD_NAT
      MODULE PROCEDURE DGESDD_NAT
      MODULE PROCEDURE CGESDD_NAT
      MODULE PROCEDURE ZGESDD_NAT

      END INTERFACE ! LA_GESDD
      PRIVATE SGESDD_NAT, DGESDD_NAT, CGESDD_NAT, ZGESDD_NAT
!
!-----Interface for xGESV
!
      INTERFACE LA_GESV

      SUBROUTINE SGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE SGESV

      SUBROUTINE DGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE DGESV

      SUBROUTINE CGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE CGESV

      SUBROUTINE ZGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE ZGESV

      MODULE PROCEDURE SGESV_A2I1B2
      MODULE PROCEDURE DGESV_A2I1B2
      MODULE PROCEDURE CGESV_A2I1B2
      MODULE PROCEDURE ZGESV_A2I1B2

      END INTERFACE ! LA_GESV
      PRIVATE SGESV_A2I1B2, DGESV_A2I1B2, CGESV_A2I1B2, ZGESV_A2I1B2
!
!-----Interface for xGESVD
!
      INTERFACE LA_GESVD

      SUBROUTINE SGESVD( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                   LDVT, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: S, U, VT, WORK
      END SUBROUTINE SGESVD

      SUBROUTINE DGESVD( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                   LDVT, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: S, U, VT, WORK
      END SUBROUTINE DGESVD

      SUBROUTINE CGESVD( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                   LDVT, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE CGESVD

      SUBROUTINE ZGESVD( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                   LDVT, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, S
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE ZGESVD

      MODULE PROCEDURE SGESVD_NAT
      MODULE PROCEDURE DGESVD_NAT
      MODULE PROCEDURE CGESVD_NAT
      MODULE PROCEDURE ZGESVD_NAT

      END INTERFACE ! LA_GESVD
      PRIVATE SGESVD_NAT, DGESVD_NAT, CGESVD_NAT, ZGESVD_NAT
!
!-----Interface for xGESVX
!
      INTERFACE LA_GESVX

      SUBROUTINE SGESVX( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV,
     &                   EQUED, R, C, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, AF, B, C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, X, WORK
      END SUBROUTINE SGESVX

      SUBROUTINE DGESVX( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV,
     &                   EQUED, R, C, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, AF, B, C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, X, WORK
      END SUBROUTINE DGESVX

      SUBROUTINE CGESVX( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV,
     &                   EQUED, R, C, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, AF, B
         COMPLEX(WP), INTENT(OUT) :: X, WORK
      END SUBROUTINE CGESVX

      SUBROUTINE ZGESVX( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF, IPIV,
     &                   EQUED, R, C, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: C, R
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, AF, B
         COMPLEX(WP), INTENT(OUT) :: X, WORK
      END SUBROUTINE ZGESVX

      MODULE PROCEDURE SGESVX_A2I1B2
      MODULE PROCEDURE DGESVX_A2I1B2
      MODULE PROCEDURE CGESVX_A2I1B2
      MODULE PROCEDURE ZGESVX_A2I1B2

      END INTERFACE ! LA_GESVX
      PRIVATE SGESVX_A2I1B2, DGESVX_A2I1B2, CGESVX_A2I1B2, ZGESVX_A2I1B2
!
!-----Interface for xGETRF
!
      INTERFACE LA_GETRF

      SUBROUTINE SGETRF( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SGETRF

      SUBROUTINE DGETRF( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE DGETRF

      SUBROUTINE CGETRF( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CGETRF

      SUBROUTINE ZGETRF( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE ZGETRF

      MODULE PROCEDURE SGETRF_A2I1
      MODULE PROCEDURE DGETRF_A2I1
      MODULE PROCEDURE CGETRF_A2I1
      MODULE PROCEDURE ZGETRF_A2I1

      END INTERFACE ! LA_GETRF
      PRIVATE SGETRF_A2I1, DGETRF_A2I1, CGETRF_A2I1, ZGETRF_A2I1
!
!-----Interface for xGETRI
!
      INTERFACE LA_GETRI

      SUBROUTINE SGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE SGETRI

      SUBROUTINE DGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE DGETRI

      SUBROUTINE CGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE CGETRI

      SUBROUTINE ZGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE ZGETRI

      END INTERFACE ! LA_GETRI
!
!-----Interface for xGETRS
!
      INTERFACE LA_GETRS

      SUBROUTINE SGETRS( TRANS, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SGETRS

      SUBROUTINE DGETRS( TRANS, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DGETRS

      SUBROUTINE CGETRS( TRANS, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CGETRS

      SUBROUTINE ZGETRS( TRANS, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZGETRS

      MODULE PROCEDURE SGETRS_A2I1B2
      MODULE PROCEDURE DGETRS_A2I1B2
      MODULE PROCEDURE CGETRS_A2I1B2
      MODULE PROCEDURE ZGETRS_A2I1B2

      MODULE PROCEDURE SGETRS_A2I1B1
      MODULE PROCEDURE DGETRS_A2I1B1
      MODULE PROCEDURE CGETRS_A2I1B1
      MODULE PROCEDURE ZGETRS_A2I1B1

      END INTERFACE ! LA_GETRS
      PRIVATE SGETRS_A2I1B2, DGETRS_A2I1B2, CGETRS_A2I1B2, ZGETRS_A2I1B2
      PRIVATE SGETRS_A2I1B1, DGETRS_A2I1B1, CGETRS_A2I1B1, ZGETRS_A2I1B1
!
!-----Interface for xGGBAK
!
      INTERFACE LA_GGBAK

      SUBROUTINE SGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                   V, LDV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE, RSCALE
         REAL(WP), INTENT(INOUT) :: V
      END SUBROUTINE SGGBAK

      SUBROUTINE DGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                   V, LDV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE, RSCALE
         REAL(WP), INTENT(INOUT) :: V
      END SUBROUTINE DGGBAK

      SUBROUTINE CGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                   V, LDV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE, RSCALE
         COMPLEX(WP), INTENT(INOUT) :: V
      END SUBROUTINE CGGBAK

      SUBROUTINE ZGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                   V, LDV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE, RSCALE
         COMPLEX(WP), INTENT(INOUT) :: V
      END SUBROUTINE ZGGBAK

      MODULE PROCEDURE SGGBAK_S1V2
      MODULE PROCEDURE DGGBAK_S1V2
      MODULE PROCEDURE CGGBAK_S1V2
      MODULE PROCEDURE ZGGBAK_S1V2

      END INTERFACE ! LA_GGBAK
      PRIVATE SGGBAK_S1V2, DGGBAK_S1V2, CGGBAK_S1V2, ZGGBAK_S1V2
!
!-----Interface for xGGBAL
!
      INTERFACE LA_GGBAL

      SUBROUTINE SGGBAL( JOB, N, A, LDA, B, LDB, ILO, IHI, LSCALE,
     &                   RSCALE, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: LSCALE, RSCALE, WORK
      END SUBROUTINE SGGBAL

      SUBROUTINE DGGBAL( JOB, N, A, LDA, B, LDB, ILO, IHI, LSCALE,
     &                   RSCALE, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: LSCALE, RSCALE, WORK
      END SUBROUTINE DGGBAL

      SUBROUTINE CGGBAL( JOB, N, A, LDA, B, LDB, ILO, IHI, LSCALE,
     &                   RSCALE, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: LSCALE, RSCALE, WORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE CGGBAL

      SUBROUTINE ZGGBAL( JOB, N, A, LDA, B, LDB, ILO, IHI, LSCALE,
     &                   RSCALE, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: LSCALE, RSCALE, WORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE ZGGBAL

      MODULE PROCEDURE SGGBAL_A2S1W1
      MODULE PROCEDURE DGGBAL_A2S1W1
      MODULE PROCEDURE CGGBAL_A2S1W1
      MODULE PROCEDURE ZGGBAL_A2S1W1

      END INTERFACE ! LA_GGBAL
      PRIVATE SGGBAL_A2S1W1, DGGBAL_A2S1W1, CGGBAL_A2S1W1, ZGGBAL_A2S1W1
!
!-----Interface for xGGES
!
      INTERFACE LA_GGES

      SUBROUTINE SGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B, LDB,
     &                  SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL, VSR,
     &                  LDVSR, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE SGGES

      SUBROUTINE DGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B, LDB,
     &                  SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL, VSR,
     &                  LDVSR, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE DGGES

      SUBROUTINE CGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B, LDB,
     &                  SDIM, ALPHA, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                  LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE CGGES

      SUBROUTINE ZGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B, LDB,
     &                  SDIM, ALPHA, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                  LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE ZGGES

      MODULE PROCEDURE SGGES_NAT
      MODULE PROCEDURE DGGES_NAT
      MODULE PROCEDURE CGGES_NAT
      MODULE PROCEDURE ZGGES_NAT

      END INTERFACE ! LA_GGES
      PRIVATE SGGES_NAT, DGGES_NAT, CGGES_NAT, ZGGES_NAT
!
!-----Interface for xGGESX
!
      INTERFACE LA_GGESX

      SUBROUTINE SGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A, LDA,
     &                   B, LDB, SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL,
     &                   VSR, LDVSR, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                   LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK 
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, RCONDE, RCONDV,
     &                            VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE SGGESX

      SUBROUTINE DGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A, LDA,
     &                   B, LDB, SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL,
     &                   VSR, LDVSR, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                   LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK 
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, RCONDE, RCONDV,
     &                            VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE DGGESX

      SUBROUTINE CGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A, LDA,
     &                   B, LDB, SDIM, ALPHA, BETA, VSL, LDVSL, VSR,
     &                   LDVSR, RCONDE, RCONDV, WORK, LWORK, RWORK,
     &                   IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK 
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE CGGESX

      SUBROUTINE ZGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A, LDA,
     &                   B, LDB, SDIM, ALPHA, BETA, VSL, LDVSL, VSR,
     &                   LDVSR, RCONDE, RCONDV, WORK, LWORK, RWORK,
     &                   IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK 
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VSL, VSR, WORK
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
      END SUBROUTINE ZGGESX

      MODULE PROCEDURE SGGESX_NAT
      MODULE PROCEDURE DGGESX_NAT
      MODULE PROCEDURE CGGESX_NAT
      MODULE PROCEDURE ZGGESX_NAT

      END INTERFACE ! LA_GGESX
      PRIVATE SGGESX_NAT, DGGESX_NAT, CGGESX_NAT, ZGGESX_NAT
!
!-----Interface for xGGEV
!
      INTERFACE LA_GGEV

      SUBROUTINE SGGEV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR, ALPHAI,
     &                  BETA, VL, LDVL, VR, LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VL, VR, WORK
      END SUBROUTINE SGGEV

      SUBROUTINE DGGEV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR, ALPHAI,
     &                  BETA, VL, LDVL, VR, LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, VL, VR, WORK
      END SUBROUTINE DGGEV

      SUBROUTINE CGGEV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VL, LDVL, VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE CGGEV

      SUBROUTINE ZGGEV( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA, BETA,
     &                  VL, LDVL, VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) ::  ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE ZGGEV

      MODULE PROCEDURE SGGEV_NAT
      MODULE PROCEDURE DGGEV_NAT
      MODULE PROCEDURE CGGEV_NAT
      MODULE PROCEDURE ZGGEV_NAT

      END INTERFACE ! LA_GGEV
      PRIVATE SGGEV_NAT, DGGEV_NAT, CGGEV_NAT, ZGGEV_NAT
!
!-----Interface for xGGEVX
!
      INTERFACE LA_GGEVX

      SUBROUTINE SGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, VL, LDVL, VR, LDVR, ILO,
     &                   IHI, LSCALE, RSCALE, ABNRM, BBNRM, RCONDE,
     &                   RCONDV, WORK, LWORK, IWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT):: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, LSCALE, RCONDE,
     &                            RCONDV, RSCALE, VL, VR, WORK
      END SUBROUTINE SGGEVX

      SUBROUTINE DGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, VL, LDVL, VR, LDVR, ILO,
     &                   IHI, LSCALE, RSCALE, ABNRM, BBNRM, RCONDE,
     &                   RCONDV, WORK, LWORK, IWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT):: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, LSCALE, RCONDE,
     &                            RCONDV, RSCALE, VL, VR, WORK
      END SUBROUTINE DGGEVX

      SUBROUTINE CGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B, LDB,
     &                   ALPHA, BETA, VL, LDVL, VR, LDVR, ILO, IHI,
     &                   LSCALE, RSCALE, ABNRM, BBNRM, RCONDE, RCONDV,
     &                   WORK, LWORK, RWORK, IWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: LSCALE, RCONDE, RCONDV, RSCALE, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE CGGEVX

      SUBROUTINE ZGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B, LDB,
     &                   ALPHA, BETA, VL, LDVL, VR, LDVR, ILO, IHI,
     &                   LSCALE, RSCALE, ABNRM, BBNRM, RCONDE, RCONDV,
     &                   WORK, LWORK, RWORK, IWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: LSCALE, RCONDE, RCONDV, RSCALE, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, VL, VR, WORK
      END SUBROUTINE ZGGEVX

      MODULE PROCEDURE SGGEVX_NAT
      MODULE PROCEDURE DGGEVX_NAT
      MODULE PROCEDURE CGGEVX_NAT
      MODULE PROCEDURE ZGGEVX_NAT

      END INTERFACE ! LA_GGEVX
      PRIVATE SGGEVX_NAT, DGGEVX_NAT, CGGEVX_NAT, ZGGEVX_NAT
!
!-----Interface for xGGGLM
!
      INTERFACE LA_GGGLM

      SUBROUTINE SGGGLM( N, M, P, A, LDA, B, LDB, D, X, Y, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, D
         REAL(WP), INTENT(OUT) :: WORK, X, Y
      END SUBROUTINE SGGGLM

      SUBROUTINE DGGGLM( N, M, P, A, LDA, B, LDB, D, X, Y, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, D
         REAL(WP), INTENT(OUT) :: WORK, X, Y
      END SUBROUTINE DGGGLM

      SUBROUTINE CGGGLM( N, M, P, A, LDA, B, LDB, D, X, Y, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, D
         COMPLEX(WP), INTENT(OUT) :: WORK, X, Y
      END SUBROUTINE CGGGLM

      SUBROUTINE ZGGGLM( N, M, P, A, LDA, B, LDB, D, X, Y, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, D
         COMPLEX(WP), INTENT(OUT) :: WORK, X, Y
      END SUBROUTINE ZGGGLM

      MODULE PROCEDURE SGGGLM_NAT
      MODULE PROCEDURE DGGGLM_NAT
      MODULE PROCEDURE CGGGLM_NAT
      MODULE PROCEDURE ZGGGLM_NAT

      END INTERFACE ! LA_GGGLM
      PRIVATE SGGGLM_NAT, DGGGLM_NAT, CGGGLM_NAT, ZGGGLM_NAT
!
!-----Interface for xGGHRD
!
      INTERFACE LA_GGHRD

      SUBROUTINE SGGHRD( COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB, Q,
     &                   LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE SGGHRD

      SUBROUTINE DGGHRD( COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB, Q,
     &                   LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE DGGHRD

      SUBROUTINE CGGHRD( COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB, Q,
     &                   LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE CGGHRD

      SUBROUTINE ZGGHRD( COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB, Q,
     &                   LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE ZGGHRD

      MODULE PROCEDURE SGGHRD_A2B2Q2
      MODULE PROCEDURE DGGHRD_A2B2Q2
      MODULE PROCEDURE CGGHRD_A2B2Q2
      MODULE PROCEDURE ZGGHRD_A2B2Q2

      END INTERFACE ! LA_GGHRD
      PRIVATE SGGHRD_A2B2Q2, DGGHRD_A2B2Q2, CGGHRD_A2B2Q2, ZGGHRD_A2B2Q2
!
!-----Interface for xGGLSE
!
      INTERFACE LA_GGLSE

      SUBROUTINE SGGLSE( M, N, P, A, LDA, B, LDB, C, D, X, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, C, D
         REAL(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE SGGLSE

      SUBROUTINE DGGLSE( M, N, P, A, LDA, B, LDB, C, D, X, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, C, D
         REAL(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE DGGLSE

      SUBROUTINE CGGLSE( M, N, P, A, LDA, B, LDB, C, D, X, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, C, D
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CGGLSE

      SUBROUTINE ZGGLSE( M, N, P, A, LDA, B, LDB, C, D, X, WORK, LWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, C, D
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZGGLSE

      MODULE PROCEDURE SGGLSE_NAT
      MODULE PROCEDURE DGGLSE_NAT
      MODULE PROCEDURE CGGLSE_NAT
      MODULE PROCEDURE ZGGLSE_NAT

      END INTERFACE ! LA_GGLSE
      PRIVATE SGGLSE_NAT, DGGLSE_NAT, CGGLSE_NAT, ZGGLSE_NAT
!
!-----Interface for xGGQRF
!
      INTERFACE LA_GGQRF

      SUBROUTINE SGGQRF( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE SGGQRF

      SUBROUTINE DGGQRF( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE DGGQRF

      SUBROUTINE CGGQRF( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE CGGQRF

      SUBROUTINE ZGGQRF( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE ZGGQRF

      MODULE PROCEDURE SGGQRF_NAT
      MODULE PROCEDURE DGGQRF_NAT
      MODULE PROCEDURE CGGQRF_NAT
      MODULE PROCEDURE ZGGQRF_NAT

      END INTERFACE ! LA_GGQRF
      PRIVATE SGGQRF_NAT, DGGQRF_NAT, CGGQRF_NAT, ZGGQRF_NAT
!
!-----Interface for xGGRQF
!
      INTERFACE LA_GGRQF

      SUBROUTINE SGGRQF( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE SGGRQF

      SUBROUTINE DGGRQF( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE DGGRQF

      SUBROUTINE CGGRQF( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE CGGRQF

      SUBROUTINE ZGGRQF( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: TAUA, TAUB, WORK
      END SUBROUTINE ZGGRQF

      MODULE PROCEDURE SGGRQF_NAT
      MODULE PROCEDURE DGGRQF_NAT
      MODULE PROCEDURE CGGRQF_NAT
      MODULE PROCEDURE ZGGRQF_NAT

      END INTERFACE ! LA_GGRQF
      PRIVATE SGGRQF_NAT, DGGRQF_NAT, CGGRQF_NAT, ZGGRQF_NAT
!
!-----Interface for xGGSVD
!
      INTERFACE LA_GGSVD

      SUBROUTINE SGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                   LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, Q, U, V, WORK
      END SUBROUTINE SGGSVD

      SUBROUTINE DGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                   LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, Q, U, V, WORK
      END SUBROUTINE DGGSVD

      SUBROUTINE CGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                   LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                   WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: Q, U, V, WORK
      END SUBROUTINE CGGSVD

      SUBROUTINE ZGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                   LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                   WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: Q, U, V, WORK
      END SUBROUTINE ZGGSVD

      MODULE PROCEDURE SGGSVD_NAT
      MODULE PROCEDURE DGGSVD_NAT
      MODULE PROCEDURE CGGSVD_NAT
      MODULE PROCEDURE ZGGSVD_NAT

      END INTERFACE ! LA_GGSVD
      PRIVATE SGGSVD_NAT, DGGSVD_NAT, CGGSVD_NAT, ZGGSVD_NAT
!
!-----Interface for xGGSVP
!
      INTERFACE LA_GGSVP

      SUBROUTINE SGGSVP( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                   TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                   IWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: Q, TAU, U, V, WORK
      END SUBROUTINE SGGSVP

      SUBROUTINE DGGSVP( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                   TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                   IWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: Q, TAU, U, V, WORK
      END SUBROUTINE DGGSVP

      SUBROUTINE CGGSVP( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                   TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                   IWORK, RWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: Q, TAU, U, V, WORK
      END SUBROUTINE CGGSVP

      SUBROUTINE ZGGSVP( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                   TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                   IWORK, RWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: Q, TAU, U, V, WORK
      END SUBROUTINE ZGGSVP

      MODULE PROCEDURE SGGSVP_NAT
      MODULE PROCEDURE DGGSVP_NAT
      MODULE PROCEDURE CGGSVP_NAT
      MODULE PROCEDURE ZGGSVP_NAT

      END INTERFACE ! LA_GGSVP
      PRIVATE SGGSVP_NAT, DGGSVP_NAT, CGGSVP_NAT, ZGGSVP_NAT
!
!-----Interface for xGTCON
!
      INTERFACE LA_GTCON

      SUBROUTINE SGTCON( NORM, N, DL, D, DU, DU2, IPIV, ANORM, RCOND,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SGTCON

      SUBROUTINE DGTCON( NORM, N, DL, D, DU, DU2, IPIV, ANORM, RCOND,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DGTCON

      SUBROUTINE CGTCON( NORM, N, DL, D, DU, DU2, IPIV, ANORM, RCOND,
     &                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CGTCON

      SUBROUTINE ZGTCON( NORM, N, DL, D, DU, DU2, IPIV, ANORM, RCOND,
     &                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZGTCON

      END INTERFACE ! LA_GTCON
!
!-----Interface for xGTRFS
!
      INTERFACE LA_GTRFS

      SUBROUTINE SGTRFS( TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF, DU2,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS, IPIV(*)
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), DF(*), DL(*), DLF(*),
     &                           DU(*), DU2(*), DUF(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SGTRFS

      SUBROUTINE DGTRFS( TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF, DU2,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS, IPIV(*)
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), DF(*), DL(*), DLF(*),
     &                           DU(*), DU2(*), DUF(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DGTRFS

      SUBROUTINE CGTRFS( TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF, DU2,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS, IPIV(*)
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), D(*), DF(*), DL(*),
     &                              DLF(*), DU(*), DU2(*), DUF(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CGTRFS

      SUBROUTINE ZGTRFS( TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF, DU2,
     &                   IPIV, B, LDB, X, LDX, FERR, BERR, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS, IPIV(*)
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), D(*), DF(*), DL(*),
     &                              DLF(*), DU(*), DU2(*), DUF(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZGTRFS

      END INTERFACE ! LA_GTRFS
!
!-----Interface for xGTSV
!
      INTERFACE LA_GTSV

      SUBROUTINE SGTSV( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B, D, DL, DU
      END SUBROUTINE SGTSV

      SUBROUTINE DGTSV( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B, D, DL, DU
      END SUBROUTINE DGTSV

      SUBROUTINE CGTSV( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: B, D, DL, DU
      END SUBROUTINE CGTSV

      SUBROUTINE ZGTSV( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: B, D, DL, DU
      END SUBROUTINE ZGTSV

      MODULE PROCEDURE SGTSV_D1B2
      MODULE PROCEDURE DGTSV_D1B2
      MODULE PROCEDURE CGTSV_D1B2
      MODULE PROCEDURE ZGTSV_D1B2

      END INTERFACE ! LA_GTSV
      PRIVATE SGTSV_D1B2, DGTSV_D1B2, CGTSV_D1B2, ZGTSV_D1B2
!
!-----Interface for xGTSVX
!
      INTERFACE LA_GTSVX

      SUBROUTINE SGTSVX( FACT, TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF,
     &                   DU2, IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: B, D, DL, DU
         REAL(WP), INTENT(INOUT) :: DF, DLF, DU2, DUF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SGTSVX

      SUBROUTINE DGTSVX( FACT, TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF,
     &                   DU2, IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: B, D, DL, DU
         REAL(WP), INTENT(INOUT) :: DF, DLF, DU2, DUF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DGTSVX

      SUBROUTINE CGTSVX( FACT, TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF,
     &                   DU2, IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, D, DL, DU
         COMPLEX(WP), INTENT(INOUT) :: DF, DLF, DU2, DUF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CGTSVX

      SUBROUTINE ZGTSVX( FACT, TRANS, N, NRHS, DL, D, DU, DLF, DF, DUF,
     &                   DU2, IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, D, DL, DU
         COMPLEX(WP), INTENT(INOUT) :: DF, DLF, DU2, DUF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZGTSVX

      MODULE PROCEDURE SGTSVX_D1B2W1
      MODULE PROCEDURE DGTSVX_D1B2W1
      MODULE PROCEDURE CGTSVX_D1B2W1
      MODULE PROCEDURE ZGTSVX_D1B2W1

      END INTERFACE ! LA_GTSVX
      PRIVATE SGTSVX_D1B2W1, DGTSVX_D1B2W1, CGTSVX_D1B2W1, ZGTSVX_D1B2W1
!
!-----Interface for xGTTRF
!
      INTERFACE LA_GTTRF

      SUBROUTINE SGTTRF( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: D, DL, DU
         REAL(WP), INTENT(OUT) :: DU2
      END SUBROUTINE SGTTRF

      SUBROUTINE DGTTRF( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: D, DL, DU
         REAL(WP), INTENT(OUT) :: DU2
      END SUBROUTINE DGTTRF

      SUBROUTINE CGTTRF( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: D, DL, DU
         COMPLEX(WP), INTENT(OUT) :: DU2
      END SUBROUTINE CGTTRF

      SUBROUTINE ZGTTRF( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: D, DL, DU
         COMPLEX(WP), INTENT(OUT) :: DU2
      END SUBROUTINE ZGTTRF

      MODULE PROCEDURE SGTTRF_D1I1
      MODULE PROCEDURE DGTTRF_D1I1
      MODULE PROCEDURE CGTTRF_D1I1
      MODULE PROCEDURE ZGTTRF_D1I1

      END INTERFACE ! LA_GTTRF
      PRIVATE SGTTRF_D1I1, DGTTRF_D1I1, CGTTRF_D1I1, ZGTTRF_D1I1
!
!-----Interface for xGTTRS
!
      INTERFACE LA_GTTRS

      SUBROUTINE SGTTRS( TRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: D, DL, DU, DU2
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SGTTRS

      SUBROUTINE DGTTRS( TRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: D, DL, DU, DU2
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DGTTRS

      SUBROUTINE CGTTRS( TRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: D, DL, DU, DU2
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CGTTRS

      SUBROUTINE ZGTTRS( TRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: D, DL, DU, DU2
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZGTTRS

      MODULE PROCEDURE SGTTRS_D1I1B2
      MODULE PROCEDURE DGTTRS_D1I1B2
      MODULE PROCEDURE CGTTRS_D1I1B2
      MODULE PROCEDURE ZGTTRS_D1I1B2

      MODULE PROCEDURE SGTTRS_D1I1B1
      MODULE PROCEDURE DGTTRS_D1I1B1
      MODULE PROCEDURE CGTTRS_D1I1B1
      MODULE PROCEDURE ZGTTRS_D1I1B1

      END INTERFACE ! LA_GTTRS
      PRIVATE SGTTRS_D1I1B2, DGTTRS_D1I1B2, CGTTRS_D1I1B2, ZGTTRS_D1I1B2
      PRIVATE SGTTRS_D1I1B1, DGTTRS_D1I1B1, CGTTRS_D1I1B1, ZGTTRS_D1I1B1
!
!-----Interface for xHGEQZ
!
      INTERFACE LA_HGEQZ

      SUBROUTINE SHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, Q, LDQ, Z, LDZ, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, WORK
      END SUBROUTINE SHGEQZ

      SUBROUTINE DHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, Q, LDQ, Z, LDZ, WORK,
     &                   LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, WORK
      END SUBROUTINE DHGEQZ

      SUBROUTINE CHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB,
     &                   ALPHA, BETA, Q, LDQ, Z, LDZ, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE CHGEQZ

      SUBROUTINE ZHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA, B, LDB,
     &                   ALPHA, BETA, Q, LDQ, Z, LDZ, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE ZHGEQZ

      MODULE PROCEDURE SHGEQZ_A2B2W1
      MODULE PROCEDURE DHGEQZ_A2B2W1
      MODULE PROCEDURE CHGEQZ_A2B2W1
      MODULE PROCEDURE ZHGEQZ_A2B2W1

      MODULE PROCEDURE SHGEQZ_A2B2W0
      MODULE PROCEDURE DHGEQZ_A2B2W0
      MODULE PROCEDURE CHGEQZ_A2B2W0
      MODULE PROCEDURE ZHGEQZ_A2B2W0

      END INTERFACE ! LA_HGEQZ
      PRIVATE SHGEQZ_A2B2W1, DHGEQZ_A2B2W1, CHGEQZ_A2B2W1, ZHGEQZ_A2B2W1
      PRIVATE SHGEQZ_A2B2W0, DHGEQZ_A2B2W0, CHGEQZ_A2B2W0, ZHGEQZ_A2B2W0
!
!-----Interface for xHSEIN
!
      INTERFACE LA_HSEIN

      SUBROUTINE SHSEIN( SIDE, EIGSRC, INITV, SELECT, N, H, LDH, WR, WI,
     &                   VL, LDVL, VR, LDVR, MM, M, WORK, IFAILL,
     &                   IFAILR, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT
         INTEGER, INTENT(OUT) :: IFAILL, IFAILR
         REAL(WP), INTENT(IN) :: H, WI
         REAL(WP), INTENT(INOUT) :: VL, VR, WR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SHSEIN

      SUBROUTINE DHSEIN( SIDE, EIGSRC, INITV, SELECT, N, H, LDH, WR, WI,
     &                   VL, LDVL, VR, LDVR, MM, M, WORK, IFAILL,
     &                   IFAILR, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT
         INTEGER, INTENT(OUT) :: IFAILL, IFAILR
         REAL(WP), INTENT(IN) :: H, WI
         REAL(WP), INTENT(INOUT) :: VL, VR, WR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DHSEIN

      SUBROUTINE CHSEIN( SIDE, EIGSRC, INITV, SELECT, N, H, LDH, W,
     &                   VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                   IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT
         INTEGER, INTENT(OUT) :: IFAILL, IFAILR
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: H
         COMPLEX(WP), INTENT(INOUT) :: VL, VR, W
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHSEIN

      SUBROUTINE ZHSEIN( SIDE, EIGSRC, INITV, SELECT, N, H, LDH, W,
     &                   VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                   IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT
         INTEGER, INTENT(OUT) :: IFAILL, IFAILR
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: H
         COMPLEX(WP), INTENT(INOUT) :: VL, VR, W
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHSEIN

      MODULE PROCEDURE SHSEIN_H2V2W1
      MODULE PROCEDURE DHSEIN_H2V2W1
      MODULE PROCEDURE CHSEIN_H2V2W1
      MODULE PROCEDURE ZHSEIN_H2V2W1

      END INTERFACE ! LA_HSEIN
      PRIVATE SHSEIN_H2V2W1, DHSEIN_H2V2W1, CHSEIN_H2V2W1, ZHSEIN_H2V2W1
!
!-----Interface for xHSEQR
!
      INTERFACE LA_HSEQR

      SUBROUTINE SHSEQR( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                   Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H, Z
         REAL(WP), INTENT(OUT) ::  WI, WORK, WR
      END SUBROUTINE SHSEQR

      SUBROUTINE DHSEQR( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                   Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H, Z
         REAL(WP), INTENT(OUT) ::  WI, WORK, WR
      END SUBROUTINE DHSEQR

      SUBROUTINE CHSEQR( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                   Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H, Z
         COMPLEX(WP), INTENT(OUT) ::  W, WORK
      END SUBROUTINE CHSEQR

      SUBROUTINE ZHSEQR( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                   Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H, Z
         COMPLEX(WP), INTENT(OUT) ::  W, WORK
      END SUBROUTINE ZHSEQR

      MODULE PROCEDURE SHSEQR_H2Z2W1
      MODULE PROCEDURE DHSEQR_H2Z2W1
      MODULE PROCEDURE CHSEQR_H2Z2W1
      MODULE PROCEDURE ZHSEQR_H2Z2W1

      MODULE PROCEDURE SHSEQR_H2Z2W0
      MODULE PROCEDURE DHSEQR_H2Z2W0
      MODULE PROCEDURE CHSEQR_H2Z2W0
      MODULE PROCEDURE ZHSEQR_H2Z2W0

      END INTERFACE ! LA_HSEQR
      PRIVATE SHSEQR_H2Z2W1, DHSEQR_H2Z2W1, CHSEQR_H2Z2W1, ZHSEQR_H2Z2W1
      PRIVATE SHSEQR_H2Z2W0, DHSEQR_H2Z2W0, CHSEQR_H2Z2W0, ZHSEQR_H2Z2W0
!
!-----Interface for xOPGTR and xUPGTR
!
      INTERFACE LA_OPGTR

      SUBROUTINE SOPGTR( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP, TAU
         REAL(WP), INTENT(OUT) :: Q, WORK
      END SUBROUTINE SOPGTR

      SUBROUTINE DOPGTR( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP, TAU
         REAL(WP), INTENT(OUT) :: Q, WORK
      END SUBROUTINE DOPGTR

      MODULE PROCEDURE SOPGTR_NAT
      MODULE PROCEDURE DOPGTR_NAT

      END INTERFACE ! LA_OPGTR
      PRIVATE SOPGTR_NAT, DOPGTR_NAT

      INTERFACE LA_UPGTR

      SUBROUTINE CUPGTR( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP, TAU
         COMPLEX(WP), INTENT(OUT) :: Q, WORK
      END SUBROUTINE CUPGTR

      SUBROUTINE ZUPGTR( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP, TAU
         COMPLEX(WP), INTENT(OUT) :: Q, WORK
      END SUBROUTINE ZUPGTR

      MODULE PROCEDURE CUPGTR_NAT
      MODULE PROCEDURE ZUPGTR_NAT

      END INTERFACE ! LA_UPGTR
      PRIVATE CUPGTR_NAT, ZUPGTR_NAT
!
!-----Interface for xOPMTR and xUPMTR
!
      INTERFACE LA_OPMTR

      SUBROUTINE SOPMTR( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC, WORK,
     $                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SOPMTR

      SUBROUTINE DOPMTR( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC, WORK,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DOPMTR

      MODULE PROCEDURE SOPMTR_NAT
      MODULE PROCEDURE DOPMTR_NAT

      END INTERFACE ! LA_OPMTR
      PRIVATE SOPMTR_NAT, DOPMTR_NAT

      INTERFACE LA_UPMTR

      SUBROUTINE CUPMTR( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC, WORK,
     $                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUPMTR

      SUBROUTINE ZUPMTR( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC, WORK,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUPMTR

      MODULE PROCEDURE CUPMTR_NAT
      MODULE PROCEDURE ZUPMTR_NAT

      END INTERFACE ! LA_UPMTR
      PRIVATE CUPMTR_NAT, ZUPMTR_NAT
!
!-----Interface for xORGBR and xUNGBR
!
      INTERFACE LA_ORGBR

      SUBROUTINE SORGBR( VECT, M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGBR

      SUBROUTINE DORGBR( VECT, M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGBR

      MODULE PROCEDURE SORGBR_A2T1W1
      MODULE PROCEDURE DORGBR_A2T1W1

      END INTERFACE ! LA_ORGBR
      PRIVATE SORGBR_A2T1W1, DORGBR_A2T1W1

      INTERFACE LA_UNGBR

      SUBROUTINE CUNGBR( VECT, M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGBR

      SUBROUTINE ZUNGBR( VECT, M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGBR

      MODULE PROCEDURE CUNGBR_A2T1W1
      MODULE PROCEDURE ZUNGBR_A2T1W1

      END INTERFACE ! LA_UNGBR
      PRIVATE CUNGBR_A2T1W1, ZUNGBR_A2T1W1
!
!-----Interface for xORGHR and xUNGHR
!
      INTERFACE LA_ORGHR

      SUBROUTINE SORGHR( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGHR

      SUBROUTINE DORGHR( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGHR

      MODULE PROCEDURE SORGHR_A2T1W1
      MODULE PROCEDURE DORGHR_A2T1W1

      END INTERFACE ! LA_ORGHR
      PRIVATE SORGHR_A2T1W1, DORGHR_A2T1W1

      INTERFACE LA_UNGHR

      SUBROUTINE CUNGHR( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGHR

      SUBROUTINE ZUNGHR( N, ILO, IHI, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGHR

      MODULE PROCEDURE CUNGHR_A2T1W1
      MODULE PROCEDURE ZUNGHR_A2T1W1

      END INTERFACE ! LA_UNGHR
      PRIVATE CUNGHR_A2T1W1, ZUNGHR_A2T1W1
!
!-----Interface for xORGLQ and xUNGLQ
!
      INTERFACE LA_ORGLQ

      SUBROUTINE SORGLQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGLQ

      SUBROUTINE DORGLQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGLQ

      MODULE PROCEDURE SORGLQ_A2T1W1
      MODULE PROCEDURE DORGLQ_A2T1W1

      END INTERFACE ! LA_ORGLQ
      PRIVATE SORGLQ_A2T1W1, DORGLQ_A2T1W1

      INTERFACE LA_UNGLQ

      SUBROUTINE CUNGLQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGLQ

      SUBROUTINE ZUNGLQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGLQ

      MODULE PROCEDURE CUNGLQ_A2T1W1
      MODULE PROCEDURE ZUNGLQ_A2T1W1

      END INTERFACE ! LA_UNGLQ
      PRIVATE CUNGLQ_A2T1W1, ZUNGLQ_A2T1W1
!
!-----Interface for xORGQL and xUNGQL
!
      INTERFACE LA_ORGQL

      SUBROUTINE SORGQL( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGQL

      SUBROUTINE DORGQL( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGQL

      MODULE PROCEDURE SORGQL_A2T1W1
      MODULE PROCEDURE DORGQL_A2T1W1

      END INTERFACE ! LA_ORGQL
      PRIVATE SORGQL_A2T1W1, DORGQL_A2T1W1

      INTERFACE LA_UNGQL

      SUBROUTINE CUNGQL( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGQL

      SUBROUTINE ZUNGQL( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGQL

      MODULE PROCEDURE CUNGQL_A2T1W1
      MODULE PROCEDURE ZUNGQL_A2T1W1

      END INTERFACE ! LA_UNGQL
      PRIVATE CUNGQL_A2T1W1, ZUNGQL_A2T1W1
!
!-----Interface for xORGQR and xUNGQR
!
      INTERFACE LA_ORGQR

      SUBROUTINE SORGQR( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGQR

      SUBROUTINE DORGQR( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGQR

      MODULE PROCEDURE SORGQR_A2T1W1
      MODULE PROCEDURE DORGQR_A2T1W1

      END INTERFACE ! LA_ORGQR
      PRIVATE SORGQR_A2T1W1, DORGQR_A2T1W1

      INTERFACE LA_UNGQR

      SUBROUTINE CUNGQR( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGQR

      SUBROUTINE ZUNGQR( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGQR

      MODULE PROCEDURE CUNGQR_A2T1W1
      MODULE PROCEDURE ZUNGQR_A2T1W1

      END INTERFACE ! LA_UNGQR
      PRIVATE CUNGQR_A2T1W1, ZUNGQR_A2T1W1
!
!-----Interface for xORGRQ and xUNGRQ
!
      INTERFACE LA_ORGRQ

      SUBROUTINE SORGRQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGRQ

      SUBROUTINE DORGRQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGRQ

      MODULE PROCEDURE SORGRQ_A2T1W1
      MODULE PROCEDURE DORGRQ_A2T1W1

      END INTERFACE ! LA_ORGRQ
      PRIVATE SORGRQ_A2T1W1, DORGRQ_A2T1W1

      INTERFACE LA_UNGRQ

      SUBROUTINE CUNGRQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGRQ

      SUBROUTINE ZUNGRQ( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGRQ

      MODULE PROCEDURE CUNGRQ_A2T1W1
      MODULE PROCEDURE ZUNGRQ_A2T1W1

      END INTERFACE ! LA_UNGRQ
      PRIVATE CUNGRQ_A2T1W1, ZUNGRQ_A2T1W1
!
!-----Interface for xORGTR and xUNGTR
!
      INTERFACE LA_ORGTR

      SUBROUTINE SORGTR( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGTR

      SUBROUTINE DORGTR( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGTR

      MODULE PROCEDURE SORGTR_A2T1W1
      MODULE PROCEDURE DORGTR_A2T1W1

      END INTERFACE ! LA_ORGTR
      PRIVATE SORGTR_A2T1W1, DORGTR_A2T1W1

      INTERFACE LA_UNGTR

      SUBROUTINE CUNGTR( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGTR

      SUBROUTINE ZUNGTR( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGTR

      MODULE PROCEDURE CUNGTR_A2T1W1
      MODULE PROCEDURE ZUNGTR_A2T1W1

      END INTERFACE ! LA_UNGTR
      PRIVATE CUNGTR_A2T1W1, ZUNGTR_A2T1W1
!
!-----Interface for xORMBR and xUNMBR
!
      INTERFACE LA_ORMBR

      SUBROUTINE SORMBR( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMBR

      SUBROUTINE DORMBR( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMBR

      MODULE PROCEDURE SORMBR_A2T1W1
      MODULE PROCEDURE DORMBR_A2T1W1

      END INTERFACE ! LA_ORMBR
      PRIVATE SORMBR_A2T1W1, DORMBR_A2T1W1

      INTERFACE LA_UNMBR

      SUBROUTINE CUNMBR( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMBR

      SUBROUTINE ZUNMBR( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMBR

      MODULE PROCEDURE CUNMBR_A2T1W1
      MODULE PROCEDURE ZUNMBR_A2T1W1

      END INTERFACE ! LA_UNMBR
      PRIVATE CUNMBR_A2T1W1, ZUNMBR_A2T1W1
!
!-----Interface for xORMHR and xUNMHR
!
      INTERFACE LA_ORMHR

      SUBROUTINE SORMHR( SIDE, TRANS, M, N, ILO, IHI, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMHR

      SUBROUTINE DORMHR( SIDE, TRANS, M, N, ILO, IHI, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMHR

      MODULE PROCEDURE SORMHR_A2T1W1
      MODULE PROCEDURE DORMHR_A2T1W1

      END INTERFACE ! LA_ORMHR
      PRIVATE SORMHR_A2T1W1, DORMHR_A2T1W1

      INTERFACE LA_UNMHR

      SUBROUTINE CUNMHR( SIDE, TRANS, M, N, ILO, IHI, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMHR

      SUBROUTINE ZUNMHR( SIDE, TRANS, M, N, ILO, IHI, A, LDA, TAU, C,
     &                   LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMHR

      MODULE PROCEDURE CUNMHR_A2T1W1
      MODULE PROCEDURE ZUNMHR_A2T1W1

      END INTERFACE ! LA_UNMHR
      PRIVATE CUNMHR_A2T1W1, ZUNMHR_A2T1W1
!
!-----Interface for xORMLQ and xUNMLQ
!
      INTERFACE LA_ORMLQ

      SUBROUTINE SORMLQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMLQ

      SUBROUTINE DORMLQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMLQ

      MODULE PROCEDURE SORMLQ_A2T1W1
      MODULE PROCEDURE DORMLQ_A2T1W1

      END INTERFACE ! LA_ORMLQ
      PRIVATE SORMLQ_A2T1W1, DORMLQ_A2T1W1

      INTERFACE LA_UNMLQ

      SUBROUTINE CUNMLQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMLQ

      SUBROUTINE ZUNMLQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMLQ

      MODULE PROCEDURE CUNMLQ_A2T1W1
      MODULE PROCEDURE ZUNMLQ_A2T1W1

      END INTERFACE ! LA_UNMLQ
      PRIVATE CUNMLQ_A2T1W1, ZUNMLQ_A2T1W1
!
!-----Interface for xORMQL and xUNMQL
!
      INTERFACE LA_ORMQL

      SUBROUTINE SORMQL( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMQL

      SUBROUTINE DORMQL( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMQL

      MODULE PROCEDURE SORMQL_A2T1W1
      MODULE PROCEDURE DORMQL_A2T1W1

      END INTERFACE ! LA_ORMQL
      PRIVATE SORMQL_A2T1W1, DORMQL_A2T1W1

      INTERFACE LA_UNMQL

      SUBROUTINE CUNMQL( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMQL

      SUBROUTINE ZUNMQL( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMQL

      MODULE PROCEDURE CUNMQL_A2T1W1
      MODULE PROCEDURE ZUNMQL_A2T1W1

      END INTERFACE ! LA_UNMQL
      PRIVATE CUNMQL_A2T1W1, ZUNMQL_A2T1W1
!
!-----Interface for xORMQR and xUNMQR
!
      INTERFACE LA_ORMQR

      SUBROUTINE SORMQR( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMQR

      SUBROUTINE DORMQR( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMQR

      MODULE PROCEDURE SORMQR_A2T1W1
      MODULE PROCEDURE DORMQR_A2T1W1

      END INTERFACE ! LA_ORMQR
      PRIVATE SORMQR_A2T1W1, DORMQR_A2T1W1

      INTERFACE LA_UNMQR

      SUBROUTINE CUNMQR( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMQR

      SUBROUTINE ZUNMQR( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMQR

      MODULE PROCEDURE CUNMQR_A2T1W1
      MODULE PROCEDURE ZUNMQR_A2T1W1

      END INTERFACE ! LA_UNMQR
      PRIVATE CUNMQR_A2T1W1, ZUNMQR_A2T1W1
!
!-----Interface for xORMRQ and xUNMRQ
!
      INTERFACE LA_ORMRQ

      SUBROUTINE SORMRQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMRQ

      SUBROUTINE DORMRQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMRQ

      MODULE PROCEDURE SORMRQ_A2T1W1
      MODULE PROCEDURE DORMRQ_A2T1W1

      END INTERFACE ! LA_ORMRQ
      PRIVATE SORMRQ_A2T1W1, DORMRQ_A2T1W1

      INTERFACE LA_UNMRQ

      SUBROUTINE CUNMRQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMRQ

      SUBROUTINE ZUNMRQ( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMRQ

      MODULE PROCEDURE CUNMRQ_A2T1W1
      MODULE PROCEDURE ZUNMRQ_A2T1W1

      END INTERFACE ! LA_UNMRQ
      PRIVATE CUNMRQ_A2T1W1, ZUNMRQ_A2T1W1
!
!-----Interface for xORMRZ and xUNMRZ
!
      INTERFACE LA_ORMRZ

      SUBROUTINE SORMRZ( SIDE, TRANS, M, N, K, L, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORMRZ

      SUBROUTINE DORMRZ( SIDE, TRANS, M, N, K, L, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORMRZ

      MODULE PROCEDURE SORMRZ_A2T1W1
      MODULE PROCEDURE DORMRZ_A2T1W1

      END INTERFACE ! LA_ORMRZ
      PRIVATE SORMRZ_A2T1W1, DORMRZ_A2T1W1

      INTERFACE LA_UNMRZ

      SUBROUTINE CUNMRZ( SIDE, TRANS, M, N, K, L, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNMRZ

      SUBROUTINE ZUNMRZ( SIDE, TRANS, M, N, K, L, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNMRZ

      MODULE PROCEDURE CUNMRZ_A2T1W1
      MODULE PROCEDURE ZUNMRZ_A2T1W1

      END INTERFACE ! LA_UNMRZ
      PRIVATE CUNMRZ_A2T1W1, ZUNMRZ_A2T1W1
!
!-----Interface for xORMTR and xUNMTR
!
      INTERFACE LA_ORMTR

      SUBROUTINE SORMTR( SIDE, UPLO, TRANS, M, N, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(OUT) :: WORK
         REAL(WP), INTENT(INOUT) :: C
      END SUBROUTINE SORMTR

      SUBROUTINE DORMTR( SIDE, UPLO, TRANS, M, N, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(OUT) :: WORK
         REAL(WP), INTENT(INOUT) :: C
      END SUBROUTINE DORMTR

      MODULE PROCEDURE SORMTR_A2T1W1
      MODULE PROCEDURE DORMTR_A2T1W1

      END INTERFACE ! LA_ORMTR
      PRIVATE SORMTR_A2T1W1, DORMTR_A2T1W1

      INTERFACE LA_UNMTR

      SUBROUTINE CUNMTR( SIDE, UPLO, TRANS, M, N, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: C
      END SUBROUTINE CUNMTR

      SUBROUTINE ZUNMTR( SIDE, UPLO, TRANS, M, N, A, LDA, TAU, C, LDC,
     &                   WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: C
      END SUBROUTINE ZUNMTR

      END INTERFACE ! LA_UNMTR
      PRIVATE CUNMTR_A2T1W1, ZUNMTR_A2T1W1
!
!-----Interface for xPBCON
!
      INTERFACE LA_PBCON

      SUBROUTINE SPBCON( UPLO, N, KD, AB, LDAB, ANORM, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPBCON

      SUBROUTINE DPBCON( UPLO, N, KD, AB, LDAB, ANORM, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPBCON

      SUBROUTINE CPBCON( UPLO, N, KD, AB, LDAB, ANORM, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPBCON

      SUBROUTINE ZPBCON( UPLO, N, KD, AB, LDAB, ANORM, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPBCON

      END INTERFACE ! LA_PBCON
!
!-----Interface for xPBEQU
!
      INTERFACE LA_PBEQU

      SUBROUTINE SPBEQU( UPLO, N, KD, AB, LDAB, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE SPBEQU

      SUBROUTINE DPBEQU( UPLO, N, KD, AB, LDAB, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE DPBEQU

      SUBROUTINE CPBEQU( UPLO, N, KD, AB, LDAB, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE CPBEQU

      SUBROUTINE ZPBEQU( UPLO, N, KD, AB, LDAB, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
      END SUBROUTINE ZPBEQU

      END INTERFACE ! LA_PBEQU
!
!-----Interface for xPBRFS
!
      INTERFACE LA_PBRFS

      SUBROUTINE SPBRFS( UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) ::  KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) ::  AB(LDAB,*), AFB(LDAFB,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPBRFS

      SUBROUTINE DPBRFS( UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) ::  KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) ::  AB(LDAB,*), AFB(LDAFB,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPBRFS

      SUBROUTINE CPBRFS( UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) ::  KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  AB(LDAB,*), AFB(LDAFB,*),
     &                               B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPBRFS

      SUBROUTINE ZPBRFS( UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) ::  KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  AB(LDAB,*), AFB(LDAFB,*),
     &                               B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPBRFS

      END INTERFACE ! LA_PBRFS
!
!-----Interface for xPBSTF
!
      INTERFACE LA_PBSTF

      SUBROUTINE SPBSTF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
      END SUBROUTINE SPBSTF

      SUBROUTINE DPBSTF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
      END SUBROUTINE DPBSTF

      SUBROUTINE CPBSTF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
      END SUBROUTINE CPBSTF

      SUBROUTINE ZPBSTF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
      END SUBROUTINE ZPBSTF

      END INTERFACE ! LA_PBSTF
!
!-----Interface for xPBSV
!
      INTERFACE LA_PBSV

      SUBROUTINE SPBSV( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE SPBSV

      SUBROUTINE DPBSV( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE DPBSV

      SUBROUTINE CPBSV( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE CPBSV

      SUBROUTINE ZPBSV( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB, B
      END SUBROUTINE ZPBSV

      MODULE PROCEDURE SPBSV_A2B2
      MODULE PROCEDURE DPBSV_A2B2
      MODULE PROCEDURE CPBSV_A2B2
      MODULE PROCEDURE ZPBSV_A2B2

      END INTERFACE ! LA_PBSV
      PRIVATE SPBSV_A2B2, DPBSV_A2B2, CPBSV_A2B2, ZPBSV_A2B2
!
!-----Interface for xPBSVX
!
      INTERFACE LA_PBSVX

      SUBROUTINE SPBSVX( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB,
     &                   EQUED, S, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, AFB, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SPBSVX

      SUBROUTINE DPBSVX( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB,
     &                   EQUED, S, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, AFB, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DPBSVX

      SUBROUTINE CPBSVX( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB,
     &                   EQUED, S, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, AFB, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CPBSVX

      SUBROUTINE ZPBSVX( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB, LDAFB,
     &                   EQUED, S, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                   WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AB, AFB, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZPBSVX

      MODULE PROCEDURE SPBSVX_A2B2W1
      MODULE PROCEDURE DPBSVX_A2B2W1
      MODULE PROCEDURE CPBSVX_A2B2W1
      MODULE PROCEDURE ZPBSVX_A2B2W1

      END INTERFACE ! LA_PBSVX
      PRIVATE SPBSVX_A2B2W1, DPBSVX_A2B2W1, CPBSVX_A2B2W1, ZPBSVX_A2B2W1
!
!-----Interface for xPBTRF
!
      INTERFACE LA_PBTRF

      SUBROUTINE SPBTRF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE SPBTRF

      SUBROUTINE DPBTRF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE DPBTRF

      SUBROUTINE CPBTRF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE CPBTRF

      SUBROUTINE ZPBTRF( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE ZPBTRF

      MODULE PROCEDURE SPBTRF_A2
      MODULE PROCEDURE DPBTRF_A2
      MODULE PROCEDURE CPBTRF_A2
      MODULE PROCEDURE ZPBTRF_A2

      END INTERFACE ! LA_PBTRF
      PRIVATE SPBTRF_A2, DPBTRF_A2, CPBTRF_A2, ZPBTRF_A2
!
!-----Interface for xPBTRS
!
      INTERFACE LA_PBTRS

      SUBROUTINE SPBTRS( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPBTRS

      SUBROUTINE DPBTRS( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DPBTRS

      SUBROUTINE CPBTRS( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPBTRS

      SUBROUTINE ZPBTRS( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZPBTRS

      MODULE PROCEDURE SPBTRS_A2B2
      MODULE PROCEDURE DPBTRS_A2B2
      MODULE PROCEDURE CPBTRS_A2B2
      MODULE PROCEDURE ZPBTRS_A2B2

      MODULE PROCEDURE SPBTRS_A2B1
      MODULE PROCEDURE DPBTRS_A2B1
      MODULE PROCEDURE CPBTRS_A2B1
      MODULE PROCEDURE ZPBTRS_A2B1

      END INTERFACE ! LA_PBTRS
      PRIVATE SPBTRS_A2B2, DPBTRS_A2B2, CPBTRS_A2B2, ZPBTRS_A2B2
      PRIVATE SPBTRS_A2B1, DPBTRS_A2B1, CPBTRS_A2B1, ZPBTRS_A2B1
!
!-----Interface for xPOCON
!
      INTERFACE LA_POCON

      SUBROUTINE SPOCON( UPLO, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPOCON

      SUBROUTINE DPOCON( UPLO, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPOCON

      SUBROUTINE CPOCON( UPLO, N, A, LDA, ANORM, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPOCON

      SUBROUTINE ZPOCON( UPLO, N, A, LDA, ANORM, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPOCON

      END INTERFACE ! LA_POCON
!
!-----Interface for xPOEQU
!
      INTERFACE LA_POEQU

      SUBROUTINE SPOEQU( N, A, LDA, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE SPOEQU

      SUBROUTINE DPOEQU( N, A, LDA, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE DPOEQU

      SUBROUTINE CPOEQU( N, A, LDA, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
      END SUBROUTINE CPOEQU

      SUBROUTINE ZPOEQU( N, A, LDA, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
      END SUBROUTINE ZPOEQU

      END INTERFACE ! LA_POEQU
!
!-----Interface for xPORFS
!
      INTERFACE LA_PORFS

      SUBROUTINE SPORFS( UPLO, N, NRHS, A, LDA, AF, LDAF, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPORFS

      SUBROUTINE DPORFS( UPLO, N, NRHS, A, LDA, AF, LDAF, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPORFS

      SUBROUTINE CPORFS( UPLO, N, NRHS, A, LDA, AF, LDAF, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPORFS

      SUBROUTINE ZPORFS( UPLO, N, NRHS, A, LDA, AF, LDAF, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPORFS

      END INTERFACE ! LA_PORFS
!
!-----Interface for xPOSV
!
      INTERFACE LA_POSV

      SUBROUTINE SPOSV( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE SPOSV

      SUBROUTINE DPOSV( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE DPOSV

      SUBROUTINE CPOSV( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE CPOSV

      SUBROUTINE ZPOSV( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B
      END SUBROUTINE ZPOSV

      MODULE PROCEDURE SPOSV_A2B2
      MODULE PROCEDURE DPOSV_A2B2
      MODULE PROCEDURE CPOSV_A2B2
      MODULE PROCEDURE ZPOSV_A2B2

      END INTERFACE ! LA_POSV
      PRIVATE SPOSV_A2B2, DPOSV_A2B2, CPOSV_A2B2, ZPOSV_A2B2
!
!-----Interface for xPOSVX
!
      INTERFACE LA_POSVX

      SUBROUTINE SPOSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, EQUED,
     &                   S, B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, AF, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SPOSVX

      SUBROUTINE DPOSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, EQUED,
     &                   S, B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, AF, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DPOSVX

      SUBROUTINE CPOSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, EQUED,
     &                   S, B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, AF, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CPOSVX

      SUBROUTINE ZPOSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, EQUED,
     &                   S, B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: A, AF, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZPOSVX

      MODULE PROCEDURE SPOSVX_A2B2W1
      MODULE PROCEDURE DPOSVX_A2B2W1
      MODULE PROCEDURE CPOSVX_A2B2W1
      MODULE PROCEDURE ZPOSVX_A2B2W1

      END INTERFACE ! LA_POSVX
      PRIVATE SPOSVX_A2B2W1, DPOSVX_A2B2W1, CPOSVX_A2B2W1, ZPOSVX_A2B2W1
!
!-----Interface for xPOTRF
!
      INTERFACE LA_POTRF

      SUBROUTINE SPOTRF( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SPOTRF

      SUBROUTINE DPOTRF( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE DPOTRF

      SUBROUTINE CPOTRF( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CPOTRF

      SUBROUTINE ZPOTRF( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE ZPOTRF

      MODULE PROCEDURE SPOTRF_A2
      MODULE PROCEDURE DPOTRF_A2
      MODULE PROCEDURE CPOTRF_A2
      MODULE PROCEDURE ZPOTRF_A2

      END INTERFACE ! LA_POTRF
      PRIVATE SPOTRF_A2, DPOTRF_A2, CPOTRF_A2, ZPOTRF_A2
!
!-----Interface for xPOTRI
!
      INTERFACE LA_POTRI

      SUBROUTINE SPOTRI( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE SPOTRI

      SUBROUTINE DPOTRI( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE DPOTRI

      SUBROUTINE CPOTRI( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE CPOTRI

      SUBROUTINE ZPOTRI( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE ZPOTRI

      END INTERFACE ! LA_POTRI
!
!-----Interface for xPOTRS
!
      INTERFACE LA_POTRS

      SUBROUTINE SPOTRS( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPOTRS

      SUBROUTINE DPOTRS( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DPOTRS

      SUBROUTINE CPOTRS( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPOTRS

      SUBROUTINE ZPOTRS( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZPOTRS

      MODULE PROCEDURE SPOTRS_A2B2
      MODULE PROCEDURE DPOTRS_A2B2
      MODULE PROCEDURE CPOTRS_A2B2
      MODULE PROCEDURE ZPOTRS_A2B2

      MODULE PROCEDURE SPOTRS_A2B1
      MODULE PROCEDURE DPOTRS_A2B1
      MODULE PROCEDURE CPOTRS_A2B1
      MODULE PROCEDURE ZPOTRS_A2B1

      END INTERFACE ! LA_POTRS
      PRIVATE SPOTRS_A2B2, DPOTRS_A2B2, CPOTRS_A2B2, ZPOTRS_A2B2
      PRIVATE SPOTRS_A2B1, DPOTRS_A2B1, CPOTRS_A2B1, ZPOTRS_A2B1
!
!-----Interface for xPPCON
!
      INTERFACE LA_PPCON

      SUBROUTINE SPPCON( UPLO, N, AP, ANORM, RCOND, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPPCON

      SUBROUTINE DPPCON( UPLO, N, AP, ANORM, RCOND, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPPCON

      SUBROUTINE CPPCON( UPLO, N, AP, ANORM, RCOND, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPPCON

      SUBROUTINE ZPPCON( UPLO, N, AP, ANORM, RCOND, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPPCON

      END INTERFACE ! LA_PPCON
!
!-----Interface for xPPEQU
!
      INTERFACE LA_PPEQU

      SUBROUTINE SPPEQU( UPLO, N, AP, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE SPPEQU

      SUBROUTINE DPPEQU( UPLO, N, AP, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AMAX, SCOND
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: S(*)
      END SUBROUTINE DPPEQU

      SUBROUTINE CPPEQU( UPLO, N, AP, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
      END SUBROUTINE CPPEQU

      SUBROUTINE ZPPEQU( UPLO, N, AP, S, SCOND, AMAX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AMAX, SCOND
         REAL(WP), INTENT(OUT) :: S(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
      END SUBROUTINE ZPPEQU

      END INTERFACE ! LA_PPEQU
!
!-----Interface for xPPRFS
!
      INTERFACE LA_PPRFS

      SUBROUTINE SPPRFS( UPLO, N, NRHS, AP, AFP, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPPRFS

      SUBROUTINE DPPRFS( UPLO, N, NRHS, AP, AFP, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPPRFS

      SUBROUTINE CPPRFS( UPLO, N, NRHS, AP, AFP, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPPRFS

      SUBROUTINE ZPPRFS( UPLO, N, NRHS, AP, AFP, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPPRFS

      END INTERFACE ! LA_PPRFS
!
!-----Interface for xPPSV
!
      INTERFACE LA_PPSV

      SUBROUTINE SPPSV( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE SPPSV

      SUBROUTINE DPPSV( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE DPPSV

      SUBROUTINE CPPSV( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE CPPSV

      SUBROUTINE ZPPSV( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE ZPPSV

      MODULE PROCEDURE SPPSV_A1B2
      MODULE PROCEDURE DPPSV_A1B2
      MODULE PROCEDURE CPPSV_A1B2
      MODULE PROCEDURE ZPPSV_A1B2

      END INTERFACE ! LA_PPSV
      PRIVATE SPPSV_A1B2, DPPSV_A1B2, CPPSV_A1B2, ZPPSV_A1B2
!
!-----Interface for xPPSVX
!
      INTERFACE LA_PPSVX

      SUBROUTINE SPPSVX( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AFP, AP, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SPPSVX

      SUBROUTINE DPPSVX( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AFP, AP, B, S
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DPPSVX

      SUBROUTINE CPPSVX( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AFP, AP, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CPPSVX

      SUBROUTINE ZPPSVX( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(INOUT) :: AFP, AP, B
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZPPSVX

      END INTERFACE ! LA_PPSVX
!
!-----Interface for xPPTRF
!
      INTERFACE LA_PPTRF

      SUBROUTINE SPPTRF( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE SPPTRF

      SUBROUTINE DPPTRF( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE DPPTRF

      SUBROUTINE CPPTRF( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE CPPTRF

      SUBROUTINE ZPPTRF( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE ZPPTRF

      MODULE PROCEDURE SPPTRF_A1
      MODULE PROCEDURE DPPTRF_A1
      MODULE PROCEDURE CPPTRF_A1
      MODULE PROCEDURE ZPPTRF_A1

      END INTERFACE ! LA_PPTRF
      PRIVATE SPPTRF_A1, DPPTRF_A1, CPPTRF_A1, ZPPTRF_A1
!
!-----Interface for xPPTRI
!
      INTERFACE LA_PPTRI

      SUBROUTINE SPPTRI( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE SPPTRI

      SUBROUTINE DPPTRI( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE DPPTRI

      SUBROUTINE CPPTRI( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE CPPTRI

      SUBROUTINE ZPPTRI( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE ZPPTRI

      END INTERFACE ! LA_PPTRI
!
!-----Interface for xPPTRS
!
      INTERFACE LA_PPTRS

      SUBROUTINE SPPTRS( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPPTRS

      SUBROUTINE DPPTRS( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DPPTRS

      SUBROUTINE CPPTRS( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPPTRS

      SUBROUTINE ZPPTRS( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZPPTRS

      MODULE PROCEDURE SPPTRS_A1B2
      MODULE PROCEDURE DPPTRS_A1B2
      MODULE PROCEDURE CPPTRS_A1B2
      MODULE PROCEDURE ZPPTRS_A1B2

      MODULE PROCEDURE SPPTRS_A1B1
      MODULE PROCEDURE DPPTRS_A1B1
      MODULE PROCEDURE CPPTRS_A1B1
      MODULE PROCEDURE ZPPTRS_A1B1

      END INTERFACE ! LA_PPTRS
      PRIVATE SPPTRS_A1B2, DPPTRS_A1B2, CPPTRS_A1B2, ZPPTRS_A1B2
      PRIVATE SPPTRS_A1B1, DPPTRS_A1B1, CPPTRS_A1B1, ZPPTRS_A1B1
!
!-----Interface for xPTCON
!
      INTERFACE LA_PTCON

      SUBROUTINE SPTCON( N, D, E, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPTCON

      SUBROUTINE DPTCON( N, D, E, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPTCON

      SUBROUTINE CPTCON( N, D, E, ANORM, RCOND, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
      END SUBROUTINE CPTCON

      SUBROUTINE ZPTCON( N, D, E, ANORM, RCOND, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
      END SUBROUTINE ZPTCON

      END INTERFACE ! LA_PTCON
!
!-----Interface for xPTEQR
!
      INTERFACE LA_PTEQR

      SUBROUTINE SPTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SPTEQR

      SUBROUTINE DPTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DPTEQR

      SUBROUTINE CPTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE CPTEQR

      SUBROUTINE ZPTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE ZPTEQR

      MODULE PROCEDURE SPTEQR_D1Z2W1
      MODULE PROCEDURE DPTEQR_D1Z2W1
      MODULE PROCEDURE CPTEQR_D1Z2W1
      MODULE PROCEDURE ZPTEQR_D1Z2W1

      END INTERFACE ! LA_PTEQR
      PRIVATE SPTEQR_D1Z2W1, DPTEQR_D1Z2W1, CPTEQR_D1Z2W1, ZPTEQR_D1Z2W1
!
!-----Interface for xPTRFS
!
      INTERFACE LA_PTRFS

      SUBROUTINE SPTRFS( N, NRHS, D, E, DF, EF, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), E(*), EF(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SPTRFS

      SUBROUTINE DPTRFS( N, NRHS, D, E, DF, EF, B, LDB, X, LDX, FERR,
     &                   BERR, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), E(*), EF(*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DPTRFS

      SUBROUTINE CPTRFS( UPLO, N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*), EF(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CPTRFS

      SUBROUTINE ZPTRFS( UPLO, N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*), EF(*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZPTRFS

      END INTERFACE ! LA_PTRFS
!
!-----Interface for xPTSV
!
      INTERFACE LA_PTSV

      SUBROUTINE SPTSV( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B, D, E
      END SUBROUTINE SPTSV

      SUBROUTINE DPTSV( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B, D, E
      END SUBROUTINE DPTSV

      SUBROUTINE CPTSV( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: B, E
      END SUBROUTINE CPTSV

      SUBROUTINE ZPTSV( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: B, E
      END SUBROUTINE ZPTSV

      MODULE PROCEDURE SPTSV_D1B2
      MODULE PROCEDURE DPTSV_D1B2
      MODULE PROCEDURE CPTSV_U0D1B2
      MODULE PROCEDURE ZPTSV_U0D1B2

      MODULE PROCEDURE CPTSV_D0B0
      MODULE PROCEDURE ZPTSV_D0B0
      MODULE PROCEDURE CPTSV_D1B2
      MODULE PROCEDURE ZPTSV_D1B2

      END INTERFACE ! LA_PTSV
      PRIVATE SPTSV_D1B2, DPTSV_D1B2, CPTSV_U0D1B2, ZPTSV_U0D1B2
      PRIVATE CPTSV_D0B0, ZPTSV_D0B0, CPTSV_D1B2, ZPTSV_D1B2
!
!-----Interface for xPTSVX
!
      INTERFACE LA_PTSVX

      SUBROUTINE SPTSVX( FACT, N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: B, D, E
         REAL(WP), INTENT(INOUT) :: DF, EF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SPTSVX

      SUBROUTINE DPTSVX( FACT, N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                   RCOND, FERR, BERR, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: B, D, E
         REAL(WP), INTENT(INOUT) :: DF, EF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DPTSVX

      SUBROUTINE CPTSVX( FACT, UPLO, N, NRHS, D, E, DF, EF, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(INOUT) :: DF
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, E
         COMPLEX(WP), INTENT(INOUT) :: EF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CPTSVX

      SUBROUTINE ZPTSVX( FACT, UPLO, N, NRHS, D, E, DF, EF, B, LDB,
     &                   X, LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(INOUT) :: DF
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, E
         COMPLEX(WP), INTENT(INOUT) :: EF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZPTSVX

      MODULE PROCEDURE SPTSVX_D1B2
      MODULE PROCEDURE DPTSVX_D1B2
      MODULE PROCEDURE CPTSVX_U0D1B2
      MODULE PROCEDURE ZPTSVX_U0D1B2

      MODULE PROCEDURE CPTSVX_D0B0
      MODULE PROCEDURE ZPTSVX_D0B0
      MODULE PROCEDURE CPTSVX_D1B2
      MODULE PROCEDURE ZPTSVX_D1B2

      END INTERFACE ! LA_PTSVX
      PRIVATE SPTSVX_D1B2, DPTSVX_D1B2, CPTSVX_U0D1B2, ZPTSVX_U0D1B2
      PRIVATE CPTSVX_D0B0, ZPTSVX_D0B0, CPTSVX_D1B2, ZPTSVX_D1B2
!
!-----Interface for xPTTRF
!
      INTERFACE LA_PTTRF

      SUBROUTINE SPTTRF( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         REAL(WP), INTENT(INOUT) :: E
      END SUBROUTINE SPTTRF

      SUBROUTINE DPTTRF( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         REAL(WP), INTENT(INOUT) :: E
      END SUBROUTINE DPTTRF

      SUBROUTINE CPTTRF( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: E
      END SUBROUTINE CPTTRF

      SUBROUTINE ZPTTRF( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: E
      END SUBROUTINE ZPTTRF

      MODULE PROCEDURE SPTTRF_D1
      MODULE PROCEDURE DPTTRF_D1
      MODULE PROCEDURE CPTTRF_D1
      MODULE PROCEDURE ZPTTRF_D1

      END INTERFACE ! LA_PTTRF
      PRIVATE SPTTRF_D1, DPTTRF_D1, CPTTRF_D1, ZPTTRF_D1
!
!-----Interface for xPTTRS
!
      INTERFACE LA_PTTRS

      SUBROUTINE SPTTRS( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPTTRS

      SUBROUTINE DPTTRS( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DPTTRS

      SUBROUTINE CPTTRS( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D
         COMPLEX(WP), INTENT(IN) :: E
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPTTRS

      SUBROUTINE ZPTTRS( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D
         COMPLEX(WP), INTENT(IN) :: E
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZPTTRS

      MODULE PROCEDURE SPTTRS_D1B2
      MODULE PROCEDURE DPTTRS_D1B2
      MODULE PROCEDURE CPTTRS_D1B2
      MODULE PROCEDURE ZPTTRS_D1B2

      MODULE PROCEDURE SPTTRS_D1B1
      MODULE PROCEDURE DPTTRS_D1B1
      MODULE PROCEDURE CPTTRS_D1B1
      MODULE PROCEDURE ZPTTRS_D1B1

      END INTERFACE ! LA_PTTRS
      PRIVATE SPTTRS_D1B2, DPTTRS_D1B2, CPTTRS_D1B2, ZPTTRS_D1B2
      PRIVATE SPTTRS_D1B1, DPTTRS_D1B1, CPTTRS_D1B1, ZPTTRS_D1B1
!
!-----Interface for xSBGST and xHBGST
!
      INTERFACE LA_SBGST

      SUBROUTINE SSBGST( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, X,
     &                   LDX, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BB
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE SSBGST

      SUBROUTINE DSBGST( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, X,
     &                   LDX, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BB
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE DSBGST

      MODULE PROCEDURE SSBGST_NAT
      MODULE PROCEDURE DSBGST_NAT

      END INTERFACE ! LA_SBGST
      PRIVATE SSBGST_NAT, DSBGST_NAT

      INTERFACE LA_HBGST

      SUBROUTINE CHBGST( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, X,
     &                   LDX, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: BB
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CHBGST

      SUBROUTINE ZHBGST( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, X,
     &                   LDX, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: BB
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZHBGST

      MODULE PROCEDURE CHBGST_NAT
      MODULE PROCEDURE ZHBGST_NAT

      END INTERFACE ! LA_HBGST
      PRIVATE CHBGST_NAT, ZHBGST_NAT
!
!-----Interface for xSBEV and xHBEV
!
      INTERFACE LA_SBEV

      SUBROUTINE SSBEV( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSBEV

      SUBROUTINE DSBEV( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSBEV

      MODULE PROCEDURE SSBEV_NAT
      MODULE PROCEDURE DSBEV_NAT

      END INTERFACE ! LA_SBEV
      PRIVATE SSBEV_NAT, DSBEV_NAT

      INTERFACE LA_HBEV

      SUBROUTINE CHBEV( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                  RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHBEV

      SUBROUTINE ZHBEV( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                  RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHBEV

      MODULE PROCEDURE CHBEV_NAT
      MODULE PROCEDURE ZHBEV_NAT

      END INTERFACE ! LA_HBEV
      PRIVATE CHBEV_NAT, ZHBEV_NAT
!
!-----Interface for xSBEVD and xHBEVD
!
      INTERFACE LA_SBEVD

      SUBROUTINE SSBEVD( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                   LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSBEVD

      SUBROUTINE DSBEVD( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                   LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSBEVD

      MODULE PROCEDURE SSBEVD_NAT
      MODULE PROCEDURE DSBEVD_NAT

      END INTERFACE ! LA_SBEVD
      PRIVATE SSBEVD_NAT, DSBEVD_NAT

      INTERFACE LA_HBEVD

      SUBROUTINE CHBEVD( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHBEVD

      SUBROUTINE ZHBEVD( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHBEVD

      MODULE PROCEDURE CHBEVD_NAT
      MODULE PROCEDURE ZHBEVD_NAT

      END INTERFACE ! LA_HBEVD
      PRIVATE CHBEVD_NAT, ZHBEVD_NAT
!
!-----Interface for xSBEVX and xHBEVX
!
      INTERFACE LA_SBEVX

      SUBROUTINE SSBEVX( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: Q, W, WORK, Z
      END SUBROUTINE SSBEVX

      SUBROUTINE DSBEVX( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AB
         REAL(WP), INTENT(OUT) :: Q, W, WORK, Z
      END SUBROUTINE DSBEVX

      MODULE PROCEDURE SSBEVX_NAT
      MODULE PROCEDURE DSBEVX_NAT

      END INTERFACE ! LA_SBEVX
      PRIVATE SSBEVX_NAT, DSBEVX_NAT

      INTERFACE LA_HBEVX

      SUBROUTINE CHBEVX( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: Q, WORK, Z
      END SUBROUTINE CHBEVX

      SUBROUTINE ZHBEVX( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB
         COMPLEX(WP), INTENT(OUT) :: Q, WORK, Z
      END SUBROUTINE ZHBEVX

      MODULE PROCEDURE CHBEVX_NAT
      MODULE PROCEDURE ZHBEVX_NAT

      END INTERFACE ! LA_HBEVX
      PRIVATE CHBEVX_NAT, ZHBEVX_NAT
!
!-----Interface for xSBGV and xHBGV
!
      INTERFACE LA_SBGV

      SUBROUTINE SSBGV( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, W,
     &                  Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSBGV

      SUBROUTINE DSBGV( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, W,
     &                  Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSBGV

      MODULE PROCEDURE SSBGV_NAT
      MODULE PROCEDURE DSBGV_NAT

      END INTERFACE ! LA_SBGV
      PRIVATE SSBGV_NAT, DSBGV_NAT

      INTERFACE LA_HBGV

      SUBROUTINE CHBGV( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, W,
     &                  Z, LDZ, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHBGV

      SUBROUTINE ZHBGV( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB, W,
     &                  Z, LDZ, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHBGV

      MODULE PROCEDURE CHBGV_NAT
      MODULE PROCEDURE ZHBGV_NAT

      END INTERFACE ! LA_HBGV
      PRIVATE CHBGV_NAT, ZHBGV_NAT
!
!-----Interface for xSBGVD and xHBGVD
!
      INTERFACE LA_SBGVD

      SUBROUTINE SSBGVD( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB, LDBB,
     &                   W, Z, LDZ, WORK, LWORK, IWORK, LIWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: W
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SSBGVD

      SUBROUTINE DSBGVD( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB, LDBB,
     &                   W, Z, LDZ, WORK, LWORK, IWORK, LIWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: W
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DSBGVD

      MODULE PROCEDURE SSBGVD_NAT
      MODULE PROCEDURE DSBGVD_NAT

      END INTERFACE ! LA_SBGVD
      PRIVATE SSBGVD_NAT, DSBGVD_NAT

      INTERFACE LA_HBGVD

      SUBROUTINE CHBGVD( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB, LDBB,
     &                   W, Z, LDZ, WORK, LWORK, RWORK, LRWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHBGVD

      SUBROUTINE ZHBGVD( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB, LDBB,
     &                   W, Z, LDZ, WORK, LWORK, RWORK, LRWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHBGVD

      MODULE PROCEDURE CHBGVD_NAT
      MODULE PROCEDURE ZHBGVD_NAT

      END INTERFACE ! LA_HBGVD
      PRIVATE CHBGVD_NAT, ZHBGVD_NAT
!
!-----Interface for xSBGVX and xHBGVX
!
      INTERFACE LA_SBGVX

      SUBROUTINE SSBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                   LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL, M, W, Z,
     &                   LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: Q, W, WORK, Z
      END SUBROUTINE SSBGVX

      SUBROUTINE DSBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                    LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL, M, W, Z,
     &                    LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AB, BB
         REAL(WP), INTENT(OUT) :: Q, W, WORK, Z
      END SUBROUTINE DSBGVX

      MODULE PROCEDURE SSBGVX_NAT
      MODULE PROCEDURE DSBGVX_NAT

      END INTERFACE ! LA_SBGVX
      PRIVATE SSBGVX_NAT, DSBGVX_NAT

      INTERFACE LA_HBGVX

      SUBROUTINE CHBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                   LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL, M, W, Z,
     &                   LDZ, WORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: Q, WORK, Z
      END SUBROUTINE CHBGVX

      SUBROUTINE ZHBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                   LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL, M, W, Z,
     &                   LDZ, WORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AB, BB
         COMPLEX(WP), INTENT(OUT) :: Q, WORK, Z
      END SUBROUTINE ZHBGVX

      MODULE PROCEDURE CHBGVX_NAT
      MODULE PROCEDURE ZHBGVX_NAT

      END INTERFACE ! LA_HBGVX
      PRIVATE CHBGVX_NAT, ZHBGVX_NAT
!
!-----Interface for xSBTRD and xHBTRD
!
      INTERFACE LA_SBTRD

      SUBROUTINE SSBTRD( VECT, UPLO, N, KD, AB, LDAB, D, E, Q, LDQ,
     &                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, Q
         REAL(WP), INTENT(OUT) :: D, E, WORK
      END SUBROUTINE SSBTRD

      SUBROUTINE DSBTRD( VECT, UPLO, N, KD, AB, LDAB, D, E, Q, LDQ,
     &                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB, Q
         REAL(WP), INTENT(OUT) :: D, E, WORK
      END SUBROUTINE DSBTRD

      MODULE PROCEDURE SSBTRD_A2Q2W1
      MODULE PROCEDURE DSBTRD_A2Q2W1

      END INTERFACE ! LA_SBTRD
      PRIVATE SSBTRD_A2Q2W1, DSBTRD_A2Q2W1

      INTERFACE LA_HBTRD

      SUBROUTINE CHBTRD( VECT, UPLO, N, KD, AB, LDAB, D, E, Q, LDQ,
     &                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: AB, Q
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHBTRD

      SUBROUTINE ZHBTRD( VECT, UPLO, N, KD, AB, LDAB, D, E, Q, LDQ,
     &                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: AB, Q
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHBTRD

      MODULE PROCEDURE CHBTRD_A2Q2W1
      MODULE PROCEDURE ZHBTRD_A2Q2W1

      END INTERFACE ! LA_HBTRD
      PRIVATE CHBTRD_A2Q2W1, ZHBTRD_A2Q2W1
!
!-----Interface for xSPCON and xHPCON
!
      INTERFACE LA_SPCON

      SUBROUTINE SSPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSPCON

      SUBROUTINE DSPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSPCON

      SUBROUTINE CSPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSPCON

      SUBROUTINE ZSPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSPCON

      END INTERFACE ! LA_SPCON

      INTERFACE LA_HPCON

      SUBROUTINE CHPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHPCON

      SUBROUTINE ZHPCON( UPLO, N, AP, IPIV, ANORM, RCOND, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHPCON

      END INTERFACE ! LA_HPCON
!
!-----Interface for xSPEV and xHPEV
!
      INTERFACE LA_SPEV

      SUBROUTINE SSPEV( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPEV

      SUBROUTINE DSPEV( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPEV

      MODULE PROCEDURE SSPEV_NAT
      MODULE PROCEDURE DSPEV_NAT

      END INTERFACE ! LA_SPEV
      PRIVATE SSPEV_NAT, DSPEV_NAT

      INTERFACE LA_HPEV

      SUBROUTINE CHPEV( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHPEV

      SUBROUTINE ZHPEV( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHPEV

      MODULE PROCEDURE CHPEV_NAT
      MODULE PROCEDURE ZHPEV_NAT

      END INTERFACE ! LA_HPEV
      PRIVATE CHPEV_NAT, ZHPEV_NAT
!
!-----Interface for xSPEVD and xHPEVD
!
      INTERFACE LA_SPEVD

      SUBROUTINE SSPEVD( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPEVD

      SUBROUTINE DSPEVD( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPEVD

      MODULE PROCEDURE SSPEVD_NAT
      MODULE PROCEDURE DSPEVD_NAT

      END INTERFACE ! LA_SPEVD
      PRIVATE SSPEVD_NAT, DSPEVD_NAT

      INTERFACE LA_HPEVD

      SUBROUTINE CHPEVD( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                   RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHPEVD

      SUBROUTINE ZHPEVD( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                   RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHPEVD

      MODULE PROCEDURE CHPEVD_NAT
      MODULE PROCEDURE ZHPEVD_NAT

      END INTERFACE ! LA_HPEVD
      PRIVATE CHPEVD_NAT, ZHPEVD_NAT
!
!-----Interface for xSPEVX and xHPEVX
!
      INTERFACE LA_SPEVX

      SUBROUTINE SSPEVX( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPEVX

      SUBROUTINE DSPEVX( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPEVX

      MODULE PROCEDURE SSPEVX_NAT
      MODULE PROCEDURE DSPEVX_NAT

      END INTERFACE ! LA_SPEVX
      PRIVATE SSPEVX_NAT, DSPEVX_NAT

      INTERFACE LA_HPEVX

      SUBROUTINE CHPEVX( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, RWORK, IWORK,
     &                   IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHPEVX

      SUBROUTINE ZHPEVX( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, RWORK, IWORK,
     &                   IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHPEVX

      MODULE PROCEDURE CHPEVX_NAT
      MODULE PROCEDURE ZHPEVX_NAT

      END INTERFACE ! LA_HPEVX
      PRIVATE CHPEVX_NAT, ZHPEVX_NAT
!
!-----Interface for xSPGST and xHPGST
!
      INTERFACE LA_SPGST

      SUBROUTINE SSPGST( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BP
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE SSPGST

      SUBROUTINE DSPGST( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BP
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE DSPGST

      MODULE PROCEDURE SSPGST_A1B1
      MODULE PROCEDURE DSPGST_A1B1

      END INTERFACE ! LA_SPGST
      PRIVATE SSPGST_A1B1, DSPGST_A1B1

      INTERFACE LA_HPGST

      SUBROUTINE CHPGST( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: BP
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE CHPGST

      SUBROUTINE ZHPGST( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: BP
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE ZHPGST

      MODULE PROCEDURE CHPGST_A1B1
      MODULE PROCEDURE ZHPGST_A1B1

      END INTERFACE ! LA_HPGST
      PRIVATE CHPGST_A1B1, ZHPGST_A1B1
!
!-----Interface for xSPGV and xHPGV
!
      INTERFACE LA_SPGV

      SUBROUTINE SSPGV( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPGV

      SUBROUTINE DSPGV( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPGV

      MODULE PROCEDURE SSPGV_NAT
      MODULE PROCEDURE DSPGV_NAT

      END INTERFACE ! LA_SPGV
      PRIVATE SSPGV_NAT, DSPGV_NAT

      INTERFACE LA_HPGV

      SUBROUTINE CHPGV( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                  RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHPGV

      SUBROUTINE ZHPGV( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                  RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHPGV

      MODULE PROCEDURE CHPGV_NAT
      MODULE PROCEDURE ZHPGV_NAT

      END INTERFACE ! LA_HPGV
      PRIVATE CHPGV_NAT, ZHPGV_NAT
!
!-----Interface for xSPGVD and xHPGVD
!
      INTERFACE LA_SPGVD

      SUBROUTINE SSPGVD( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                   WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPGVD

      SUBROUTINE DSPGVD( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                   WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPGVD

      MODULE PROCEDURE SSPGVD_NAT
      MODULE PROCEDURE DSPGVD_NAT

      END INTERFACE ! LA_SPGVD
      PRIVATE SSPGVD_NAT, DSPGVD_NAT

      INTERFACE LA_HPGVD

      SUBROUTINE CHPGVD( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT):: WORK, Z
      END SUBROUTINE CHPGVD

      SUBROUTINE ZHPGVD( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT):: WORK, Z
      END SUBROUTINE ZHPGVD

      MODULE PROCEDURE CHPGVD_NAT
      MODULE PROCEDURE ZHPGVD_NAT

      END INTERFACE ! LA_HPGVD
      PRIVATE CHPGVD_NAT, ZHPGVD_NAT
!
!-----Interface for xSPGVX and xHPGVX
!
      INTERFACE LA_SPGVX

      SUBROUTINE SSPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL, VU,
     &                   IL, IU, ABSTOL, M, W, Z, LDZ, WORK, IWORK,
     &                   IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSPGVX

      SUBROUTINE DSPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL, VU,
     &                    IL, IU, ABSTOL, M, W, Z, LDZ, WORK, IWORK,
     &                    IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: AP, BP
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSPGVX

      MODULE PROCEDURE SSPGVX_NAT
      MODULE PROCEDURE DSPGVX_NAT

      END INTERFACE ! LA_SPGVX
      PRIVATE SSPGVX_NAT, DSPGVX_NAT

      INTERFACE LA_HPGVX

      SUBROUTINE CHPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL, VU,
     &                    IL, IU, ABSTOL, M, W, Z, LDZ, WORK, RWORK,
     &                    IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHPGVX

      SUBROUTINE ZHPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL, VU,
     &                    IL, IU, ABSTOL, M, W, Z, LDZ, WORK, RWORK,
     &                    IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: AP, BP
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHPGVX

      MODULE PROCEDURE CHPGVX_NAT
      MODULE PROCEDURE ZHPGVX_NAT

      END INTERFACE ! LA_HPGVX
      PRIVATE CHPGVX_NAT, ZHPGVX_NAT
!
!-----Interface for xSPRFS and xHPRFS
!
      INTERFACE LA_SPRFS

      SUBROUTINE SSPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSPRFS

      SUBROUTINE DSPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSPRFS

      SUBROUTINE CSPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSPRFS

      SUBROUTINE ZSPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSPRFS

      END INTERFACE ! LA_SPRFS

      INTERFACE LA_HPRFS

      SUBROUTINE CHPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHPRFS

      SUBROUTINE ZHPRFS( UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHPRFS

      END INTERFACE ! LA_HPRFS
!
!-----Interface for xSPSV and xHPSV
!
      INTERFACE LA_SPSV

      SUBROUTINE SSPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE SSPSV

      SUBROUTINE DSPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE DSPSV

      SUBROUTINE CSPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE CSPSV

      SUBROUTINE ZSPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE ZSPSV

      MODULE PROCEDURE SSPSV_A1I1B2
      MODULE PROCEDURE DSPSV_A1I1B2
      MODULE PROCEDURE CSPSV_A1I1B2
      MODULE PROCEDURE ZSPSV_A1I1B2

      END INTERFACE ! LA_SPSV
      PRIVATE SSPSV_A1I1B2, DSPSV_A1I1B2, CSPSV_A1I1B2, ZSPSV_A1I1B2

      INTERFACE LA_HPSV

      SUBROUTINE CHPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE CHPSV

      SUBROUTINE ZHPSV( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP, B
      END SUBROUTINE ZHPSV

      MODULE PROCEDURE CHPSV_A1I1B2
      MODULE PROCEDURE ZHPSV_A1I1B2

      END INTERFACE ! LA_HPSV
      PRIVATE CHPSV_A1I1B2, ZHPSV_A1I1B2
!
!-----Interface for xSPSVX and xHPSVX
!
      INTERFACE LA_SPSVX

      SUBROUTINE SSPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: AP, B
         REAL(WP), INTENT(INOUT) :: AFP
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SSPSVX

      SUBROUTINE DSPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: AP, B
         REAL(WP), INTENT(INOUT) :: AFP
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DSPSVX

      SUBROUTINE CSPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: AP, B
         COMPLEX(WP), INTENT(INOUT) :: AFP
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CSPSVX

      SUBROUTINE ZSPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: AP, B
         COMPLEX(WP), INTENT(INOUT) :: AFP
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZSPSVX

      MODULE PROCEDURE SSPSVX_A1B2W1
      MODULE PROCEDURE DSPSVX_A1B2W1
      MODULE PROCEDURE CSPSVX_A1B2W1
      MODULE PROCEDURE ZSPSVX_A1B2W1

      END INTERFACE ! LA_SPSVX
      PRIVATE SSPSVX_A1B2W1, DSPSVX_A1B2W1, CSPSVX_A1B2W1, ZSPSVX_A1B2W1

      INTERFACE LA_HPSVX

      SUBROUTINE CHPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: AP, B
         COMPLEX(WP), INTENT(INOUT) :: AFP
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CHPSVX

      SUBROUTINE ZHPSVX( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B, LDB, X,
     &                   LDX, RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: AP, B
         COMPLEX(WP), INTENT(INOUT) :: AFP
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZHPSVX

      MODULE PROCEDURE CHPSVX_A1B2W1
      MODULE PROCEDURE ZHPSVX_A1B2W1

      END INTERFACE ! LA_HPSVX
      PRIVATE CHPSVX_A1B2W1, ZHPSVX_A1B2W1
!
!-----Interface for xSPTRD and xHPTRD
!
      INTERFACE LA_SPTRD

      SUBROUTINE SSPTRD( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: D, E, TAU
      END SUBROUTINE SSPTRD

      SUBROUTINE DSPTRD( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP
         REAL(WP), INTENT(OUT) :: D, E, TAU
      END SUBROUTINE DSPTRD

      MODULE PROCEDURE SSPTRD_A1D1T1
      MODULE PROCEDURE DSPTRD_A1D1T1

      END INTERFACE ! LA_SPTRD
      PRIVATE SSPTRD_A1D1T1, DSPTRD_A1D1T1

      INTERFACE LA_HPTRD

      SUBROUTINE CHPTRD( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE CHPTRD

      SUBROUTINE ZHPTRD( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: AP
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE ZHPTRD

      MODULE PROCEDURE CHPTRD_A1D1T1
      MODULE PROCEDURE ZHPTRD_A1D1T1

      END INTERFACE ! LA_HPTRD
      PRIVATE CHPTRD_A1D1T1, ZHPTRD_A1D1T1
!
!-----Interface for xSPTRF and xHPTRF
!
      INTERFACE LA_SPTRF

      SUBROUTINE SSPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE SSPTRF

      SUBROUTINE DSPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: AP
      END SUBROUTINE DSPTRF

      SUBROUTINE CSPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE CSPTRF

      SUBROUTINE ZSPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE ZSPTRF

      MODULE PROCEDURE SSPTRF_A1I1
      MODULE PROCEDURE DSPTRF_A1I1
      MODULE PROCEDURE CSPTRF_A1I1
      MODULE PROCEDURE ZSPTRF_A1I1

      END INTERFACE ! LA_SPTRF
      PRIVATE SSPTRF_A1I1, DSPTRF_A1I1, CSPTRF_A1I1, ZSPTRF_A1I1

      INTERFACE LA_HPTRF

      SUBROUTINE CHPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE CHPTRF

      SUBROUTINE ZHPTRF( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: AP
      END SUBROUTINE ZHPTRF

      MODULE PROCEDURE CHPTRF_A1I1
      MODULE PROCEDURE ZHPTRF_A1I1

      END INTERFACE ! LA_HPTRF
      PRIVATE CHPTRF_A1I1, ZHPTRF_A1I1
!
!-----Interface for xSPTRI and xHPTRI
!
      INTERFACE LA_SPTRI

      SUBROUTINE SSPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSPTRI

      SUBROUTINE DSPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSPTRI

      SUBROUTINE CSPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSPTRI

      SUBROUTINE ZSPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSPTRI

      END INTERFACE ! LA_SPTRI

      INTERFACE LA_HPTRI

      SUBROUTINE CHPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHPTRI

      SUBROUTINE ZHPTRI( UPLO, N, AP, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHPTRI

      END INTERFACE ! LA_HPTRI
!
!-----Interface for xSPTRS and xHPTRS
!
      INTERFACE LA_SPTRS

      SUBROUTINE SSPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SSPTRS

      SUBROUTINE DSPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DSPTRS

      SUBROUTINE CSPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CSPTRS

      SUBROUTINE ZSPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZSPTRS

      MODULE PROCEDURE SSPTRS_A1I1B2
      MODULE PROCEDURE DSPTRS_A1I1B2
      MODULE PROCEDURE CSPTRS_A1I1B2
      MODULE PROCEDURE ZSPTRS_A1I1B2

      MODULE PROCEDURE SSPTRS_A1I1B1
      MODULE PROCEDURE DSPTRS_A1I1B1
      MODULE PROCEDURE CSPTRS_A1I1B1
      MODULE PROCEDURE ZSPTRS_A1I1B1

      END INTERFACE ! LA_SPTRS
      PRIVATE SSPTRS_A1I1B2, DSPTRS_A1I1B2, CSPTRS_A1I1B2, ZSPTRS_A1I1B2
      PRIVATE SSPTRS_A1I1B1, DSPTRS_A1I1B1, CSPTRS_A1I1B1, ZSPTRS_A1I1B1

      INTERFACE LA_HPTRS

      SUBROUTINE CHPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CHPTRS

      SUBROUTINE ZHPTRS( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZHPTRS

      MODULE PROCEDURE CHPTRS_A1I1B2
      MODULE PROCEDURE ZHPTRS_A1I1B2

      MODULE PROCEDURE CHPTRS_A1I1B1
      MODULE PROCEDURE ZHPTRS_A1I1B1

      END INTERFACE ! LA_HPTRS
      PRIVATE CHPTRS_A1I1B2, ZHPTRS_A1I1B2, CHPTRS_A1I1B1, ZHPTRS_A1I1B1
!
!-----Interface for xSTEBZ
!
      INTERFACE LA_STEBZ

      SUBROUTINE SSTEBZ( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL, D, E,
     &                   M, NSPLIT, W, IBLOCK, ISPLIT, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: ORDER, RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK, ISPLIT, IWORK
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE SSTEBZ

      SUBROUTINE DSTEBZ( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL, D, E,
     &                   M, NSPLIT, W, IBLOCK, ISPLIT, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ORDER, RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK, ISPLIT, IWORK
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE DSTEBZ

      MODULE PROCEDURE SSTEBZ_D1I1
      MODULE PROCEDURE DSTEBZ_D1I1

      END INTERFACE ! LA_STEBZ
      PRIVATE SSTEBZ_D1I1, DSTEBZ_D1I1
!
!-----Interface for xSTEDC
!
      INTERFACE LA_STEDC

      SUBROUTINE SSTEDC( COMPZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SSTEDC

      SUBROUTINE DSTEDC( COMPZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DSTEDC

      SUBROUTINE CSTEDC( COMPZ, N, D, E, Z, LDZ, WORK, LWORK, RWORK,
     &                   LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: Z
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CSTEDC

      SUBROUTINE ZSTEDC( COMPZ, N, D, E, Z, LDZ, WORK, LWORK, RWORK,
     &                   LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: Z
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZSTEDC

      MODULE PROCEDURE SSTEDC_D1Z2W1
      MODULE PROCEDURE DSTEDC_D1Z2W1
      MODULE PROCEDURE CSTEDC_D1Z2W1
      MODULE PROCEDURE ZSTEDC_D1Z2W1

      END INTERFACE ! LA_STEDC
      PRIVATE SSTEDC_D1Z2W1, DSTEDC_D1Z2W1, CSTEDC_D1Z2W1, ZSTEDC_D1Z2W1
!
!-----Interface for xSTEGR
!
      INTERFACE LA_STEGR

      SUBROUTINE SSTEGR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SSTEGR

      SUBROUTINE DSTEGR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DSTEGR

      SUBROUTINE CSTEGR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE CSTEGR

      SUBROUTINE ZSTEGR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE ZSTEGR

      MODULE PROCEDURE SSTEGR_NAT
      MODULE PROCEDURE DSTEGR_NAT
      MODULE PROCEDURE CSTEGR_NAT
      MODULE PROCEDURE ZSTEGR_NAT

      END INTERFACE ! LA_STEGR
      PRIVATE SSTEGR_NAT, DSTEGR_NAT, CSTEGR_NAT, ZSTEGR_NAT
!
!-----Interface for xSTEIN
!
      INTERFACE LA_STEIN

      SUBROUTINE SSTEIN( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK, ISPLIT
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(IN) :: D, E, W
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SSTEIN

      SUBROUTINE DSTEIN( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK, ISPLIT
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(IN) :: D, E, W
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DSTEIN

      SUBROUTINE CSTEIN( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK, ISPLIT
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(IN) :: D, E, W
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE CSTEIN

      SUBROUTINE ZSTEIN( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ, WORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK, ISPLIT
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(IN) :: D, E, W
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(OUT) :: Z
      END SUBROUTINE ZSTEIN

      MODULE PROCEDURE SSTEIN_D1Z2W1
      MODULE PROCEDURE DSTEIN_D1Z2W1
      MODULE PROCEDURE CSTEIN_D1Z2W1
      MODULE PROCEDURE ZSTEIN_D1Z2W1

      END INTERFACE ! LA_STEIN
      PRIVATE SSTEIN_D1Z2W1, DSTEIN_D1Z2W1, CSTEIN_D1Z2W1, ZSTEIN_D1Z2W1
!
!-----Interface for xSTEQR
!
      INTERFACE LA_STEQR

      SUBROUTINE SSTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SSTEQR

      SUBROUTINE DSTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DSTEQR

      SUBROUTINE CSTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE CSTEQR

      SUBROUTINE ZSTEQR( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Z
      END SUBROUTINE ZSTEQR

      MODULE PROCEDURE SSTEQR_D1Z2W1
      MODULE PROCEDURE DSTEQR_D1Z2W1
      MODULE PROCEDURE CSTEQR_D1Z2W1
      MODULE PROCEDURE ZSTEQR_D1Z2W1

      END INTERFACE ! LA_STEQR
      PRIVATE SSTEQR_D1Z2W1, DSTEQR_D1Z2W1, CSTEQR_D1Z2W1, ZSTEQR_D1Z2W1
!
!-----Interface for xSTERF
!
      INTERFACE LA_STERF

      SUBROUTINE SSTERF( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
      END SUBROUTINE SSTERF

      SUBROUTINE DSTERF( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
      END SUBROUTINE DSTERF

      MODULE PROCEDURE SSTERF_D1E1
      MODULE PROCEDURE DSTERF_D1E1

      END INTERFACE ! LA_STERF
      PRIVATE SSTERF_D1E1, DSTERF_D1E1
!
!-----Interface for xSTEV
!
      INTERFACE LA_STEV

      SUBROUTINE SSTEV( JOBZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SSTEV

      SUBROUTINE DSTEV( JOBZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DSTEV

      MODULE PROCEDURE SSTEV_NAT
      MODULE PROCEDURE DSTEV_NAT

      END INTERFACE ! LA_SSTEV
      PRIVATE SSTEV_NAT, DSTEV_NAT
!
!-----Interface for xSTEVD
!
      INTERFACE LA_STEVD

      SUBROUTINE SSTEVD( JOBZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE SSTEVD

      SUBROUTINE DSTEVD( JOBZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE DSTEVD

      MODULE PROCEDURE SSTEVD_NAT
      MODULE PROCEDURE DSTEVD_NAT

      END INTERFACE ! LA_STEVD
      PRIVATE SSTEVD_NAT, DSTEVD_NAT
!
!-----Interface for xSTEVR
!
      INTERFACE LA_STEVR

      SUBROUTINE SSTEVR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU, ABSTOL,
     &                   M, W, Z, LDZ, ISUPPZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: N, IL, IU, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSTEVR

      SUBROUTINE DSTEVR( JOBZ, RANGE, N, D, E, VL, VU, IL, IU, ABSTOL,
     &                   M, W, Z, LDZ, ISUPPZ, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: N, IL, IU, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSTEVR

      MODULE PROCEDURE SSTEVR_NAT
      MODULE PROCEDURE DSTEVR_NAT

      END INTERFACE ! LA_STEVR
      PRIVATE SSTEVR_NAT, DSTEVR_NAT
!
!-----Interface for xSTEVX
!
      INTERFACE LA_STEVX

      SUBROUTINE SSTEVX( JOBZ, RANGE, N, D, E, VL, VU, IL, IU, ABSTOL,
     &                   M, W, Z, LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSTEVX

      SUBROUTINE DSTEVX( JOBZ, RANGE, N, D, E, VL, VU, IL, IU, ABSTOL,
     &                   M, W, Z, LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSTEVX

      MODULE PROCEDURE SSTEVX_NAT
      MODULE PROCEDURE DSTEVX_NAT

      END INTERFACE ! LA_STEVX
      PRIVATE SSTEVX_NAT, DSTEVX_NAT
!
!-----Interface for xSYCON and xHECON
!
      INTERFACE LA_SYCON

      SUBROUTINE SSYCON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSYCON

      SUBROUTINE DSYCON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSYCON

      SUBROUTINE CSYCON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSYCON

      SUBROUTINE ZSYCON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSYCON

      END INTERFACE ! LA_SYCON

      INTERFACE LA_HECON

      SUBROUTINE CHECON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHECON

      SUBROUTINE ZHECON( UPLO, N, A, LDA, IPIV, ANORM, RCOND, WORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ANORM
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHECON

      END INTERFACE ! LA_HECON
!
!-----Interface for xSYEV and xHEEV
!
      INTERFACE LA_SYEV

      SUBROUTINE SSYEV( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE SSYEV

      SUBROUTINE DSYEV( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE DSYEV

      MODULE PROCEDURE SSYEV_NAT
      MODULE PROCEDURE DSYEV_NAT

      END INTERFACE ! LA_SYEV
      PRIVATE SSYEV_NAT, DSYEV_NAT

      INTERFACE LA_HEEV

      SUBROUTINE CHEEV( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHEEV

      SUBROUTINE ZHEEV( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHEEV

      MODULE PROCEDURE CHEEV_NAT
      MODULE PROCEDURE ZHEEV_NAT

      END INTERFACE ! LA_HEEV
      PRIVATE CHEEV_NAT, ZHEEV_NAT
!
!-----Interface for xSYEVD and xHEEVD
!
      INTERFACE LA_SYEVD

      SUBROUTINE SSYEVD( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE SSYEVD

      SUBROUTINE DSYEVD( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, IWORK,
     &                   LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE DSYEVD

      MODULE PROCEDURE SSYEVD_NAT
      MODULE PROCEDURE DSYEVD_NAT

      END INTERFACE ! LA_SYEVD
      PRIVATE SSYEVD_NAT, DSYEVD_NAT

      INTERFACE LA_HEEVD

      SUBROUTINE CHEEVD( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, RWORK,
     &                   LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHEEVD

      SUBROUTINE ZHEEVD( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, RWORK,
     &                   LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHEEVD

      MODULE PROCEDURE CHEEVD_NAT
      MODULE PROCEDURE ZHEEVD_NAT

      END INTERFACE ! LA_HEEVD
      PRIVATE CHEEVD_NAT, ZHEEVD_NAT
!
!-----Interface for xSYEVR and xHEEVR
!
      INTERFACE LA_SYEVR

      SUBROUTINE SSYEVR( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE  SSYEVR

      SUBROUTINE DSYEVR( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE  DSYEVR

      MODULE PROCEDURE SSYEVR_NAT
      MODULE PROCEDURE DSYEVR_NAT

      END INTERFACE ! LA_SYEVR
      PRIVATE SSYEVR_NAT, DSYEVR_NAT

      INTERFACE LA_HEEVR

      SUBROUTINE CHEEVR( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHEEVR

      SUBROUTINE ZHEEVR( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHEEVR

      MODULE PROCEDURE CHEEVR_NAT
      MODULE PROCEDURE ZHEEVR_NAT

      END INTERFACE ! LA_HEEVR
      PRIVATE CHEEVR_NAT, ZHEEVR_NAT
!
!-----Interface for xSYEVX and xHEEVX
!
      INTERFACE LA_SYEVX

      SUBROUTINE SSYEVX( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, LWORK, IWORK,
     &                   IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSYEVX

      SUBROUTINE DSYEVX( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, LWORK, IWORK,
     &                   IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSYEVX

      MODULE PROCEDURE SSYEVX_NAT
      MODULE PROCEDURE DSYEVX_NAT

      END INTERFACE ! LA_SYEVX
      PRIVATE SSYEVX_NAT, DSYEVX_NAT

      INTERFACE LA_HEEVX

      SUBROUTINE CHEEVX( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, LWORK, RWORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHEEVX

      SUBROUTINE ZHEEVX( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, WORK, LWORK, RWORK,
     &                   IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHEEVX

      MODULE PROCEDURE CHEEVX_NAT
      MODULE PROCEDURE ZHEEVX_NAT

      END INTERFACE ! LA_HEEVX
      PRIVATE CHEEVX_NAT, ZHEEVX_NAT
!
!-----Interface for xSYGST and xHEGST
!
      INTERFACE LA_SYGST

      SUBROUTINE SSYGST( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SSYGST

      SUBROUTINE DSYGST( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE DSYGST

      MODULE PROCEDURE SSYGST_A2B2
      MODULE PROCEDURE DSYGST_A2B2

      END INTERFACE ! LA_SYGST
      PRIVATE SSYGST_A2B2, DSYGST_A2B2

      INTERFACE LA_HEGST

      SUBROUTINE CHEGST( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CHEGST

      SUBROUTINE ZHEGST( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE ZHEGST

      MODULE PROCEDURE CHEGST_A2B2
      MODULE PROCEDURE ZHEGST_A2B2

      END INTERFACE ! LA_HEGST
      PRIVATE CHEGST_A2B2, ZHEGST_A2B2
!
!-----Interface for xSYGV and xHEGV
!
      INTERFACE LA_SYGV

      SUBROUTINE SSYGV( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE SSYGV

      SUBROUTINE DSYGV( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE DSYGV

      MODULE PROCEDURE SSYGV_NAT
      MODULE PROCEDURE DSYGV_NAT

      END INTERFACE ! LA_SYGV
      PRIVATE SSYGV_NAT, DSYGV_NAT

      INTERFACE LA_HEGV

      SUBROUTINE CHEGV( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                  LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHEGV

      SUBROUTINE ZHEGV( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                  LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHEGV

      MODULE PROCEDURE CHEGV_NAT
      MODULE PROCEDURE ZHEGV_NAT

      END INTERFACE ! LA_HEGV
      PRIVATE CHEGV_NAT, ZHEGV_NAT
!
!-----Interface for xSYGVD and xHEGVD
!
      INTERFACE LA_SYGVD

      SUBROUTINE SSYGVD( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                   LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE SSYGVD

      SUBROUTINE DSYGVD( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                   LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE DSYGVD

      MODULE PROCEDURE SSYGVD_NAT
      MODULE PROCEDURE DSYGVD_NAT

      END INTERFACE ! LA_SYGVD
      PRIVATE SSYGVD_NAT, DSYGVD_NAT

      INTERFACE LA_HEGVD

      SUBROUTINE CHEGVD( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHEGVD

      SUBROUTINE ZHEGVD( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W, WORK,
     &                   LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHEGVD

      MODULE PROCEDURE CHEGVD_NAT
      MODULE PROCEDURE ZHEGVD_NAT

      END INTERFACE ! LA_HEGVD
      PRIVATE CHEGVD_NAT, ZHEGVD_NAT
!
!-----Interface for xSYGVX and xHEGVX
!
      INTERFACE LA_SYGVX

      SUBROUTINE SSYGVX( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B, LDB,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   LWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, IL, IU, LDZ, LDA, LDB, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE SSYGVX

      SUBROUTINE DSYGVX( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B, LDB,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   LWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, IL, IU, LDZ, LDA, LDB, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: W, WORK, Z
      END SUBROUTINE DSYGVX

      MODULE PROCEDURE SSYGVX_NAT
      MODULE PROCEDURE DSYGVX_NAT

      END INTERFACE ! LA_SYGVX
      PRIVATE SSYGVX_NAT, DSYGVX_NAT

      INTERFACE LA_HEGVX

      SUBROUTINE CHEGVX( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B, LDB,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDA, LDB, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE CHEGVX

      SUBROUTINE ZHEGVX( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B, LDB,
     &                   VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                   LWORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDA, LDB, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL, IWORK
         REAL(WP), INTENT(OUT) :: RWORK, W
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK, Z
      END SUBROUTINE ZHEGVX

      MODULE PROCEDURE CHEGVX_NAT
      MODULE PROCEDURE ZHEGVX_NAT

      END INTERFACE ! LA_HEGVX
      PRIVATE CHEGVX_NAT, ZHEGVX_NAT
!
!-----Interface for xSYRFS and xHERFS
!
      INTERFACE LA_SYRFS

      SUBROUTINE SSYRFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSYRFS

      SUBROUTINE DSYRFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSYRFS

      SUBROUTINE CSYRFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSYRFS

      SUBROUTINE ZSYRFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSYRFS

      END INTERFACE ! LA_SYRFS

      INTERFACE LA_HERFS

      SUBROUTINE CHERFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHERFS

      SUBROUTINE ZHERFS( UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B, LDB,
     &                   X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) ::  A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHERFS

      END INTERFACE ! LA_HERFS
!
!-----Interface for xSYSV and xHESV
!
      INTERFACE LA_SYSV

      SUBROUTINE SSYSV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SSYSV

      SUBROUTINE DSYSV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DSYSV

      SUBROUTINE CSYSV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CSYSV

      SUBROUTINE ZSYSV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZSYSV

      MODULE PROCEDURE SSYSV_A2B2W1
      MODULE PROCEDURE DSYSV_A2B2W1
      MODULE PROCEDURE CSYSV_A2B2W1
      MODULE PROCEDURE ZSYSV_A2B2W1

      END INTERFACE ! LA_SYSV
      PRIVATE SSYSV_A2B2W1, DSYSV_A2B2W1, CSYSV_A2B2W1, ZSYSV_A2B2W1

      INTERFACE LA_HESV

      SUBROUTINE CHESV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHESV

      SUBROUTINE ZHESV( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, WORK,
     &                  LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, B
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHESV

      MODULE PROCEDURE CHESV_A2B2W1
      MODULE PROCEDURE ZHESV_A2B2W1

      END INTERFACE ! LA_HESV
      PRIVATE CHESV_A2B2W1, ZHESV_A2B2W1
!
!-----Interface for xSYSVX and xHESVX
!
      INTERFACE LA_SYSVX

      SUBROUTINE SSYSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: AF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE SSYSVX

      SUBROUTINE DSYSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: AF
         REAL(WP), INTENT(OUT) :: BERR, FERR, WORK, X
      END SUBROUTINE DSYSVX

      SUBROUTINE CSYSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: AF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CSYSVX

      SUBROUTINE ZSYSVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: AF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZSYSVX

      MODULE PROCEDURE SSYSVX_A2B2W1
      MODULE PROCEDURE DSYSVX_A2B2W1
      MODULE PROCEDURE CSYSVX_A2B2W1
      MODULE PROCEDURE ZSYSVX_A2B2W1

      END INTERFACE ! LA_SYSVX
      PRIVATE SSYSVX_A2B2W1, DSYSVX_A2B2W1, CSYSVX_A2B2W1, ZSYSVX_A2B2W1

      INTERFACE LA_HESVX

      SUBROUTINE CHESVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: AF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE CHESVX

      SUBROUTINE ZHESVX( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF, IPIV, B,
     &                   LDB, X, LDX, RCOND, FERR, BERR, WORK, LWORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: AF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
      END SUBROUTINE ZHESVX

      MODULE PROCEDURE CHESVX_A2B2W1
      MODULE PROCEDURE ZHESVX_A2B2W1

      END INTERFACE ! LA_HESVX
      PRIVATE CHESVX_A2B2W1, ZHESVX_A2B2W1
!
!-----Interface for xSYTRD and xHETRD
!
      INTERFACE LA_SYTRD

      SUBROUTINE SSYTRD( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAU, WORK
      END SUBROUTINE SSYTRD

      SUBROUTINE DSYTRD( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAU, WORK
      END SUBROUTINE DSYTRD

      MODULE PROCEDURE SSYTRD_NAT
      MODULE PROCEDURE DSYTRD_NAT

      END INTERFACE ! LA_SYTRD
      PRIVATE SSYTRD_NAT, DSYTRD_NAT

      INTERFACE LA_HETRD

      SUBROUTINE CHETRD( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CHETRD

      SUBROUTINE ZHETRD( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZHETRD

      MODULE PROCEDURE CHETRD_NAT
      MODULE PROCEDURE ZHETRD_NAT

      END INTERFACE ! LA_HETRD
      PRIVATE CHETRD_NAT, ZHETRD_NAT
!
!-----Interface for xSYTRF and xHETRF
!
      INTERFACE LA_SYTRF

      SUBROUTINE SSYTRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SSYTRF

      SUBROUTINE DSYTRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DSYTRF

      SUBROUTINE CSYTRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CSYTRF

      SUBROUTINE ZSYTRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZSYTRF

      MODULE PROCEDURE SSYTRF_A2I1W1
      MODULE PROCEDURE DSYTRF_A2I1W1
      MODULE PROCEDURE CSYTRF_A2I1W1
      MODULE PROCEDURE ZSYTRF_A2I1W1

      END INTERFACE ! LA_SYTRF
      PRIVATE SSYTRF_A2I1W1, DSYTRF_A2I1W1, CSYTRF_A2I1W1, ZSYTRF_A2I1W1

      INTERFACE LA_HETRF

      SUBROUTINE CHETRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CHETRF

      SUBROUTINE ZHETRF( UPLO, N, A, LDA, IPIV, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZHETRF

      MODULE PROCEDURE CHETRF_A2I1W1
      MODULE PROCEDURE ZHETRF_A2I1W1

      END INTERFACE ! LA_HETRF
      PRIVATE CHETRF_A2I1W1, ZHETRF_A2I1W1
!
!-----Interface for xSYTRI and xHETRI
!
      INTERFACE LA_SYTRI

      SUBROUTINE SSYTRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE SSYTRI

      SUBROUTINE DSYTRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DSYTRI

      SUBROUTINE CSYTRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CSYTRI

      SUBROUTINE ZSYTRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZSYTRI

      END INTERFACE ! LA_SYTRI

      INTERFACE LA_HETRI

      SUBROUTINE CHETRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CHETRI

      SUBROUTINE ZHETRI( UPLO, N, A, LDA, IPIV, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZHETRI

      END INTERFACE ! LA_HETRI
!
!-----Interface for xSYTRS and xHETRS
!
      INTERFACE LA_SYTRS

      SUBROUTINE SSYTRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SSYTRS

      SUBROUTINE DSYTRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DSYTRS

      SUBROUTINE CSYTRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CSYTRS

      SUBROUTINE ZSYTRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZSYTRS

      MODULE PROCEDURE SSYTRS_A2I1B2
      MODULE PROCEDURE DSYTRS_A2I1B2
      MODULE PROCEDURE CSYTRS_A2I1B2
      MODULE PROCEDURE ZSYTRS_A2I1B2

      MODULE PROCEDURE SSYTRS_A2I1B1
      MODULE PROCEDURE DSYTRS_A2I1B1
      MODULE PROCEDURE CSYTRS_A2I1B1
      MODULE PROCEDURE ZSYTRS_A2I1B1

      END INTERFACE ! LA_SYTRS
      PRIVATE SSYTRS_A2I1B2, DSYTRS_A2I1B2, CSYTRS_A2I1B2, ZSYTRS_A2I1B2
      PRIVATE SSYTRS_A2I1B1, DSYTRS_A2I1B1, CSYTRS_A2I1B1, ZSYTRS_A2I1B1

      INTERFACE LA_HETRS

      SUBROUTINE CHETRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CHETRS

      SUBROUTINE ZHETRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZHETRS

      MODULE PROCEDURE CHETRS_A2I1B2
      MODULE PROCEDURE ZHETRS_A2I1B2

      MODULE PROCEDURE CHETRS_A2I1B1
      MODULE PROCEDURE ZHETRS_A2I1B1

      END INTERFACE ! LA_HETRS
      PRIVATE CHETRS_A2I1B2, ZHETRS_A2I1B2, CHETRS_A2I1B1, ZHETRS_A2I1B1
!
!-----Interface for xTBCON
!
      INTERFACE LA_TBCON

      SUBROUTINE STBCON( NORM, UPLO, DIAG, N, KD, AB, LDAB, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STBCON

      SUBROUTINE DTBCON( NORM, UPLO, DIAG, N, KD, AB, LDAB, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTBCON

      SUBROUTINE CTBCON( NORM, UPLO, DIAG, N, KD, AB, LDAB, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTBCON

      SUBROUTINE ZTBCON( NORM, UPLO, DIAG, N, KD, AB, LDAB, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTBCON

      END INTERFACE ! LA_TBCON
!
!-----Interface for xTBRFS
!
      INTERFACE LA_TBRFS

      SUBROUTINE STBRFS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*), B(LDB,*), X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STBRFS

      SUBROUTINE DTBRFS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*), B(LDB,*), X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTBRFS

      SUBROUTINE CTBRFS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*), B(LDB,*), X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTBRFS

      SUBROUTINE ZTBRFS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, X, LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*), B(LDB,*), X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTBRFS

      END INTERFACE ! LA_TBRFS
!
!-----Interface for xTBTRS
!
      INTERFACE LA_TBTRS

      SUBROUTINE STBTRS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE STBTRS

      SUBROUTINE DTBTRS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE DTBTRS

      SUBROUTINE CTBTRS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE CTBTRS

      SUBROUTINE ZTBTRS( UPLO, TRANS, DIAG, N, KD, NRHS, AB, LDAB, B,
     &                   LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE ZTBTRS

      END INTERFACE ! LA_TBTRS
!
!-----Interface for xTGEVC
!
      INTERFACE LA_TGEVC

      SUBROUTINE STGEVC( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: VL, VR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE STGEVC

      SUBROUTINE DTGEVC( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: VL, VR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DTGEVC

      SUBROUTINE CTGEVC( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, MM, M, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTGEVC

      SUBROUTINE ZTGEVC( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, MM, M, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTGEVC

      MODULE PROCEDURE STGEVC_A2B2W1
      MODULE PROCEDURE DTGEVC_A2B2W1
      MODULE PROCEDURE CTGEVC_A2B2W1
      MODULE PROCEDURE ZTGEVC_A2B2W1

      MODULE PROCEDURE STGEVC_A2B2W0
      MODULE PROCEDURE DTGEVC_A2B2W0
      MODULE PROCEDURE CTGEVC_A2B2W0
      MODULE PROCEDURE ZTGEVC_A2B2W0

      END INTERFACE ! LA_TGEVC
      PRIVATE STGEVC_A2B2W1, DTGEVC_A2B2W1, CTGEVC_A2B2W1, ZTGEVC_A2B2W1
      PRIVATE STGEVC_A2B2W0, DTGEVC_A2B2W0, CTGEVC_A2B2W0, ZTGEVC_A2B2W0
!
!-----Interface for xTGEXC
!
      INTERFACE LA_TGEXC

      SUBROUTINE STGEXC( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ, Z,
     &                   LDZ, IFST, ILST, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE STGEXC

      SUBROUTINE DTGEXC( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ, Z,
     &                   LDZ, IFST, ILST, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DTGEXC

      SUBROUTINE CTGEXC( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ, Z,
     &                   LDZ, IFST, ILST, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE CTGEXC

      SUBROUTINE ZTGEXC( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ, Z,
     &                   LDZ, IFST, ILST, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
      END SUBROUTINE ZTGEXC

      MODULE PROCEDURE STGEXC_A2B2Q2
      MODULE PROCEDURE DTGEXC_A2B2Q2
      MODULE PROCEDURE CTGEXC_A2B2Q2
      MODULE PROCEDURE ZTGEXC_A2B2Q2

      END INTERFACE ! LA_TGEXC
      PRIVATE STGEXC_A2B2Q2, DTGEXC_A2B2Q2, CTGEXC_A2B2Q2, ZTGEXC_A2B2Q2
!
!-----Interface for xTGSEN
!
      INTERFACE LA_TGSEN

      SUBROUTINE STGSEN( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, Q, LDQ, Z, LDZ, M, PL,
     &                   PR, DIF, WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, DIF, WORK
      END SUBROUTINE STGSEN

      SUBROUTINE DTGSEN( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA, B, LDB,
     &                   ALPHAR, ALPHAI, BETA, Q, LDQ, Z, LDZ, M, PL,
     &                   PR, DIF, WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: A, B, Q, Z
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA, DIF, WORK
      END SUBROUTINE DTGSEN

      SUBROUTINE CTGSEN( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA, B, LDB,
     &                   ALPHA, BETA, Q, LDQ, Z, LDZ, M, PL, PR, DIF,
     &                   WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: DIF
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE CTGSEN

      SUBROUTINE ZTGSEN( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA, B, LDB,
     &                   ALPHA, BETA, Q, LDQ, Z, LDZ, M, PL, PR, DIF,
     &                   WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: DIF
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, Z
         COMPLEX(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE ZTGSEN

      MODULE PROCEDURE STGSEN_A2B2W1
      MODULE PROCEDURE DTGSEN_A2B2W1
      MODULE PROCEDURE CTGSEN_A2B2W1
      MODULE PROCEDURE ZTGSEN_A2B2W1

      END INTERFACE ! LA_TGSEN
      PRIVATE STGSEN_A2B2W1, DTGSEN_A2B2W1, CTGSEN_A2B2W1, ZTGSEN_A2B2W1
!
!-----Interface for xTGSJA
!
      INTERFACE LA_TGSJA

      SUBROUTINE STGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA, B,
     &                   LDB, TOLA, TOLB, ALPHA, BETA, U, LDU, V, LDV,
     &                   Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(INOUT) :: A, B, Q, U, V
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE STGSJA

      SUBROUTINE DTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA, B,
     &                   LDB, TOLA, TOLB, ALPHA, BETA, U, LDU, V, LDV,
     &                   Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(INOUT) :: A, B, Q, U, V
         REAL(WP), INTENT(OUT) :: ALPHA, BETA, WORK
      END SUBROUTINE DTGSJA

      SUBROUTINE CTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA, B,
     &                   LDB, TOLA, TOLB, ALPHA, BETA, U, LDU, V, LDV,
     &                   Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(OUT) :: ALPHA, BETA
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, U, V
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTGSJA

      SUBROUTINE ZTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA, B,
     &                   LDB, TOLA, TOLB, ALPHA, BETA, U, LDU, V, LDV,
     &                   Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(OUT) :: ALPHA, BETA
         COMPLEX(WP), INTENT(INOUT) :: A, B, Q, U, V
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTGSJA

      MODULE PROCEDURE STGSJA_A2B2W1
      MODULE PROCEDURE DTGSJA_A2B2W1
      MODULE PROCEDURE CTGSJA_A2B2W1
      MODULE PROCEDURE ZTGSJA_A2B2W1

      END INTERFACE ! LA_TGSJA
      PRIVATE STGSJA_A2B2W1, DTGSJA_A2B2W1, CTGSJA_A2B2W1, ZTGSJA_A2B2W1
!
!-----Interface for xTGSNA
!
      INTERFACE LA_TGSNA

      SUBROUTINE STGSNA( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, S, DIF, MM, M, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B, VL, VR
         REAL(WP), INTENT(OUT) :: DIF, S, WORK
      END SUBROUTINE STGSNA

      SUBROUTINE DTGSNA( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, S, DIF, MM, M, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B, VL, VR
         REAL(WP), INTENT(OUT) :: DIF, S, WORK
      END SUBROUTINE DTGSNA

      SUBROUTINE CTGSNA( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, S, DIF, MM, M, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: DIF, S
         COMPLEX(WP), INTENT(IN) :: A, B, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTGSNA

      SUBROUTINE ZTGSNA( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB, VL,
     &                   LDVL, VR, LDVR, S, DIF, MM, M, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(OUT) :: DIF, S
         COMPLEX(WP), INTENT(IN) :: A, B, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTGSNA

      MODULE PROCEDURE STGSNA_A2B2W1
      MODULE PROCEDURE DTGSNA_A2B2W1
      MODULE PROCEDURE CTGSNA_A2B2W1
      MODULE PROCEDURE ZTGSNA_A2B2W1

      END INTERFACE ! LA_TGSNA
      PRIVATE STGSNA_A2B2W1, DTGSNA_A2B2W1, CTGSNA_A2B2W1, ZTGSNA_A2B2W1
!
!-----Interface for xTGSYL
!
      INTERFACE LA_TGSYL

      SUBROUTINE STGSYL( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     &                   LDD, E, LDE, F, LDF, SCALE, DIF, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B, D, E
         REAL(WP), INTENT(INOUT) :: C, F
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE STGSYL

      SUBROUTINE DTGSYL( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     &                   LDD, E, LDE, F, LDF, SCALE, DIF, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B, D, E
         REAL(WP), INTENT(INOUT) :: C, F
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DTGSYL

      SUBROUTINE CTGSYL( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     &                   LDD, E, LDE, F, LDF, SCALE, DIF, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK
         COMPLEX(WP), INTENT(IN) :: A, B, D, E
         COMPLEX(WP), INTENT(INOUT) :: C, F
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTGSYL

      SUBROUTINE ZTGSYL( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     &                   LDD, E, LDE, F, LDF, SCALE, DIF, WORK, LWORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK
         COMPLEX(WP), INTENT(IN) :: A, B, D, E
         COMPLEX(WP), INTENT(INOUT) :: C, F
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTGSYL

      MODULE PROCEDURE STGSYL_A2B2W1
      MODULE PROCEDURE DTGSYL_A2B2W1
      MODULE PROCEDURE CTGSYL_A2B2W1
      MODULE PROCEDURE ZTGSYL_A2B2W1

      END INTERFACE ! LA_TGSYL
      PRIVATE STGSYL_A2B2W1, DTGSYL_A2B2W1, CTGSYL_A2B2W1, ZTGSYL_A2B2W1
!
!-----Interface for xTPCON
!
      INTERFACE LA_TPCON

      SUBROUTINE STPCON( NORM, UPLO, DIAG, N, AP, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STPCON

      SUBROUTINE DTPCON( NORM, UPLO, DIAG, N, AP, RCOND, WORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTPCON

      SUBROUTINE CTPCON( NORM, UPLO, DIAG, N, AP, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTPCON

      SUBROUTINE ZTPCON( NORM, UPLO, DIAG, N, AP, RCOND, WORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTPCON

      END INTERFACE ! LA_TPCON
!
!-----Interface for xTPRFS
!
      INTERFACE LA_TPRFS

      SUBROUTINE STPRFS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AP(*), B(LDB,*), X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STPRFS

      SUBROUTINE DTPRFS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: AP(*), B(LDB,*), X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTPRFS

      SUBROUTINE CTPRFS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*), X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTPRFS

      SUBROUTINE ZTPRFS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, X, LDX,
     &                   FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*), X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTPRFS

      END INTERFACE ! LA_TPRFS
!
!-----Interface for xTPTRI
!
      INTERFACE LA_TPTRI

      SUBROUTINE STPTRI( UPLO, DIAG, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE STPTRI

      SUBROUTINE DTPTRI( UPLO, DIAG, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE DTPTRI

      SUBROUTINE CTPTRI( UPLO, DIAG, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE CTPTRI

      SUBROUTINE ZTPTRI( UPLO, DIAG, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
      END SUBROUTINE ZTPTRI

      END INTERFACE ! LA_TPTRI
!
!-----Interface for xTPTRS
!
      INTERFACE LA_TPTRS

      SUBROUTINE STPTRS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE STPTRS

      SUBROUTINE DTPTRS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE DTPTRS

      SUBROUTINE CTPTRS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE CTPTRS

      SUBROUTINE ZTPTRS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE ZTPTRS

      END INTERFACE ! LA_TPTRS
!
!-----Interface for xTRCON
!
      INTERFACE LA_TRCON

      SUBROUTINE STRCON( NORM, UPLO, DIAG, N, A, LDA, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STRCON

      SUBROUTINE DTRCON( NORM, UPLO, DIAG, N, A, LDA, RCOND, WORK,
     &                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTRCON

      SUBROUTINE CTRCON( NORM, UPLO, DIAG, N, A, LDA, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTRCON

      SUBROUTINE ZTRCON( NORM, UPLO, DIAG, N, A, LDA, RCOND, WORK,
     &                   RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND, RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTRCON

      END INTERFACE ! LA_TRCON
!
!-----Interface for xTREVC
!
      INTERFACE LA_TREVC

      SUBROUTINE STREVC( SIDE, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT
         REAL(WP), INTENT(IN) :: T
         REAL(WP), INTENT(INOUT) :: VL, VR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE STREVC

      SUBROUTINE DTREVC( SIDE, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT
         REAL(WP), INTENT(IN) :: T
         REAL(WP), INTENT(INOUT) :: VL, VR
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DTREVC

      SUBROUTINE CTREVC( SIDE, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, MM, M, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: T, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTREVC

      SUBROUTINE ZTREVC( SIDE, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, MM, M, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: T, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTREVC

      MODULE PROCEDURE STREVC_T2V2W1
      MODULE PROCEDURE DTREVC_T2V2W1
      MODULE PROCEDURE CTREVC_T2V2W1
      MODULE PROCEDURE ZTREVC_T2V2W1

      MODULE PROCEDURE STREVC_T2V2W0
      MODULE PROCEDURE DTREVC_T2V2W0
      MODULE PROCEDURE CTREVC_T2V2W0
      MODULE PROCEDURE ZTREVC_T2V2W0

      END INTERFACE ! LA_TREVC
      PRIVATE STREVC_T2V2W1, DTREVC_T2V2W1, CTREVC_T2V2W1, ZTREVC_T2V2W1
      PRIVATE STREVC_T2V2W0, DTREVC_T2V2W0, CTREVC_T2V2W0, ZTREVC_T2V2W0
!
!-----Interface for STREXC
!
      INTERFACE LA_TREXC

      SUBROUTINE STREXC( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST, WORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: LDQ, LDT, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Q, T
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE STREXC

      SUBROUTINE DTREXC( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST, WORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: LDQ, LDT, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Q, T
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DTREXC

      SUBROUTINE CTREXC( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: IFST, ILST, LDQ, LDT, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: Q, T
      END SUBROUTINE CTREXC

      SUBROUTINE ZTREXC( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: IFST, ILST, LDQ, LDT, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: Q, T
      END SUBROUTINE ZTREXC

      MODULE PROCEDURE STREXC_T2Q2W1
      MODULE PROCEDURE DTREXC_T2Q2W1
      MODULE PROCEDURE CTREXC_T2Q2
      MODULE PROCEDURE ZTREXC_T2Q2

      END INTERFACE ! LA_TREXC
      PRIVATE STREXC_T2Q2W1, DTREXC_T2Q2W1, CTREXC_T2Q2, ZTREXC_T2Q2
!
!-----Interface for xTRRFS
!
      INTERFACE LA_TRRFS

      SUBROUTINE STRRFS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(IN) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE STRRFS

      SUBROUTINE DTRRFS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, IWORK(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(IN) :: X(LDX,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE DTRRFS

      SUBROUTINE CTRRFS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE CTRRFS

      SUBROUTINE ZTRRFS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB, X,
     &                   LDX, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
      END SUBROUTINE ZTRRFS

      END INTERFACE ! LA_TRRFS
!
!-----Interface for xTRSEN
!
      INTERFACE LA_TRSEN

      SUBROUTINE STRSEN( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ, WR, WI,
     &                   M, S, SEP, WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: Q, T
         REAL(WP), INTENT(OUT) :: WI, WORK, WR
      END SUBROUTINE STRSEN

      SUBROUTINE DTRSEN( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ, WR, WI,
     &                   M, S, SEP, WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: Q, T
         REAL(WP), INTENT(OUT) :: WI, WORK, WR
      END SUBROUTINE DTRSEN

      SUBROUTINE CTRSEN( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ, W,
     &                   M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT
         COMPLEX(WP), INTENT(INOUT) :: Q, T
         COMPLEX(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE CTRSEN

      SUBROUTINE ZTRSEN( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ, W,
     &                   M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT
         COMPLEX(WP), INTENT(INOUT) :: Q, T
         COMPLEX(WP), INTENT(OUT) :: W, WORK
      END SUBROUTINE ZTRSEN

      MODULE PROCEDURE STRSEN_T2Q2W1
      MODULE PROCEDURE DTRSEN_T2Q2W1
      MODULE PROCEDURE CTRSEN_T2Q2W1
      MODULE PROCEDURE ZTRSEN_T2Q2W1

      MODULE PROCEDURE STRSEN_T2Q2W0
      MODULE PROCEDURE DTRSEN_T2Q2W0
      MODULE PROCEDURE CTRSEN_T2Q2W0
      MODULE PROCEDURE ZTRSEN_T2Q2W0

      END INTERFACE ! LA_TRSEN
      PRIVATE STRSEN_T2Q2W1, DTRSEN_T2Q2W1, CTRSEN_T2Q2W1, ZTRSEN_T2Q2W1
      PRIVATE STRSEN_T2Q2W0, DTRSEN_T2Q2W0, CTRSEN_T2Q2W0, ZTRSEN_T2Q2W0
!
!-----Interface for xTRSNA
!
      INTERFACE LA_TRSNA

      SUBROUTINE STRSNA( JOB, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, S, SEP, MM, M, WORK, LDWORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: T, VL, VR
         REAL(WP), INTENT(OUT) :: S, SEP, WORK
      END SUBROUTINE STRSNA

      SUBROUTINE DTRSNA( JOB, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, S, SEP, MM, M, WORK, LDWORK, IWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: T, VL, VR
         REAL(WP), INTENT(OUT) :: S, SEP, WORK
      END SUBROUTINE DTRSNA

      SUBROUTINE CTRSNA( JOB, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, S, SEP, MM, M, WORK, LDWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK, S, SEP
         COMPLEX(WP), INTENT(IN) :: T, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CTRSNA

      SUBROUTINE ZTRSNA( JOB, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
     &                   LDVR, S, SEP, MM, M, WORK, LDWORK, RWORK,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT
         REAL(WP), INTENT(OUT) :: RWORK, S, SEP
         COMPLEX(WP), INTENT(IN) :: T, VL, VR
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZTRSNA

      MODULE PROCEDURE STRSNA_T2V2W2
      MODULE PROCEDURE DTRSNA_T2V2W2
      MODULE PROCEDURE CTRSNA_T2V2W2
      MODULE PROCEDURE ZTRSNA_T2V2W2

      MODULE PROCEDURE STRSNA_T2V2W0
      MODULE PROCEDURE DTRSNA_T2V2W0
      MODULE PROCEDURE CTRSNA_T2V2W0
      MODULE PROCEDURE ZTRSNA_T2V2W0

      END INTERFACE ! LA_TRSNA
      PRIVATE STRSNA_T2V2W2, DTRSNA_T2V2W2, CTRSNA_T2V2W2, ZTRSNA_T2V2W2
      PRIVATE STRSNA_T2V2W0, DTRSNA_T2V2W0, CTRSNA_T2V2W0, ZTRSNA_T2V2W0
!
!-----Interface for xTRSYL
!
      INTERFACE LA_TRSYL

      SUBROUTINE STRSYL( TRANA, TRANB, ISGN, M, N, A, LDA, B, LDB, C,
     &                   LDC, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: C
      END SUBROUTINE STRSYL

      SUBROUTINE DTRSYL( TRANA, TRANB, ISGN, M, N, A, LDA, B, LDB, C,
     &                   LDC, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(INOUT) :: C
      END SUBROUTINE DTRSYL

      SUBROUTINE CTRSYL( TRANA, TRANB, ISGN, M, N, A, LDA, B, LDB, C,
     &                   LDC, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: C
      END SUBROUTINE CTRSYL

      SUBROUTINE ZTRSYL( TRANA, TRANB, ISGN, M, N, A, LDA, B, LDB, C,
     &                   LDC, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A, B
         COMPLEX(WP), INTENT(INOUT) :: C
      END SUBROUTINE ZTRSYL

      MODULE PROCEDURE STRSYL_A2B2C2
      MODULE PROCEDURE DTRSYL_A2B2C2
      MODULE PROCEDURE CTRSYL_A2B2C2
      MODULE PROCEDURE ZTRSYL_A2B2C2

      END INTERFACE ! LA_TRSYL
      PRIVATE STRSYL_A2B2C2, DTRSYL_A2B2C2, CTRSYL_A2B2C2, ZTRSYL_A2B2C2
!
!-----Interface for xTRTRI
!
      INTERFACE LA_TRTRI

      SUBROUTINE STRTRI( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE STRTRI

      SUBROUTINE DTRTRI( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE DTRTRI

      SUBROUTINE CTRTRI( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE CTRTRI

      SUBROUTINE ZTRTRI( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
      END SUBROUTINE ZTRTRI

      END INTERFACE ! LA_TRTRI
!
!-----Interface for xTRTRS
!
      INTERFACE LA_TRTRS

      SUBROUTINE STRTRS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE STRTRS

      SUBROUTINE DTRTRS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE DTRTRS

      SUBROUTINE CTRTRS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE CTRTRS

      SUBROUTINE ZTRTRS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
      END SUBROUTINE ZTRTRS

      END INTERFACE ! LA_TRTRS
!
!-----Interface for xTZRQF
!
      INTERFACE LA_TZRQF

      SUBROUTINE STZRQF( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU
      END SUBROUTINE STZRQF

      SUBROUTINE DTZRQF( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU
      END SUBROUTINE DTZRQF

      SUBROUTINE CTZRQF( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE CTZRQF

      SUBROUTINE ZTZRQF( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE ZTZRQF

      MODULE PROCEDURE STZRQF_A2T1
      MODULE PROCEDURE DTZRQF_A2T1
      MODULE PROCEDURE CTZRQF_A2T1
      MODULE PROCEDURE ZTZRQF_A2T1

      END INTERFACE ! LA_TZRQF
      PRIVATE STZRQF_A2T1, DTZRQF_A2T1, CTZRQF_A2T1, ZTZRQF_A2T1
!
!-----Interface for xTZRZF
!
      INTERFACE LA_TZRZF

      SUBROUTINE STZRZF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE STZRZF

      SUBROUTINE DTZRZF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DTZRZF

      SUBROUTINE CTZRZF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CTZRZF

      SUBROUTINE ZTZRZF( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZTZRZF

      MODULE PROCEDURE STZRZF_A2T1W1
      MODULE PROCEDURE DTZRZF_A2T1W1
      MODULE PROCEDURE CTZRZF_A2T1W1
      MODULE PROCEDURE ZTZRZF_A2T1W1

      END INTERFACE ! LA_TZRZF
      PRIVATE STZRZF_A2T1W1, DTZRZF_A2T1W1, CTZRZF_A2T1W1, ZTZRZF_A2T1W1

      CONTAINS
!
!-----Natural interface for xBDSDC
!
      SUBROUTINE SBDSDC_NAT( UPLO, COMPQ, N, D, E, U, LDU, VT, LDVT, Q,
     &                       IQ, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, UPLO
         INTEGER, INTENT(IN) :: LDU, LDVT, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IQ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: Q(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL SBDSDC( UPLO, COMPQ, N, D(1), E(1), U(1,1), LDU, VT(1,1),
     &                LDVT, Q(1), IQ(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE SBDSDC_NAT

      SUBROUTINE DBDSDC_NAT( UPLO, COMPQ, N, D, E, U, LDU, VT, LDVT, Q,
     &                       IQ, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, UPLO
         INTEGER, INTENT(IN) :: LDU, LDVT, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IQ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: Q(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL DBDSDC( UPLO, COMPQ, N, D(1), E(1), U(1,1), LDU, VT(1,1),
     &                LDVT, Q(1), IQ(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE DBDSDC_NAT
!
!-----Natural interface for xBDSQR
!
      SUBROUTINE SBDSQR_V2C2W1( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     &                          U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C(LDC,*), D(*), E(*), U(LDU,*),
     &                              VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SBDSQR( UPLO, N, NCVT, NRU, NCC, D(1), E(1), VT(1,1),
     &                LDVT, U(1,1), LDU, C(1,1), LDC, WORK(1), INFO )
      END SUBROUTINE SBDSQR_V2C2W1

      SUBROUTINE DBDSQR_V2C2W1( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     &                          U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C(LDC,*), D(*), E(*), U(LDU,*),
     &                              VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DBDSQR( UPLO, N, NCVT, NRU, NCC, D(1), E(1), VT(1,1),
     &                LDVT, U(1,1), LDU, C(1,1), LDC, WORK(1), INFO )
      END SUBROUTINE DBDSQR_V2C2W1

      SUBROUTINE CBDSQR_V2C2W1( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     &                          U, LDU, C, LDC, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         CALL CBDSQR( UPLO, N, NCVT, NRU, NCC, D(1), E(1), VT(1,1),
     &                LDVT, U(1,1), LDU, C(1,1), LDC, RWORK(1), INFO )
      END SUBROUTINE CBDSQR_V2C2W1

      SUBROUTINE ZBDSQR_V2C2W1( UPLO, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     &                          U, LDU, C, LDC, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         CALL ZBDSQR( UPLO, N, NCVT, NRU, NCC, D(1), E(1), VT(1,1),
     &                LDVT, U(1,1), LDU, C(1,1), LDC, RWORK(1), INFO )
      END SUBROUTINE ZBDSQR_V2C2W1
!
!-----Natural interface for xDISNA
!
      SUBROUTINE SDISNA_D1S1( JOB, M, N, D, SEP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(OUT) :: SEP(*)
         CALL SDISNA( JOB, M, N, D(1), SEP(1), INFO )
      END SUBROUTINE SDISNA_D1S1

      SUBROUTINE DDISNA_D1S1( JOB, M, N, D, SEP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(OUT) :: SEP(*)
         CALL DDISNA( JOB, M, N, D(1), SEP(1), INFO )
      END SUBROUTINE DDISNA_D1S1
!
!-----Natural interface for xGBBRD
!
      SUBROUTINE SGBBRD_A2C2W1( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E,
     &                          Q, LDQ, PT, LDPT, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), C(LDC,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), PT(LDPT,*), Q(LDQ,*),
     &                            WORK(*)
         CALL SGBBRD( VECT, M, N, NCC, KL, KU, AB(1,1), LDAB, D(1),
     &                E(1), Q(1,1), LDQ, PT(1,1), LDPT, C(1,1), LDC,
     &                WORK(1), INFO )
      END SUBROUTINE SGBBRD_A2C2W1

      SUBROUTINE DGBBRD_A2C2W1( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E,
     &                          Q, LDQ, PT, LDPT, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), C(LDC,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), PT(LDPT,*), Q(LDQ,*),
     &                            WORK(*)
         CALL DGBBRD( VECT, M, N, NCC, KL, KU, AB(1,1), LDAB, D(1),
     &                E(1), Q(1,1), LDQ, PT(1,1), LDPT, C(1,1), LDC,
     &                WORK(1), INFO )
      END SUBROUTINE DGBBRD_A2C2W1

      SUBROUTINE CGBBRD_A2C2W1( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E,
     &                          Q, LDQ, PT, LDPT, C, LDC, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: PT(LDPT,*), Q(LDQ,*), WORK(*)
         CALL CGBBRD( VECT, M, N, NCC, KL, KU, AB(1,1), LDAB, D(1),
     &                E(1), Q(1,1), LDQ, PT(1,1), LDPT, C(1,1), LDC,
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CGBBRD_A2C2W1

      SUBROUTINE ZGBBRD_A2C2W1( VECT, M, N, NCC, KL, KU, AB, LDAB, D, E,
     &                          Q, LDQ, PT, LDPT, C, LDC, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDC, LDPT, LDQ, M, N, NCC
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: PT(LDPT,*), Q(LDQ,*), WORK(*)
         CALL ZGBBRD( VECT, M, N, NCC, KL, KU, AB(1,1), LDAB, D(1),
     &                E(1), Q(1,1), LDQ, PT(1,1), LDPT, C(1,1), LDC,
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZGBBRD_A2C2W1
!
!-----Natural interface for xGBSV
!
      SUBROUTINE SGBSV_A2I1B2( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                         INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL SGBSV( N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1), B(1,1),
     &               LDB, INFO )
      END SUBROUTINE SGBSV_A2I1B2

      SUBROUTINE DGBSV_A2I1B2( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                         INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL DGBSV( N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1), B(1,1),
     &               LDB, INFO )
      END SUBROUTINE DGBSV_A2I1B2

      SUBROUTINE CGBSV_A2I1B2( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                         INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL CGBSV( N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1), B(1,1),
     &               LDB, INFO )
      END SUBROUTINE CGBSV_A2I1B2

      SUBROUTINE ZGBSV_A2I1B2( N, KL, KU, NRHS, AB, LDAB, IPIV, B, LDB,
     &                         INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL ZGBSV( N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1), B(1,1),
     &               LDB, INFO )
      END SUBROUTINE ZGBSV_A2I1B2
!
!-----Natural interface for xGBSVX
!
      SUBROUTINE SGBSVX_A2I1B2( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB,
     &                          AFB, LDAFB, IPIV, EQUED, R, C, B, LDB,
     &                          X, LDX, RCOND, FERR, BERR, WORK, IWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*),
     &                              C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB(1,1), LDAB,
     &                AFB(1,1), LDAFB, IPIV(1), EQUED, R(1), C(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SGBSVX_A2I1B2

      SUBROUTINE DGBSVX_A2I1B2( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB,
     &                          AFB, LDAFB, IPIV, EQUED, R, C, B, LDB,
     &                          X, LDX, RCOND, FERR, BERR, WORK, IWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*),
     &                              C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB(1,1), LDAB,
     &                AFB(1,1), LDAFB, IPIV(1), EQUED, R(1), C(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DGBSVX_A2I1B2

      SUBROUTINE CGBSVX_A2I1B2( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB,
     &                          AFB, LDAFB, IPIV, EQUED, R, C, B, LDB,
     &                          X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*),
     &                                 B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB(1,1), LDAB,
     &                AFB(1,1), LDAFB, IPIV(1), EQUED, R(1), C(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CGBSVX_A2I1B2

      SUBROUTINE ZGBSVX_A2I1B2( FACT, TRANS, N, KL, KU, NRHS, AB, LDAB,
     &                          AFB, LDAFB, IPIV, EQUED, R, C, B, LDB,
     &                          X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*),
     &                                 B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZGBSVX( FACT, TRANS, N, KL, KU, NRHS, AB(1,1), LDAB,
     &                AFB(1,1), LDAFB, IPIV(1), EQUED, R(1), C(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZGBSVX_A2I1B2
!
!-----Natural interface for xGBTRF
!
      SUBROUTINE SGBTRF_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL SGBTRF( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE SGBTRF_A2I1

      SUBROUTINE DGBTRF_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL DGBTRF( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE DGBTRF_A2I1

      SUBROUTINE CGBTRF_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL CGBTRF( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE CGBTRF_A2I1

      SUBROUTINE ZGBTRF_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: KL, KU, LDAB, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL ZGBTRF( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE ZGBTRF_A2I1
!
!-----Natural interface for xGBTRS
!
      SUBROUTINE SGBTRS_A2I1B2( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1,1), LDB, INFO )
      END SUBROUTINE SGBTRS_A2I1B2

      SUBROUTINE DGBTRS_A2I1B2( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1,1), LDB, INFO )
      END SUBROUTINE DGBTRS_A2I1B2

      SUBROUTINE CGBTRS_A2I1B2( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1,1), LDB, INFO )
      END SUBROUTINE CGBTRS_A2I1B2

      SUBROUTINE ZGBTRS_A2I1B2( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1,1), LDB, INFO )
      END SUBROUTINE ZGBTRS_A2I1B2
!
!-----Natural interface for xGBTRS with one RHS
!
      SUBROUTINE SGBTRS_A2I1B1( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1), LDB, INFO )
      END SUBROUTINE SGBTRS_A2I1B1

      SUBROUTINE DGBTRS_A2I1B1( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1), LDB, INFO )
      END SUBROUTINE DGBTRS_A2I1B1

      SUBROUTINE CGBTRS_A2I1B1( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1), LDB, INFO )
      END SUBROUTINE CGBTRS_A2I1B1

      SUBROUTINE ZGBTRS_A2I1B1( TRANS, N, KL, KU, NRHS, AB, LDAB, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: KL, KU, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZGBTRS( TRANS, N, KL, KU, NRHS, AB(1,1), LDAB, IPIV(1),
     &                B(1), LDB, INFO )
      END SUBROUTINE ZGBTRS_A2I1B1
!
!-----Natural interface for xGEBAK
!
      SUBROUTINE SGEBAK_S1V2( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         CALL SGEBAK( JOB, SIDE, N, ILO, IHI, SCALE(1), M, V(1,1), LDV,
     &                INFO )
      END SUBROUTINE SGEBAK_S1V2

      SUBROUTINE DGEBAK_S1V2( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         CALL DGEBAK( JOB, SIDE, N, ILO, IHI, SCALE(1), M, V(1,1), LDV,
     &                INFO )
      END SUBROUTINE DGEBAK_S1V2

      SUBROUTINE CGEBAK_S1V2( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         CALL CGEBAK( JOB, SIDE, N, ILO, IHI, SCALE(1), M, V(1,1), LDV,
     &                INFO )
      END SUBROUTINE CGEBAK_S1V2

      SUBROUTINE ZGEBAK_S1V2( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     &                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(IN) :: INFO
         REAL(WP), INTENT(IN) :: SCALE(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         CALL ZGEBAK( JOB, SIDE, N, ILO, IHI, SCALE(1), M, V(1,1), LDV,
     &                INFO )
      END SUBROUTINE ZGEBAK_S1V2
!
!-----Natural interface for xGEBAL
!
      SUBROUTINE SGEBAL_A2S1( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*)
         CALL SGEBAL( JOB, N, A(1,1), LDA, ILO, IHI, SCALE(1), INFO )
      END SUBROUTINE SGEBAL_A2S1

      SUBROUTINE DGEBAL_A2S1( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*)
         CALL DGEBAL( JOB, N, A(1,1), LDA, ILO, IHI, SCALE(1), INFO )
      END SUBROUTINE DGEBAL_A2S1

      SUBROUTINE CGEBAL_A2S1( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*)
         CALL CGEBAL( JOB, N, A(1,1), LDA, ILO, IHI, SCALE(1), INFO )
      END SUBROUTINE CGEBAL_A2S1

      SUBROUTINE ZGEBAL_A2S1( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*)
         CALL ZGEBAL( JOB, N, A(1,1), LDA, ILO, IHI, SCALE(1), INFO )
      END SUBROUTINE ZGEBAL_A2S1
!
!-----Natural inteface for xGEBRD
!
      SUBROUTINE SGEBRD_A2T1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     &                          LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL SGEBRD( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     &                WORK(1), LWORK, INFO )
      END SUBROUTINE SGEBRD_A2T1W1

      SUBROUTINE DGEBRD_A2T1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     &                          LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL DGEBRD( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     &                WORK(1), LWORK, INFO )
      END SUBROUTINE DGEBRD_A2T1W1

      SUBROUTINE CGEBRD_A2T1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     &                          LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL CGEBRD( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     &                WORK(1), LWORK, INFO )
      END SUBROUTINE CGEBRD_A2T1W1

      SUBROUTINE ZGEBRD_A2T1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     &                          LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL ZGEBRD( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     &                WORK(1), LWORK, INFO )
      END SUBROUTINE ZGEBRD_A2T1W1
!
!-----Natural interface for xGEES
!
      SUBROUTINE SGEES_NAT( JOBVS, SORT, SELECT, N, A, LDA, SDIM, WR,
     &                      WI, VS, LDVS, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VS(LDVS,*), WI(*), WORK(*), WR(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( WR, WI )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
         CALL SGEES( JOBVS, SORT, SELECT, N, A(1,1), LDA, SDIM, WR(1),
     &               WI(1), VS(1,1), LDVS, WORK(1), LWORK, BWORK(1),
     &               INFO )
      END SUBROUTINE SGEES_NAT

      SUBROUTINE DGEES_NAT( JOBVS, SORT, SELECT, N, A, LDA, SDIM, WR,
     &                      WI, VS, LDVS, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VS(LDVS,*), WI(*), WORK(*), WR(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( WR, WI )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
         CALL DGEES( JOBVS, SORT, SELECT, N, A(1,1), LDA, SDIM, WR(1),
     &               WI(1), VS(1,1), LDVS, WORK(1), LWORK, BWORK(1),
     &               INFO )
      END SUBROUTINE DGEES_NAT

      SUBROUTINE CGEES_NAT( JOBVS, SORT, SELECT, N, A, LDA, SDIM, W, VS,
     &                      LDVS, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*), W(*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
         CALL CGEES( JOBVS, SORT, SELECT, N, A(1,1), LDA, SDIM, W(1),
     &               VS(1,1), LDVS, WORK(1), LWORK, RWORK(1), BWORK(1),
     &               INFO )
      END SUBROUTINE CGEES_NAT

      SUBROUTINE ZGEES_NAT( JOBVS, SORT, SELECT, N, A, LDA, SDIM, W, VS,
     &                      LDVS, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*), W(*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
         CALL ZGEES( JOBVS, SORT, SELECT, N, A(1,1), LDA, SDIM, W(1),
     &               VS(1,1), LDVS, WORK(1), LWORK, RWORK(1), BWORK(1),
     &               INFO )
      END SUBROUTINE ZGEES_NAT
!
!-----Natural interface for xGEESX
!
      SUBROUTINE SGEESX_NAT( JOBVS, SORT, SELECT, SENSE, N, A, LDA,
     &                       SDIM, WR, WI, VS, LDVS, RCONDE, RCONDV,
     &                       WORK, LWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VS(LDVS,*), WI(*), WORK(*), WR(*)
         INTERFACE
            LOGICAL FUNCTION SELECT(WR, WI)
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
         CALL SGEESX( JOBVS, SORT, SELECT, SENSE, N, A(1,1), LDA, SDIM,
     &                WR(1), WI(1), VS(1,1), LDVS, RCONDE, RCONDV,
     &                WORK(1), LWORK, IWORK(1), LIWORK, BWORK(1), INFO )
      END SUBROUTINE SGEESX_NAT

      SUBROUTINE DGEESX_NAT( JOBVS, SORT, SELECT, SENSE, N, A, LDA,
     &                       SDIM, WR, WI, VS, LDVS, RCONDE, RCONDV,
     &                       WORK, LWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VS(LDVS,*), WI(*), WORK(*), WR(*)
         INTERFACE
            LOGICAL FUNCTION SELECT(WR, WI)
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: WR, WI
            END FUNCTION SELECT
         END INTERFACE
         CALL DGEESX( JOBVS, SORT, SELECT, SENSE, N, A(1,1), LDA, SDIM,
     &                WR(1), WI(1), VS(1,1), LDVS, RCONDE, RCONDV,
     &                WORK(1), LWORK, IWORK(1), LIWORK, BWORK(1), INFO )
      END SUBROUTINE DGEESX_NAT

      SUBROUTINE CGEESX_NAT( JOBVS, SORT, SELECT, SENSE, N, A, LDA,
     &                       SDIM, W, VS, LDVS, RCONDE, RCONDV, WORK,
     &                       LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*), W(*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
         CALL CGEESX( JOBVS, SORT, SELECT, SENSE, N, A(1,1), LDA, SDIM,
     &                W(1), VS(1,1), LDVS, RCONDE, RCONDV, WORK(1),
     &                LWORK, RWORK(1), BWORK(1), INFO )
      END SUBROUTINE CGEESX_NAT

      SUBROUTINE ZGEESX_NAT( JOBVS, SORT, SELECT, SENSE, N, A, LDA,
     &                       SDIM, W, VS, LDVS, RCONDE, RCONDV, WORK,
     &                       LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVS, SENSE, SORT
         INTEGER, INTENT(IN) :: N, LDA, LDVS, LWORK
         INTEGER, INTENT(OUT) :: INFO, SDIM
         REAL(WP), INTENT(OUT) :: RCONDE, RCONDV
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*), W(*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELECT( W )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
         END INTERFACE
         CALL ZGEESX( JOBVS, SORT, SELECT, SENSE, N, A(1,1), LDA, SDIM,
     &                W(1), VS(1,1), LDVS, RCONDE, RCONDV, WORK(1),
     &                LWORK, RWORK(1), BWORK(1), INFO )
      END SUBROUTINE ZGEESX_NAT
!
!-----Natural interface for xGEEV
!
      SUBROUTINE SGEEV_NAT( JOBVL, JOBVR, N, A, LDA, WR, WI, VL, LDVL,
     &                      VR, LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), WI(*),
     &                            WORK(*), WR(*)
         CALL SGEEV( JOBVL, JOBVR, N, A(1,1), LDA, WR(1), WI(1),
     &               VL(1,1), LDVL, VR(1,1), LDVR, WORK(1), LWORK, INFO)
      END SUBROUTINE SGEEV_NAT

      SUBROUTINE DGEEV_NAT( JOBVL, JOBVR, N, A, LDA, WR, WI, VL, LDVL,
     &                      VR, LDVR, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), WI(*),
     &                            WORK(*), WR(*)
         CALL DGEEV( JOBVL, JOBVR, N, A(1,1), LDA, WR(1), WI(1),
     &               VL(1,1), LDVL, VR(1,1), LDVR, WORK(1), LWORK, INFO)
      END SUBROUTINE DGEEV_NAT

      SUBROUTINE CGEEV_NAT( JOBVL, JOBVR, N, A, LDA, W, VL, LDVL,
     &                      VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), W(*),
     &                               WORK(*)
         CALL CGEEV( JOBVL, JOBVR, N, A(1,1), LDA, W(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGEEV_NAT

      SUBROUTINE ZGEEV_NAT( JOBVL, JOBVR, N, A, LDA, W, VL, LDVL,
     &                      VR, LDVR, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), W(*),
     &                               WORK(*)
         CALL ZGEEV( JOBVL, JOBVR, N, A(1,1), LDA, W(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGEEV_NAT
!
!-----Natural interface for xGEEVX
!
      SUBROUTINE SGEEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, WR,
     &                       WI, VL, LDVL, VR, LDVR, ILO, IHI, SCALE,
     &                       ABNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*), RCONDE(*), RCONDV(*),
     &                            VL(LDVL,*), VR(LDVR,*), WR(*), WI(*),
     &                            WORK(*)
         CALL SGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                WR(1), WI(1), VL(1,1), LDVL, VR(1,1), LDVR, ILO,
     &                IHI, SCALE(1), ABNRM, RCONDE(1), RCONDV(1),
     &                WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE SGEEVX_NAT

      SUBROUTINE DGEEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, WR,
     &                       WI, VL, LDVL, VR, LDVR, ILO, IHI, SCALE,
     &                       ABNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: SCALE(*), RCONDE(*), RCONDV(*),
     &                            VL(LDVL,*), VR(LDVR,*), WR(*), WI(*),
     &                            WORK(*)
         CALL DGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                WR(1), WI(1), VL(1,1), LDVL, VR(1,1), LDVR, ILO,
     &                IHI, SCALE(1), ABNRM, RCONDE(1), RCONDV(1),
     &                WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DGEEVX_NAT

      SUBROUTINE CGEEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, W,
     &                       VL, LDVL, VR, LDVR, ILO, IHI, SCALE, ABNRM,
     &                       RCONDE, RCONDV, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         REAL(WP), INTENT(OUT) :: SCALE(*), RCONDE(*), RCONDV(*),
     &                            RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), W(*),
     &                               WORK(*)
         CALL CGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA, W(1),
     &                VL(1,1), LDVL, VR(1,1), LDVR, ILO, IHI, SCALE(1),
     &                ABNRM, RCONDE(1), RCONDV(1), WORK(1), LWORK,
     &                RWORK(1), INFO )
      END SUBROUTINE CGEEVX_NAT

      SUBROUTINE ZGEEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, W,
     &                       VL, LDVL, VR, LDVR, ILO, IHI, SCALE, ABNRM,
     &                       RCONDE, RCONDV, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: N, LDA, LDVL, LDVR, LWORK
         INTEGER, INTENT(OUT) :: INFO, ILO, IHI
         REAL(WP), INTENT(OUT) :: ABNRM
         REAL(WP), INTENT(OUT) :: SCALE(*), RCONDE(*), RCONDV(*),
     &                            RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*), VR(LDVR,*), W(*),
     &                               WORK(*)
         CALL ZGEEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA, W(1),
     &                VL(1,1), LDVL, VR(1,1), LDVR, ILO, IHI, SCALE(1),
     &                ABNRM, RCONDE(1), RCONDV(1), WORK(1), LWORK,
     &                RWORK(1), INFO )
      END SUBROUTINE ZGEEVX_NAT
!
!-----Natural interface for xGEGS
!
      SUBROUTINE SGEGS_NAT( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAR(*), ALPHAI(*), BETA(*),
     &                            VSL(LDVSL,*), VSR(LDVSR,*), WORK(*)
         CALL SGEGS( JOBVSL, JOBVSR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VSL(1,1), LDVSL,
     &               VSR(1,1), LDVSR, WORK(1), LWORK, INFO )
      END SUBROUTINE SGEGS_NAT

      SUBROUTINE DGEGS_NAT( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAR(*), ALPHAI(*), BETA(*),
     &                            VSL(LDVSL,*), VSR(LDVSR,*), WORK(*)
         CALL DGEGS( JOBVSL, JOBVSR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VSL(1,1), LDVSL,
     &               VSR(1,1), LDVSR, WORK(1), LWORK, INFO )
      END SUBROUTINE DGEGS_NAT

      SUBROUTINE CGEGS_NAT( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VSL, LDVSL, VSR, LDVSR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         CALL CGEGS( JOBVSL, JOBVSR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VSL(1,1), LDVSL, VSR(1,1),
     &               LDVSR, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGEGS_NAT

      SUBROUTINE ZGEGS_NAT( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VSL, LDVSL, VSR, LDVSR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR
         INTEGER, INTENT(IN) :: LDA, LDB, N, LDVSL, LDVSR, LWORK
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         CALL ZGEGS( JOBVSL, JOBVSR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VSL(1,1), LDVSL, VSR(1,1),
     &               LDVSR, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGEGS_NAT
!
!-----Natural interface for xGEGV
!
      SUBROUTINE SGEGV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VL(LDVL,*), VR(LDVR,*), WORK(*)
         CALL SGEGV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, INFO )
      END SUBROUTINE SGEGV_NAT

      SUBROUTINE DGEGV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VL(LDVL,*), VR(LDVR,*), WORK(*)
         CALL DGEGV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, INFO )
      END SUBROUTINE DGEGV_NAT

      SUBROUTINE CGEGV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL CGEGV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VL(1,1), LDVL, VR(1,1), LDVR,
     &               WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGEGV_NAT

      SUBROUTINE ZGEGV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL ZGEGV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VL(1,1), LDVL, VR(1,1), LDVR,
     &               WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGEGV_NAT
!
!-----Natural interface for xGEHRD
!
      SUBROUTINE SGEHRD_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGEHRD( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SGEHRD_A2T1W1

      SUBROUTINE DGEHRD_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGEHRD( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DGEHRD_A2T1W1

      SUBROUTINE CGEHRD_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGEHRD( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CGEHRD_A2T1W1

      SUBROUTINE ZGEHRD_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZGEHRD( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZGEHRD_A2T1W1
!
!-----Natural interface for xGELQF
!
      SUBROUTINE SGELQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL SGELQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGELQF_A2T1W1

      SUBROUTINE DGELQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL DGELQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGELQF_A2T1W1

      SUBROUTINE CGELQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL CGELQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGELQF_A2T1W1

      SUBROUTINE ZGELQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL ZGELQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGELQF_A2T1W1
!
!-----Natural interface for xGELS
!
      SUBROUTINE SGELS_A2B2W1( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK,
     &                         LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SGELS( TRANS, M, N, NRHS, A(1,1), LDA, B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE SGELS_A2B2W1

      SUBROUTINE DGELS_A2B2W1( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK,
     &                         LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DGELS( TRANS, M, N, NRHS, A(1,1), LDA, B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE DGELS_A2B2W1

      SUBROUTINE CGELS_A2B2W1( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK,
     &                         LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CGELS( TRANS, M, N, NRHS, A(1,1), LDA, B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE CGELS_A2B2W1

      SUBROUTINE ZGELS_A2B2W1( TRANS, M, N, NRHS, A, LDA, B, LDB, WORK,
     &                         LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZGELS( TRANS, M, N, NRHS, A(1,1), LDA, B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE ZGELS_A2B2W1
!
!-----Natural interface for xGELSD
!
      SUBROUTINE SGELSD_NAT( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                       WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: S(*), WORK(*)
         CALL SGELSD( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE SGELSD_NAT

      SUBROUTINE DGELSD_NAT( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                       WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: S(*), WORK(*)
         CALL DGELSD( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DGELSD_NAT

      SUBROUTINE CGELSD_NAT( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                       WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CGELSD( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, RWORK(1), IWORK(1), INFO )
      END SUBROUTINE CGELSD_NAT

      SUBROUTINE ZGELSD_NAT( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
     &                       WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZGELSD( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, RWORK(1), IWORK(1), INFO )
      END SUBROUTINE ZGELSD_NAT
!
!-----Natural interface for xGELSS
!
      SUBROUTINE SGELSS_A2B2W1( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
     &                          RANK, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: S(*), WORK(*)
         CALL SGELSS( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, INFO )
      END SUBROUTINE SGELSS_A2B2W1

      SUBROUTINE DGELSS_A2B2W1( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
     &                          RANK, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: S(*), WORK(*)
         CALL DGELSS( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, INFO )
      END SUBROUTINE DGELSS_A2B2W1

      SUBROUTINE CGELSS_A2B2W1( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
     &                          RANK, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(OUT) :: S(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CGELSS( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGELSS_A2B2W1

      SUBROUTINE ZGELSS_A2B2W1( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
     &                          RANK, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         REAL(WP), INTENT(OUT) :: S(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZGELSS( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, S(1), RCOND,
     &                RANK, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGELSS_A2B2W1
!
!-----Natural interface for xGELSX
!
      SUBROUTINE SGELSX_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SGELSX( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), INFO )
      END SUBROUTINE SGELSX_A2B2W1

      SUBROUTINE DGELSX_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DGELSX( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), INFO )
      END SUBROUTINE DGELSX_A2B2W1

      SUBROUTINE CGELSX_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CGELSX( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), RWORK(1), INFO )
      END SUBROUTINE CGELSX_A2B2W1

      SUBROUTINE ZGELSX_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZGELSX( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZGELSX_A2B2W1
!
!-----Natural interface for xGELSY
!
      SUBROUTINE SGELSY_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SGELSY( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), LWORK, INFO )
      END SUBROUTINE SGELSY_A2B2W1

      SUBROUTINE DGELSY_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DGELSY( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), LWORK, INFO )
      END SUBROUTINE DGELSY_A2B2W1

      SUBROUTINE CGELSY_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CGELSY( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGELSY_A2B2W1

      SUBROUTINE ZGELSY_A2B2W1( M, N, NRHS, A, LDA, B, LDB, JPVT, RCOND,
     &                          RANK, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, NRHS
         INTEGER, INTENT(OUT) :: INFO, RANK
         REAL(WP), INTENT(IN) :: RCOND
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZGELSY( M, N, NRHS, A(1,1), LDA, B(1,1), LDB, JPVT(1),
     &                RCOND, RANK, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGELSY_A2B2W1
!
!-----Natural interface for xGEQLF
!
      SUBROUTINE SGEQLF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL SGEQLF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGEQLF_A2T1W1

      SUBROUTINE DGEQLF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL DGEQLF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGEQLF_A2T1W1

      SUBROUTINE CGEQLF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL CGEQLF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGEQLF_A2T1W1

      SUBROUTINE ZGEQLF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL ZGEQLF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGEQLF_A2T1W1
!
!-----Natural interface for xGEQP3
!
      SUBROUTINE SGEQP3_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGEQP3( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE SGEQP3_A2T1W1

      SUBROUTINE DGEQP3_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGEQP3( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE DGEQP3_A2T1W1

      SUBROUTINE CGEQP3_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, LWORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         CALL CGEQP3( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                LWORK, RWORK(1), INFO )
      END SUBROUTINE CGEQP3_A2T1W1

      SUBROUTINE ZGEQP3_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, LWORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         CALL ZGEQP3( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGEQP3_A2T1W1
!
!-----Natural interface for xGEQPF
!
      SUBROUTINE SGEQPF_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGEQPF( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                INFO )
      END SUBROUTINE SGEQPF_A2T1W1

      SUBROUTINE DGEQPF_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGEQPF( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                INFO )
      END SUBROUTINE DGEQPF_A2T1W1

      SUBROUTINE CGEQPF_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGEQPF( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE CGEQPF_A2T1W1

      SUBROUTINE ZGEQPF_A2T1W1( M, N, A, LDA, JPVT, TAU, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZGEQPF( M, N, A(1,1), LDA, JPVT(1), TAU(1), WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE ZGEQPF_A2T1W1
!
!-----Natural interface for xGEQRF
!
      SUBROUTINE SGEQRF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL SGEQRF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGEQRF_A2T1W1

      SUBROUTINE DGEQRF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL DGEQRF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGEQRF_A2T1W1

      SUBROUTINE CGEQRF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL CGEQRF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGEQRF_A2T1W1

      SUBROUTINE ZGEQRF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL ZGEQRF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGEQRF_A2T1W1
!
!-----Natural interface for xGERQF
!
      SUBROUTINE SGERQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL SGERQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGERQF_A2T1W1

      SUBROUTINE DGERQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL DGERQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGERQF_A2T1W1

      SUBROUTINE CGERQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL CGERQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGERQF_A2T1W1

      SUBROUTINE ZGERQF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(LWORK)
         CALL ZGERQF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGERQF_A2T1W1
!
!-----Natural interface for xGESDD
!
      SUBROUTINE SGESDD_NAT( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                       WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL SGESDD( JOBZ, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE SGESDD_NAT

      SUBROUTINE DGESDD_NAT( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                       WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL DGESDD( JOBZ, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DGESDD_NAT

      SUBROUTINE CGESDD_NAT( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                       WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL CGESDD( JOBZ, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, RWORK(1), IWORK(1),
     &                INFO )
      END SUBROUTINE CGESDD_NAT

      SUBROUTINE ZGESDD_NAT( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
     &                       WORK, LWORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL ZGESDD( JOBZ, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, RWORK(1), IWORK(1),
     &                INFO )
      END SUBROUTINE ZGESDD_NAT
!
!-----Natural interface for xGESV
!
      SUBROUTINE SGESV_A2I1B2( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL SGESV( N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE SGESV_A2I1B2

      SUBROUTINE DGESV_A2I1B2( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL DGESV( N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE DGESV_A2I1B2

      SUBROUTINE CGESV_A2I1B2( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL CGESV( N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CGESV_A2I1B2

      SUBROUTINE ZGESV_A2I1B2( N, NRHS, A, LDA, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL ZGESV( N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZGESV_A2I1B2
!
!-----Natural interface for xGESVD
!
      SUBROUTINE SGESVD_NAT( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                       LDVT, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL SGESVD( JOBU, JOBVT, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, INFO )
      END SUBROUTINE SGESVD_NAT

      SUBROUTINE DGESVD_NAT( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                       LDVT, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: S(*), U(LDU,*), VT(LDVT,*), WORK(*)
         CALL DGESVD( JOBU, JOBVT, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, INFO )
      END SUBROUTINE DGESVD_NAT

      SUBROUTINE CGESVD_NAT( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                       LDVT, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL CGESVD( JOBU, JOBVT, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGESVD_NAT

      SUBROUTINE ZGESVD_NAT( JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT,
     &                       LDVT, WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBU, JOBVT
         INTEGER, INTENT(IN) :: LDA, LDU, LDVT, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL ZGESVD( JOBU, JOBVT, M, N, A(1,1), LDA, S(1), U(1,1), LDU,
     &                VT(1,1), LDVT, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGESVD_NAT
!
!-----Natural interface for xGESVX
!
      SUBROUTINE SGESVX_A2I1B2( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*),
     &                              C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), X(LDX,*), WORK(*)
         CALL SGESVX( FACT, TRANS, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), EQUED, R(1), C(1), B(1,1), LDB, X(1,1),
     &                LDX, RCOND, FERR(1), BERR(1), WORK(1), IWORK(1),
     &                INFO )
      END SUBROUTINE SGESVX_A2I1B2

      SUBROUTINE DGESVX_A2I1B2( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*),
     &                              C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), X(LDX,*), WORK(*)
         CALL DGESVX( FACT, TRANS, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), EQUED, R(1), C(1), B(1,1), LDB, X(1,1),
     &                LDX, RCOND, FERR(1), BERR(1), WORK(1), IWORK(1),
     &                INFO )
      END SUBROUTINE DGESVX_A2I1B2

      SUBROUTINE CGESVX_A2I1B2( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: X(LDX,*), WORK(*)
         CALL CGESVX( FACT, TRANS, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), EQUED, R(1), C(1), B(1,1), LDB, X(1,1),
     &                LDX, RCOND, FERR(1), BERR(1), WORK(1), RWORK(1),
     &                INFO )
      END SUBROUTINE CGESVX_A2I1B2

      SUBROUTINE ZGESVX_A2I1B2( FACT, TRANS, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, EQUED, R, C, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: C(*), R(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: X(LDX,*), WORK(*)
         CALL ZGESVX( FACT, TRANS, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), EQUED, R(1), C(1), B(1,1), LDB, X(1,1),
     &                LDX, RCOND, FERR(1), BERR(1), WORK(1), RWORK(1),
     &                INFO )
      END SUBROUTINE ZGESVX_A2I1B2
!
!-----Natural interface for xGETRF
!
      SUBROUTINE SGETRF_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SGETRF( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE SGETRF_A2I1

      SUBROUTINE DGETRF_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL DGETRF( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE DGETRF_A2I1

      SUBROUTINE CGETRF_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CGETRF( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE CGETRF_A2I1

      SUBROUTINE ZGETRF_A2I1( M, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL ZGETRF( M, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE ZGETRF_A2I1
!
!-----Natural interface for xGETRS
!
      SUBROUTINE SGETRS_A2I1B2( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE SGETRS_A2I1B2

      SUBROUTINE DGETRS_A2I1B2( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE DGETRS_A2I1B2

      SUBROUTINE CGETRS_A2I1B2( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE CGETRS_A2I1B2

      SUBROUTINE ZGETRS_A2I1B2( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE ZGETRS_A2I1B2
!
!-----Natural interface for xGETRS with one RHS
!
      SUBROUTINE SGETRS_A2I1B1( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE SGETRS_A2I1B1

      SUBROUTINE DGETRS_A2I1B1( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE DGETRS_A2I1B1

      SUBROUTINE CGETRS_A2I1B1( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE CGETRS_A2I1B1

      SUBROUTINE ZGETRS_A2I1B1( TRANS, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZGETRS( TRANS, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE ZGETRS_A2I1B1
!
!-----Natural interface for xGGBAK
!
      SUBROUTINE SGGBAK_S1V2( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                        V, LDV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE(*), RSCALE(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         CALL SGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE(1), RSCALE(1), M,
     &                V(1,1), LDV, INFO )
      END SUBROUTINE SGGBAK_S1V2

      SUBROUTINE DGGBAK_S1V2( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                        V, LDV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE(*), RSCALE(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         CALL DGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE(1), RSCALE(1), M,
     &                V(1,1), LDV, INFO )
      END SUBROUTINE DGGBAK_S1V2

      SUBROUTINE CGGBAK_S1V2( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                        V, LDV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE(*), RSCALE(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         CALL CGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE(1), RSCALE(1), M,
     &                V(1,1), LDV, INFO )
      END SUBROUTINE CGGBAK_S1V2

      SUBROUTINE ZGGBAK_S1V2( JOB, SIDE, N, ILO, IHI, LSCALE, RSCALE, M,
     &                        V, LDV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB, SIDE
         INTEGER, INTENT(IN) :: IHI, ILO, LDV, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: LSCALE(*), RSCALE(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         CALL ZGGBAK( JOB, SIDE, N, ILO, IHI, LSCALE(1), RSCALE(1), M,
     &                V(1,1), LDV, INFO )
      END SUBROUTINE ZGGBAK_S1V2
!
!-----Natural interface for xGGBAL
!
      SUBROUTINE SGGBAL_A2S1W1( JOB, N, A, LDA, B, LDB, ILO, IHI,
     &                          LSCALE, RSCALE, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: LSCALE(*), RSCALE(*), WORK(*)
         CALL SGGBAL( JOB, N, A(1,1), LDA, B(1,1), LDB, ILO, IHI,
     &                LSCALE(1), RSCALE(1), WORK(1), INFO )
      END SUBROUTINE SGGBAL_A2S1W1

      SUBROUTINE DGGBAL_A2S1W1( JOB, N, A, LDA, B, LDB, ILO, IHI,
     &                          LSCALE, RSCALE, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: LSCALE(*), RSCALE(*), WORK(*)
         CALL DGGBAL( JOB, N, A(1,1), LDA, B(1,1), LDB, ILO, IHI,
     &                LSCALE(1), RSCALE(1), WORK(1), INFO )
      END SUBROUTINE DGGBAL_A2S1W1

      SUBROUTINE CGGBAL_A2S1W1( JOB, N, A, LDA, B, LDB, ILO, IHI,
     &                          LSCALE, RSCALE, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: LSCALE(*), RSCALE(*), WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL CGGBAL( JOB, N, A(1,1), LDA, B(1,1), LDB, ILO, IHI,
     &                LSCALE(1), RSCALE(1), WORK(1), INFO )
      END SUBROUTINE CGGBAL_A2S1W1

      SUBROUTINE ZGGBAL_A2S1W1( JOB, N, A, LDA, B, LDB, ILO, IHI,
     &                          LSCALE, RSCALE, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOB
         INTEGER, INTENT(IN) :: LDA, LDB, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: LSCALE(*), RSCALE(*), WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL ZGGBAL( JOB, N, A(1,1), LDA, B(1,1), LDB, ILO, IHI,
     &                LSCALE(1), RSCALE(1), WORK(1), INFO )
      END SUBROUTINE ZGGBAL_A2S1W1
!
!-----Natural interface for xGGES
!
      SUBROUTINE SGGES_NAT( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B,
     &                      LDB, SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL,
     &                      VSR, LDVSR, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VSL(LDVSL,*), VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL SGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A(1,1), LDA,
     &               B(1,1), LDB, SDIM, ALPHAR(1), ALPHAI(1), BETA(1),
     &               VSL(1,1), LDVSL, VSR(1,1), LDVSR, WORK(1), LWORK,
     &               BWORK(1), INFO )
      END SUBROUTINE SGGES_NAT

      SUBROUTINE DGGES_NAT( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B,
     &                      LDB, SDIM, ALPHAR, ALPHAI, BETA, VSL, LDVSL,
     &                      VSR, LDVSR, WORK, LWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VSL(LDVSL,*), VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL DGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A(1,1), LDA,
     &               B(1,1), LDB, SDIM, ALPHAR(1), ALPHAI(1), BETA(1),
     &               VSL(1,1), LDVSL, VSR(1,1), LDVSR, WORK(1), LWORK,
     &               BWORK(1), INFO )
      END SUBROUTINE DGGES_NAT

      SUBROUTINE CGGES_NAT( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B,
     &                      LDB, SDIM, ALPHA, BETA, VSL, LDVSL, VSR,
     &                      LDVSR, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL CGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A(1,1), LDA,
     &               B(1,1), LDB, SDIM, ALPHA(1), BETA(1), VSL(1,1),
     &               LDVSL, VSR(1,1), LDVSR, WORK(1), LWORK, RWORK(1),
     &               BWORK(1), INFO )
      END SUBROUTINE CGGES_NAT

      SUBROUTINE ZGGES_NAT( JOBVSL, JOBVSR, SORT, SELCTG, N, A, LDA, B,
     &                      LDB, SDIM, ALPHA, BETA, VSL, LDVSL, VSR,
     &                      LDVSR, WORK, LWORK, RWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL ZGGES( JOBVSL, JOBVSR, SORT, SELCTG, N, A(1,1), LDA,
     &               B(1,1), LDB, SDIM, ALPHA(1), BETA(1), VSL(1,1),
     &               LDVSL, VSR(1,1), LDVSR, WORK(1), LWORK, RWORK(1),
     &               BWORK(1), INFO )
      END SUBROUTINE ZGGES_NAT
!
!-----Natural interface for xGGESX
!
      SUBROUTINE SGGESX_NAT( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A,
     &                       LDA, B, LDB, SDIM, ALPHAR, ALPHAI, BETA,
     &                       VSL, LDVSL, VSR, LDVSR, RCONDE, RCONDV,
     &                       WORK, LWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK (*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            RCONDE(2), RCONDV(2), VSL(LDVSL,*),
     &                            VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL SGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A(1,1),
     &                LDA, B(1,1), LDB, SDIM, ALPHAR(1), ALPHAI(1),
     &                BETA(1), VSL(1,1), LDVSL, VSR(1,1), LDVSR,
     &                RCONDE(1), RCONDV(1), WORK(1), LWORK, IWORK(1),
     &                LIWORK, BWORK(1), INFO )
      END SUBROUTINE SGGESX_NAT

      SUBROUTINE DGGESX_NAT( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A,
     &                       LDA, B, LDB, SDIM, ALPHAR, ALPHAI, BETA,
     &                       VSL, LDVSL, VSR, LDVSR, RCONDE, RCONDV,
     &                       WORK, LWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK (*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            RCONDE(2), RCONDV(2), VSL(LDVSL,*),
     &                            VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHAR, ALPHAI, BETA )
               USE LA_CONSTANTS, ONLY: WP
               REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL DGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A(1,1),
     &                LDA, B(1,1), LDB, SDIM, ALPHAR(1), ALPHAI(1),
     &                BETA(1), VSL(1,1), LDVSL, VSR(1,1), LDVSR,
     &                RCONDE(1), RCONDV(1), WORK(1), LWORK, IWORK(1),
     &                LIWORK, BWORK(1), INFO )
      END SUBROUTINE DGGESX_NAT

      SUBROUTINE CGGESX_NAT( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A,
     &                       LDA, B, LDB, SDIM, ALPHA, BETA, VSL, LDVSL,
     &                       VSR, LDVSR, RCONDE, RCONDV, WORK, LWORK,
     &                       RWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK (*)
         REAL(WP), INTENT(OUT) :: RCONDE(2), RCONDV(2)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS32, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL CGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A(1,1),
     &                LDA, B(1,1), LDB, SDIM, ALPHA(1), BETA(1),
     &                VSL(1,1), LDVSL, VSR(1,1), LDVSR, RCONDE(1),
     &                RCONDV(1), WORK(1), LWORK, RWORK(1), IWORK(1),
     &                LIWORK, BWORK(1), INFO )
      END SUBROUTINE CGGESX_NAT

      SUBROUTINE ZGGESX_NAT( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A,
     &                       LDA, B, LDB, SDIM, ALPHA, BETA, VSL, LDVSL,
     &                       VSR, LDVSR, RCONDE, RCONDV, WORK, LWORK,
     &                       RWORK, IWORK, LIWORK, BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVSL, JOBVSR, SENSE, SORT
         INTEGER, INTENT(IN) :: LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, SDIM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK (*)
         REAL(WP), INTENT(OUT) :: RCONDE(2), RCONDV(2)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VSL(LDVSL,*),
     &                               VSR(LDVSR,*), WORK(*)
         INTERFACE
            LOGICAL FUNCTION SELCTG( ALPHA, BETA )
               USE LA_CONSTANTS, ONLY: WP
               COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
            END FUNCTION SELCTG
         END INTERFACE
         CALL ZGGESX( JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A(1,1),
     &                LDA, B(1,1), LDB, SDIM, ALPHA(1), BETA(1),
     &                VSL(1,1), LDVSL, VSR(1,1), LDVSR, RCONDE(1),
     &                RCONDV(1), WORK(1), LWORK, RWORK(1), IWORK(1),
     &                LIWORK, BWORK(1), INFO )
      END SUBROUTINE ZGGESX_NAT
!
!-----Natural interface for xGGEV
!
      SUBROUTINE SGGEV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VL(LDVL,*), VR(LDVR,*), WORK(*)
         CALL SGGEV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, INFO )
      END SUBROUTINE SGGEV_NAT

      SUBROUTINE DGGEV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHAR,
     &                      ALPHAI, BETA, VL, LDVL, VR, LDVR, WORK,
     &                      LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            VL(LDVL,*), VR(LDVR,*), WORK(*)
         CALL DGGEV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHAR(1), ALPHAI(1), BETA(1), VL(1,1), LDVL,
     &               VR(1,1), LDVR, WORK(1), LWORK, INFO )
      END SUBROUTINE DGGEV_NAT

      SUBROUTINE CGGEV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL CGGEV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VL(1,1), LDVL, VR(1,1), LDVR,
     &               WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CGGEV_NAT

      SUBROUTINE ZGGEV_NAT( JOBVL, JOBVR, N, A, LDA, B, LDB, ALPHA,
     &                      BETA, VL, LDVL, VR, LDVR, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBVL, JOBVR
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL ZGGEV( JOBVL, JOBVR, N, A(1,1), LDA, B(1,1), LDB,
     &               ALPHA(1), BETA(1), VL(1,1), LDVL, VR(1,1), LDVR,
     &               WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZGGEV_NAT
!
!-----Natural interface for xGGEVX
!
      SUBROUTINE SGGEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B,
     &                       LDB, ALPHAR, ALPHAI, BETA, VL, LDVL, VR,
     &                       LDVR, ILO, IHI, LSCALE, RSCALE, ABNRM,
     &                       BBNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                       BWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT):: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            LSCALE(*), RCONDE(*), RCONDV(*),
     &                            RSCALE(*), VL(LDVL,*), VR(LDVR,*),
     &                            WORK(*)
         CALL SGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                VL(1,1), LDVL, VR(1,1), LDVR, ILO, IHI, LSCALE(1),
     &                RSCALE(1), ABNRM, BBNRM, RCONDE(1), RCONDV(1),
     &                WORK(1), LWORK, IWORK(1), BWORK(1), INFO )
      END SUBROUTINE SGGEVX_NAT

      SUBROUTINE DGGEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B,
     &                       LDB, ALPHAR, ALPHAI, BETA, VL, LDVL, VR,
     &                       LDVR, ILO, IHI, LSCALE, RSCALE, ABNRM,
     &                       BBNRM, RCONDE, RCONDV, WORK, LWORK, IWORK,
     &                       BWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT):: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*),
     &                            LSCALE(*), RCONDE(*), RCONDV(*),
     &                            RSCALE(*), VL(LDVL,*), VR(LDVR,*),
     &                            WORK(*)
         CALL DGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                VL(1,1), LDVL, VR(1,1), LDVR, ILO, IHI, LSCALE(1),
     &                RSCALE(1), ABNRM, BBNRM, RCONDE(1), RCONDV(1),
     &                WORK(1), LWORK, IWORK(1), BWORK(1), INFO )
      END SUBROUTINE DGGEVX_NAT

      SUBROUTINE CGGEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B,
     &                       LDB, ALPHA, BETA, VL, LDVL, VR, LDVR, ILO,
     &                       IHI, LSCALE, RSCALE, ABNRM, BBNRM, RCONDE,
     &                       RCONDV, WORK, LWORK, RWORK, IWORK, BWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: LSCALE(*), RCONDE(*), RCONDV(*),
     &                            RSCALE(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL CGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), VL(1,1), LDVL,
     &                VR(1,1), LDVR, ILO, IHI, LSCALE(1), RSCALE(1),
     &                ABNRM, BBNRM, RCONDE(1), RCONDV(1), WORK(1),
     &                LWORK, RWORK(1), IWORK(1), BWORK(1), INFO )
      END SUBROUTINE CGGEVX_NAT

      SUBROUTINE ZGGEVX_NAT( BALANC, JOBVL, JOBVR, SENSE, N, A, LDA, B,
     &                       LDB, ALPHA, BETA, VL, LDVL, VR, LDVR, ILO,
     &                       IHI, LSCALE, RSCALE, ABNRM, BBNRM, RCONDE,
     &                       RCONDV, WORK, LWORK, RWORK, IWORK, BWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: BALANC, JOBVL, JOBVR, SENSE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, N
         INTEGER, INTENT(OUT) :: IHI, ILO, INFO
         REAL(WP), INTENT(OUT) :: ABNRM, BBNRM
         LOGICAL, INTENT(OUT) :: BWORK(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: LSCALE(*), RCONDE(*), RCONDV(*),
     &                            RSCALE(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), VL(LDVL,*),
     &                               VR(LDVR,*), WORK(*)
         CALL ZGGEVX( BALANC, JOBVL, JOBVR, SENSE, N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), VL(1,1), LDVL,
     &                VR(1,1), LDVR, ILO, IHI, LSCALE(1), RSCALE(1),
     &                ABNRM, BBNRM, RCONDE(1), RCONDV(1), WORK(1),
     &                LWORK, RWORK(1), IWORK(1), BWORK(1), INFO )
      END SUBROUTINE ZGGEVX_NAT
!
!-----Interface for xGGGLM
!
      SUBROUTINE SGGGLM_NAT( N, M, P, A, LDA, B, LDB, D, X, Y, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), D(*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(*), Y(*)
         CALL SGGGLM( N, M, P, A(1,1), LDA, B(1,1), LDB, D(1), X(1),
     &                Y(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGGGLM_NAT

      SUBROUTINE DGGGLM_NAT( N, M, P, A, LDA, B, LDB, D, X, Y, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), D(*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(*), Y(*)
         CALL DGGGLM( N, M, P, A(1,1), LDA, B(1,1), LDB, D(1), X(1),
     &                Y(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGGGLM_NAT

      SUBROUTINE CGGGLM_NAT( N, M, P, A, LDA, B, LDB, D, X, Y, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), D(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(*), Y(*)
         CALL CGGGLM( N, M, P, A(1,1), LDA, B(1,1), LDB, D(1), X(1),
     &                Y(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGGGLM_NAT

      SUBROUTINE ZGGGLM_NAT( N, M, P, A, LDA, B, LDB, D, X, Y, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), D(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(*), Y(*)
         CALL ZGGGLM( N, M, P, A(1,1), LDA, B(1,1), LDB, D(1), X(1),
     &                Y(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGGGLM_NAT
!
!-----Natural interface for xGGHRD
!
      SUBROUTINE SGGHRD_A2B2Q2( COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, Q, LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         CALL SGGHRD( COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, Q(1,1), LDQ, Z(1,1), LDZ, INFO )
      END SUBROUTINE SGGHRD_A2B2Q2

      SUBROUTINE DGGHRD_A2B2Q2( COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, Q, LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         CALL DGGHRD( COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, Q(1,1), LDQ, Z(1,1), LDZ, INFO )
      END SUBROUTINE DGGHRD_A2B2Q2

      SUBROUTINE CGGHRD_A2B2Q2( COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, Q, LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         CALL CGGHRD( COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, Q(1,1), LDQ, Z(1,1), LDZ, INFO )
      END SUBROUTINE CGGHRD_A2B2Q2

      SUBROUTINE ZGGHRD_A2B2Q2( COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, Q, LDQ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         CALL ZGGHRD( COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, Q(1,1), LDQ, Z(1,1), LDZ, INFO )
      END SUBROUTINE ZGGHRD_A2B2Q2
!
!-----Natural interface for xGGLSE
!
      SUBROUTINE SGGLSE_NAT( M, N, P, A, LDA, B, LDB, C, D, X, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), C(*), D(*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(*)
         CALL SGGLSE( M, N, P, A(1,1), LDA, B(1,1), LDB, C(1), D(1),
     &                X(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGGLSE_NAT

      SUBROUTINE DGGLSE_NAT( M, N, P, A, LDA, B, LDB, C, D, X, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), C(*), D(*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(*)
         CALL DGGLSE( M, N, P, A(1,1), LDA, B(1,1), LDB, C(1), D(1),
     &                X(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGGLSE_NAT

      SUBROUTINE CGGLSE_NAT( M, N, P, A, LDA, B, LDB, C, D, X, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), C(*), D(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(*)
         CALL CGGLSE( M, N, P, A(1,1), LDA, B(1,1), LDB, C(1), D(1),
     &                X(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGGLSE_NAT

      SUBROUTINE ZGGLSE_NAT( M, N, P, A, LDA, B, LDB, C, D, X, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), C(*), D(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(*)
         CALL ZGGLSE( M, N, P, A(1,1), LDA, B(1,1), LDB, C(1), D(1),
     &                X(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGGLSE_NAT
!
!-----Natural interface for xGGQRF
!
      SUBROUTINE SGGQRF_NAT( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL SGGQRF( N, M, P, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGGQRF_NAT

      SUBROUTINE DGGQRF_NAT( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL DGGQRF( N, M, P, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGGQRF_NAT

      SUBROUTINE CGGQRF_NAT( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL CGGQRF( N, M, P, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGGQRF_NAT

      SUBROUTINE ZGGQRF_NAT( N, M, P, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL ZGGQRF( N, M, P, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGGQRF_NAT
!
!-----Natural interface for xGGRQF
!
      SUBROUTINE SGGRQF_NAT( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL SGGRQF( M, P, N, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SGGRQF_NAT

      SUBROUTINE DGGRQF_NAT( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL DGGRQF( M, P, N, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DGGRQF_NAT

      SUBROUTINE CGGRQF_NAT( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL CGGRQF( M, P, N, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CGGRQF_NAT

      SUBROUTINE ZGGRQF_NAT( M, P, N, A, LDA, TAUA, B, LDB, TAUB, WORK,
     &                       LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, M, N, P
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: TAUA(*), TAUB(*), WORK(*)
         CALL ZGGRQF( M, P, N, A(1,1), LDA, TAUA(1), B(1,1), LDB,
     &                TAUB(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZGGRQF_NAT
!
!-----Natural interface for xGGSVD
!
      SUBROUTINE SGGSVD_NAT( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                       LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                       WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), Q(LDQ,*), U(LDU,*),
     &                            V(LDV,*), WORK(*)
         CALL SGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), U(1,1), LDU,
     &                V(1,1), LDV, Q(1,1), LDQ, WORK(1), IWORK(1), INFO)
      END SUBROUTINE SGGSVD_NAT

      SUBROUTINE DGGSVD_NAT( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                       LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                       WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), Q(LDQ,*), U(LDU,*),
     &                            V(LDV,*), WORK(*)
         CALL DGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), U(1,1), LDU,
     &                V(1,1), LDV, Q(1,1), LDQ, WORK(1), IWORK(1), INFO)
      END SUBROUTINE DGGSVD_NAT

      SUBROUTINE CGGSVD_NAT( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                       LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                       WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), U(LDU,*), V(LDV,*),
     &                               WORK(*)
         CALL CGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), U(1,1), LDU,
     &                V(1,1), LDV, Q(1,1), LDQ, WORK(1), RWORK(1),
     &                IWORK(1), INFO )
      END SUBROUTINE CGGSVD_NAT

      SUBROUTINE ZGGSVD_NAT( JOBU, JOBV, JOBQ, M, N, P, K, L, A, LDA, B,
     &                       LDB, ALPHA, BETA, U, LDU, V, LDV, Q, LDQ,
     &                       WORK, RWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), U(LDU,*), V(LDV,*),
     &                               WORK(*)
         CALL ZGGSVD( JOBU, JOBV, JOBQ, M, N, P, K, L, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), U(1,1), LDU,
     &                V(1,1), LDV, Q(1,1), LDQ, WORK(1), RWORK(1),
     &                IWORK(1), INFO )
      END SUBROUTINE ZGGSVD_NAT
!
!-----Natural interface for xGGSVP
!
      SUBROUTINE SGGSVP_NAT( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                       TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                       IWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), TAU(*), U(LDU,*), V(LDV,*),
     &                            WORK(*)
         CALL SGGSVP( JOBU, JOBV, JOBQ, M, P, N, A(1,1), LDA, B(1,1),
     &                LDB, TOLA, TOLB, K, L, U(1,1), LDU, V(1,1), LDV,
     &                Q(1,1), LDQ, IWORK(1), TAU(1), WORK(1), INFO )
      END SUBROUTINE SGGSVP_NAT

      SUBROUTINE DGGSVP_NAT( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                       TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                       IWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), TAU(*), U(LDU,*), V(LDV,*),
     &                            WORK(*)
         CALL DGGSVP( JOBU, JOBV, JOBQ, M, P, N, A(1,1), LDA, B(1,1),
     &                LDB, TOLA, TOLB, K, L, U(1,1), LDU, V(1,1), LDV,
     &                Q(1,1), LDQ, IWORK(1), TAU(1), WORK(1), INFO )
      END SUBROUTINE DGGSVP_NAT

      SUBROUTINE CGGSVP_NAT( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                       TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                       IWORK, RWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), TAU(*), U(LDU,*),
     &                               V(LDV,*), WORK(*)
         CALL CGGSVP( JOBU, JOBV, JOBQ, M, P, N, A(1,1), LDA, B(1,1),
     &                LDB, TOLA, TOLB, K, L, U(1,1), LDU, V(1,1), LDV,
     &                Q(1,1), LDQ, IWORK(1), RWORK(1), TAU(1), WORK(1),
     &                INFO )
      END SUBROUTINE CGGSVP_NAT

      SUBROUTINE ZGGSVP_NAT( JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
     &                       TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
     &                       IWORK, RWORK, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, K, L
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), TAU(*), U(LDU,*),
     &                               V(LDV,*), WORK(*)
         CALL ZGGSVP( JOBU, JOBV, JOBQ, M, P, N, A(1,1), LDA, B(1,1),
     &                LDB, TOLA, TOLB, K, L, U(1,1), LDU, V(1,1), LDV,
     &                Q(1,1), LDQ, IWORK(1), RWORK(1), TAU(1), WORK(1),
     &                INFO )
      END SUBROUTINE ZGGSVP_NAT
!
!-----Natural interface for xGTSV
!
      SUBROUTINE SGTSV_D1B2( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), DL(*), DU(*)
         CALL SGTSV( N, NRHS, DL(1), D(1), DU(1), B(1,1), LDB, INFO )
      END SUBROUTINE SGTSV_D1B2

      SUBROUTINE DGTSV_D1B2( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), DL(*), DU(*)
         CALL DGTSV( N, NRHS, DL(1), D(1), DU(1), B(1,1), LDB, INFO )
      END SUBROUTINE DGTSV_D1B2

      SUBROUTINE CGTSV_D1B2( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), D(*), DL(*), DU(*)
         CALL CGTSV( N, NRHS, DL(1), D(1), DU(1), B(1,1), LDB, INFO )
      END SUBROUTINE CGTSV_D1B2

      SUBROUTINE ZGTSV_D1B2( N, NRHS, DL, D, DU, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), D(*), DL(*), DU(*)
         CALL ZGTSV( N, NRHS, DL(1), D(1), DU(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZGTSV_D1B2
!
!-----Natural interface for xGTSVX
!
      SUBROUTINE SGTSVX_D1B2W1( FACT, TRANS, N, NRHS, DL, D, DU, DLF,
     &                          DF, DUF, DU2, IPIV, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), DL(*), DU(*)
         REAL(WP), INTENT(INOUT) :: DF(*), DLF(*), DU2(*), DUF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SGTSVX( FACT, TRANS, N, NRHS, DL(1), D(1), DU(1), DLF(1),
     &                DF(1), DUF(1), DU2(1), IPIV(1), B(1,1), LDB,
     &                X(1,1), LDX, RCOND, FERR(1), BERR(1), WORK(1),
     &                IWORK(1), INFO )
      END SUBROUTINE SGTSVX_D1B2W1

      SUBROUTINE DGTSVX_D1B2W1( FACT, TRANS, N, NRHS, DL, D, DU, DLF,
     &                          DF, DUF, DU2, IPIV, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), DL(*), DU(*)
         REAL(WP), INTENT(INOUT) :: DF(*), DLF(*), DU2(*), DUF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DGTSVX( FACT, TRANS, N, NRHS, DL(1), D(1), DU(1), DLF(1),
     &                DF(1), DUF(1), DU2(1), IPIV(1), B(1,1), LDB,
     &                X(1,1), LDX, RCOND, FERR(1), BERR(1), WORK(1),
     &                IWORK(1), INFO )
      END SUBROUTINE DGTSVX_D1B2W1

      SUBROUTINE CGTSVX_D1B2W1( FACT, TRANS, N, NRHS, DL, D, DU, DLF,
     &                          DF, DUF, DU2, IPIV, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), D(*), DL(*), DU(*)
         COMPLEX(WP), INTENT(INOUT) :: DF(*), DLF(*), DU2(*), DUF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CGTSVX( FACT, TRANS, N, NRHS, DL(1), D(1), DU(1), DLF(1),
     &                DF(1), DUF(1), DU2(1), IPIV(1), B(1,1), LDB,
     &                X(1,1), LDX, RCOND, FERR(1), BERR(1), WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE CGTSVX_D1B2W1

      SUBROUTINE ZGTSVX_D1B2W1( FACT, TRANS, N, NRHS, DL, D, DU, DLF,
     &                          DF, DUF, DU2, IPIV, B, LDB, X, LDX,
     &                          RCOND, FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), D(*), DL(*), DU(*)
         COMPLEX(WP), INTENT(INOUT) :: DF(*), DLF(*), DU2(*), DUF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZGTSVX( FACT, TRANS, N, NRHS, DL(1), D(1), DU(1), DLF(1),
     &                DF(1), DUF(1), DU2(1), IPIV(1), B(1,1), LDB,
     &                X(1,1), LDX, RCOND, FERR(1), BERR(1), WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE ZGTSVX_D1B2W1
!
!-----Natural interface for xGTTRF
!
      SUBROUTINE SGTTRF_D1I1( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: D(*), DL(*), DU(*)
         REAL(WP), INTENT(OUT) :: DU2(*)
         CALL SGTTRF( N, DL(1), D(1), DU(1), DU2(1), IPIV(1), INFO )
      END SUBROUTINE SGTTRF_D1I1

      SUBROUTINE DGTTRF_D1I1( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: D(*), DL(*), DU(*)
         REAL(WP), INTENT(OUT) :: DU2(*)
         CALL DGTTRF( N, DL(1), D(1), DU(1), DU2(1), IPIV(1), INFO )
      END SUBROUTINE DGTTRF_D1I1

      SUBROUTINE CGTTRF_D1I1( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: D(*), DL(*), DU(*)
         COMPLEX(WP), INTENT(OUT) :: DU2(*)
         CALL CGTTRF( N, DL(1), D(1), DU(1), DU2(1), IPIV(1), INFO )
      END SUBROUTINE CGTTRF_D1I1

      SUBROUTINE ZGTTRF_D1I1( N, DL, D, DU, DU2, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: D(*), DL(*), DU(*)
         COMPLEX(WP), INTENT(OUT) :: DU2(*)
         CALL ZGTTRF( N, DL(1), D(1), DU(1), DU2(1), IPIV(1), INFO )
      END SUBROUTINE ZGTTRF_D1I1
!
!-----Natural interface for xGTTRS
!
      SUBROUTINE SGTTRS_D1I1B2( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE SGTTRS_D1I1B2

      SUBROUTINE DGTTRS_D1I1B2( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE DGTTRS_D1I1B2

      SUBROUTINE CGTTRS_D1I1B2( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CGTTRS_D1I1B2

      SUBROUTINE ZGTTRS_D1I1B2( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZGTTRS_D1I1B2
!
!-----Natural interface for xGTTRS with one RHS
!
      SUBROUTINE SGTTRS_D1I1B1( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE SGTTRS_D1I1B1

      SUBROUTINE DGTTRS_D1I1B1( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE DGTTRS_D1I1B1

      SUBROUTINE CGTTRS_D1I1B1( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE CGTTRS_D1I1B1

      SUBROUTINE ZGTTRS_D1I1B1( TRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     &                          B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZGTTRS( TRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     &                IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE ZGTTRS_D1I1B1
!
!-----Natural interface for xHGEQZ
!
      SUBROUTINE SHGEQZ_A2B2W1( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), WORK(*)
         CALL SHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE SHGEQZ_A2B2W1

      SUBROUTINE DHGEQZ_A2B2W1( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), WORK(*)
         CALL DHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE DHGEQZ_A2B2W1

      SUBROUTINE CHGEQZ_A2B2W1( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL CHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CHGEQZ_A2B2W1

      SUBROUTINE ZHGEQZ_A2B2W1( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL ZHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZHGEQZ_A2B2W1
!
!-----Interface for xHGEQZ with point interface for WORK/RWORK only
!
      SUBROUTINE SHGEQZ_A2B2W0( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), WORK
         CALL SHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE SHGEQZ_A2B2W0

      SUBROUTINE DHGEQZ_A2B2W0( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), WORK
         CALL DHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE DHGEQZ_A2B2W0

      SUBROUTINE CHGEQZ_A2B2W0( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK
         CALL CHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, WORK, LWORK, RWORK, INFO )
      END SUBROUTINE CHGEQZ_A2B2W0

      SUBROUTINE ZHGEQZ_A2B2W0( JOB, COMPQ, COMPZ, N, ILO, IHI, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK
         CALL ZHGEQZ( JOB, COMPQ, COMPZ, N, ILO, IHI, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, WORK, LWORK, RWORK, INFO )
      END SUBROUTINE ZHGEQZ_A2B2W0
!
!-----Natural interface for xHSEIN
!
      SUBROUTINE SHSEIN_H2V2W1( SIDE, EIGSRC, INITV, SELECT, N, H, LDH,
     &                          WR, WI, VL, LDVL, VR, LDVR, MM, M, WORK,
     &                          IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IFAILL(*), IFAILR(*)
         REAL(WP), INTENT(IN) :: H(LDH,*), WI(*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*), WR(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SHSEIN( SIDE, EIGSRC, INITV, SELECT(1), N, H(1,1), LDH,
     &                WR(1), WI(1), VL(1,1), LDVL, VR(1,1), LDVR, MM, M,
     &                WORK(1), IFAILL(1), IFAILR(1), INFO )
      END SUBROUTINE SHSEIN_H2V2W1

      SUBROUTINE DHSEIN_H2V2W1( SIDE, EIGSRC, INITV, SELECT, N, H, LDH,
     &                          WR, WI, VL, LDVL, VR, LDVR, MM, M, WORK,
     &                          IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IFAILL(*), IFAILR(*)
         REAL(WP), INTENT(IN) :: H(LDH,*), WI(*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*), WR(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DHSEIN( SIDE, EIGSRC, INITV, SELECT(1), N, H(1,1), LDH,
     &                WR(1), WI(1), VL(1,1), LDVL, VR(1,1), LDVR, MM, M,
     &                WORK(1), IFAILL(1), IFAILR(1), INFO )
      END SUBROUTINE DHSEIN_H2V2W1

      SUBROUTINE CHSEIN_H2V2W1( SIDE, EIGSRC, INITV, SELECT, N, H, LDH,
     &                          W, VL, LDVL, VR, LDVR, MM, M, WORK,
     &                          RWORK, IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IFAILL(*), IFAILR(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: H(LDH,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*), W(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHSEIN( SIDE, EIGSRC, INITV, SELECT(1), N, H(1,1), LDH,
     &                W(1), VL(1,1), LDVL, VR(1,1), LDVR, MM, M,
     &                WORK(1), RWORK(1), IFAILL(1), IFAILR(1), INFO )
      END SUBROUTINE CHSEIN_H2V2W1

      SUBROUTINE ZHSEIN_H2V2W1( SIDE, EIGSRC, INITV, SELECT, N, H, LDH,
     &                          W, VL, LDVL, VR, LDVR, MM, M, WORK,
     &                          RWORK, IFAILL, IFAILR, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: EIGSRC, INITV, SIDE
         INTEGER, INTENT(IN) :: LDH, LDVL, LDVR, M, MM, N
         INTEGER, INTENT(OUT) :: INFO
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IFAILL(*), IFAILR(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: H(LDH,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*), W(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHSEIN( SIDE, EIGSRC, INITV, SELECT(1), N, H(1,1), LDH,
     &                W(1), VL(1,1), LDVL, VR(1,1), LDVR, MM, M,
     &                WORK(1), RWORK(1), IFAILL(1), IFAILR(1), INFO )
      END SUBROUTINE ZHSEIN_H2V2W1
!
!-----Natural interface for xHSEQR
!
      SUBROUTINE SHSEQR_H2Z2W1( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) ::  WI(*), WORK(*), WR(*)
         CALL SHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     &                WI(1), Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE SHSEQR_H2Z2W1

      SUBROUTINE DHSEQR_H2Z2W1( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) ::  WI(*), WORK(*), WR(*)
         CALL DHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     &                WI(1), Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE DHSEQR_H2Z2W1

      SUBROUTINE CHSEQR_H2Z2W1( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) ::  W(*), WORK(*)
         CALL CHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, W(1),
     &                Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE CHSEQR_H2Z2W1

      SUBROUTINE ZHSEQR_H2Z2W1( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) ::  W(*), WORK(*)
         CALL ZHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, W(1),
     &                Z(1,1), LDZ, WORK(1), LWORK, INFO )
      END SUBROUTINE ZHSEQR_H2Z2W1
!
!-----Interface for xHSEQR with point interface for WORK only
!
      SUBROUTINE SHSEQR_H2Z2W0( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) ::  WI(*), WORK, WR(*)
         CALL SHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     &                WI(1), Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE SHSEQR_H2Z2W0

      SUBROUTINE DHSEQR_H2Z2W0( JOB, COMPZ, N, ILO, IHI, H, LDH, WR, WI,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) ::  WI(*), WORK, WR(*)
         CALL DHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     &                WI(1), Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE DHSEQR_H2Z2W0

      SUBROUTINE CHSEQR_H2Z2W0( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) ::  W(*), WORK
         CALL CHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, W(1),
     &                Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE CHSEQR_H2Z2W0

      SUBROUTINE ZHSEQR_H2Z2W0( JOB, COMPZ, N, ILO, IHI, H, LDH, W,
     &                          Z, LDZ, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ, JOB
         INTEGER, INTENT(IN) :: IHI, ILO, LDH, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) ::  W(*), WORK
         CALL ZHSEQR( JOB, COMPZ, N, ILO, IHI, H(1,1), LDH, W(1),
     &                Z(1,1), LDZ, WORK, LWORK, INFO )
      END SUBROUTINE ZHSEQR_H2Z2W0
!
!-----Natural interface for xOPGTR and xUPGTR
!
      SUBROUTINE SOPGTR_NAT( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*), TAU(*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*)
         CALL SOPGTR( UPLO, N, AP(1), TAU(1), Q(1,1), LDQ, WORK(1),
     &                INFO )
      END SUBROUTINE SOPGTR_NAT

      SUBROUTINE DOPGTR_NAT( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*), TAU(*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*)
         CALL DOPGTR( UPLO, N, AP(1), TAU(1), Q(1,1), LDQ, WORK(1),
     &                INFO )
      END SUBROUTINE DOPGTR_NAT

      SUBROUTINE CUPGTR_NAT( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*), TAU(*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*)
         CALL CUPGTR( UPLO, N, AP(1), TAU(1), Q(1,1), LDQ, WORK(1),
     &                INFO )
      END SUBROUTINE CUPGTR_NAT

      SUBROUTINE ZUPGTR_NAT( UPLO, N, AP, TAU, Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*), TAU(*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*)
         CALL ZUPGTR( UPLO, N, AP(1), TAU(1), Q(1,1), LDQ, WORK(1),
     &                INFO )
      END SUBROUTINE ZUPGTR_NAT
!
!-----Natural interface for xOPMTR and xUPMTR
!
      SUBROUTINE SOPMTR_NAT( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC,
     &                       WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SOPMTR( SIDE, UPLO, TRANS, M, N, AP(1), TAU(1), C(1,1),
     &                LDC, WORK(1), INFO )
      END SUBROUTINE SOPMTR_NAT

      SUBROUTINE DOPMTR_NAT( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC,
     &                       WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DOPMTR( SIDE, UPLO, TRANS, M, N, AP(1), TAU(1), C(1,1),
     &                LDC, WORK(1), INFO )
      END SUBROUTINE DOPMTR_NAT

      SUBROUTINE CUPMTR_NAT( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC,
     &                       WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUPMTR( SIDE, UPLO, TRANS, M, N, AP(1), TAU(1), C(1,1),
     &                LDC, WORK(1), INFO )
      END SUBROUTINE CUPMTR_NAT

      SUBROUTINE ZUPMTR_NAT( SIDE, UPLO, TRANS, M, N, AP, TAU, C, LDC,
     &                       WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUPMTR( SIDE, UPLO, TRANS, M, N, AP(1), TAU(1), C(1,1),
     &                LDC, WORK(1), INFO )
      END SUBROUTINE ZUPMTR_NAT
!
!-----Natural interface for xORGBR and xUNGBR
!
      SUBROUTINE SORGBR_A2T1W1( VECT, M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGBR( VECT, M, N, K, A(1,1), LDA, TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE SORGBR_A2T1W1

      SUBROUTINE DORGBR_A2T1W1( VECT, M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGBR( VECT, M, N, K, A(1,1), LDA, TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE DORGBR_A2T1W1

      SUBROUTINE CUNGBR_A2T1W1( VECT, M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGBR( VECT, M, N, K, A(1,1), LDA, TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE CUNGBR_A2T1W1

      SUBROUTINE ZUNGBR_A2T1W1( VECT, M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: VECT
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGBR( VECT, M, N, K, A(1,1), LDA, TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE ZUNGBR_A2T1W1
!
!-----Natural interface for xORGHR and xUNGHR
!
      SUBROUTINE SORGHR_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGHR( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGHR_A2T1W1

      SUBROUTINE DORGHR_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGHR( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGHR_A2T1W1

      SUBROUTINE CUNGHR_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGHR( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGHR_A2T1W1

      SUBROUTINE ZUNGHR_A2T1W1( N, ILO, IHI, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGHR( N, ILO, IHI, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGHR_A2T1W1
!
!-----Natural interface for xORGLQ and xUNGLQ
!
      SUBROUTINE SORGLQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGLQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGLQ_A2T1W1

      SUBROUTINE DORGLQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGLQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGLQ_A2T1W1

      SUBROUTINE CUNGLQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGLQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGLQ_A2T1W1

      SUBROUTINE ZUNGLQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGLQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGLQ_A2T1W1
!
!-----Natural interface for xORGQL and xUNGQL
!
      SUBROUTINE SORGQL_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGQL( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGQL_A2T1W1

      SUBROUTINE DORGQL_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGQL( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGQL_A2T1W1

      SUBROUTINE CUNGQL_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGQL( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGQL_A2T1W1

      SUBROUTINE ZUNGQL_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGQL( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGQL_A2T1W1
!
!-----Natural interface for xORGQR and xUNGQR
!
      SUBROUTINE SORGQR_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGQR( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGQR_A2T1W1

      SUBROUTINE DORGQR_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGQR( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGQR_A2T1W1

      SUBROUTINE CUNGQR_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGQR( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGQR_A2T1W1

      SUBROUTINE ZUNGQR_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGQR( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGQR_A2T1W1
!
!-----Natural interface for xORGRQ and xUNGRQ
!
      SUBROUTINE SORGRQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGRQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGRQ_A2T1W1

      SUBROUTINE DORGRQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGRQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGRQ_A2T1W1

      SUBROUTINE CUNGRQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGRQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGRQ_A2T1W1

      SUBROUTINE ZUNGRQ_A2T1W1( M, N, K, A, LDA, TAU, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGRQ( M, N, K, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGRQ_A2T1W1
!
!-----Natural interface for xORGTR and xUNGTR
!
      SUBROUTINE SORGTR_A2T1W1( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGTR( UPLO, N, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SORGTR_A2T1W1

      SUBROUTINE DORGTR_A2T1W1( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGTR( UPLO, N, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DORGTR_A2T1W1

      SUBROUTINE CUNGTR_A2T1W1( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGTR( UPLO, N, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CUNGTR_A2T1W1

      SUBROUTINE ZUNGTR_A2T1W1( UPLO, N, A, LDA, TAU, WORK, LWORK, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGTR( UPLO, N, A(1,1), LDA, TAU(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZUNGTR_A2T1W1
!
!-----Natural interface for xORMBR and xUNMBR
!
      SUBROUTINE SORMBR_A2T1W1( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMBR( VECT, SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMBR_A2T1W1

      SUBROUTINE DORMBR_A2T1W1( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMBR( VECT, SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMBR_A2T1W1

      SUBROUTINE CUNMBR_A2T1W1( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMBR( VECT, SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMBR_A2T1W1

      SUBROUTINE ZUNMBR_A2T1W1( VECT, SIDE, TRANS, M, N, K, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, VECT
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMBR( VECT, SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMBR_A2T1W1
!
!-----Natural interface for xORMHR and xUNMHR
!
      SUBROUTINE SORMHR_A2T1W1( SIDE, TRANS, M, N, ILO, IHI, A, LDA,
     &                          TAU, C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMHR( SIDE, TRANS, M, N, ILO, IHI, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMHR_A2T1W1

      SUBROUTINE DORMHR_A2T1W1( SIDE, TRANS, M, N, ILO, IHI, A, LDA,
     &                          TAU, C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMHR( SIDE, TRANS, M, N, ILO, IHI, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMHR_A2T1W1

      SUBROUTINE CUNMHR_A2T1W1( SIDE, TRANS, M, N, ILO, IHI, A, LDA,
     &                          TAU, C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMHR( SIDE, TRANS, M, N, ILO, IHI, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMHR_A2T1W1

      SUBROUTINE ZUNMHR_A2T1W1( SIDE, TRANS, M, N, ILO, IHI, A, LDA,
     &                          TAU, C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER,  INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMHR( SIDE, TRANS, M, N, ILO, IHI, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMHR_A2T1W1
!
!-----Natural interface for xORMLQ and xUNMLQ
!
      SUBROUTINE SORMLQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMLQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMLQ_A2T1W1

      SUBROUTINE DORMLQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMLQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMLQ_A2T1W1

      SUBROUTINE CUNMLQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMLQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMLQ_A2T1W1

      SUBROUTINE ZUNMLQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMLQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMLQ_A2T1W1
!
!-----Natural interface for xORMQL and xUNMQL
!
      SUBROUTINE SORMQL_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMQL( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMQL_A2T1W1

      SUBROUTINE DORMQL_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMQL( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMQL_A2T1W1

      SUBROUTINE CUNMQL_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMQL( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMQL_A2T1W1

      SUBROUTINE ZUNMQL_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMQL( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMQL_A2T1W1
!
!-----Natural interface for xORMQR and xUNMQR
!
      SUBROUTINE SORMQR_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMQR( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMQR_A2T1W1

      SUBROUTINE DORMQR_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMQR( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMQR_A2T1W1

      SUBROUTINE CUNMQR_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMQR( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMQR_A2T1W1

      SUBROUTINE ZUNMQR_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMQR( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMQR_A2T1W1
!
!-----Natural interface for xORMRQ and xUNMRQ
!
      SUBROUTINE SORMRQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMRQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMRQ_A2T1W1

      SUBROUTINE DORMRQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMRQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMRQ_A2T1W1

      SUBROUTINE CUNMRQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMRQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMRQ_A2T1W1

      SUBROUTINE ZUNMRQ_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     &                          LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMRQ( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     &                LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMRQ_A2T1W1
!
!-----Natural interface for xORMRZ and xUNMRZ
!
      SUBROUTINE SORMRZ_A2T1W1( SIDE, TRANS, M, N, K, L, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORMRZ( SIDE, TRANS, M, N, K, L, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMRZ_A2T1W1

      SUBROUTINE DORMRZ_A2T1W1( SIDE, TRANS, M, N, K, L, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORMRZ( SIDE, TRANS, M, N, K, L, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMRZ_A2T1W1

      SUBROUTINE CUNMRZ_A2T1W1( SIDE, TRANS, M, N, K, L, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNMRZ( SIDE, TRANS, M, N, K, L, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMRZ_A2T1W1

      SUBROUTINE ZUNMRZ_A2T1W1( SIDE, TRANS, M, N, K, L, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, L, LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNMRZ( SIDE, TRANS, M, N, K, L, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMRZ_A2T1W1
!
!-----Natural interface for xORMTR and xUNMTR
!
      SUBROUTINE SORMTR_A2T1W1( SIDE, UPLO, TRANS, M, N, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         CALL SORMTR( SIDE, UPLO, TRANS, M, N, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE SORMTR_A2T1W1

      SUBROUTINE DORMTR_A2T1W1( SIDE, UPLO, TRANS, M, N, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         CALL DORMTR( SIDE, UPLO, TRANS, M, N, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE DORMTR_A2T1W1

      SUBROUTINE CUNMTR_A2T1W1( SIDE, UPLO, TRANS, M, N, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         CALL CUNMTR( SIDE, UPLO, TRANS, M, N, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE CUNMTR_A2T1W1

      SUBROUTINE ZUNMTR_A2T1W1( SIDE, UPLO, TRANS, M, N, A, LDA, TAU,
     &                          C, LDC, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, LDC, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         CALL ZUNMTR( SIDE, UPLO, TRANS, M, N, A(1,1), LDA, TAU(1),
     &                C(1,1), LDC, WORK(1), LWORK, INFO )
      END SUBROUTINE ZUNMTR_A2T1W1
!
!-----Natural interface for xPBSV
!
      SUBROUTINE SPBSV_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL SPBSV( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &               INFO )
      END SUBROUTINE SPBSV_A2B2

      SUBROUTINE DPBSV_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL DPBSV( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &               INFO )
      END SUBROUTINE DPBSV_A2B2

      SUBROUTINE CPBSV_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL CPBSV( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &               INFO )
      END SUBROUTINE CPBSV_A2B2

      SUBROUTINE ZPBSV_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), B(LDB,*)
         CALL ZPBSV( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &               INFO )
      END SUBROUTINE ZPBSV_A2B2
!
!-----Natural interface for xPBSVX
!
      SUBROUTINE SPBSVX_A2B2W1( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB,
     &                          LDAFB, EQUED, S, B, LDB, X, LDX, RCOND,
     &                          FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*),
     &                              S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SPBSVX( FACT, UPLO, N, KD, NRHS, AB(1,1), LDAB, AFB(1,1),
     &                LDAFB, EQUED, S(1), B(1,1), LDB, X(1,1), LDX,
     &                RCOND, FERR(1), BERR(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE SPBSVX_A2B2W1

      SUBROUTINE DPBSVX_A2B2W1( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB,
     &                          LDAFB, EQUED, S, B, LDB, X, LDX, RCOND,
     &                          FERR, BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*), B(LDB,*),
     &                              S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DPBSVX( FACT, UPLO, N, KD, NRHS, AB(1,1), LDAB, AFB(1,1),
     &                LDAFB, EQUED, S(1), B(1,1), LDB, X(1,1), LDX,
     &                RCOND, FERR(1), BERR(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE DPBSVX_A2B2W1

      SUBROUTINE CPBSVX_A2B2W1( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB,
     &                          LDAFB, EQUED, S, B, LDB, X, LDX, RCOND,
     &                          FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*),
     &                                 B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CPBSVX( FACT, UPLO, N, KD, NRHS, AB(1,1), LDAB, AFB(1,1),
     &                LDAFB, EQUED, S(1), B(1,1), LDB, X(1,1), LDX,
     &                RCOND, FERR(1), BERR(1), WORK(1), RWORK(1), INFO )
      END SUBROUTINE CPBSVX_A2B2W1

      SUBROUTINE ZPBSVX_A2B2W1( FACT, UPLO, N, KD, NRHS, AB, LDAB, AFB,
     &                          LDAFB, EQUED, S, B, LDB, X, LDX, RCOND,
     &                          FERR, BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: KD, LDAB, LDAFB, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), AFB(LDAFB,*),
     &                                 B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZPBSVX( FACT, UPLO, N, KD, NRHS, AB(1,1), LDAB, AFB(1,1),
     &                LDAFB, EQUED, S(1), B(1,1), LDB, X(1,1), LDX,
     &                RCOND, FERR(1), BERR(1), WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZPBSVX_A2B2W1
!
!-----Natural interface for xPBTRF
!
      SUBROUTINE SPBTRF_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL SPBTRF( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE SPBTRF_A2

      SUBROUTINE DPBTRF_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL DPBTRF( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE DPBTRF_A2

      SUBROUTINE CPBTRF_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL CPBTRF( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE CPBTRF_A2

      SUBROUTINE ZPBTRF_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL ZPBTRF( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE ZPBTRF_A2
!
!-----Natural interface for xPBTRS
!
      SUBROUTINE SPBTRS_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &                INFO )
      END SUBROUTINE SPBTRS_A2B2

      SUBROUTINE DPBTRS_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &                INFO )
      END SUBROUTINE DPBTRS_A2B2

      SUBROUTINE CPBTRS_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &                INFO )
      END SUBROUTINE CPBTRS_A2B2

      SUBROUTINE ZPBTRS_A2B2( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1,1), LDB,
     &                INFO )
      END SUBROUTINE ZPBTRS_A2B2
!
!-----Natural interface for xPBTRS with one RHS
!
      SUBROUTINE SPBTRS_A2B1( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1), LDB,
     &                INFO )
      END SUBROUTINE SPBTRS_A2B1

      SUBROUTINE DPBTRS_A2B1( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1), LDB,
     &                INFO )
      END SUBROUTINE DPBTRS_A2B1

      SUBROUTINE CPBTRS_A2B1( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1), LDB,
     &                INFO )
      END SUBROUTINE CPBTRS_A2B1

      SUBROUTINE ZPBTRS_A2B1( UPLO, N, KD, NRHS, AB, LDAB, B, LDB, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZPBTRS( UPLO, N, KD, NRHS, AB(1,1), LDAB, B(1), LDB,
     &                INFO )
      END SUBROUTINE ZPBTRS_A2B1
!
!-----Natural interface for xPOSV
!
      SUBROUTINE SPOSV_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL SPOSV( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE SPOSV_A2B2

      SUBROUTINE DPOSV_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL DPOSV( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE DPOSV_A2B2

      SUBROUTINE CPOSV_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL CPOSV( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE CPOSV_A2B2

      SUBROUTINE ZPOSV_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         CALL ZPOSV( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE ZPOSV_A2B2
!
!-----Natural interface for xPOSVX
!
      SUBROUTINE SPOSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          EQUED, S, B, LDB, X, LDX, RCOND, FERR,
     &                          BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*),
     &                              S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SPOSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                EQUED, S(1), B(1,1), LDB, X(1,1), LDX, RCOND,
     &                FERR(1), BERR(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE SPOSVX_A2B2W1

      SUBROUTINE DPOSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          EQUED, S, B, LDB, X, LDX, RCOND, FERR,
     &                          BERR, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*),
     &                              S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DPOSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                EQUED, S(1), B(1,1), LDB, X(1,1), LDX, RCOND,
     &                FERR(1), BERR(1), WORK(1), IWORK(1), INFO )
      END SUBROUTINE DPOSVX_A2B2W1

      SUBROUTINE CPOSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          EQUED, S, B, LDB, X, LDX, RCOND, FERR,
     &                          BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CPOSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                EQUED, S(1), B(1,1), LDB, X(1,1), LDX, RCOND,
     &                FERR(1), BERR(1), WORK(1), RWORK(1), INFO )
      END SUBROUTINE CPOSVX_A2B2W1

      SUBROUTINE ZPOSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          EQUED, S, B, LDB, X, LDX, RCOND, FERR,
     &                          BERR, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AF(LDAF,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZPOSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                EQUED, S(1), B(1,1), LDB, X(1,1), LDX, RCOND,
     &                FERR(1), BERR(1), WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZPOSVX_A2B2W1
!
!-----Natural interface for xPOTRF
!
      SUBROUTINE SPOTRF_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SPOTRF( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE SPOTRF_A2

      SUBROUTINE DPOTRF_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL DPOTRF( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE DPOTRF_A2

      SUBROUTINE CPOTRF_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CPOTRF( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE CPOTRF_A2

      SUBROUTINE ZPOTRF_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL ZPOTRF( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE ZPOTRF_A2
!
!-----Natural interface for xPOTRS
!
      SUBROUTINE SPOTRS_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE SPOTRS_A2B2

      SUBROUTINE DPOTRS_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE DPOTRS_A2B2

      SUBROUTINE CPOTRS_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE CPOTRS_A2B2

      SUBROUTINE ZPOTRS_A2B2( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE ZPOTRS_A2B2
!
!-----Natural interface for xPOTRS with one RHS
!
      SUBROUTINE SPOTRS_A2B1( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1), LDB, INFO )
      END SUBROUTINE SPOTRS_A2B1

      SUBROUTINE DPOTRS_A2B1( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1), LDB, INFO )
      END SUBROUTINE DPOTRS_A2B1

      SUBROUTINE CPOTRS_A2B1( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1), LDB, INFO )
      END SUBROUTINE CPOTRS_A2B1

      SUBROUTINE ZPOTRS_A2B1( UPLO, N, NRHS, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZPOTRS( UPLO, N, NRHS, A(1,1), LDA, B(1), LDB, INFO )
      END SUBROUTINE ZPOTRS_A2B1
!
!-----Natural interface for xPPSV
!
      SUBROUTINE SPPSV_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL SPPSV( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE SPPSV_A1B2

      SUBROUTINE DPPSV_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL DPPSV( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE DPPSV_A1B2

      SUBROUTINE CPPSV_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL CPPSV( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE CPPSV_A1B2

      SUBROUTINE ZPPSV_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL ZPPSV( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZPPSV_A1B2
!
!-----Natural interface for xPPSVX
!
      SUBROUTINE SPPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S,
     &                          B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AFP(*), AP(*), B(LDB,*), S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SPPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), EQUED, S(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SPPSVX_A1B2W1

      SUBROUTINE DPPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S,
     &                          B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AFP(*), AP(*), B(LDB,*), S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DPPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), EQUED, S(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DPPSVX_A1B2W1

      SUBROUTINE CPPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S,
     &                          B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CPPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), EQUED, S(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CPPSVX_A1B2W1

      SUBROUTINE ZPPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, EQUED, S,
     &                          B, LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         CHARACTER, INTENT(INOUT) :: EQUED
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(INOUT) :: S(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*), AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZPPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), EQUED, S(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZPPSVX_A1B2W1
!
!-----Natural interface for xPPTRF
!
      SUBROUTINE SPPTRF_A1( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL SPPTRF( UPLO, N, AP(1), INFO )
      END SUBROUTINE SPPTRF_A1

      SUBROUTINE DPPTRF_A1( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL DPPTRF( UPLO, N, AP(1), INFO )
      END SUBROUTINE DPPTRF_A1

      SUBROUTINE CPPTRF_A1( UPLO, N, AP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL CPPTRF( UPLO, N, AP(1), INFO )
      END SUBROUTINE CPPTRF_A1

      SUBROUTINE ZPPTRF_A1( UPLO, N, AP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL ZPPTRF( UPLO, N, AP(1), INFO )
      END SUBROUTINE ZPPTRF_A1
!
!-----Natural interface for xPPTRS
!
      SUBROUTINE SPPTRS_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPPTRS( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE SPPTRS_A1B2

      SUBROUTINE DPPTRS_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DPPTRS( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE DPPTRS_A1B2

      SUBROUTINE CPPTRS_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPPTRS( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE CPPTRS_A1B2

      SUBROUTINE ZPPTRS_A1B2( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZPPTRS( UPLO, N, NRHS, AP(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZPPTRS_A1B2
!
!-----Natural interface for xPPTRS with one RHS
!
      SUBROUTINE SPPTRS_A1B1( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SPPTRS( UPLO, N, NRHS, AP(1), B(1), LDB, INFO )
      END SUBROUTINE SPPTRS_A1B1

      SUBROUTINE DPPTRS_A1B1( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DPPTRS( UPLO, N, NRHS, AP(1), B(1), LDB, INFO )
      END SUBROUTINE DPPTRS_A1B1

      SUBROUTINE CPPTRS_A1B1( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CPPTRS( UPLO, N, NRHS, AP(1), B(1), LDB, INFO )
      END SUBROUTINE CPPTRS_A1B1

      SUBROUTINE ZPPTRS_A1B1( UPLO, N, NRHS, AP, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZPPTRS( UPLO, N, NRHS, AP(1), B(1), LDB, INFO )
      END SUBROUTINE ZPPTRS_A1B1
!
!-----Natural interface for xPTEQR
!
      SUBROUTINE SPTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SPTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE SPTEQR_D1Z2W1

      SUBROUTINE DPTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DPTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE DPTEQR_D1Z2W1

      SUBROUTINE CPTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         CALL CPTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE CPTEQR_D1Z2W1

      SUBROUTINE ZPTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         CALL ZPTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE ZPTEQR_D1Z2W1
!
!-----Natural interface(s) for xPTSV
!
!     For compatibility with LAPACK 3, the UPLO argument may be
!     omitted when calling LA_PTSV with complex data, in which
!     case it is assumed to be 'L'.
!
      SUBROUTINE SPTSV_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), E(*)
         CALL SPTSV( N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE SPTSV_D1B2

      SUBROUTINE DPTSV_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: B(LDB,*), D(*), E(*)
         CALL DPTSV( N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE DPTSV_D1B2

      SUBROUTINE CPTSV_U0D1B2( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), E(*)
         CALL CPTSV( UPLO, N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE CPTSV_U0D1B2

      SUBROUTINE ZPTSV_U0D1B2( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), E(*)
         CALL ZPTSV( UPLO, N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZPTSV_U0D1B2

      SUBROUTINE CPTSV_D0B0( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: B, E
         CALL CPTSV( 'L', N, NRHS, D, E, B, LDB, INFO )
      END SUBROUTINE CPTSV_D0B0

      SUBROUTINE ZPTSV_D0B0( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D
         COMPLEX(WP), INTENT(INOUT) :: B, E
         CALL ZPTSV( 'L', N, NRHS, D, E, B, LDB, INFO )
      END SUBROUTINE ZPTSV_D0B0

      SUBROUTINE CPTSV_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), E(*)
         CALL CPTSV( 'L', N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE CPTSV_D1B2

      SUBROUTINE ZPTSV_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*), E(*)
         CALL ZPTSV( 'L', N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZPTSV_D1B2
!
!-----Natural interface for xPTSVX
!
!     For compatibility with LAPACK 3, the UPLO argument may be
!     omitted when calling LA_PTSVX with complex data, in which
!     case it is assumed to be 'L'.
!
      SUBROUTINE SPTSVX_D1B2( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), E(*)
         REAL(WP), INTENT(INOUT) :: DF(*), EF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SPTSVX( FACT, N, NRHS, D(1), E(1), DF(1), EF(1), B(1,1),
     &                LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), INFO )
      END SUBROUTINE SPTSVX_D1B2

      SUBROUTINE DPTSVX_D1B2( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: B(LDB,*), D(*), E(*)
         REAL(WP), INTENT(INOUT) :: DF(*), EF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DPTSVX( FACT, N, NRHS, D(1), E(1), DF(1), EF(1), B(1,1),
     &                LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), INFO )
      END SUBROUTINE DPTSVX_D1B2

      SUBROUTINE CPTSVX_U0D1B2( FACT, UPLO, N, NRHS, D, E, DF, EF, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(INOUT) :: DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: EF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CPTSVX( FACT, UPLO, N, NRHS, D(1), E(1), DF(1), EF(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CPTSVX_U0D1B2

      SUBROUTINE ZPTSVX_U0D1B2( FACT, UPLO, N, NRHS, D, E, DF, EF, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(INOUT) :: DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: EF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZPTSVX( FACT, UPLO, N, NRHS, D(1), E(1), DF(1), EF(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZPTSVX_U0D1B2

      SUBROUTINE CPTSVX_D0B0( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                        INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(INOUT) :: DF
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, E
         COMPLEX(WP), INTENT(INOUT) :: EF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
         CALL CPTSVX( FACT, 'L', N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                RCOND, FERR, BERR, WORK, RWORK, INFO )
      END SUBROUTINE CPTSVX_D0B0

      SUBROUTINE ZPTSVX_D0B0( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                        INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D
         REAL(WP), INTENT(INOUT) :: DF
         REAL(WP), INTENT(OUT) :: BERR, FERR, RWORK
         COMPLEX(WP), INTENT(IN) :: B, E
         COMPLEX(WP), INTENT(INOUT) :: EF
         COMPLEX(WP), INTENT(OUT) :: WORK, X
         CALL ZPTSVX( FACT, 'L', N, NRHS, D, E, DF, EF, B, LDB, X, LDX,
     &                RCOND, FERR, BERR, WORK, RWORK, INFO )
      END SUBROUTINE ZPTSVX_D0B0

      SUBROUTINE CPTSVX_D1B2( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                        INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(INOUT) :: DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: EF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CPTSVX( FACT, 'L', N, NRHS, D(1), E(1), DF(1), EF(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CPTSVX_D1B2

      SUBROUTINE ZPTSVX_D1B2( FACT, N, NRHS, D, E, DF, EF, B, LDB,
     &                        X, LDX, RCOND, FERR, BERR, WORK, RWORK,
     &                        INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         REAL(WP), INTENT(IN) :: D(*)
         REAL(WP), INTENT(INOUT) :: DF(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: EF(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZPTSVX( FACT, 'L', N, NRHS, D(1), E(1), DF(1), EF(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZPTSVX_D1B2
!
!-----Natural interface for xPTTRF
!
      SUBROUTINE SPTTRF_D1( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         REAL(WP), INTENT(INOUT) :: E(*)
         CALL SPTTRF( N, D(1), E(1), INFO )
      END SUBROUTINE SPTTRF_D1

      SUBROUTINE DPTTRF_D1( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         REAL(WP), INTENT(INOUT) :: E(*)
         CALL DPTTRF( N, D(1), E(1), INFO )
      END SUBROUTINE DPTTRF_D1

      SUBROUTINE CPTTRF_D1( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: E(*)
         CALL CPTTRF( N, D(1), E(1), INFO )
      END SUBROUTINE CPTTRF_D1

      SUBROUTINE ZPTTRF_D1( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*)
         COMPLEX(WP), INTENT(INOUT) :: E(*)
         CALL ZPTTRF( N, D(1), E(1), INFO )
      END SUBROUTINE ZPTTRF_D1
!
!-----Natural interface for xPTTRS
!
      SUBROUTINE SPTTRS_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPTTRS( N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE SPTTRS_D1B2

      SUBROUTINE DPTTRS_D1B2( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DPTTRS( N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE DPTTRS_D1B2

      SUBROUTINE CPTTRS_D1B2( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPTTRS( UPLO, N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE CPTTRS_D1B2

      SUBROUTINE ZPTTRS_D1B2( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZPTTRS( UPLO, N, NRHS, D(1), E(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZPTTRS_D1B2
!
!-----Natural interface for xPTTRS with one RHS
!
      SUBROUTINE SPTTRS_D1B1( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SPTTRS( N, NRHS, D(1), E(1), B(1), LDB, INFO )
      END SUBROUTINE SPTTRS_D1B1

      SUBROUTINE DPTTRS_D1B1( N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DPTTRS( N, NRHS, D(1), E(1), B(1), LDB, INFO )
      END SUBROUTINE DPTTRS_D1B1

      SUBROUTINE CPTTRS_D1B1( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CPTTRS( UPLO, N, NRHS, D(1), E(1), B(1), LDB, INFO )
      END SUBROUTINE CPTTRS_D1B1

      SUBROUTINE ZPTTRS_D1B1( UPLO, N, NRHS, D, E, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZPTTRS( UPLO, N, NRHS, D(1), E(1), B(1), LDB, INFO )
      END SUBROUTINE ZPTTRS_D1B1
!
!-----Natural interface for xSBGST and xHBGST
!
      SUBROUTINE SSBGST_NAT( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                       X, LDX, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BB(LDBB,*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL SSBGST( VECT, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, X(1,1), LDX, WORK(1), INFO )
      END SUBROUTINE SSBGST_NAT

      SUBROUTINE DSBGST_NAT( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                       X, LDX, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BB(LDBB,*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL DSBGST( VECT, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, X(1,1), LDX, WORK(1), INFO )
      END SUBROUTINE DSBGST_NAT

      SUBROUTINE CHBGST_NAT( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                       X, LDX, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: BB(LDBB,*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CHBGST( VECT, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, X(1,1), LDX, WORK(1), RWORK(1), INFO )
      END SUBROUTINE CHBGST_NAT

      SUBROUTINE ZHBGST_NAT( VECT, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                       X, LDX, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDX, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: BB(LDBB,*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZHBGST( VECT, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, X(1,1), LDX, WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZHBGST_NAT
!
!-----Natural interface for xSBEV and xHBEV
!
      SUBROUTINE SSBEV_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                      WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSBEV( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &               LDZ, WORK(1), INFO )
      END SUBROUTINE SSBEV_NAT

      SUBROUTINE DSBEV_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                      WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSBEV( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &               LDZ, WORK(1), INFO )
      END SUBROUTINE DSBEV_NAT

      SUBROUTINE CHBEV_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                      WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHBEV( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &               LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE CHBEV_NAT

      SUBROUTINE ZHBEV_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                      WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHBEV( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &               LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZHBEV_NAT
!
!-----Natural interface for xSBEVD and xHBEVD
!
      SUBROUTINE SSBEVD_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSBEVD( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSBEVD_NAT

      SUBROUTINE DSBEVD_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSBEVD( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSBEVD_NAT

      SUBROUTINE CHBEVD_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHBEVD( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE CHBEVD_NAT

      SUBROUTINE ZHBEVD_NAT( JOBZ, UPLO, N, KD, AB, LDAB, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB, LDZ, LIWORK, LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHBEVD( JOBZ, UPLO, N, KD, AB(1,1), LDAB, W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE ZHBEVD_NAT
!
!-----Natural interface for xSBEVX and xHBEVX
!
      SUBROUTINE SSBEVX_NAT( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                       VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), W(*), WORK(*), Z(LDZ,*)
         CALL SSBEVX( JOBZ, RANGE, UPLO, N, KD, AB(1,1), LDAB, Q(1,1),
     &                LDQ, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE SSBEVX_NAT

      SUBROUTINE DSBEVX_NAT( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                       VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), W(*), WORK(*), Z(LDZ,*)
         CALL DSBEVX( JOBZ, RANGE, UPLO, N, KD, AB(1,1), LDAB, Q(1,1),
     &                LDQ, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE DSBEVX_NAT

      SUBROUTINE CHBEVX_NAT( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                       VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*), Z(LDZ,*)
         CALL CHBEVX( JOBZ, RANGE, UPLO, N, KD, AB(1,1), LDAB, Q(1,1),
     &                LDQ, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CHBEVX_NAT

      SUBROUTINE ZHBEVX_NAT( JOBZ, RANGE, UPLO, N, KD, AB, LDAB, Q, LDQ,
     &                       VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KD, LDAB, LDQ, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*), Z(LDZ,*)
         CALL ZHBEVX( JOBZ, RANGE, UPLO, N, KD, AB(1,1), LDAB, Q(1,1),
     &                LDQ, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZHBEVX_NAT
!
!-----Natural interface for xSBGV and xHBGV
!
      SUBROUTINE SSBGV_NAT( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                      W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSBGV( JOBZ, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &               LDBB, W(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE SSBGV_NAT

      SUBROUTINE DSBGV_NAT( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                      W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSBGV( JOBZ, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &               LDBB, W(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE DSBGV_NAT

      SUBROUTINE CHBGV_NAT( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                      W, Z, LDZ, WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHBGV( JOBZ, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &               LDBB, W(1), Z(1,1), LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE CHBGV_NAT

      SUBROUTINE ZHBGV_NAT( JOBZ, UPLO, N, KA, KB, AB, LDAB, BB, LDBB,
     &                      W, Z, LDZ, WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: KA, KB, LDAB, LDBB, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHBGV( JOBZ, UPLO, N, KA, KB, AB(1,1), LDAB, BB(1,1),
     &               LDBB, W(1), Z(1,1), LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZHBGV_NAT
!
!-----Natural interface for xSBGVD and xHBGVD
!
      SUBROUTINE SSBGVD_NAT( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                       LDBB, W, Z, LDZ, WORK, LWORK, IWORK,
     &                       LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: W(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SSBGVD( JOBZ, UPLO, N, KAB, KBB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, W(1), Z(1,1), LDZ, WORK(1), LWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE SSBGVD_NAT

      SUBROUTINE DSBGVD_NAT( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                       LDBB, W, Z, LDZ, WORK, LWORK, IWORK,
     &                       LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: W(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DSBGVD( JOBZ, UPLO, N, KAB, KBB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, W(1), Z(1,1), LDZ, WORK(1), LWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE DSBGVD_NAT

      SUBROUTINE CHBGVD_NAT( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                       LDBB, W, Z, LDZ, WORK, LWORK, RWORK,
     &                       LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHBGVD( JOBZ, UPLO, N, KAB, KBB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, W(1), Z(1,1), LDZ, WORK(1), LWORK, RWORK(1),
     &                LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CHBGVD_NAT

      SUBROUTINE ZHBGVD_NAT( JOBZ, UPLO, N, KAB, KBB, AB, LDAB, BB,
     &                       LDBB, W, Z, LDZ, WORK, LWORK, RWORK,
     &                       LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: N, KAB, KBB, LDAB, LDBB, LDZ, LIWORK,
     &                          LRWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHBGVD( JOBZ, UPLO, N, KAB, KBB, AB(1,1), LDAB, BB(1,1),
     &                LDBB, W(1), Z(1,1), LDZ, WORK(1), LWORK, RWORK(1),
     &                LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZHBGVD_NAT
!
!-----Natural interface for xSBGVX and xHBGVX
!
      SUBROUTINE SSBGVX_NAT( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB,
     &                       BB, LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL,
     &                       M, W, Z, LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), W(*), WORK(*), Z(LDZ,*)
         CALL SSBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB(1,1), LDAB,
     &                BB(1,1), LDBB, Q(1,1), LDQ, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE SSBGVX_NAT

      SUBROUTINE DSBGVX_NAT( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB,
     &                       BB, LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL,
     &                       M, W, Z, LDZ, WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         REAL(WP), INTENT(OUT) :: Q(LDQ,*), W(*), WORK(*), Z(LDZ,*)
         CALL DSBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB(1,1), LDAB,
     &                BB(1,1), LDBB, Q(1,1), LDQ, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE DSBGVX_NAT

      SUBROUTINE CHBGVX_NAT( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB,
     &                       BB, LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL,
     &                       M, W, Z, LDZ, WORK, RWORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*), Z(LDZ,*)
         CALL CHBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB(1,1), LDAB,
     &                BB(1,1), LDBB, Q(1,1), LDQ, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), RWORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CHBGVX_NAT

      SUBROUTINE ZHBGVX_NAT( JOBZ, RANGE, UPLO, N, KAB, KBB, AB, LDAB,
     &                       BB, LDBB, Q, LDQ, VL, VU, IL, IU, ABSTOL,
     &                       M, W, Z, LDZ, WORK, RWORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, KAB, KBB, LDAB, LDBB, LDQ, LDZ,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), BB(LDBB,*)
         COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*), WORK(*), Z(LDZ,*)
         CALL ZHBGVX( JOBZ, RANGE, UPLO, N, KAB, KBB, AB(1,1), LDAB,
     &                BB(1,1), LDBB, Q(1,1), LDQ, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), RWORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZHBGVX_NAT
!
!-----Natural interface for xSBTRD and xHBTRD
!
      SUBROUTINE SSBTRD_A2Q2W1( VECT, UPLO, N, KD, AB, LDAB, D, E,
     &                          Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), Q(LDQ,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), WORK(*)
         CALL SSBTRD( VECT, UPLO, N, KD, AB(1,1), LDAB, D(1), E(1),
     &                Q(1,1), LDQ, WORK(1), INFO )
      END SUBROUTINE SSBTRD_A2Q2W1

      SUBROUTINE DSBTRD_A2Q2W1( VECT, UPLO, N, KD, AB, LDAB, D, E,
     &                          Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*), Q(LDQ,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), WORK(*)
         CALL DSBTRD( VECT, UPLO, N, KD, AB(1,1), LDAB, D(1), E(1),
     &                Q(1,1), LDQ, WORK(1), INFO )
      END SUBROUTINE DSBTRD_A2Q2W1

      SUBROUTINE CHBTRD_A2Q2W1( VECT, UPLO, N, KD, AB, LDAB, D, E,
     &                          Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), Q(LDQ,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHBTRD( VECT, UPLO, N, KD, AB(1,1), LDAB, D(1), E(1),
     &                Q(1,1), LDQ, WORK(1), INFO )
      END SUBROUTINE CHBTRD_A2Q2W1

      SUBROUTINE ZHBTRD_A2Q2W1( VECT, UPLO, N, KD, AB, LDAB, D, E,
     &                          Q, LDQ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO, VECT
         INTEGER, INTENT(IN) :: KD, LDAB, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*), Q(LDQ,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHBTRD( VECT, UPLO, N, KD, AB(1,1), LDAB, D(1), E(1),
     &                Q(1,1), LDQ, WORK(1), INFO )
      END SUBROUTINE ZHBTRD_A2Q2W1
!
!-----Natural interface for xSPEV and xHPEV
!
      SUBROUTINE SSPEV_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPEV( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &               INFO )
      END SUBROUTINE SSPEV_NAT

      SUBROUTINE DSPEV_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPEV( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &               INFO )
      END SUBROUTINE DSPEV_NAT

      SUBROUTINE CHPEV_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHPEV( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &               RWORK(1), INFO )
      END SUBROUTINE CHPEV_NAT

      SUBROUTINE ZHPEV_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, RWORK,
     &                  INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHPEV( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &               RWORK(1), INFO )
      END SUBROUTINE ZHPEV_NAT
!
!-----Natural interface for xSPEVD and xHPEVD
!
      SUBROUTINE SSPEVD_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPEVD( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSPEVD_NAT

      SUBROUTINE DSPEVD_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPEVD( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSPEVD_NAT

      SUBROUTINE CHPEVD_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                       RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHPEVD( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &                LWORK, RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CHPEVD_NAT

      SUBROUTINE ZHPEVD_NAT( JOBZ, UPLO, N, AP, W, Z, LDZ, WORK, LWORK,
     &                       RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHPEVD( JOBZ, UPLO, N, AP(1), W(1), Z(1,1), LDZ, WORK(1),
     &                LWORK, RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZHPEVD_NAT
!
!-----Natural interface for xSPEVX and xHPEVX
!
      SUBROUTINE SSPEVX_NAT( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPEVX( JOBZ, RANGE, UPLO, N, AP(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE SSPEVX_NAT

      SUBROUTINE DSPEVX_NAT( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPEVX( JOBZ, RANGE, UPLO, N, AP(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE DSPEVX_NAT

      SUBROUTINE CHPEVX_NAT( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, RWORK, IWORK,
     &                       IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHPEVX( JOBZ, RANGE, UPLO, N, AP(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), RWORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CHPEVX_NAT

      SUBROUTINE ZHPEVX_NAT( JOBZ, RANGE, UPLO, N, AP, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, RWORK, IWORK,
     &                       IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHPEVX( JOBZ, RANGE, UPLO, N, AP(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), RWORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZHPEVX_NAT
!
!-----Natural interface for xSPGST and xHPGST
!
      SUBROUTINE SSPGST_A1B1( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BP(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL SSPGST( ITYPE, UPLO, N, AP(1), BP(1), INFO )
      END SUBROUTINE SSPGST_A1B1

      SUBROUTINE DSPGST_A1B1( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: BP(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL DSPGST( ITYPE, UPLO, N, AP(1), BP(1), INFO )
      END SUBROUTINE DSPGST_A1B1

      SUBROUTINE CHPGST_A1B1( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: BP(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL CHPGST( ITYPE, UPLO, N, AP(1), BP(1), INFO )
      END SUBROUTINE CHPGST_A1B1

      SUBROUTINE ZHPGST_A1B1( ITYPE, UPLO, N, AP, BP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: BP(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL ZHPGST( ITYPE, UPLO, N, AP(1), BP(1), INFO )
      END SUBROUTINE ZHPGST_A1B1
!
!-----Natural interface for xSPGV and xHPGV
!
      SUBROUTINE SSPGV_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                      WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPGV( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &               LDZ, WORK(1), INFO )
      END SUBROUTINE SSPGV_NAT

      SUBROUTINE DSPGV_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                      WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPGV( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &               LDZ, WORK(1), INFO )
      END SUBROUTINE DSPGV_NAT

      SUBROUTINE CHPGV_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                      WORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHPGV( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &               LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE CHPGV_NAT

      SUBROUTINE ZHPGV_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                      WORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, LDZ
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHPGV( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &               LDZ, WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZHPGV_NAT
!
!-----Natural interface for xSPGVD and xHPGVD
!
      SUBROUTINE SSPGVD_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPGVD( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSPGVD_NAT

      SUBROUTINE DSPGVD_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPGVD( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSPGVD_NAT

      SUBROUTINE CHPGVD_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT):: WORK(*), Z(LDZ,*)
         CALL CHPGVD( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE CHPGVD_NAT

      SUBROUTINE ZHPGVD_NAT( ITYPE, JOBZ, UPLO, N, AP, BP, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT):: WORK(*), Z(LDZ,*)
         CALL ZHPGVD( ITYPE, JOBZ, UPLO, N, AP(1), BP(1), W(1), Z(1,1),
     &                LDZ, WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE ZHPGVD_NAT
!
!-----Natural interface for xSPGVX and xHPGVX
!
      SUBROUTINE SSPGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL,
     &                       VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP(1), BP(1), VL, VU,
     &                IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE SSPGVX_NAT

      SUBROUTINE DSPGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL,
     &                       VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: AP(*), BP(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP(1), BP(1), VL, VU,
     &                IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1),
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE DSPGVX_NAT

      SUBROUTINE CHPGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL,
     &                       VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP(1), BP(1), VL, VU,
     &                IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1),
     &                RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CHPGVX_NAT

      SUBROUTINE ZHPGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL,
     &                       VU, IL, IU, ABSTOL, M, W, Z, LDZ, WORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), BP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHPGVX( ITYPE, JOBZ, RANGE, UPLO, N, AP(1), BP(1), VL, VU,
     &                IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1),
     &                RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZHPGVX_NAT
!
!-----Natural interface for xSPSV and xHPSV
!
      SUBROUTINE SSPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL SSPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE SSPSV_A1I1B2

      SUBROUTINE DSPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL DSPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE DSPSV_A1I1B2

      SUBROUTINE CSPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL CSPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CSPSV_A1I1B2

      SUBROUTINE ZSPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL ZSPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZSPSV_A1I1B2

      SUBROUTINE CHPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL CHPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CHPSV_A1I1B2

      SUBROUTINE ZHPSV_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*), B(LDB,*)
         CALL ZHPSV( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZHPSV_A1I1B2
!
!-----Natural interface for xSPSVX and xHPSVX
!
      SUBROUTINE SSPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: AFP(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SSPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SSPSVX_A1B2W1

      SUBROUTINE DSPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: AP(*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: AFP(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DSPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DSPSVX_A1B2W1

      SUBROUTINE CSPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CSPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CSPSVX_A1B2W1

      SUBROUTINE ZSPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZSPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZSPSVX_A1B2W1

      SUBROUTINE CHPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CHPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE CHPSVX_A1B2W1

      SUBROUTINE ZHPSVX_A1B2W1( FACT, UPLO, N, NRHS, AP, AFP, IPIV, B,
     &                          LDB, X, LDX, RCOND, FERR, BERR, WORK,
     &                          RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: AP(*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AFP(*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZHPSVX( FACT, UPLO, N, NRHS, AP(1), AFP(1), IPIV(1),
     &                B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1), BERR(1),
     &                WORK(1), RWORK(1), INFO )
      END SUBROUTINE ZHPSVX_A1B2W1
!
!-----Natural interface for xSPTRD
!
      SUBROUTINE SSPTRD_A1D1T1( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAU(*)
         CALL SSPTRD( UPLO, N, AP(1), D(1), E(1), TAU(1), INFO )
      END SUBROUTINE SSPTRD_A1D1T1

      SUBROUTINE DSPTRD_A1D1T1( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AP(*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAU(*)
         CALL DSPTRD( UPLO, N, AP(1), D(1), E(1), TAU(1), INFO )
      END SUBROUTINE DSPTRD_A1D1T1

      SUBROUTINE CHPTRD_A1D1T1( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL CHPTRD( UPLO, N, AP(1), D(1), E(1), TAU(1), INFO )
      END SUBROUTINE CHPTRD_A1D1T1

      SUBROUTINE ZHPTRD_A1D1T1( UPLO, N, AP, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL ZHPTRD( UPLO, N, AP(1), D(1), E(1), TAU(1), INFO )
      END SUBROUTINE ZHPTRD_A1D1T1
!
!-----Natural interface for xSPTRF and xHPTRF
!
      SUBROUTINE SSPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL SSPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE SSPTRF_A1I1

      SUBROUTINE DSPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: AP(*)
         CALL DSPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE DSPTRF_A1I1

      SUBROUTINE CSPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL CSPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE CSPTRF_A1I1

      SUBROUTINE ZSPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL ZSPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE ZSPTRF_A1I1

      SUBROUTINE CHPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL CHPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE CHPTRF_A1I1

      SUBROUTINE ZHPTRF_A1I1( UPLO, N, AP, IPIV, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: AP(*)
         CALL ZHPTRF( UPLO, N, AP(1), IPIV(1), INFO )
      END SUBROUTINE ZHPTRF_A1I1
!
!-----Natural interface for xSPTRS and xHETRS
!
      SUBROUTINE SSPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE SSPTRS_A1I1B2

      SUBROUTINE DSPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE DSPTRS_A1I1B2

      SUBROUTINE CSPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CSPTRS_A1I1B2

      SUBROUTINE ZSPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZSPTRS_A1I1B2

      SUBROUTINE CHPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CHPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE CHPTRS_A1I1B2

      SUBROUTINE ZHPTRS_A1I1B2( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZHPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB, INFO )
      END SUBROUTINE ZHPTRS_A1I1B2
!
!-----Natural interface for xSPTRS and xHETRS with one RHS
!
      SUBROUTINE SSPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE SSPTRS_A1I1B1

      SUBROUTINE DSPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE DSPTRS_A1I1B1

      SUBROUTINE CSPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE CSPTRS_A1I1B1

      SUBROUTINE ZSPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZSPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE ZSPTRS_A1I1B1

      SUBROUTINE CHPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CHPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE CHPTRS_A1I1B1

      SUBROUTINE ZHPTRS_A1I1B1( UPLO, N, NRHS, AP, IPIV, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZHPTRS( UPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB, INFO )
      END SUBROUTINE ZHPTRS_A1I1B1
!
!-----Natural interface for xSTEBZ
!
      SUBROUTINE SSTEBZ_D1I1( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL,
     &                        D, E, M, NSPLIT, W, IBLOCK, ISPLIT, WORK,
     &                        IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: ORDER, RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK(*), ISPLIT(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL SSTEBZ( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL, D(1),
     &                E(1), M, NSPLIT, W(1), IBLOCK(1), ISPLIT(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SSTEBZ_D1I1

      SUBROUTINE DSTEBZ_D1I1( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL,
     &                        D, E, M, NSPLIT, W, IBLOCK, ISPLIT, WORK,
     &                        IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ORDER, RANGE
         INTEGER, INTENT(IN) :: IL, IU, N
         INTEGER, INTENT(OUT) :: INFO, M, NSPLIT
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IBLOCK(*), ISPLIT(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL DSTEBZ( RANGE, ORDER, N, VL, VU, IL, IU, ABSTOL, D(1),
     &                E(1), M, NSPLIT, W(1), IBLOCK(1), ISPLIT(1),
     &                WORK(1), IWORK(1), INFO )
      END SUBROUTINE DSTEBZ_D1I1
!
!-----Natural interface for xSTEDC
!
      SUBROUTINE SSTEDC_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, LWORK,
     &                          IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SSTEDC( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSTEDC_D1Z2W1

      SUBROUTINE DSTEDC_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, LWORK,
     &                          IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DSTEDC( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSTEDC_D1Z2W1

      SUBROUTINE CSTEDC_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, LWORK,
     &                          RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CSTEDC( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CSTEDC_D1Z2W1

      SUBROUTINE ZSTEDC_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, LWORK,
     &                          RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZSTEDC( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZSTEDC_D1Z2W1
!
!-----Natural interface for xSTEGR
!
      SUBROUTINE SSTEGR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: W(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SSTEGR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSTEGR_NAT

      SUBROUTINE DSTEGR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: W(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DSTEGR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSTEGR_NAT

      SUBROUTINE CSTEGR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: W(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL CSTEGR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CSTEGR_NAT

      SUBROUTINE ZSTEGR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                   ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                   IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: W(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL ZSTEGR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZSTEGR_NAT
!
!-----Natural interface for xSTEIN
!
      SUBROUTINE SSTEIN_D1Z2W1( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ,
     &                          WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*), W(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SSTEIN( N, D(1), E(1), M, W(1), IBLOCK(1), ISPLIT(1),
     &                Z(1,1), LDZ, WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE SSTEIN_D1Z2W1

      SUBROUTINE DSTEIN_D1Z2W1( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ,
     &                          WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*), W(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DSTEIN( N, D(1), E(1), M, W(1), IBLOCK(1), ISPLIT(1),
     &                Z(1,1), LDZ, WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE DSTEIN_D1Z2W1

      SUBROUTINE CSTEIN_D1Z2W1( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ,
     &                          WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*), W(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL CSTEIN( N, D(1), E(1), M, W(1), IBLOCK(1), ISPLIT(1),
     &                Z(1,1), LDZ, WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CSTEIN_D1Z2W1

      SUBROUTINE ZSTEIN_D1Z2W1( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ,
     &                          WORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDZ, M, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IBLOCK(*), ISPLIT(*)
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(IN) :: D(*), E(*), W(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
         CALL ZSTEIN( N, D(1), E(1), M, W(1), IBLOCK(1), ISPLIT(1),
     &                Z(1,1), LDZ, WORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZSTEIN_D1Z2W1
!
!-----Natural interface for xSTEQR
!
      SUBROUTINE SSTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SSTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE SSTEQR_D1Z2W1

      SUBROUTINE DSTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DSTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE DSTEQR_D1Z2W1

      SUBROUTINE CSTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         CALL CSTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE CSTEQR_D1Z2W1

      SUBROUTINE ZSTEQR_D1Z2W1( COMPZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) ::  COMPZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
         CALL ZSTEQR( COMPZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE ZSTEQR_D1Z2W1
!
!-----Natural interface for xSTERF
!
      SUBROUTINE SSTERF_D1E1( N, D, E, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         CALL SSTERF( N, D(1), E(1), INFO )
      END SUBROUTINE SSTERF_D1E1

      SUBROUTINE DSTERF_D1E1( N, D, E, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         CALL DSTERF( N, D(1), E(1), INFO )
      END SUBROUTINE DSTERF_D1E1
!
!-----Natural interface for xSTEV
!
      SUBROUTINE SSTEV_NAT( JOBZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SSTEV( JOBZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE SSTEV_NAT

      SUBROUTINE DSTEV_NAT( JOBZ, N, D, E, Z, LDZ, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DSTEV( JOBZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), INFO )
      END SUBROUTINE DSTEV_NAT
!
!-----Natural interface for xSTEVD
!
      SUBROUTINE SSTEVD_NAT( JOBZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                       LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL SSTEVD( JOBZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSTEVD_NAT

      SUBROUTINE DSTEVD_NAT( JOBZ, N, D, E, Z, LDZ, WORK, LWORK, IWORK,
     &                       LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ
         INTEGER, INTENT(IN) :: LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL DSTEVD( JOBZ, N, D(1), E(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSTEVD_NAT
!
!-----Natural interface for xSTEVR
!
      SUBROUTINE SSTEVR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: N, IL, IU, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSTEVR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSTEVR_NAT

      SUBROUTINE DSTEVR_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: N, IL, IU, LDZ, LIWORK, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSTEVR( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSTEVR_NAT
!
!-----Natural interface for xSTEVX
!
      SUBROUTINE SSTEVX_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSTEVX( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE SSTEVX_NAT

      SUBROUTINE DSTEVX_NAT( JOBZ, RANGE, N, D, E, VL, VU, IL, IU,
     &                       ABSTOL, M, W, Z, LDZ, WORK, IWORK, IFAIL,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE
         INTEGER, INTENT(IN) :: IL, IU, LDZ, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSTEVX( JOBZ, RANGE, N, D(1), E(1), VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), IWORK(1),
     &                IFAIL(1), INFO )
      END SUBROUTINE DSTEVX_NAT
!
!-----Natural interface for xSYEV and xHEEV
!
      SUBROUTINE SSYEV_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, INFO)
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL SSYEV( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &               INFO )
      END SUBROUTINE SSYEV_NAT

      SUBROUTINE DSYEV_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, INFO)
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL DSYEV( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &               INFO )
      END SUBROUTINE DSYEV_NAT

      SUBROUTINE CHEEV_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHEEV( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &               RWORK(1), INFO )
      END SUBROUTINE CHEEV_NAT

      SUBROUTINE ZHEEV_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                      RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHEEV( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &               RWORK(1), INFO )
      END SUBROUTINE ZHEEV_NAT
!
!-----Natural interface for xSYEVD and xHEEVD
!
      SUBROUTINE SSYEVD_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL SSYEVD( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSYEVD_NAT

      SUBROUTINE DSYEVD_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                       IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL DSYEVD( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSYEVD_NAT

      SUBROUTINE CHEEVD_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                       RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHEEVD( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &                RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CHEEVD_NAT

      SUBROUTINE ZHEEVD_NAT( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK,
     &                       RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: LDA, LIWORK, LRWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHEEVD( JOBZ, UPLO, N, A(1,1), LDA, W(1), WORK(1), LWORK,
     &                RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZHEEVD_NAT
!
!-----Natural interface for xSYEVR and xHEEVR
!
      SUBROUTINE SSYEVR_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK,
     &                       LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSYEVR( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE  SSYEVR_NAT

      SUBROUTINE DSYEVR_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK,
     &                       LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSYEVR( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE  DSYEVR_NAT

      SUBROUTINE CHEEVR_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK,
     &                       LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHEEVR( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE CHEEVR_NAT

      SUBROUTINE ZHEEVR_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, ISUPPZ, WORK,
     &                       LWORK, RWORK, LRWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: ISUPPZ(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHEEVR( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, ISUPPZ(1), WORK(1),
     &                LWORK, RWORK(1), LRWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZHEEVR_NAT
!
!-----Natural interface for xSYEVX and xHEEVX
!
      SUBROUTINE SSYEVX_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, WORK, LWORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSYEVX( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE SSYEVX_NAT

      SUBROUTINE DSYEVX_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, WORK, LWORK,
     &                       IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSYEVX( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE DSYEVX_NAT

      SUBROUTINE CHEEVX_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, WORK, LWORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHEEVX( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE CHEEVX_NAT

      SUBROUTINE ZHEEVX_NAT( JOBZ, RANGE, UPLO, N, A, LDA, VL, VU, IL,
     &                       IU, ABSTOL, M, W, Z, LDZ, WORK, LWORK,
     &                       RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, IU, LDA, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHEEVX( JOBZ, RANGE, UPLO, N, A(1,1), LDA, VL, VU, IL, IU,
     &                ABSTOL, M, W(1), Z(1,1), LDZ, WORK(1), LWORK,
     &                RWORK(1), IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE ZHEEVX_NAT
!
!-----Natural interface for xSYGST and xHEGST
!
      SUBROUTINE SSYGST_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B(LDB,*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SSYGST( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE SSYGST_A2B2

      SUBROUTINE DSYGST_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B(LDB,*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL DSYGST( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE DSYGST_A2B2

      SUBROUTINE CHEGST_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CHEGST( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE CHEGST_A2B2

      SUBROUTINE ZHEGST_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL ZHEGST( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE ZHEGST_A2B2
!
!-----Natural interface for xSYGV and xHEGV
!
      SUBROUTINE SSYGV_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                      WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL SSYGV( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &               W(1), WORK(1), LWORK, INFO )
      END SUBROUTINE SSYGV_NAT

      SUBROUTINE DSYGV_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                      WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL DSYGV( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &               W(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DSYGV_NAT

      SUBROUTINE CHEGV_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                      WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHEGV( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &               W(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CHEGV_NAT

      SUBROUTINE ZHEGV_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                      WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHEGV( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &               W(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZHEGV_NAT
!
!-----Natural interface for xSYGVD and xHEGVD
!
      SUBROUTINE SSYGVD_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL SSYGVD( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &                W(1), WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE SSYGVD_NAT

      SUBROUTINE DSYGVD_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                       WORK, LWORK, IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL DSYGVD( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &                W(1), WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DSYGVD_NAT

      SUBROUTINE CHEGVD_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHEGVD( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &                W(1), WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE CHEGVD_NAT

      SUBROUTINE ZHEGVD_NAT( ITYPE, JOBZ, UPLO, N, A, LDA, B, LDB, W,
     &                       WORK, LWORK, RWORK, LRWORK, IWORK, LIWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, LIWORK, LRWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHEGVD( ITYPE, JOBZ, UPLO, N, A(1,1), LDA, B(1,1), LDB,
     &                W(1), WORK(1), LWORK, RWORK(1), LRWORK, IWORK(1),
     &                LIWORK, INFO )
      END SUBROUTINE ZHEGVD_NAT
!
!-----Natural interface for xSYGVX and xHEGVX
!
      SUBROUTINE SSYGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B,
     &                       LDB, VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, IL, IU, LDZ, LDA, LDB, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL SSYGVX( ITYPE, JOBZ, RANGE, UPLO, N, A(1,1), LDA, B(1,1),
     &                LDB, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), LWORK, IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE SSYGVX_NAT

      SUBROUTINE DSYGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B,
     &                       LDB, VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ,
     &                       WORK, LWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: ITYPE, N, IL, IU, LDZ, LDA, LDB, LWORK
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: W(*), WORK(*), Z(LDZ,*)
         CALL DSYGVX( ITYPE, JOBZ, RANGE, UPLO, N, A(1,1), LDA, B(1,1),
     &                LDB, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), LWORK, IWORK(1), IFAIL(1), INFO )
      END SUBROUTINE DSYGVX_NAT

      SUBROUTINE CHEGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B,
     &                       LDB, VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDA, LDB, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL CHEGVX( ITYPE, JOBZ, RANGE, UPLO, N, A(1,1), LDA, B(1,1),
     &                LDB, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), LWORK, RWORK(1), IWORK(1), IFAIL(1),
     &                INFO )
      END SUBROUTINE CHEGVX_NAT

      SUBROUTINE ZHEGVX_NAT( ITYPE, JOBZ, RANGE, UPLO, N, A, LDA, B,
     &                       LDB, VL, VU, IL, IU, ABSTOL, M, W, Z, LDZ,
     &                       WORK, LWORK, RWORK, IWORK, IFAIL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBZ, RANGE, UPLO
         INTEGER, INTENT(IN) :: IL, ITYPE, IU, LDA, LDB, LDZ, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(IN) :: ABSTOL, VL, VU
         INTEGER, INTENT(OUT) :: IFAIL(*), IWORK(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), W(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), Z(LDZ,*)
         CALL ZHEGVX( ITYPE, JOBZ, RANGE, UPLO, N, A(1,1), LDA, B(1,1),
     &                LDB, VL, VU, IL, IU, ABSTOL, M, W(1), Z(1,1), LDZ,
     &                WORK(1), LWORK, RWORK(1), IWORK(1), IFAIL(1),
     &                INFO )
      END SUBROUTINE ZHEGVX_NAT
!
!-----Natural interface for xSYSV and xHESV
!
      SUBROUTINE SSYSV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SSYSV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE SSYSV_A2B2W1

      SUBROUTINE DSYSV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DSYSV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE DSYSV_A2B2W1

      SUBROUTINE CSYSV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CSYSV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE CSYSV_A2B2W1

      SUBROUTINE ZSYSV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZSYSV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE ZSYSV_A2B2W1

      SUBROUTINE CHESV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHESV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE CHESV_A2B2W1

      SUBROUTINE ZHESV_A2B2W1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                         WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHESV( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &               WORK(1), LWORK, INFO )
      END SUBROUTINE ZHESV_A2B2W1
!
!-----Natural interface for xSYSVX and xHESVX
!
      SUBROUTINE SSYSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL SSYSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE SSYSVX_A2B2W1

      SUBROUTINE DSYSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), WORK(*), X(LDX,*)
         CALL DSYSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DSYSVX_A2B2W1

      SUBROUTINE CSYSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CSYSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CSYSVX_A2B2W1

      SUBROUTINE ZSYSVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZSYSVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZSYSVX_A2B2W1

      SUBROUTINE CHESVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL CHESVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE CHESVX_A2B2W1

      SUBROUTINE ZHESVX_A2B2W1( FACT, UPLO, N, NRHS, A, LDA, AF, LDAF,
     &                          IPIV, B, LDB, X, LDX, RCOND, FERR, BERR,
     &                          WORK, LWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: FACT, UPLO
         INTEGER, INTENT(IN) :: LDA, LDAF, LDB, LDX, LWORK, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: RCOND
         INTEGER, INTENT(INOUT) :: IPIV(*)
         REAL(WP), INTENT(OUT) :: BERR(*), FERR(*), RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*), X(LDX,*)
         CALL ZHESVX( FACT, UPLO, N, NRHS, A(1,1), LDA, AF(1,1), LDAF,
     &                IPIV(1), B(1,1), LDB, X(1,1), LDX, RCOND, FERR(1),
     &                BERR(1), WORK(1), LWORK, RWORK(1), INFO )
      END SUBROUTINE ZHESVX_A2B2W1
!
!-----Natural interface for xSYTRD and xHETRD
!
      SUBROUTINE SSYTRD_NAT( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAU(*), WORK(*)
         CALL SSYTRD( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE SSYTRD_NAT

      SUBROUTINE DSYTRD_NAT( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAU(*), WORK(*)
         CALL DSYTRD( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE DSYTRD_NAT

      SUBROUTINE CHETRD_NAT( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK,
     &                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CHETRD( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE CHETRD_NAT

      SUBROUTINE ZHETRD_NAT( UPLO, N, A, LDA, D, E, TAU, WORK, LWORK,
     &                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZHETRD( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), WORK(1),
     &                LWORK, INFO )
      END SUBROUTINE ZHETRD_NAT
!
!-----Natural interface for xSYTRF and xHETRF
!
      SUBROUTINE SSYTRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SSYTRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE SSYTRF_A2I1W1

      SUBROUTINE DSYTRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DSYTRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DSYTRF_A2I1W1

      SUBROUTINE CSYTRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CSYTRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CSYTRF_A2I1W1

      SUBROUTINE ZSYTRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZSYTRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZSYTRF_A2I1W1

      SUBROUTINE CHETRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CHETRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE CHETRF_A2I1W1

      SUBROUTINE ZHETRF_A2I1W1( UPLO, N, A, LDA, IPIV, WORK, LWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LWORK, N
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZHETRF( UPLO, N, A(1,1), LDA, IPIV(1), WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE ZHETRF_A2I1W1
!
!-----Natural interface for xSYTRS and xHETRS
!
      SUBROUTINE SSYTRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE SSYTRS_A2I1B2

      SUBROUTINE DSYTRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE DSYTRS_A2I1B2

      SUBROUTINE CSYTRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE CSYTRS_A2I1B2

      SUBROUTINE ZSYTRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE ZSYTRS_A2I1B2

      SUBROUTINE CHETRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CHETRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE CHETRS_A2I1B2

      SUBROUTINE ZHETRS_A2I1B2( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZHETRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB,
     &                INFO )
      END SUBROUTINE ZHETRS_A2I1B2
!
!-----Natural interface for xSYTRS and xHETRS with one RHS
!
      SUBROUTINE SSYTRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE SSYTRS_A2I1B1

      SUBROUTINE DSYTRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE DSYTRS_A2I1B1

      SUBROUTINE CSYTRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE CSYTRS_A2I1B1

      SUBROUTINE ZSYTRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZSYTRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE ZSYTRS_A2I1B1

      SUBROUTINE CHETRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CHETRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE CHETRS_A2I1B1

      SUBROUTINE ZHETRS_A2I1B1( UPLO, N, NRHS, A, LDA, IPIV, B, LDB,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, N, NRHS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZHETRS( UPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB,
     &                INFO )
      END SUBROUTINE ZHETRS_A2I1B1
!
!-----Natural interface for xTGEVC
!
      SUBROUTINE STGEVC_A2B2W1( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL STGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK(1),
     &                INFO )
      END SUBROUTINE STGEVC_A2B2W1

      SUBROUTINE DTGEVC_A2B2W1( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK(1),
     &                INFO )
      END SUBROUTINE DTGEVC_A2B2W1

      SUBROUTINE CTGEVC_A2B2W1( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE CTGEVC_A2B2W1

      SUBROUTINE ZTGEVC_A2B2W1( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK(1),
     &                RWORK(1), INFO )
      END SUBROUTINE ZTGEVC_A2B2W1
!
!-----Interface for xTGEVC with point interface for WORK/RWORK only
!
      SUBROUTINE STGEVC_A2B2W0( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK
         CALL STGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK,
     &                INFO )
      END SUBROUTINE STGEVC_A2B2W0

      SUBROUTINE DTGEVC_A2B2W0( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK
         CALL DTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK,
     &                INFO )
      END SUBROUTINE DTGEVC_A2B2W0

      SUBROUTINE CTGEVC_A2B2W0( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL CTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK,
     &                RWORK, INFO )
      END SUBROUTINE CTGEVC_A2B2W0

      SUBROUTINE ZTGEVC_A2B2W0( SIDE, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL ZTGEVC( SIDE, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, MM, M, WORK,
     &                RWORK, INFO )
      END SUBROUTINE ZTGEVC_A2B2W0
!
!-----Natural interface for xTGEXC
!
      SUBROUTINE STGEXC_A2B2Q2( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ,
     &                          Z, LDZ, IFST, ILST, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL STGEXC( WANTQ, WANTZ, N, A(1,1), LDA, B(1,1), LDB, Q(1,1),
     &                LDQ, Z(1,1), LDZ, IFST, ILST, WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE STGEXC_A2B2Q2

      SUBROUTINE DTGEXC_A2B2Q2( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ,
     &                          Z, LDZ, IFST, ILST, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, LWORK, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DTGEXC( WANTQ, WANTZ, N, A(1,1), LDA, B(1,1), LDB, Q(1,1),
     &                LDQ, Z(1,1), LDZ, IFST, ILST, WORK(1), LWORK,
     &                INFO )
      END SUBROUTINE DTGEXC_A2B2Q2

      SUBROUTINE CTGEXC_A2B2Q2( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ,
     &                          Z, LDZ, IFST, ILST, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         CALL CTGEXC( WANTQ, WANTZ, N, A(1,1), LDA, B(1,1), LDB, Q(1,1),
     &                LDQ, Z(1,1), LDZ, IFST, ILST, INFO )
      END SUBROUTINE CTGEXC_A2B2Q2

      SUBROUTINE ZTGEXC_A2B2Q2( WANTQ, WANTZ, N, A, LDA, B, LDB, Q, LDQ,
     &                          Z, LDZ, IFST, ILST, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: LDA, LDB, LDQ, LDZ, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         CALL ZTGEXC( WANTQ, WANTZ, N, A(1,1), LDA, B(1,1), LDB, Q(1,1),
     &                LDQ, Z(1,1), LDZ, IFST, ILST, INFO )
      END SUBROUTINE ZTGEXC_A2B2Q2
!
!-----Natural interface for xTGSEN
!
      SUBROUTINE STGSEN_A2B2W1( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, M, PL, PR, DIF, WORK, LWORK,
     &                          IWORK, LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), DIF(*),
     &                            WORK(*)
         CALL STGSEN( IJOB, WANTQ, WANTZ, SELECT(1), N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, M, PL, PR, DIF(1),
     &                WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE STGSEN_A2B2W1

      SUBROUTINE DTGSEN_A2B2W1( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA,
     &                          B, LDB, ALPHAR, ALPHAI, BETA, Q, LDQ,
     &                          Z, LDZ, M, PL, PR, DIF, WORK, LWORK,
     &                          IWORK, LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(*), ALPHAR(*), BETA(*), DIF(*),
     &                            WORK(*)
         CALL DTGSEN( IJOB, WANTQ, WANTZ, SELECT(1), N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     &                Q(1,1), LDQ, Z(1,1), LDZ, M, PL, PR, DIF(1),
     &                WORK(1), LWORK, IWORK(1), LIWORK, INFO )
      END SUBROUTINE DTGSEN_A2B2W1

      SUBROUTINE CTGSEN_A2B2W1( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ, M,
     &                          PL, PR, DIF, WORK, LWORK, IWORK, LIWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: DIF(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL CTGSEN( IJOB, WANTQ, WANTZ, SELECT(1), N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, M, PL, PR, DIF(1), WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE CTGSEN_A2B2W1

      SUBROUTINE ZTGSEN_A2B2W1( IJOB, WANTQ, WANTZ, SELECT, N, A, LDA,
     &                          B, LDB, ALPHA, BETA, Q, LDQ, Z, LDZ, M,
     &                          PL, PR, DIF, WORK, LWORK, IWORK, LIWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTQ, WANTZ
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDQ, LDZ, LIWORK, LWORK,
     &                          N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: PL, PR
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: DIF(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL ZTGSEN( IJOB, WANTQ, WANTZ, SELECT(1), N, A(1,1), LDA,
     &                B(1,1), LDB, ALPHA(1), BETA(1), Q(1,1), LDQ,
     &                Z(1,1), LDZ, M, PL, PR, DIF(1), WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE ZTGSEN_A2B2W1
!
!-----Natural interface for xTGSJA
!
      SUBROUTINE STGSJA_A2B2W1( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA,
     &                          B, LDB, TOLA, TOLB, ALPHA, BETA, U, LDU,
     &                          V, LDV, Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              U(LDU,*), V(LDV,*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL STGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A(1,1), LDA,
     &                B(1,1), LDB, TOLA, TOLB, ALPHA(1), BETA(1),
     &                U(1,1), LDU, V(1,1), LDV, Q(1,1), LDQ, WORK(1),
     &                NCYCLE, INFO )
      END SUBROUTINE STGSJA_A2B2W1

      SUBROUTINE DTGSJA_A2B2W1( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA,
     &                          B, LDB, TOLA, TOLB, ALPHA, BETA, U, LDU,
     &                          V, LDV, Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                              U(LDU,*), V(LDV,*)
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*), WORK(*)
         CALL DTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A(1,1), LDA,
     &                B(1,1), LDB, TOLA, TOLB, ALPHA(1), BETA(1),
     &                U(1,1), LDU, V(1,1), LDV, Q(1,1), LDQ, WORK(1),
     &                NCYCLE, INFO )
      END SUBROUTINE DTGSJA_A2B2W1

      SUBROUTINE CTGSJA_A2B2W1( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA,
     &                          B, LDB, TOLA, TOLB, ALPHA, BETA, U, LDU,
     &                          V, LDV, Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 U(LDU,*), V(LDV,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A(1,1), LDA,
     &                B(1,1), LDB, TOLA, TOLB, ALPHA(1), BETA(1),
     &                U(1,1), LDU, V(1,1), LDV, Q(1,1), LDQ, WORK(1),
     &                NCYCLE, INFO )
      END SUBROUTINE CTGSJA_A2B2W1

      SUBROUTINE ZTGSJA_A2B2W1( JOBU, JOBV, JOBQ, M, P, N, K, L, A, LDA,
     &                          B, LDB, TOLA, TOLB, ALPHA, BETA, U, LDU,
     &                          V, LDV, Q, LDQ, WORK, NCYCLE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: JOBQ, JOBU, JOBV
         INTEGER, INTENT(IN) :: K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
         INTEGER, INTENT(OUT) :: INFO, NCYCLE
         REAL(WP), INTENT(IN) :: TOLA, TOLB
         REAL(WP), INTENT(OUT) :: ALPHA(*), BETA(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*), Q(LDQ,*),
     &                                 U(LDU,*), V(LDV,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZTGSJA( JOBU, JOBV, JOBQ, M, P, N, K, L, A(1,1), LDA,
     &                B(1,1), LDB, TOLA, TOLB, ALPHA(1), BETA(1),
     &                U(1,1), LDU, V(1,1), LDV, Q(1,1), LDQ, WORK(1),
     &                NCYCLE, INFO )
      END SUBROUTINE ZTGSJA_A2B2W1
!
!-----Natural interface for xTGSNA
!
      SUBROUTINE STGSNA_A2B2W1( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, S, DIF, MM, M, WORK,
     &                          LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), VL(LDVL,*),
     &                           VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: DIF(*), S(*), WORK(*)
         CALL STGSNA( JOB, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, S(1), DIF(1),
     &                MM, M, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE STGSNA_A2B2W1

      SUBROUTINE DTGSNA_A2B2W1( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, S, DIF, MM, M, WORK,
     &                          LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), VL(LDVL,*),
     &                           VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: DIF(*), S(*), WORK(*)
         CALL DTGSNA( JOB, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, S(1), DIF(1),
     &                MM, M, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DTGSNA_A2B2W1

      SUBROUTINE CTGSNA_A2B2W1( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, S, DIF, MM, M, WORK,
     &                          LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: DIF(*), S(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), VL(LDVL,*),
     &                              VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CTGSNA( JOB, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, S(1), DIF(1),
     &                MM, M, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE CTGSNA_A2B2W1

      SUBROUTINE ZTGSNA_A2B2W1( JOB, HOWMNY, SELECT, N, A, LDA, B, LDB,
     &                          VL, LDVL, VR, LDVR, S, DIF, MM, M, WORK,
     &                          LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDA, LDB, LDVL, LDVR, LWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(OUT) :: DIF(*), S(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), VL(LDVL,*),
     &                              VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZTGSNA( JOB, HOWMNY, SELECT(1), N, A(1,1), LDA, B(1,1),
     &                LDB, VL(1,1), LDVL, VR(1,1), LDVR, S(1), DIF(1),
     &                MM, M, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE ZTGSNA_A2B2W1
!
!-----Natural interface for xTGSYL
!
      SUBROUTINE STGSYL_A2B2W1( TRANS, IJOB, M, N, A, LDA, B, LDB,
     &                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     &                          DIF, WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*), E(LDE,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL STGSYL( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     &                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     &                LDF, SCALE, DIF, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE STGSYL_A2B2W1

      SUBROUTINE DTGSYL_A2B2W1( TRANS, IJOB, M, N, A, LDA, B, LDB,
     &                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     &                          DIF, WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*), E(LDE,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DTGSYL( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     &                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     &                LDF, SCALE, DIF, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE DTGSYL_A2B2W1

      SUBROUTINE CTGSYL_A2B2W1( TRANS, IJOB, M, N, A, LDA, B, LDB,
     &                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     &                          DIF, WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*),
     &                              E(LDE,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CTGSYL( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     &                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     &                LDF, SCALE, DIF, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE CTGSYL_A2B2W1

      SUBROUTINE ZTGSYL_A2B2W1( TRANS, IJOB, M, N, A, LDA, B, LDB,
     &                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     &                          DIF, WORK, LWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF,
     &                          LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: DIF, SCALE
         INTEGER, INTENT(OUT) :: IWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*),
     &                              E(LDE,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZTGSYL( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     &                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     &                LDF, SCALE, DIF, WORK(1), LWORK, IWORK(1), INFO )
      END SUBROUTINE ZTGSYL_A2B2W1
!
!-----Natural interface for xTREVC
!
      SUBROUTINE STREVC_T2V2W1( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(IN) :: T(LDT,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL STREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK(1), INFO )
      END SUBROUTINE STREVC_T2V2W1

      SUBROUTINE DTREVC_T2V2W1( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(IN) :: T(LDT,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK(1), INFO )
      END SUBROUTINE DTREVC_T2V2W1

      SUBROUTINE CTREVC_T2V2W1( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK(1), RWORK(1),
     &                INFO )
      END SUBROUTINE CTREVC_T2V2W1

      SUBROUTINE ZTREVC_T2V2W1( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK(1), RWORK(1),
     &                INFO )
      END SUBROUTINE ZTREVC_T2V2W1
!
!-----Interface for xTREVC with point interface for WORK/RWORK only
!
      SUBROUTINE STREVC_T2V2W0( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(IN) :: T(LDT,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK
         CALL STREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK, INFO )
      END SUBROUTINE STREVC_T2V2W0

      SUBROUTINE DTREVC_T2V2W0( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(IN) :: T(LDT,*)
         REAL(WP), INTENT(INOUT) :: VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: WORK
         CALL DTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK, INFO )
      END SUBROUTINE DTREVC_T2V2W0

      SUBROUTINE CTREVC_T2V2W0( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL CTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK, RWORK, INFO )
      END SUBROUTINE CTREVC_T2V2W0

      SUBROUTINE ZTREVC_T2V2W0( SIDE, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, MM, M, WORK, RWORK,
     &                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, SIDE
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(INOUT) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL ZTREVC( SIDE, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, MM, M, WORK, RWORK, INFO )
      END SUBROUTINE ZTREVC_T2V2W0
!
!-----Natural interface for xTREXC
!
      SUBROUTINE STREXC_T2Q2W1( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST,
     &                          WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: LDQ, LDT, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL STREXC( COMPQ, N, T(1,1), LDT, Q(1,1), LDQ, IFST, ILST,
     &                WORK(1), INFO )
      END SUBROUTINE STREXC_T2Q2W1

      SUBROUTINE DTREXC_T2Q2W1( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST,
     &                          WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: LDQ, LDT, N
         INTEGER, INTENT(INOUT) :: IFST, ILST
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DTREXC( COMPQ, N, T(1,1), LDT, Q(1,1), LDQ, IFST, ILST,
     &                WORK(1), INFO )
      END SUBROUTINE DTREXC_T2Q2W1

      SUBROUTINE CTREXC_T2Q2( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST,
     &                        INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: IFST, ILST, LDQ, LDT, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         CALL CTREXC( COMPQ, N, T(1,1), LDT, Q(1,1), LDQ, IFST, ILST,
     &                INFO )
      END SUBROUTINE CTREXC_T2Q2

      SUBROUTINE ZTREXC_T2Q2( COMPQ, N, T, LDT, Q, LDQ, IFST, ILST,
     &                        INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ
         INTEGER, INTENT(IN) :: IFST, ILST, LDQ, LDT, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         CALL ZTREXC( COMPQ, N, T(1,1), LDT, Q(1,1), LDQ, IFST, ILST,
     &                INFO )
      END SUBROUTINE ZTREXC_T2Q2
!
!-----Natural interface for xTRSEN
!
      SUBROUTINE STRSEN_T2Q2W1( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          WR, WI, M, S, SEP, WORK, LWORK, IWORK,
     &                          LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WI(*), WORK(*), WR(*)
         CALL STRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, WR(1), WI(1), M, S, SEP, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE STRSEN_T2Q2W1

      SUBROUTINE DTRSEN_T2Q2W1( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          WR, WI, M, S, SEP, WORK, LWORK, IWORK,
     &                          LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WI(*), WORK(*), WR(*)
         CALL DTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, WR(1), WI(1), M, S, SEP, WORK(1), LWORK,
     &                IWORK(1), LIWORK, INFO )
      END SUBROUTINE DTRSEN_T2Q2W1

      SUBROUTINE CTRSEN_T2Q2W1( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          W, M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         COMPLEX(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL CTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, W(1), M, S, SEP, WORK(1), LWORK, INFO )
      END SUBROUTINE CTRSEN_T2Q2W1

      SUBROUTINE ZTRSEN_T2Q2W1( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          W, M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         COMPLEX(WP), INTENT(OUT) :: W(*), WORK(*)
         CALL ZTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, W(1), M, S, SEP, WORK(1), LWORK, INFO )
      END SUBROUTINE ZTRSEN_T2Q2W1
!
!-----Interface for xTRSEN with point interface for WORK/IWORK only
!
      SUBROUTINE STRSEN_T2Q2W0( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          WR, WI, M, S, SEP, WORK, LWORK, IWORK,
     &                          LIWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WI(*), WORK, WR(*)
         CALL STRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, WR(1), WI(1), M, S, SEP, WORK, LWORK,
     &                IWORK, LIWORK, INFO )
      END SUBROUTINE STRSEN_T2Q2W0

      SUBROUTINE DTRSEN_T2Q2W0( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          WR, WI, M, S, SEP, WORK, LWORK, IWORK,
     &                          LIWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LIWORK, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         REAL(WP), INTENT(OUT) :: WI(*), WORK, WR(*)
         CALL DTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, WR(1), WI(1), M, S, SEP, WORK, LWORK,
     &                IWORK, LIWORK, INFO )
      END SUBROUTINE DTRSEN_T2Q2W0

      SUBROUTINE CTRSEN_T2Q2W0( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          W, M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         COMPLEX(WP), INTENT(OUT) :: W(*), WORK
         CALL CTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, W(1), M, S, SEP, WORK, LWORK, INFO )
      END SUBROUTINE CTRSEN_T2Q2W0

      SUBROUTINE ZTRSEN_T2Q2W0( JOB, COMPQ, SELECT, N, T, LDT, Q, LDQ,
     &                          W, M, S, SEP, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: COMPQ, JOB
         INTEGER, INTENT(IN) :: LDQ, LDT, LWORK, N
         INTEGER, INTENT(OUT) :: INFO, M
         REAL(WP), INTENT(OUT) :: S, SEP
         LOGICAL, INTENT(IN) :: SELECT(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*), T(LDT,*)
         COMPLEX(WP), INTENT(OUT) :: W(*), WORK
         CALL ZTRSEN( JOB, COMPQ, SELECT(1), N, T(1,1), LDT, Q(1,1),
     &                LDQ, W(1), M, S, SEP, WORK, LWORK, INFO )
      END SUBROUTINE ZTRSEN_T2Q2W0
!
!-----Natural interface for xTRSNA
!
      SUBROUTINE STRSNA_T2V2W2( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: S(*), SEP(*), WORK(LDWORK,*)
         CALL STRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK(1,1), LDWORK, IWORK(1), INFO )
      END SUBROUTINE STRSNA_T2V2W2

      SUBROUTINE DTRSNA_T2V2W2( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: S(*), SEP(*), WORK(LDWORK,*)
         CALL DTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK(1,1), LDWORK, IWORK(1), INFO )
      END SUBROUTINE DTRSNA_T2V2W2

      SUBROUTINE CTRSNA_T2V2W2( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*), SEP(*)
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL CTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK(1,1), LDWORK, RWORK(1), INFO )
      END SUBROUTINE CTRSNA_T2V2W2

      SUBROUTINE ZTRSNA_T2V2W2( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*), SEP(*)
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL ZTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK(1,1), LDWORK, RWORK(1), INFO )
      END SUBROUTINE ZTRSNA_T2V2W2
!
!-----Interface for xTRSNA with point interface for WORK only
!
      SUBROUTINE STRSNA_T2V2W0( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: S(*), SEP(*), WORK
         CALL STRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK, LDWORK, IWORK(1), INFO )
      END SUBROUTINE STRSNA_T2V2W0

      SUBROUTINE DTRSNA_T2V2W0( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         REAL(WP), INTENT(OUT) :: S(*), SEP(*), WORK
         CALL DTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK, LDWORK, IWORK(1), INFO )
      END SUBROUTINE DTRSNA_T2V2W0

      SUBROUTINE CTRSNA_T2V2W0( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*), SEP(*)
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL CTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK, LDWORK, RWORK(1), INFO )
      END SUBROUTINE CTRSNA_T2V2W0

      SUBROUTINE ZTRSNA_T2V2W0( JOB, HOWMNY, SELECT, N, T, LDT, VL,
     &                          LDVL, VR, LDVR, S, SEP, MM, M, WORK,
     &                          LDWORK, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: HOWMNY, JOB
         INTEGER, INTENT(IN) :: LDT, LDVL, LDVR, LDWORK, MM, N
         INTEGER, INTENT(OUT) :: INFO, M
         LOGICAL, INTENT(IN) :: SELECT(*)
         REAL(WP), INTENT(OUT) :: RWORK(*), S(*), SEP(*)
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), VL(LDVL,*), VR(LDVR,*)
         COMPLEX(WP), INTENT(OUT) :: WORK
         CALL ZTRSNA( JOB, HOWMNY, SELECT(1), N, T(1,1), LDT, VL(1,1),
     &                LDVL, VR(1,1), LDVR, S(1), SEP(1), MM, M,
     &                WORK, LDWORK, RWORK(1), INFO )
      END SUBROUTINE ZTRSNA_T2V2W0
!
!-----Natural interface for xTRSYL
!
      SUBROUTINE STRSYL_A2B2C2( TRANA, TRANB, ISGN, M, N, A, LDA,
     &                          B, LDB, C, LDC, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         CALL STRSYL( TRANA, TRANB, ISGN, M, N, A(1,1), LDA,
     &                B(1,1), LDB, C(1,1), LDC, SCALE, INFO )
      END SUBROUTINE STRSYL_A2B2C2

      SUBROUTINE DTRSYL_A2B2C2( TRANA, TRANB, ISGN, M, N, A, LDA,
     &                          B, LDB, C, LDC, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         CALL DTRSYL( TRANA, TRANB, ISGN, M, N, A(1,1), LDA,
     &                B(1,1), LDB, C(1,1), LDC, SCALE, INFO )
      END SUBROUTINE DTRSYL_A2B2C2

      SUBROUTINE CTRSYL_A2B2C2( TRANA, TRANB, ISGN, M, N, A, LDA,
     &                          B, LDB, C, LDC, SCALE, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         CALL CTRSYL( TRANA, TRANB, ISGN, M, N, A(1,1), LDA,
     &                B(1,1), LDB, C(1,1), LDC, SCALE, INFO )
      END SUBROUTINE CTRSYL_A2B2C2

      SUBROUTINE ZTRSYL_A2B2C2( TRANA, TRANB, ISGN, M, N, A, LDA,
     &                          B, LDB, C, LDC, SCALE, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANA, TRANB
         INTEGER, INTENT(IN) :: ISGN, LDA, LDB, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         CALL ZTRSYL( TRANA, TRANB, ISGN, M, N, A(1,1), LDA,
     &                B(1,1), LDB, C(1,1), LDC, SCALE, INFO )
      END SUBROUTINE ZTRSYL_A2B2C2
!
!-----Natural interface for xTZRQF
!
      SUBROUTINE STZRQF_A2T1( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*)
         CALL STZRQF( M, N, A(1,1), LDA, TAU(1), INFO )
      END SUBROUTINE STZRQF_A2T1

      SUBROUTINE DTZRQF_A2T1( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*)
         CALL DTZRQF( M, N, A(1,1), LDA, TAU(1), INFO )
      END SUBROUTINE DTZRQF_A2T1

      SUBROUTINE CTZRQF_A2T1( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL CTZRQF( M, N, A(1,1), LDA, TAU(1), INFO )
      END SUBROUTINE CTZRQF_A2T1

      SUBROUTINE ZTZRQF_A2T1( M, N, A, LDA, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL ZTZRQF( M, N, A(1,1), LDA, TAU(1), INFO )
      END SUBROUTINE ZTZRQF_A2T1
!
!-----Natural interface for xTZRZF
!
      SUBROUTINE STZRZF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL STZRZF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE STZRZF_A2T1W1

      SUBROUTINE DTZRZF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DTZRZF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE DTZRZF_A2T1W1

      SUBROUTINE CTZRZF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CTZRZF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE CTZRZF_A2T1W1

      SUBROUTINE ZTZRZF_A2T1W1( M, N, A, LDA, TAU, WORK, LWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LWORK, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZTZRZF( M, N, A(1,1), LDA, TAU(1), WORK(1), LWORK, INFO )
      END SUBROUTINE ZTZRZF_A2T1W1

      END MODULE LA_LAPACK
