      MODULE LA_CONSTANTS32
!
!  -- LAPACK module --
!     E. Anderson
!     February 12, 2002
!     04-25-02:  Change SAFMAX to ONE/SAFMIN (eca)
!     07-29-02:  Hard code all computed constants (eca)
!
!  Purpose
!  =======
!
!  LA_CONSTANTS32 defines 32-bit constants for use in LAPACK.
!
      INTEGER, PARAMETER     :: WP = 4
      REAL(WP), PARAMETER    :: ZERO = 0.0_WP
      REAL(WP), PARAMETER    :: HALF = 0.5_WP
      REAL(WP), PARAMETER    :: ONE = 1.0_WP
      REAL(WP), PARAMETER    :: TWO = 2.0_WP
      REAL(WP), PARAMETER    :: THREE = 3.0_WP
      REAL(WP), PARAMETER    :: FOUR = 4.0_WP
      REAL(WP), PARAMETER    :: EIGHT = 8.0_WP
      REAL(WP), PARAMETER    :: TEN = 10.0_WP
      COMPLEX(WP), PARAMETER :: CZERO = ( 0.0_WP, 0.0_WP )
      COMPLEX(WP), PARAMETER :: CHALF = ( 0.5_WP, 0.0_WP )
      COMPLEX(WP), PARAMETER :: CONE = ( 1.0_WP, 0.0_WP )
!eca
!eca  The following definitions are not completely portable so are
!eca  hard-coded below.
!eca
!eca  REAL(WP), PARAMETER    :: EPS = EPSILON( ONE )
!eca  REAL(WP), PARAMETER    :: ULP = EPS*RADIX( ONE )
!eca  REAL(WP), PARAMETER    :: SAFMIN = TINY(ONE)
!eca  REAL(WP), PARAMETER    :: SAFMAX = ONE / SAFMIN
!eca  REAL(WP), PARAMETER    :: SMLNUM = SAFMIN / ULP
!eca  REAL(WP), PARAMETER    :: BIGNUM = ONE / SMLNUM
!eca  REAL(WP), PARAMETER    :: RTMIN = SQRT( SMLNUM )
!eca  REAL(WP), PARAMETER    :: RTMAX = ONE / RTMIN
!
#ifdef _CRAY
#ifdef _CRAYMPP
      REAL(WP), PARAMETER    :: EPS    =  1.192092896E-7_WP
      REAL(WP), PARAMETER    :: ULP    =  2.384185791E-7_WP
      REAL(WP), PARAMETER    :: SAFMIN =  1.175494351E-38_WP
      REAL(WP), PARAMETER    :: SAFMAX =  8.507059173E+37_WP
      REAL(WP), PARAMETER    :: SMLNUM =  4.930380658E-32_WP
      REAL(WP), PARAMETER    :: BIGNUM =  2.02824096E+31_WP
      REAL(WP), PARAMETER    :: RTMIN  =  2.220446049E-16_WP
      REAL(WP), PARAMETER    :: RTMAX  =  4.503599627E+15_WP
#else
      REAL(WP), PARAMETER    :: EPS    =  1.192092895507812E-7_WP
      REAL(WP), PARAMETER    :: ULP    =  2.384185791015625E-7_WP
      REAL(WP), PARAMETER    :: SAFMIN =  7.334415470219388E-2466_WP
      REAL(WP), PARAMETER    :: SAFMAX =  1.363435169524269E+2465_WP
      REAL(WP), PARAMETER    :: SMLNUM =  3.076276814440306E-2459_WP
      REAL(WP), PARAMETER    :: BIGNUM =  3.250682758150744E+2458_WP
      REAL(WP), PARAMETER    :: RTMIN  =  5.546419398531176E-1230_WP
      REAL(WP), PARAMETER    :: RTMAX  =  1.80296499082782E+1229_WP
#endif
      CHARACTER*1, PARAMETER :: SPREFIX = 'H'
      CHARACTER*1, PARAMETER :: CPREFIX = 'G'
#else
      REAL(WP), PARAMETER    :: EPS    =  0.1192092896E-06_WP
      REAL(WP), PARAMETER    :: ULP    =  0.2384185791E-06_WP
      REAL(WP), PARAMETER    :: SAFMIN =  0.1175494351E-37_WP
      REAL(WP), PARAMETER    :: SAFMAX =  0.8507059173E+38_WP
      REAL(WP), PARAMETER    :: SMLNUM =  0.4930380658E-31_WP
      REAL(WP), PARAMETER    :: BIGNUM =  0.2028240960E+32_WP
      REAL(WP), PARAMETER    :: RTMIN  =  0.2220446049E-15_WP
      REAL(WP), PARAMETER    :: RTMAX  =  0.4503599627E+16_WP
      CHARACTER*1, PARAMETER :: SPREFIX = 'S'
      CHARACTER*1, PARAMETER :: CPREFIX = 'C'
#endif
!
      END MODULE LA_CONSTANTS32
