      MODULE LA_CONSTANTS
!
!  -- LAPACK module --
!     E. Anderson
!     February 12, 2002
!     04-25-02:  Change SAFMAX to ONE/SAFMIN (eca)
!     07-29-02:  Hard code all computed constants (eca)
!
!  Purpose
!  =======
!
!  LA_CONSTANTS defines 64-bit constants for use in LAPACK.
!
      INTEGER, PARAMETER     :: WP = 8
      REAL(WP), PARAMETER    :: ZERO = 0.0_WP
      REAL(WP), PARAMETER    :: HALF = 0.5_WP
      REAL(WP), PARAMETER    :: ONE = 1.0_WP
      REAL(WP), PARAMETER    :: TWO = 2.0_WP
      REAL(WP), PARAMETER    :: THREE = 3.0_WP
      REAL(WP), PARAMETER    :: FOUR = 4.0_WP
      REAL(WP), PARAMETER    :: EIGHT = 8.0_WP
      REAL(WP), PARAMETER    :: TEN = 10.0_WP
      COMPLEX(WP), PARAMETER :: CZERO = ( 0.0_WP, 0.0_WP )
      COMPLEX(WP), PARAMETER :: CHALF = ( 0.5_WP, 0.0_WP )
      COMPLEX(WP), PARAMETER :: CONE = ( 1.0_WP, 0.0_WP )
!eca
!eca  The following definitions are not completely portable so are
!eca  hard-coded below.
!eca
!eca  REAL(WP), PARAMETER    :: EPS = EPSILON( ONE )
!eca  REAL(WP), PARAMETER    :: ULP = EPS*RADIX( ONE )
!eca  REAL(WP), PARAMETER    :: SAFMIN = TINY(ONE)
!eca  REAL(WP), PARAMETER    :: SAFMAX = ONE / SAFMIN
!eca  REAL(WP), PARAMETER    :: SMLNUM = SAFMIN / ULP
!eca  REAL(WP), PARAMETER    :: BIGNUM = ONE / SMLNUM
!eca  REAL(WP), PARAMETER    :: RTMIN = SQRT( SMLNUM )
!eca  REAL(WP), PARAMETER    :: RTMAX = ONE / RTMIN
!
#ifdef _CRAY
#ifdef _CRAYMPP
      REAL(WP), PARAMETER    :: EPS    =  2.22044604925031308E-16_WP
      REAL(WP), PARAMETER    :: ULP    =  4.44089209850062616E-16_WP
      REAL(WP), PARAMETER    :: SAFMIN =  2.22507385850720138E-308_WP
      REAL(WP), PARAMETER    :: SAFMAX =  4.49423283715578977E+307_WP
      REAL(WP), PARAMETER    :: SMLNUM =  5.01042090002243194E-293_WP
      REAL(WP), PARAMETER    :: BIGNUM =  1.99584030953471981E+292_WP
      REAL(WP), PARAMETER    :: RTMIN  =  7.07843266551461421E-147_WP
      REAL(WP), PARAMETER    :: RTMAX  =  1.41274212421613572E+146_WP
#else
      REAL(WP), PARAMETER    :: EPS    =  1.4210854715202E-14_WP
      REAL(WP), PARAMETER    :: ULP    =  2.8421709430404E-14_WP
      REAL(WP), PARAMETER    :: SAFMIN =  7.334415470219388E-2466_WP
      REAL(WP), PARAMETER    :: SAFMAX =  1.363435169524269E+2465_WP
      REAL(WP), PARAMETER    :: SMLNUM =  2.580568029582846E-2452_WP
      REAL(WP), PARAMETER    :: BIGNUM =  3.875115821541242E+2451_WP
      REAL(WP), PARAMETER    :: RTMIN  =  1.606414650575263E-1226_WP
      REAL(WP), PARAMETER    :: RTMAX  =  6.225042828399852E+1225_WP
#endif
      CHARACTER*1, PARAMETER :: SPREFIX = 'S' 
      CHARACTER*1, PARAMETER :: CPREFIX = 'C' 
#else
      REAL(WP), PARAMETER    :: EPS    =  0.222044604925031308E-15_WP
      REAL(WP), PARAMETER    :: ULP    =  0.444089209850062616E-15_WP
!eca
!eca  IBM SP can't read it's own smallest number, use TINY for SAFMIN
!eca
!eca  REAL(WP), PARAMETER    :: SAFMIN =  0.222507385850720138E-307_WP
      REAL(WP), PARAMETER    :: SAFMIN = TINY(ONE)
      REAL(WP), PARAMETER    :: SAFMAX =  0.449423283715578977E+308_WP
      REAL(WP), PARAMETER    :: SMLNUM =  0.501042090002243194E-292_WP
      REAL(WP), PARAMETER    :: BIGNUM =  0.199584030953471981E+293_WP
      REAL(WP), PARAMETER    :: RTMIN  =  0.707843266551461421E-146_WP
      REAL(WP), PARAMETER    :: RTMAX  =  0.141274212421613572E+147_WP
      CHARACTER*1, PARAMETER :: SPREFIX = 'D' 
      CHARACTER*1, PARAMETER :: CPREFIX = 'Z' 
#endif
!
      END MODULE LA_CONSTANTS
