      INTEGER          FUNCTION ILATRS( ISPEC, NAME, OPTS, N1, N2, N3,
     $                 N4 )
!
!  -- LAPACK auxiliary routine --
!     E. Anderson, Cray Research Inc.
!     December 15, 1992
!     4-18-02:  OpenMP version for LAPACK 3E (eca)
!
!     .. Scalar Arguments ..
      CHARACTER*( * )    NAME, OPTS
      INTEGER            ISPEC, N1, N2, N3, N4
!     ..
!
!  Purpose
!  =======
!
!  ILATRS returns blocking parameters for the solve routines.
!
!  If ILATRS = 1 on exit, then it is more efficient to solve for the
!  right-hand sides one at a time, in parallel if NRHS > 1.
!
!  If 1 < ILATRS < NRHS, then it is more efficient to solve for
!  ILATRS right-hand sides at a time in a parallel loop.
!
!  If ILATRS = NRHS, then it is more efficient to solve for all
!  the right-hand sides at once.
!
!  If the number of processors available is greater than 1, then
!  ILATRS optimizes the solve for single-processor efficiency in
!  non-dedicated mode, and for throughput in dedicated mode.
!
!  Arguments
!  =========
!
!  ISPEC   (input) INTEGER
!          Ignored.
!
!  NAME    (input) CHARACTER*(*)
!          The name of the calling subroutine.
!
!  OPTS    (input) CHARACTER*(*)
!          The character options to the subroutine NAME, concatenated
!          into a single character string.  For example, UPLO = 'U',
!          TRANS = 'T', and DIAG = 'N' for a triangular routine would
!          be specified as OPTS = 'UTN'.
!
!  N1      (input) INTEGER
!  N2      (input) INTEGER
!  N3      (input) INTEGER
!  N4      (input) INTEGER
!          Problem dimensions for the subroutine NAME; these may not all
!          be required.  N1 is generally the matrix size and N2 is the
!          number of right-hand sides.
!
! (ILATRS) (output) INTEGER
!          See the Purpose section above.
!
!  =====================================================================
!
!     .. Local Scalars ..
      INTEGER            ILEN, NB, NCPU, NUSE
!     ..
#ifdef _OPENMP
!     .. External Functions ..
      LOGICAL            OMP_GET_DYNAMIC
      INTEGER            OMP_GET_NUM_THREADS
      EXTERNAL           OMP_GET_DYNAMIC, OMP_GET_NUM_THREADS
!     ..
#endif
!     .. Executable Statements ..
!
!     Get number of processors from the function OMP_GET_NUM_THREADS
!     and set the default block size.
!
#ifdef _OPENMP
      NCPU = OMP_GET_NUM_THREADS()
#else
      NCPU = 1
#endif
      ILEN = 32
!
!     Divide the right-hand sides among the processors.  Different
!     strategies are used if the number of processors is static or
!     dynamic.
!
      IF( NCPU.EQ.1 ) THEN
         NB = N2
      ELSE
#ifdef _OPENMP
         IF( .NOT.OMP_GET_DYNAMIC() ) THEN
            NUSE = NCPU
         ELSE
            NUSE = ( N2+ILEN-1 )/ILEN
         END IF
#else
         NUSE = NCPU
#endif
         NB = ( N2+NUSE-1 ) / NUSE
      END IF
!
!     Set NB to 1 if it is more efficient to solve for 1 RHS at a time.
!     The crossover point at which it becomes more efficient to solve
!     for greater than 1 RHS at a time varies for different matrix types
!     and sizes.
!
      IF( NB.LT.8 )
     &   NB = 1
!
      ILATRS = NB
      RETURN
!
!     End of ILATRS
!
      END
