#include "lapacknames.inc"
      SUBROUTINE CTRTRS( UPLO, TRANS, DIAG, N, NRHS, A, LDA, B, LDB,
     $                   INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILATRS, LSAME, XERBLA
      USE LA_BLAS2, ONLY: LA_TRSV
      USE LA_BLAS3, ONLY: LA_TRSM
*
*  -- LAPACK routine --
*     Based on LAPACK version 1.0, 2-29-92
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-18-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          DIAG, TRANS, UPLO
      INTEGER            INFO, LDA, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CTRTRS solves a triangular system of the form
*
*     A * X = B,  A**T * X = B,  or  A**H * X = B,
*
*  where A is a triangular matrix of order N, and B is an N-by-NRHS
*  matrix.  A check is made to verify that A is nonsingular.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies whether the matrix A is upper or lower triangular.
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  TRANS   (input) CHARACTER*1
*          Specifies the form of the system of equations:
*          = 'N':  A * X = B     (No transpose)
*          = 'T':  A**T * X = B  (Transpose)
*          = 'C':  A**H * X = B  (Conjugate transpose)
*
*  DIAG    (input) CHARACTER*1
*          Specifies whether or not the matrix A is unit triangular.
*          = 'N':  Non-unit triangular
*          = 'U':  Unit triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  A       (input) COMPLEX array, dimension (LDA,N)
*          The triangular matrix A.  If UPLO = 'U', the leading N-by-N
*          upper triangular part of the array A contains the upper
*          triangular matrix, and the strictly lower triangular part of
*          A is not referenced.  If UPLO = 'L', the leading N-by-N lower
*          triangular part of the array A contains the lower triangular
*          matrix, and the strictly upper triangular part of A is not
*          referenced.  If DIAG = 'U', the diagonal elements of A are
*          also not referenced and are assumed to be 1.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B.
*          On exit, if INFO = 0, the solution matrix X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0: if INFO = -k, the k-th argument had an illegal value
*          > 0: if INFO = k, the k-th diagonal element of A is zero,
*               indicating that the matrix is singular and the solution
*               X has not been computed.
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            NOUNIT
      INTEGER            J, NB
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      NOUNIT = LSAME( DIAG, 'N' )
      IF( .NOT.LSAME( UPLO, 'U' ) .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( .NOT.LSAME( TRANS, 'N' ) .AND. .NOT.
     $         LSAME( TRANS, 'T' ) .AND. .NOT.LSAME( TRANS, 'C' ) ) THEN
         INFO = -2
      ELSE IF( .NOT.NOUNIT .AND. .NOT.LSAME( DIAG, 'U' ) ) THEN
         INFO = -3
      ELSE IF( N.LT.0 ) THEN
         INFO = -4
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -5
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -7
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -9
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'TRTRS', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Check for singularity.
*
      IF( NOUNIT ) THEN
         DO 10 INFO = 1, N
            IF( A( INFO, INFO ).EQ.CZERO )
     $         RETURN
   10    CONTINUE
      END IF
      INFO = 0
*
*     Solve A * x = b,  A**T * x = b,  or  A**H * x = b.
*
      IF( NRHS.EQ.1 ) THEN
         CALL LA_TRSV( UPLO, TRANS, DIAG, N, A(1,1), LDA, B(1,1), 1 )
      ELSE
         NB = MAX( 1, ILATRS( 1, CPREFIX // 'TRTRS',
     $        UPLO // TRANS // DIAG, N, NRHS, -1, -1 ) )
         IF( NB.EQ.1 ) THEN
#ifdef _OPENMP
!$OMP PARALLEL DO PRIVATE(J)
!$OMP CNCALL
#endif
            DO 20 J = 1, NRHS
               CALL LA_TRSV( UPLO, TRANS, DIAG, N, A(1,1), LDA, B(1,J),
     $                       1 )
   20       CONTINUE
#ifdef _OPENMP
!$OMP END PARALLEL DO
#endif
         ELSE
            CALL LA_TRSM( 'Left', UPLO, TRANS, DIAG, N, NRHS, CONE, A,
     $                    LDA, B, LDB )
         END IF
      END IF
*
      RETURN
*
*     End of CTRTRS
*
      END
