#include "lapacknames.inc"
      SUBROUTINE CSTEIN( N, D, E, M, W, IBLOCK, ISPLIT, Z, LDZ, WORK,
     $                   IWORK, IFAIL, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: XERBLA, LA_LARNV
      USE LA_BLAS1, ONLY: LA_ASUM, LA_IAMAX, LA_NRM2, LA_SCAL
      USE LA_XLAEIF, ONLY: LA_LAEIF, LA_LAEIL, LA_LAEIU
*
*  -- LAPACK routine --
*     Based on LAPACK version 2.0, 9-30-94
*     E. Anderson, Cray Research Inc.
*     September 15, 1995
*     9-26-01:  Use SDOT/SAXPY during MGS (eca)
*     06-05-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDZ, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            IBLOCK( * ), IFAIL( * ), ISPLIT( * ),
     $                   IWORK( * )
      REAL(WP)           D( * ), E( * ), W( * ), WORK( * )
      COMPLEX(WP)        Z( LDZ, * )
*     ..
*
*  Purpose
*  =======
*
*  CSTEIN computes the eigenvectors of a real symmetric tridiagonal
*  matrix T corresponding to specified eigenvalues, using inverse
*  iteration.
*
*  The maximum number of iterations allowed for each eigenvector is
*  specified by an internal parameter MAXITS (currently set to 5).
*
*  Although the eigenvectors are real, they are stored in a complex
*  array, which may be passed to CUNMTR or CUPMTR for back
*  transformation to the eigenvectors of a complex Hermitian matrix
*  which was reduced to tridiagonal form.
*
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix.  N >= 0.
*
*  D       (input) REAL array, dimension (N)
*          The n diagonal elements of the tridiagonal matrix T.
*
*  E       (input) REAL array, dimension (N)
*          The (n-1) subdiagonal elements of the tridiagonal matrix
*          T, stored in elements 1 to N-1; E(N) need not be set.
*
*  M       (input) INTEGER
*          The number of eigenvectors to be found.  0 <= M <= N.
*
*  W       (input) REAL array, dimension (N)
*          The first M elements of W contain the eigenvalues for
*          which eigenvectors are to be computed.  The eigenvalues
*          should be grouped by split-off block and ordered from
*          smallest to largest within the block.  ( The output array
*          W from SSTEBZ with ORDER = 'B' is expected here. )
*
*  IBLOCK  (input) INTEGER array, dimension (N)
*          The submatrix indices associated with the corresponding
*          eigenvalues in W; IBLOCK(i)=1 if eigenvalue W(i) belongs to
*          the first submatrix from the top, =2 if W(i) belongs to
*          the second submatrix, etc.  ( The output array IBLOCK
*          from SSTEBZ is expected here. )
*
*  ISPLIT  (input) INTEGER array, dimension (N)
*          The splitting points, at which T breaks up into submatrices.
*          The first submatrix consists of rows/columns 1 to
*          ISPLIT( 1 ), the second of rows/columns ISPLIT( 1 )+1
*          through ISPLIT( 2 ), etc.
*          ( The output array ISPLIT from SSTEBZ is expected here. )
*
*  Z       (output) COMPLEX array, dimension (LDZ, M)
*          The computed eigenvectors.  The eigenvector associated
*          with the eigenvalue W(i) is stored in the i-th column of
*          Z.  Any vector which fails to converge is set to its current
*          iterate after MAXITS iterations.
*          The imaginary parts of the eigenvectors are set to zero.
*
*  LDZ     (input) INTEGER
*          The leading dimension of the array Z.  LDZ >= max(1,N).
*
*  WORK    (workspace) REAL array, dimension (5*N)
*
*  IWORK   (workspace) INTEGER array, dimension (N)
*
*  IFAIL   (output) INTEGER array, dimension (M)
*          On normal exit, all elements of IFAIL are zero.
*          If one or more eigenvectors fail to converge after
*          MAXITS iterations, then their indices are stored in
*          array IFAIL.
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -i, the i-th argument had an illegal value
*          > 0: if INFO = i, then i eigenvectors failed to converge
*               in MAXITS iterations.  Their indices are stored in
*               array IFAIL.
*
*  Internal Parameters
*  ===================
*
*  MAXITS  INTEGER, default = 5
*          The maximum number of iterations performed.
*
*  EXTRA   INTEGER, default = 1
*          The number of iterations performed after norm growth
*          criterion is satisfied, should be at least 1.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL(WP)           ODM3, ODM1
      PARAMETER          ( ODM3 = 0.001_WP, ODM1 = 0.1_WP )
      INTEGER            MAXITS, EXTRA
      PARAMETER          ( MAXITS = 5, EXTRA = 2 )
*     ..
*     .. Local Scalars ..
      INTEGER            B1, BLKSIZ, BN, GPIND, I, ID, IDL, IDU, IDU2,
     $                   IOFF, ITS, IX, J, J1, J2, JMAX, K, NBLK,
     $                   NRMCHK, NSAF
      REAL(WP)           CTR, G1, GMULT, ONENRM, ORTOL, PERTOL, PSF,
     $                   SCL, SEP, STPCRT, TOL, XJ, XJM
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 )
*     ..
*     .. External Functions ..
      REAL(WP)           SDOT
      EXTERNAL           SDOT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, SQRT
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      DO 10 I = 1, M
         IFAIL( I ) = 0
   10 CONTINUE
*
      IF( N.LT.0 ) THEN
         INFO = -1
      ELSE IF( M.LT.0 .OR. M.GT.N ) THEN
         INFO = -4
      ELSE IF( LDZ.LT.MAX( 1, N ) ) THEN
         INFO = -9
      ELSE
         DO 20 J = 2, M
            IF( IBLOCK( J ).LT.IBLOCK( J-1 ) ) THEN
               INFO = -6
               GO TO 30
            END IF
            IF( IBLOCK( J ).EQ.IBLOCK( J-1 ) .AND. W( J ).LT.W( J-1 ) )
     $           THEN
               INFO = -5
               GO TO 30
            END IF
   20    CONTINUE
   30    CONTINUE
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'STEIN', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 .OR. M.EQ.0 ) THEN
         RETURN
      ELSE IF( N.EQ.1 ) THEN
         Z( 1, 1 ) = CONE
         RETURN
      END IF
*
*     Initialize seed for random number generator xLARNV.
*
      ISEED( 1 ) = 1
      ISEED( 2 ) = 1
      ISEED( 3 ) = 1
      ISEED( 4 ) = 1
*
*     Initialize pointers.
*
      IX = 1
      IDL = IX + N
      ID = IDL + N - 1
      IDU = ID + N
      IDU2 = IDU + N - 1
      J1 = 1
*
*     Compute eigenvectors of matrix blocks.
*
   40 CONTINUE
      NBLK = IBLOCK( J1 )
*
*     Find starting and ending indices of block nblk.
*
      IF( NBLK.GT.1 ) THEN
         B1 = ISPLIT( NBLK-1 ) + 1
      ELSE
         B1 = 1
      END IF
      BN = ISPLIT( NBLK )
      BLKSIZ = BN - B1 + 1
*
      IF( BLKSIZ.EQ.1 ) THEN
*
*        If the block size is 1, the eigenvector is a column of
*        the identity matrix.
*
         DO 50 I = 1, N
            Z( I, J1 ) = ZERO
   50    CONTINUE
         Z( B1, J1 ) = ONE
         J2 = J1
      ELSE
*
*        Otherwise, initialize eigenvector array to zero outside the
*        block.
*
         DO 60 J2 = J1 + 1, M
            IF( IBLOCK( J2 ).NE.NBLK )
     $         GO TO 70
   60    CONTINUE
   70    CONTINUE
         J2 = J2 - 1
         DO 90 J = J1, J2
            DO 80 I = 1, B1 - 1
               Z( I, J ) = CZERO
   80       CONTINUE
   90    CONTINUE
         DO 110 J = J1, J2
            DO 100 I = BN + 1, N
               Z( I, J ) = CZERO
  100       CONTINUE
  110    CONTINUE
         GPIND = J1
*
*        Compute reorthogonalization criterion and stopping criterion.
*
         ONENRM = ABS( D( B1 ) ) + ABS( E( B1 ) )
         ONENRM = MAX( ONENRM, ABS( D( BN ) )+ABS( E( BN-1 ) ) )
         DO 120 I = B1 + 1, BN - 1
            ONENRM = MAX( ONENRM, ABS( D( I ) )+ABS( E( I-1 ) )+
     $               ABS( E( I ) ) )
  120    CONTINUE
         ORTOL = ODM3*ONENRM
         STPCRT = SQRT( ODM1 / BLKSIZ )
*
*        Loop through eigenvalues of block nblk.
*
         DO 180 J = J1, J2
            XJ = W( J )
*
*           If eigenvalues j and j-1 are too close, add a relatively
*           small perturbation.
*
            IF( J.GT.J1 ) THEN
               PERTOL = TEN*ABS( EPS*XJ )
               SEP = XJ - XJM
               IF( SEP.LT.PERTOL )
     $            XJ = XJM + PERTOL
            END IF
*
*           Get random starting vector.
*
            CALL LA_LARNV( 2, ISEED, BLKSIZ, WORK( IX ) )
            NRMCHK = 0
            TOL = ZERO
*
*           Compute LU factors with partial pivoting  ( PT = LU )
*
            CALL LA_LAEIF( BLKSIZ, D( B1 ), E( B1 ), XJ, WORK( IDL ),
     $                     WORK( ID ), WORK( IDU ), WORK( IDU2 ),
     $                     IWORK( 1 ) )
*
*           Compute a growth factor for U, assuming a normalized RHS.
*
            GMULT = ABS( WORK( IDU+BLKSIZ-2 ) )
            DO 130 I = 1, BLKSIZ - 2
               GMULT = MAX( GMULT, ABS( WORK( IDU+I-1 ) )+
     $                 ABS( WORK( IDU2+I-1 ) ) )
  130       CONTINUE
            GMULT = ONE / ( ONE+GMULT )
            K = BLKSIZ
            G1 = MIN( ONE, ABS( WORK( ID+BLKSIZ-1 ) ) )
            IF( G1.LT.SAFMIN )
     $         GO TO 150
            DO 140 K = BLKSIZ - 1, 1, -1
               G1 = ( G1*GMULT )*MIN( ONE, ABS( WORK( ID+K-1 ) ) )
               IF( G1.LT.SAFMIN )
     $            GO TO 150
  140       CONTINUE
  150       CONTINUE
            NSAF = BLKSIZ - K
*
*           Now here's a peculiar scaling factor
*
            PSF = BLKSIZ*ONENRM*MAX( EPS, ABS( WORK( ID+BLKSIZ-1 ) ) )
*
*           Iterate until an eigenvector is found (at most MAXITS
*           iterations).
*
            DO 160 ITS = 1, MAXITS
*
*              Normalize and scale the righthand side vector Pb.
*
               SCL = PSF / LA_ASUM( BLKSIZ, WORK( IX ), 1 )
               CALL LA_SCAL( BLKSIZ, SCL, WORK( IX ), 1 )
*
*              Solve the system LU = Pb.
*
               CALL LA_LAEIL( BLKSIZ, WORK( IDL ), IWORK( 1 ),
     $                        WORK( IX ) )
               IF( NSAF.GT.0 ) THEN
                  IOFF = BLKSIZ - NSAF
                  CALL LA_LAEIU( 1, NSAF, WORK( ID+IOFF ),
     $                           WORK( IDU+IOFF ), WORK( IDU2+IOFF ),
     $                           WORK( IX+IOFF ), TOL )
                  IF( IOFF.GT.0 ) THEN
                     IF( NSAF.GT.1 ) THEN
                        WORK( IX+IOFF-1 ) = WORK( IX+IOFF-1 ) -
     $                                      WORK( IDU2+IOFF-1 )*
     $                                      WORK( IX+IOFF+1 )
                     END IF
                     WORK( IX+IOFF-1 ) = WORK( IX+IOFF-1 ) -
     $                                   WORK( IDU+IOFF-1 )*
     $                                   WORK( IX+IOFF )
                     IF( IOFF.GT.1 ) THEN
                        WORK( IX+IOFF-2 ) = WORK( IX+IOFF-2 ) -
     $                                      WORK( IDU2+IOFF-2 )*
     $                                      WORK( IX+IOFF )
                     END IF
                  END IF
               END IF
               IF( NSAF.LT.BLKSIZ ) THEN
                  CALL LA_LAEIU( -1, BLKSIZ-NSAF, WORK( ID ),
     $                           WORK( IDU ), WORK( IDU2 ), WORK( IX ),
     $                           TOL )
               END IF
*
*              Reorthogonalize by modified Gram-Schmidt if
*              eigenvalues are close enough.
*
               IF( J.GT.J1 ) THEN
                  IF( ABS( XJ-XJM ).GT.ORTOL ) THEN
                     GPIND = J
                  ELSE
                     DO I = GPIND, J - 1
                        CTR = SDOT( BLKSIZ, WORK( IX ), 1, Z( B1, I ),
     $                              1 )
                        CALL SAXPY( BLKSIZ, -CTR, Z( B1, I ), 1,
     $                              WORK( IX ), 1 )
                     END DO
                  END IF
               END IF
*
*              Check the stopping criteria.
*
               JMAX = LA_IAMAX( BLKSIZ, WORK( IX ), 1 )
               IF( ABS( WORK( IX+JMAX-1 ) ).GE.STPCRT ) THEN
                  NRMCHK = NRMCHK + 1
                  IF( NRMCHK.GT.EXTRA )
     $               GO TO 170
               END IF
  160       CONTINUE
*
*           If stopping criterion was not satisfied, update info and
*           store eigenvector number in array IFAIL.
*
            INFO = INFO + 1
            IFAIL( INFO ) = J
*
*           Accept iterate as jth eigenvector.
*
  170       CONTINUE
            SCL = ONE / LA_NRM2( BLKSIZ, WORK( IX ), 1 )
            IF( WORK( IX+JMAX-1 ).LT.ZERO )
     $         SCL = -SCL
            CALL SCLCPY( BLKSIZ, SCL, WORK( IX ), 1, Z( B1, J ), 1 )
*
*           Save the shift to check eigenvalue spacing at next
*           iteration.
*
            XJM = XJ
  180    CONTINUE
*
*        Unpack real eigenvectors into the complex array Z.
*
         DO 200 J = J1, J2
            CALL SCOPY( BLKSIZ, Z( B1, J ), 1, WORK( 1 ), 1 )
            DO 190 I = 1, BLKSIZ
               Z( B1+I-1, J ) = WORK( I )
  190       CONTINUE
  200    CONTINUE
      END IF
      J1 = J2 + 1
      IF( J1.LE.M )
     $   GO TO 40
*
      RETURN
*
*     End of CSTEIN
*
      END
