#include "lapacknames.inc"
      SUBROUTINE CROT( N, X, INCX, Y, INCY, C, S )
      USE LA_CONSTANTS
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*     06-10-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, INCY, N
      REAL(WP)           C
      COMPLEX(WP)        S
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  CROT applies a plane rotation
*
*     [  c         s ] [ x(1)  x(2)  ...  x(n) ]
*     [ -conjg(s)  c ] [ y(1)  y(2)  ...  y(n) ]
*
*  where the cos (c) is real and the sin (s) is complex and the vectors
*  x and y are complex.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of elements in the vectors x and y.
*
*  X       (input/output) COMPLEX array, dimension (N)
*          On entry, the N-element vector x, stored as follows:
*          if INCX > 0, X(1+(i-1)*INCX) = x(i), 1<=i<=N;
*          if INCX < 0, X(1+(i-N)*INCX) = x(i), 1<=i<=N.
*
*          On exit, X is overwritten with c*x + s*y.
*
*  INCX    (input) INTEGER
*          The increment between successive values of X.  INCX <> 0.
*
*  Y       (input/output) COMPLEX array, dimension (N)
*          On entry, the N-element vector y, stored as follows:
*          if INCY > 0, Y(1+(i-1)*INCY) = y(i), 1<=i<=N;
*          if INCY < 0, Y(1+(i-N)*INCY) = y(i), 1<=i<=N.
*
*          On exit, Y is overwritten with -conjg(s)*x + c*y.
*
*  INCY    (input) INTEGER
*          The increment between successive values of Y.  INCY <> 0.
*
*  C       (input) REAL
*          The cosine c of the rotation.
*
*  S       (input) COMPLEX
*          The sine s of the rotation.  c and s define a rotation
*             [  c         s ]
*             [ -conjg(s)  c ]
*          where c*c + s*conjg(s) = 1.0.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IX, IY
      COMPLEX(WP)        STEMP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CONJG
*     ..
*     .. Executable Statements ..
*
      IF( N.LE.0 )
     $   RETURN
      IF( INCX.EQ.1 .AND. INCY.EQ.1 )
     $   GO TO 20
*
*     Code for unequal increments or equal increments not equal to 1
*
      IX = 1
      IY = 1
      IF( INCX.LT.0 )
     $   IX = ( -N+1 )*INCX + 1
      IF( INCY.LT.0 )
     $   IY = ( -N+1 )*INCY + 1
      DO 10 I = 1, N
         STEMP = C*X( IX ) + S*Y( IY )
         Y( IY ) = C*Y( IY ) - CONJG( S )*X( IX )
         X( IX ) = STEMP
         IX = IX + INCX
         IY = IY + INCY
   10 CONTINUE
      RETURN
*
*     Code for both increments equal to 1
*
   20 CONTINUE
      DO 30 I = 1, N
         STEMP = C*X( I ) + S*Y( I )
         Y( I ) = C*Y( I ) - CONJG( S )*X( I )
         X( I ) = STEMP
   30 CONTINUE
      RETURN
      END
