#include "lapacknames.inc"
      SUBROUTINE CPTSV( UPLO, N, NRHS, D, E, B, LDB, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA
      USE LA_LAPACK, ONLY: LA_PTTRF, LA_PTTRS
*
*  -- LAPACK routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 25, 1997
*     05-22-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            INFO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      REAL(WP)           D( * )
      COMPLEX(WP)        B( LDB, * ), E( * )
*     ..
*
*  Purpose
*  =======
*
*  CPTSV computes the solution to a complex system of linear
*  equations A*X = B, where A is an N-by-N Hermitian positive definite
*  tridiagonal matrix, and X and B are N-by-NRHS matrices.
*
*  The form of the factorization is
*     A = L*D*L**H,  if UPLO = 'L', or
*     A = U**H*D*U,  if UPLO = 'U',
*  where D is diagonal, L is a unit lower bidiagonal matrix and U is a
*  unit upper bidiagonal matrix.
*
*  CPTSV differs from its LAPACK 3 version through the addition of the
*  UPLO parameter.  The LAPACK 3 interface is still available through
*  the generic LA_PTSV interface.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER
*          Specifies whether the subdiagonal or the superdiagonal of the
*          tridiagonal matrix A is stored and the form of the
*          factorization.
*          = 'L':  E is the subdiagonal of A, form is A = L*D*L**H
*          = 'U':  E is the superdiagonal of A, form is A = U**H*D*U
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  D       (input/output) REAL array, dimension (N)
*          On entry, the n diagonal elements of the tridiagonal matrix
*          A.  On exit, the n diagonal elements of the diagonal matrix
*          D from the factorization A = L*D*L**H or A = U**H*D*U.
*
*  E       (input/output) COMPLEX array, dimension (N-1)
*          On entry, if UPLO = 'L', the (N-1) subdiagonal elements of
*          the tridiagonal matrix A; if UPLO = 'U', the (N-1)
*          superdiagonal elements of A.
*
*          On exit, if UPLO = 'L', the (N-1) subdiagonal elements of the
*          unit bidiagonal factor L from the factorization A = L*D*L**H;
*          if UPLO = 'U', the (N-1) superdiagonal elements of the unit
*          bidiagonal factor U from the factorization A = U**H*D*U.
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the N-by-NRHS right hand side matrix B.
*          On exit, if INFO = 0, the N-by-NRHS solution matrix X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*          > 0:  if INFO = i, the leading minor of order i is not
*                positive definite, and the solution has not been
*                computed.  The factorization has not been completed
*                unless i = N.
*
*  =====================================================================
*
*     .. Intrinsic Functions ..
      INTRINSIC          MAX
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      IF( .NOT.LSAME( UPLO, 'U' ) .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -7
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'PTSV ', -INFO )
         RETURN
      END IF
*
*     Compute the L*D*L' (or U'*D*U) factorization of A.
*
      CALL LA_PTTRF( N, D, E, INFO )
      IF( INFO.EQ.0 ) THEN
*
*        Solve the system A*X = B, overwriting B with X.
*
         CALL LA_PTTRS( UPLO, N, NRHS, D, E, B, LDB, INFO )
      END IF
      RETURN
*
*     End of CPTSV
*
      END
