#include "lapacknames.inc"
      SUBROUTINE CPPTS2( IUPLO, N, NRHS, AP, B, LDB )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LACGV
      USE LA_BLAS1, ONLY: LA_SCAL
      USE LA_BLAS2, ONLY: LA_GEMV, LA_GERU, LA_TPSV
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IUPLO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        AP( * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CPPTS2 solves a system of linear equations A*X = B with a symmetric
*  positive definite matrix A in packed storage using the Cholesky
*  factorization A = U'*U or A = L*L' computed by CPPTRF.  CPPTS2 can
*  be called in a parallel loop from CPPTRS.
*
*  Arguments
*  =========
*
*  IUPLO   (input) INTEGER
*          Specifies whether the factor stored in A is upper or lower
*          triangular.
*          = 1:  Upper triangular
*          = 0:  Lower triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  AP      (input) REAL array, dimension (N*(N+1)/2)
*          The triangular factor U or L from the Cholesky factorization
*          A = U'*U or A = L*L', packed columnwise in a linear array.
*          The j-th column of U or L is stored in the array AP as
*          follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.
*
*  B       (input/output) REAL array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B for the system of
*          linear equations.
*          On exit, the solution matrix, X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            J, KK
*     ..
*     .. Executable Statements ..
*
      IF( NRHS.EQ.1 ) THEN
*
*        No vectorization across right hand sides if NRHS = 1.
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve A*X = B where A = U'*U.
*
*           Solve U'*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Upper', 'Conjugate transpose', 'Non-unit', N,
     $                    AP(1), B(1,1), 1 )
*
*           Solve U*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Upper', 'No transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
         ELSE
*
*           Solve A*X = B where A = L*L'.
*
*           Solve L*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Lower', 'No transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
*
*           Solve L'*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Lower', 'Conjugate transpose', 'Non-unit', N,
     $                    AP(1), B(1,1), 1 )
         END IF
      ELSE
*
*        Vectorize across right hand sides if NRHS > 1.
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve U'*X = B, overwriting B with X.
*
            KK = 1
            DO 10 J = 1, N
               CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
               CALL LA_GEMV( 'Conjugate transpose', J-1, NRHS, -CONE,
     $                       B( 1, 1 ), LDB, AP( KK ), 1, CONE,
     $                       B( J, 1 ), LDB )
               CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
               CALL LA_SCAL( NRHS, CONE / AP( KK+J-1 ), B( J, 1 ), LDB )
               KK = KK + J
   10       CONTINUE
*
*           Solve U*X = B, overwriting B with X.
*
            KK = ( N*( N+1 ) ) / 2
            DO 20 J = N, 1, -1
               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ), LDB )
               CALL LA_GERU( J-1, NRHS, -CONE, AP( KK-J+1 ), 1,
     $                       B( J, 1 ), LDB, B( 1, 1 ), LDB )
               KK = KK - J
   20       CONTINUE
         ELSE
*
*           Solve L*X = B, overwriting B with X.
*
            KK = 1
            DO 30 J = 1, N - 1
               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ), LDB )
               CALL LA_GERU( N-J, NRHS, -CONE, AP( KK+1 ), 1, B( J, 1 ),
     $                       LDB, B( J+1, 1 ), LDB )
               KK = KK + ( N-J+1 )
   30       CONTINUE
            CALL LA_SCAL( NRHS, CONE / AP( KK ), B( N, 1 ), LDB )
*
*           Solve L'*X = B, overwriting B with X.
*
            KK = ( N*( N+1 ) ) / 2
            CALL LA_SCAL( NRHS, CONE / AP( KK ), B( N, 1 ), LDB )
            KK = KK - 2
            DO 40 J = N - 1, 1, -1
               CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
               CALL LA_GEMV( 'Conjugate transpose', N-J, NRHS, -CONE,
     $                       B( J+1, 1 ), LDB, AP( KK+1 ), 1, CONE,
     $                       B( J, 1 ), LDB )
               CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ), LDB )
               KK = KK - ( N-J+2 )
   40       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of CPPTS2
*
      END
