#include "lapacknames.inc"
      FUNCTION CLASGN( Z )
      USE LA_CONSTANTS
      COMPLEX(WP) CLASGN
*
*  -- LAPACK auxiliary routine --
*     E. Anderson
*     January 23, 2002
*     05-30-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      COMPLEX(WP)        Z
*     ..
*
*  Purpose
*  =======
*
*  CLASGN computes the sgn of a complex variable z, defined as
*
*     sgn(Z) = { 1            if z = 0
*              { z / abs(z)   if z <> 0
*
*  Arguments
*  =========
*
*  Z       (input) COMPLEX
*          The complex variable z.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           IMZ, REZ, SMAX, SFMAX2, SFMIN2, ZDN, ZINORM,
     $                   ZUP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, CMPLX, REAL, AIMAG, MAX, MIN, SQRT
*     ..
*     .. Executable Statements ..
*
      SFMIN2 = TWO*SAFMIN
      SFMAX2 = HALF*SAFMAX
      IF( Z.EQ.CZERO ) THEN
*
*        Special case:  if Z = 0, sgn(Z) = 1.
*
         CLASGN = CONE
      ELSE
         REZ = REAL(Z)
         IMZ = AIMAG(Z)
         SMAX = MAX( ABS(REZ), ABS(IMZ) )
         IF( SMAX.GE.SFMAX2 ) THEN
*
*           Scale down if Z is too big
*
            ZDN = ONE / MIN( SAFMAX, SMAX )
            REZ = ZDN*REZ
            IMZ = ZDN*IMZ
         ELSE IF( SMAX.LE.SFMIN2 ) THEN
*
*           Scale up if Z is too small
*
            ZUP = ONE / MAX( SAFMIN, SMAX )
            REZ = ZUP*REZ
            IMZ = ZUP*IMZ
         END IF
*
*        Now compute sgn(Z) = Z / ||Z||
*
         ZINORM = ONE / SQRT( REZ*REZ + IMZ*IMZ )
         CLASGN = CMPLX( ZINORM*REZ, ZINORM*IMZ )
      END IF
      RETURN
*
*     End of CLASGN
*
      END
