#include "lapacknames.inc"
      SUBROUTINE CLARZB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V,
     $                   LDV, T, LDT, C, LDC, WORK, LDWORK )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA, LA_GESUM, LA_LACGV
      USE LA_BLAS3, ONLY: LA_GEMM, LA_TRMM
*
*  -- LAPACK routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     December 1, 1999
*     05-08-02:  LAPACK 3E version, use xGESUM for matrix sums (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          DIRECT, SIDE, STOREV, TRANS
      INTEGER            K, L, LDC, LDT, LDV, LDWORK, M, N
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        C( LDC, * ), T( LDT, * ), V( LDV, * ),
     $                   WORK( LDWORK, * )
*     ..
*
*  Purpose
*  =======
*
*  CLARZB applies a complex block reflector H or its transpose H**H
*  to a complex distributed M-by-N  C from the left or the right.
*
*  Currently, only STOREV = 'R' and DIRECT = 'B' are supported.
*
*  Arguments
*  =========
*
*  SIDE    (input) CHARACTER*1
*          = 'L': apply H or H' from the Left
*          = 'R': apply H or H' from the Right
*
*  TRANS   (input) CHARACTER*1
*          = 'N': apply H (No transpose)
*          = 'C': apply H' (Conjugate transpose)
*
*  DIRECT  (input) CHARACTER*1
*          Indicates how H is formed from a product of elementary
*          reflectors
*          = 'F': H = H(1) H(2) . . . H(k) (Forward, not supported yet)
*          = 'B': H = H(k) . . . H(2) H(1) (Backward)
*
*  STOREV  (input) CHARACTER*1
*          Indicates how the vectors which define the elementary
*          reflectors are stored:
*          = 'C': Columnwise                        (not supported yet)
*          = 'R': Rowwise
*
*  M       (input) INTEGER
*          The number of rows of the matrix C.
*
*  N       (input) INTEGER
*          The number of columns of the matrix C.
*
*  K       (input) INTEGER
*          The order of the matrix T (= the number of elementary
*          reflectors whose product defines the block reflector).
*
*  L       (input) INTEGER
*          The number of columns of the matrix V containing the
*          meaningful part of the Householder reflectors.
*          If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0.
*
*  V       (input) COMPLEX array, dimension (LDV,NV).
*          If STOREV = 'C', NV = K; if STOREV = 'R', NV = L.
*
*  LDV     (input) INTEGER
*          The leading dimension of the array V.
*          If STOREV = 'C', LDV >= L; if STOREV = 'R', LDV >= K.
*
*  T       (input) COMPLEX array, dimension (LDT,K)
*          The triangular K-by-K matrix T in the representation of the
*          block reflector.
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T. LDT >= K.
*
*  C       (input/output) COMPLEX array, dimension (LDC,N)
*          On entry, the M-by-N matrix C.
*          On exit, C is overwritten by H*C or H'*C or C*H or C*H'.
*
*  LDC     (input) INTEGER
*          The leading dimension of the array C. LDC >= max(1,M).
*
*  WORK    (workspace) COMPLEX array, dimension (LDWORK,K)
*
*  LDWORK  (input) INTEGER
*          The leading dimension of the array WORK.
*          If SIDE = 'L', LDWORK >= max(1,N);
*          if SIDE = 'R', LDWORK >= max(1,M).
*
*  Further Details
*  ===============
*
*  Based on contributions by
*    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA
*
*  =====================================================================
*
*     .. Local Scalars ..
      CHARACTER          TRANST
      INTEGER            I, INFO, J
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( M.LE.0 .OR. N.LE.0 )
     $   RETURN
*
*     Check for currently supported options
*
      INFO = 0
      IF( .NOT.LSAME( DIRECT, 'B' ) ) THEN
         INFO = -3
      ELSE IF( .NOT.LSAME( STOREV, 'R' ) ) THEN
         INFO = -4
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'LARZB', -INFO )
         RETURN
      END IF
*
      IF( LSAME( TRANS, 'N' ) ) THEN
         TRANST = 'C'
      ELSE
         TRANST = 'N'
      END IF
*
      IF( LSAME( SIDE, 'L' ) ) THEN
*
*        Form  H * C  or  H' * C
*
*        W( 1:n, 1:k ) = conjg( C( 1:k, 1:n )' )
*
         CALL LA_GESUM( 'Transpose', N, K, CONE, C, LDC, CZERO, WORK,
     $                  LDWORK )
*
*        W( 1:n, 1:k ) = W( 1:n, 1:k ) + ...
*                        conjg( C( m-l+1:m, 1:n )' ) * V( 1:k, 1:l )'
*
         IF( L.GT.0 )
     $      CALL LA_GEMM( 'Transpose', 'Conjugate transpose', N, K, L,
     $                    CONE, C( M-L+1, 1 ), LDC, V(1,1), LDV, CONE,
     $                    WORK(1,1), LDWORK )
*
*        W( 1:n, 1:k ) = W( 1:n, 1:k ) * T'  or  W( 1:m, 1:k ) * T
*
         CALL LA_TRMM( 'Right', 'Lower', TRANST, 'Non-unit', N, K, CONE,
     $                 T, LDT, WORK, LDWORK )
*
*        C( 1:k, 1:n ) = C( 1:k, 1:n ) - conjg( W( 1:n, 1:k )' )
*
         CALL LA_GESUM( 'Transpose', K, N, -CONE, WORK, LDWORK, CONE, C,
     $                  LDC )
*
*        C( m-l+1:m, 1:n ) = C( m-l+1:m, 1:n ) - ...
*                    conjg( V( 1:k, 1:l )' ) * conjg( W( 1:n, 1:k )' )
*
         IF( L.GT.0 )
     $      CALL LA_GEMM( 'Transpose', 'Transpose', L, N, K, -CONE,
     $                    V(1,1), LDV, WORK(1,1), LDWORK, CONE,
     $                    C( M-L+1, 1 ), LDC )
*
      ELSE IF( LSAME( SIDE, 'R' ) ) THEN
*
*        Form  C * H  or  C * H'
*
*        W( 1:m, 1:k ) = C( 1:m, 1:k )
*
         CALL LA_GESUM( 'No transpose', M, K, CONE, C, LDC, CZERO, WORK,
     $                  LDWORK )
*
*        W( 1:m, 1:k ) = W( 1:m, 1:k ) + ...
*                        C( 1:m, n-l+1:n ) * conjg( V( 1:k, 1:l )' )
*
         IF( L.GT.0 )
     $      CALL LA_GEMM( 'No transpose', 'Transpose', M, K, L, CONE,
     $                    C( 1, N-L+1 ), LDC, V(1,1), LDV, CONE,
     $                    WORK(1,1), LDWORK )
*
*        W( 1:m, 1:k ) = W( 1:m, 1:k ) * conjg( T )  or
*                        W( 1:m, 1:k ) * conjg( T' )
*
         DO 50 J = 1, K
            CALL LA_LACGV( K-J+1, T( J, J ), 1 )
   50    CONTINUE
         CALL LA_TRMM( 'Right', 'Lower', TRANS, 'Non-unit', M, K, CONE,
     $                 T, LDT, WORK, LDWORK )
         DO 60 J = 1, K
            CALL LA_LACGV( K-J+1, T( J, J ), 1 )
   60    CONTINUE
*
*        C( 1:m, 1:k ) = C( 1:m, 1:k ) - W( 1:m, 1:k )
*
         CALL LA_GESUM( 'No transpose', M, K, -CONE, WORK, LDWORK, CONE,
     $                  C, LDC )
*
*        C( 1:m, n-l+1:n ) = C( 1:m, n-l+1:n ) - ...
*                            W( 1:m, 1:k ) * conjg( V( 1:k, 1:l ) )
*
         DO 90 J = 1, L
            CALL LA_LACGV( K, V( 1, J ), 1 )
   90    CONTINUE
         IF( L.GT.0 )
     $      CALL LA_GEMM( 'No transpose', 'No transpose', M, L, K,
     $                    -CONE, WORK(1,1), LDWORK, V(1,1), LDV, CONE,
     $                    C( 1, N-L+1 ), LDC )
         DO 100 J = 1, L
            CALL LA_LACGV( K, V( 1, J ), 1 )
  100    CONTINUE
*
      END IF
*
      RETURN
*
*     End of CLARZB
*
      END
