#include "lapacknames.inc"
      SUBROUTINE CLARGV( N, X, INCX, Y, INCY, C, INCC )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LASGN
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     1-23-02:  Make consistent with new BLAS standard (eca)
*     05-30-02:  LAPACK 3E version (eca)
*     09-05-02:  Avoid complex/real divisions (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCC, INCX, INCY, N
*     ..
*     .. Array Arguments ..
      REAL(WP)           C( * )
      COMPLEX(WP)        X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  CLARGV generates a vector of complex plane rotations with real
*  cosines, determined by elements of the complex vectors x and y.
*  For i = 1,2,...,n
*
*     (        c(i)   s(i) ) ( x(i) ) = ( r(i) )
*     ( -conjg(s(i))  c(i) ) ( y(i) ) = (   0  )
*
*  where c(i)**2 + ABS(s(i))**2 = 1.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of plane rotations to be generated.
*
*  X       (input/output) COMPLEX array, dimension (1+(N-1)*INCX)
*          On entry, the vector x.
*          On exit, x(i) is overwritten by r(i), for i = 1,...,n.
*
*  INCX    (input) INTEGER
*          The increment between elements of X. INCX > 0.
*
*  Y       (input/output) COMPLEX array, dimension (1+(N-1)*INCY)
*          On entry, the vector y.
*          On exit, the sines of the plane rotations.
*
*  INCY    (input) INTEGER
*          The increment between elements of Y. INCY > 0.
*
*  C       (output) REAL array, dimension (1+(N-1)*INCC)
*          The cosines of the plane rotations.
*
*  INCC    (input) INTEGER
*          The increment between elements of C. INCC > 0.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IC, IX, IY
      REAL(WP)           D, F1, F2, FN, G1, G2, GN, SFMAX2, SFMIN2
      COMPLEX(WP)        F, FS, FZ, G, GS, Z
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, AIMAG, CONJG, MAX, REAL, SQRT
*     ..
*     .. Statement Functions ..
      REAL(WP)           ABS1, ABSSQ
*     ..
*     .. Statement Function definitions ..
      ABS1( Z ) = ABS(REAL(Z))/2 + ABS(AIMAG(Z))/2
      ABSSQ( Z ) = REAL( Z )**2 + AIMAG( Z )**2
*     ..
*     .. Executable Statements ..
*
      SFMIN2 = TWO*SAFMIN
      SFMAX2 = HALF*SAFMAX
      IX = 1
      IY = 1
      IC = 1
      DO 60 I = 1, N
*
*        Use identical algorithm to CLARTG
*
         F = X( IX )
         G = Y( IY )
         IF( G.EQ.CZERO ) THEN
            C( IC ) = ONE
            X( IX ) = F
         ELSE IF( F.EQ.CZERO ) THEN
            C( IC ) = ZERO
            G1 = MAX( ABS(REAL(G)), ABS(AIMAG(G)) )
            IF( G1.GT.SFMIN2 .AND. G1.LT.SFMAX2 ) THEN
               G1 = ABS( G )
               GN = ONE / G1
               Y( IY ) = CONJG( G )*GN
               X( IX ) = G1
            ELSE
               Y( IY ) = LA_LASGN( CONJG( G ) )
               X( IX ) = Y( IY )*G
            END IF
         ELSE
            F1 = ABS1( F )
            G1 = ABS1( G )
            IF( F1.GE.G1 ) THEN
*
*              Scale by F1 or something close to that
*
               F1 = MIN( SAFMAX, MAX( F1, SAFMIN ) )
               FN = ONE / F1
               FS = F*FN
               F2 = ONE / ABSSQ( FS )
               GS = G*FN
               G2 = ABSSQ( GS )
               D = SQRT( ONE + G2*F2 )
               C( IC ) = ONE / D
               Y( IY ) = CONJG( GS )*FS*( C( IC )*F2 )
               X( IX ) = F*D
            ELSE
*
*              Scale by G1
*
               G1 = MIN( SAFMAX, MAX( G1, SAFMIN ) )
               GN = ONE / G1
               FS = F*GN
               F2 = ABSSQ( FS )
               GS = G*GN
               G2 = ABSSQ( GS )
               IF( F1.GT.SFMIN2 .AND. F1.LT.SFMAX2 ) THEN
                  D = G1*SQRT( F2 + G2 )
                  F1 = ABS( F )
                  FN = ONE / F1
                  FZ = F*FN
                  C( IC ) = F1 / D
                  Y( IY ) = ( CONJG( G ) / D )*FZ
                  X( IX ) = FZ*D
               ELSE
*
*                 Avoid ABS(F) if F is too small or too large.
*
                  D = SQRT( F2 + G2 )
                  F1 = SQRT( F2 )
                  FZ = LA_LASGN( FS )
                  C( IC ) = F1 / D
                  Y( IY ) = ( CONJG( GS ) / D )*FZ
                  X( IX ) = FZ*( G1*D )
               END IF
            END IF
         END IF
         IC = IC + INCC
         IX = IX + INCX
         IY = IY + INCY
   60 CONTINUE
      RETURN
*
*     End of CLARGV
*
      END
