#include "lapacknames.inc"
      SUBROUTINE CLARFG( N, ALPHA, X, INCX, TAU )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LAPY3, LA_LASSQ, LA_RSCL
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     04-25-02:  LAPACK 3E version, based on LAWN 126 (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, N
      COMPLEX(WP)        ALPHA, TAU
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        X( * )
*     ..
*
*  Purpose
*  =======
*
*  CLARFG generates a complex elementary reflector H of order n, such
*  that
*
*        H' * ( alpha ) = ( beta ),   H' * H = I.
*             (   x   )   (   0  )
*
*  where alpha and beta are scalars, with beta real, and x is an
*  (n-1)-element complex vector. H is represented in the form
*
*        H = I - tau * ( 1 ) * ( 1 v' ) ,
*                      ( v )
*
*  where tau is a complex scalar and v is a complex (n-1)-element
*  vector. Note that H is not hermitian.
*
*  If the elements of x are all zero and alpha is real, then tau = 0
*  and H is taken to be the unit matrix.
*
*  Otherwise  1 <= real(tau) <= 2  and  abs(tau-1) <= 1 .
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the elementary reflector.
*
*  ALPHA   (input/output) COMPLEX
*          On entry, the value alpha.
*          On exit, it is overwritten with the value beta.
*
*  X       (input/output) COMPLEX array, dimension
*                         (1+(N-2)*abs(INCX))
*          On entry, the vector x.
*          On exit, it is overwritten with the vector v.
*
*  INCX    (input) INTEGER
*          The increment between elements of X. INCX > 0.
*
*  TAU     (output) COMPLEX
*          The value tau.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           SCL, SUMSQ, XN, XA
      COMPLEX(WP)        XB
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          AIMAG, REAL, SIGN
*     ..
*     .. Executable Statements ..
*
      TAU = CZERO
      IF( N.LE.0 ) RETURN
*
*     Compute the 2-norm of x
*
      SCL = ONE
      SUMSQ = ZERO
      CALL LA_LASSQ( N-1, X(1), INCX, SCL, SUMSQ )
      XN = SCL*SQRT( SUMSQ )
*
*     Compute the reflection if || x || > 0  or if alpha is complex.
*
      IF( XN.GT.ZERO .OR. AIMAG( ALPHA ).NE.ZERO ) THEN
         XA = SIGN( LA_LAPY3( REAL( ALPHA ), AIMAG( ALPHA ), XN ),
     $        REAL( ALPHA ) )
         XB = ALPHA + XA
         TAU = XB / XA
         CALL LA_RSCL( N-1, XB, X(1), INCX )
         ALPHA = -XA
      END IF
*
      RETURN
*
*     End of CLARFG
*
      END
