#include "lapacknames.inc"
      SUBROUTINE CLAQHP( UPLO, N, AP, S, SCOND, AMAX, EQUED )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     05-09-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          EQUED, UPLO
      INTEGER            N
      REAL(WP)           AMAX, SCOND
*     ..
*     .. Array Arguments ..
      REAL(WP)           S( * )
      COMPLEX(WP)        AP( * )
*     ..
*
*  Purpose
*  =======
*
*  CLAQHP equilibrates a Hermitian matrix A using the scaling factors
*  in the vector S.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies whether the upper or lower triangular part of the
*          Hermitian matrix A is stored.
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  AP      (input/output) COMPLEX array, dimension (N*(N+1)/2)
*          On entry, the upper or lower triangle of the Hermitian matrix
*          A, packed columnwise in a linear array.  The j-th column of A
*          is stored in the array AP as follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.
*
*          On exit, the equilibrated matrix:  diag(S) * A * diag(S), in
*          the same storage format as A.
*
*  S       (input) REAL array, dimension (N)
*          The scale factors for A.
*
*  SCOND   (input) REAL
*          Ratio of the smallest S(i) to the largest S(i).
*
*  AMAX    (input) REAL
*          Absolute value of largest matrix entry.
*
*  EQUED   (output) CHARACTER*1
*          Specifies whether or not equilibration was done.
*          = 'N':  No equilibration.
*          = 'Y':  Equilibration was done, i.e., A has been replaced by
*                  diag(S) * A * diag(S).
*
*  Internal Parameters
*  ===================
*
*  THRESH is a threshold value used to decide if scaling should be done
*  based on the ratio of the scaling factors.  If SCOND < THRESH,
*  scaling is done.
*
*  BIGNUM and SMLNUM are threshold values used to decide if scaling
*  should be done based on the absolute size of the largest matrix
*  element.  If AMAX > BIGNUM or AMAX < SMLNUM, scaling is done.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL(WP)           THRESH
      PARAMETER          ( THRESH = ONE / TEN )
*     ..
*     .. Local Scalars ..
      INTEGER            I, J, JC
      REAL(WP)           CJ
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 ) THEN
         EQUED = 'N'
         RETURN
      END IF
*
      IF( SCOND.GE.THRESH .AND. AMAX.GE.SMLNUM .AND. AMAX.LE.BIGNUM )
     $   THEN
*
*        No equilibration
*
         EQUED = 'N'
      ELSE
*
*        Replace A by diag(S) * A * diag(S).
*
         IF( LSAME( UPLO, 'U' ) ) THEN
*
*           Upper triangle of A is stored.
*
            JC = 1
            DO 20 J = 1, N
               CJ = S( J )
               DO 10 I = 1, J - 1
                  AP( JC+I-1 ) = CJ*S( I )*AP( JC+I-1 )
   10          CONTINUE
               AP( JC+J-1 ) = CJ*CJ*REAL( AP( JC+J-1 ) )
               JC = JC + J
   20       CONTINUE
         ELSE
*
*           Lower triangle of A is stored.
*
            JC = 1
            DO 40 J = 1, N
               CJ = S( J )
               AP( JC ) = CJ*CJ*REAL( AP( JC ) )
               DO 30 I = J + 1, N
                  AP( JC+I-J ) = CJ*S( I )*AP( JC+I-J )
   30          CONTINUE
               JC = JC + N - J + 1
   40       CONTINUE
         END IF
         EQUED = 'Y'
      END IF
*
      RETURN
*
*     End of CLAQHP
*
      END
