#include "lapacknames.inc"
      SUBROUTINE CHEGS2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA, LA_LACGV
      USE LA_BLAS1, ONLY: LA_AXPY, LA_SCAL
      USE LA_BLAS2, ONLY: LA_HER2, LA_TRMV, LA_TRSV
*
*  -- LAPACK routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     06-07-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            INFO, ITYPE, LDA, LDB, N
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CHEGS2 reduces a complex Hermitian-definite generalized
*  eigenproblem to standard form.
*
*  If ITYPE = 1, the problem is A*x = lambda*B*x,
*  and A is overwritten by inv(U')*A*inv(U) or inv(L)*A*inv(L')
*
*  If ITYPE = 2 or 3, the problem is A*B*x = lambda*x or
*  B*A*x = lambda*x, and A is overwritten by U*A*U` or L'*A*L.
*
*  B must have been previously factorized as U'*U or L*L' by CPOTRF.
*
*  Arguments
*  =========
*
*  ITYPE   (input) INTEGER
*          = 1: compute inv(U')*A*inv(U) or inv(L)*A*inv(L');
*          = 2 or 3: compute U*A*U' or L'*A*L.
*
*  UPLO    (input) CHARACTER
*          Specifies whether the upper or lower triangular part of the
*          Hermitian matrix A is stored, and how B has been factorized.
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  N       (input) INTEGER
*          The order of the matrices A and B.  N >= 0.
*
*  A       (input/output) COMPLEX array, dimension (LDA,N)
*          On entry, the Hermitian matrix A.  If UPLO = 'U', the leading
*          n by n upper triangular part of A contains the upper
*          triangular part of the matrix A, and the strictly lower
*          triangular part of A is not referenced.  If UPLO = 'L', the
*          leading n by n lower triangular part of A contains the lower
*          triangular part of the matrix A, and the strictly upper
*          triangular part of A is not referenced.
*
*          On exit, if INFO = 0, the transformed matrix, stored in the
*          same format as A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  B       (input) COMPLEX array, dimension (LDB,N)
*          The triangular factor from the Cholesky factorization of B,
*          as returned by CPOTRF.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit.
*          < 0:  if INFO = -i, the i-th argument had an illegal value.
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            UPPER
      INTEGER            K
      REAL(WP)           AKK, BKK
      COMPLEX(WP)        CT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      UPPER = LSAME( UPLO, 'U' )
      IF( ITYPE.LT.1 .OR. ITYPE.GT.3 ) THEN
         INFO = -1
      ELSE IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -2
      ELSE IF( N.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -5
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -7
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'HEGS2', -INFO )
         RETURN
      END IF
*
      IF( ITYPE.EQ.1 ) THEN
         IF( UPPER ) THEN
*
*           Compute inv(U')*A*inv(U)
*
            DO 10 K = 1, N
*
*              Update the upper triangle of A(k:n,k:n)
*
               AKK = A( K, K )
               BKK = B( K, K )
               AKK = AKK / BKK**2
               A( K, K ) = AKK
               IF( K.LT.N ) THEN
                  CALL LA_SCAL( N-K, ONE / BKK, A( K, K+1 ), LDA )
                  CT = -HALF*AKK
                  CALL LA_LACGV( N-K, A( K, K+1 ), LDA )
                  CALL LA_LACGV( N-K, B( K, K+1 ), LDB )
                  CALL LA_AXPY( N-K, CT, B( K, K+1 ), LDB, A( K, K+1 ),
     $                          LDA )
                  CALL LA_HER2( UPLO, N-K, -CONE, A( K, K+1 ), LDA,
     $                          B( K, K+1 ), LDB, A( K+1, K+1 ), LDA )
                  CALL LA_AXPY( N-K, CT, B( K, K+1 ), LDB, A( K, K+1 ),
     $                          LDA )
                  CALL LA_LACGV( N-K, B( K, K+1 ), LDB )
                  CALL LA_TRSV( UPLO, 'Conjugate transpose', 'Non-unit',
     $                          N-K, B( K+1, K+1 ), LDB, A( K, K+1 ),
     $                          LDA )
                  CALL LA_LACGV( N-K, A( K, K+1 ), LDA )
               END IF
   10       CONTINUE
         ELSE
*
*           Compute inv(L)*A*inv(L')
*
            DO 20 K = 1, N
*
*              Update the lower triangle of A(k:n,k:n)
*
               AKK = A( K, K )
               BKK = B( K, K )
               AKK = AKK / BKK**2
               A( K, K ) = AKK
               IF( K.LT.N ) THEN
                  CALL LA_SCAL( N-K, ONE / BKK, A( K+1, K ), 1 )
                  CT = -HALF*AKK
                  CALL LA_AXPY( N-K, CT, B( K+1, K ), 1, A( K+1, K ), 1)
                  CALL LA_HER2( UPLO, N-K, -CONE, A( K+1, K ), 1,
     $                          B( K+1, K ), 1, A( K+1, K+1 ), LDA )
                  CALL LA_AXPY( N-K, CT, B( K+1, K ), 1, A( K+1, K ), 1)
                  CALL LA_TRSV( UPLO, 'No transpose', 'Non-unit', N-K,
     $                          B( K+1, K+1 ), LDB, A( K+1, K ), 1 )
               END IF
   20       CONTINUE
         END IF
      ELSE
         IF( UPPER ) THEN
*
*           Compute U*A*U'
*
            DO 30 K = 1, N
*
*              Update the upper triangle of A(1:k,1:k)
*
               AKK = A( K, K )
               BKK = B( K, K )
               CALL LA_TRMV( UPLO, 'No transpose', 'Non-unit', K-1,
     $                       B( 1, 1 ), LDB, A( 1, K ), 1 )
               CT = HALF*AKK
               CALL LA_AXPY( K-1, CT, B( 1, K ), 1, A( 1, K ), 1 )
               CALL LA_HER2( UPLO, K-1, CONE, A( 1, K ), 1, B( 1, K ),
     $                       1, A( 1, 1 ), LDA )
               CALL LA_AXPY( K-1, CT, B( 1, K ), 1, A( 1, K ), 1 )
               CALL LA_SCAL( K-1, BKK, A( 1, K ), 1 )
               A( K, K ) = AKK*BKK**2
   30       CONTINUE
         ELSE
*
*           Compute L'*A*L
*
            DO 40 K = 1, N
*
*              Update the lower triangle of A(1:k,1:k)
*
               AKK = A( K, K )
               BKK = B( K, K )
               CALL LA_LACGV( K-1, A( K, 1 ), LDA )
               CALL LA_TRMV( UPLO, 'Conjugate transpose', 'Non-unit',
     $                       K-1, B( 1, 1 ), LDB, A( K, 1 ), LDA )
               CT = HALF*AKK
               CALL LA_LACGV( K-1, B( K, 1 ), LDB )
               CALL LA_AXPY( K-1, CT, B( K, 1 ), LDB, A( K, 1 ), LDA )
               CALL LA_HER2( UPLO, K-1, CONE, A( K, 1 ), LDA, B( K, 1 ),
     $                       LDB, A( 1, 1 ), LDA )
               CALL LA_AXPY( K-1, CT, B( K, 1 ), LDB, A( K, 1 ), LDA )
               CALL LA_LACGV( K-1, B( K, 1 ), LDB )
               CALL LA_SCAL( K-1, BKK, A( K, 1 ), LDA )
               CALL LA_LACGV( K-1, A( K, 1 ), LDA )
               A( K, K ) = AKK*BKK**2
   40       CONTINUE
         END IF
      END IF
      RETURN
*
*     End of CHEGS2
*
      END
