#include "lapacknames.inc"
      SUBROUTINE CGEBAK( JOB, SIDE, N, ILO, IHI, SCALE, M, V, LDV,
     $                   INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA
      USE LA_BLAS1, ONLY: LA_SCAL, LA_SWAP
*
*  -- LAPACK routine --
*     Based on LAPACK version 2.0, 9-30-94
*     E. Anderson, Cray Research Inc.
*     May 11, 1995
*     06-10-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          JOB, SIDE
      INTEGER            IHI, ILO, INFO, LDV, M, N
*     ..
*     .. Array Arguments ..
      REAL(WP)           SCALE( * )
      COMPLEX(WP)        V( LDV, * )
*     ..
*
*  Purpose
*  =======
*
*  CGEBAK forms the right or left eigenvectors of a complex general
*  matrix by backward transformation on the computed eigenvectors of the
*  balanced matrix output by CGEBAL.
*
*  Arguments
*  =========
*
*  JOB     (input) CHARACTER*1
*          Specifies the type of backward transformation required:
*          = 'N', do nothing, return immediately;
*          = 'P', do backward transformation for permutation only;
*          = 'S', do backward transformation for scaling only;
*          = 'B', do backward transformations for both permutation and
*                 scaling.
*          JOB must be the same as the argument JOB supplied to CGEBAL.
*
*  SIDE    (input) CHARACTER*1
*          = 'R':  V contains right eigenvectors;
*          = 'L':  V contains left eigenvectors.
*
*  N       (input) INTEGER
*          The number of rows of the matrix V.  N >= 0.
*
*  ILO     (input) INTEGER
*  IHI     (input) INTEGER
*          The integers ILO and IHI determined by CGEBAL.
*          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
*
*  SCALE   (input) REAL array, dimension (N)
*          Details of the permutation and scaling factors, as returned
*          by CGEBAL.
*
*  M       (input) INTEGER
*          The number of columns of the matrix V.  M >= 0.
*
*  V       (input/output) COMPLEX array, dimension (LDV,M)
*          On entry, the matrix of right or left eigenvectors to be
*          transformed, as returned by CHSEIN or CTREVC.
*          On exit, V is overwritten by the transformed eigenvectors.
*
*  LDV     (input) INTEGER
*          The leading dimension of the array V. LDV >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value.
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            LEFTV, PERMUT, RIGHTV, SCALEA
      INTEGER            I, IP
      REAL(WP)           S
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Decode and Test the input parameters
*
      INFO = 0
      SCALEA = LSAME( JOB, 'B' )
      PERMUT = SCALEA .OR. LSAME( JOB, 'P' )
      SCALEA = SCALEA .OR. LSAME( JOB, 'S' )
      RIGHTV = LSAME( SIDE, 'R' )
      LEFTV = LSAME( SIDE, 'L' )
*
      IF( .NOT.( LSAME( JOB, 'N' ) .OR. SCALEA .OR. PERMUT ) ) THEN
         INFO = -1
      ELSE IF( .NOT.( RIGHTV .OR. LEFTV ) ) THEN
         INFO = -2
      ELSE IF( N.LT.0 ) THEN
         INFO = -3
      ELSE IF( ILO.LT.1 .OR. ILO.GT.MAX( 1, N ) ) THEN
         INFO = -4
      ELSE IF( IHI.LT.MIN( ILO, N ) .OR. IHI.GT.N ) THEN
         INFO = -5
      ELSE IF( M.LT.0 ) THEN
         INFO = -7
      ELSE IF( LDV.LT.MAX( 1, N ) ) THEN
         INFO = -9
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'GEBAK', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 .OR. M.EQ.0 .OR. LSAME( JOB, 'N' ) )
     $   RETURN
*
*     Backward balance
*
      IF( SCALEA ) THEN
         IF( RIGHTV ) THEN
*
*           Scale right eigenvectors by diag(SCALE).
*
            DO 10 I = ILO, IHI
               CALL LA_SCAL( M, SCALE( I ), V( I, 1 ), LDV )
   10       CONTINUE
         ELSE
*
*           Scale left eigenvectors by inv(diag(SCALE)).
*
            DO 20 I = ILO, IHI
               S = ONE / SCALE( I )
               CALL LA_SCAL( M, S, V( I, 1 ), LDV )
   20       CONTINUE
         END IF
      END IF
*
*     Backward permutation
*
*     For  I = ILO-1 step -1 until 1,
*              IHI+1 step 1 until N do --
*
      IF( PERMUT ) THEN
         DO 30 I = ILO-1, 1, -1
            IP = SCALE( I )
            IF( I.NE.IP )
     $         CALL LA_SWAP( M, V( I, 1 ), LDV, V( IP, 1 ), LDV )
   30    CONTINUE
         DO 40 I = IHI+1, N
            IP = SCALE( I )
            IF( I.NE.IP )
     $         CALL LA_SWAP( M, V( I, 1 ), LDV, V( IP, 1 ), LDV )
   40    CONTINUE
      END IF
*
      RETURN
*
*     End of CGEBAK
*
      END
