#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <complex.h>

int zcreateA_integers( int lower, int n, double complex *A );
int zvisualize_html( int normaltransr, int lower, int n, double complex *A, double complex *ARF );

int main(int argc, char **argv) {

   int normaltransr, lower, n, in;
   double complex *A, *ARF;
   
   printf("<html>\n<pre>\n<b>\n");
   printf("COMPLEX Rectangular Full Packed Format.\n");
   printf("\n");
   printf("EIGHT cases:\n");
   printf("   N is ODD or EVEN\n");
   printf("   TRANSR = 'L' or TRANSR = 'C'\n");
   printf("   UPLO = 'L' or UPLO = 'U'\n");
   printf("\n");
   printf("COMPLEX => entries are complex numbers. They are represented below by ( REAL_PART, IMAG_PART ).\n");
   printf("\n");
   printf("On the LEFT:  example matrix in Full Format (so ZHE, ZSY, ZTR),\n");
   printf("              the entry (***,***) represents unreference memory spaces.\n");
   printf("On the RIGHT: example matrix in Rectangular Full Packed Format (so ZHF, ZSF, ZTF)\n");
   printf("\n");
   printf("The <font color=\"green\">GREEN</font> entries represents the part of the matrix that is not tranpose in the RFP format.\n");
   printf("The <font color=\"red\">RED</font> entries represents the part of the matrix that is conjugate-tranpose in the RFP format.\n");
   printf("\n");
   printf("This web page is automatically generated by the following C-code:");
   printf(" <a href=\"http://www-math.cudenver.edu/~langou/lapack-3.2/visualize_html.tar.gz\">visualize_html.tar.gz</a>.\n");
   printf("( There is also a TERMINAL version with colors :) ");
   printf(" <a href=\"http://www-math.cudenver.edu/~langou/lapack-3.2/visualize_terminal.tar.gz\">visualize_terminal.tar.gz</a>. )\n");
   printf("\n");

   for ( in = 0; in < 2; in ++) {
      if (in == 0) n = 7;
      if (in == 1) n = 6;
      for ( normaltransr = 1; normaltransr > -1; normaltransr --) {
         for ( lower = 1; lower > -1; lower --) {
            A = (double complex *)calloc(n*n,sizeof(double complex)) ; ARF = (double complex *)calloc( (n*(n+1))/2,sizeof(double complex)) ;
            zcreateA_integers( lower, n, A );
            zvisualize_html( normaltransr, lower, n, A, ARF );
            free(ARF); free(A);
         }
      }
   }

   printf("</b>\n</pre>\n</html>\n");
   exit(0);

}
