      DOUBLE PRECISION FUNCTION DOPGB( SUBNAM, M, N, KL, KU, IPIV )
*
*  -- LAPACK timing routine (version 1.0b) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*6        SUBNAM
      INTEGER            KL, KU, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
*     ..
*
*  Purpose
*  =======
*
*  DOPGB counts operations for the LU factorization of a band matrix
*  xGBTRF.
*
*  Arguments
*  =========
*
*  SUBNAM  (input) CHARACTER*6
*          The name of the subroutine.
*
*  M       (input) INTEGER
*          The number of rows of the coefficient matrix.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the coefficient matrix.  N >= 0.
*
*  KL      (input) INTEGER
*          The number of subdiagonals of the matrix.  KL >= 0.
*
*  KU      (input) INTEGER
*          The number of superdiagonals of the matrix.  KU >= 0.
*
*  IPIV    (input)  INTEGER array, dimension (min(M,N))
*          The vector of pivot indices from DGBTRF or ZGBTRF.
*
*     .. Local Scalars ..
      LOGICAL            CORZ, SORD
      CHARACTER          C1
      INTEGER            J, JP, JU, KM
      DOUBLE PRECISION   ADDFAC, ADDS, MULFAC, MULTS
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
      DOPGB = 0
      MULTS = 0
      ADDS = 0
      C1 = SUBNAM( 1: 1 )
      SORD = LSAME( C1, 'S' ) .OR. LSAME( C1, 'D' )
      CORZ = LSAME( C1, 'C' ) .OR. LSAME( C1, 'Z' )
      IF( .NOT.( SORD .OR. CORZ ) )
     $   RETURN
      IF( LSAME( C1, 'S' ) .OR. LSAME( C1, 'D' ) ) THEN
         ADDFAC = 1
         MULFAC = 1
      ELSE
         ADDFAC = 2
         MULFAC = 6
      END IF
*
      JU = 1
      DO 10 J = 1, MIN( M, N )
         KM = MIN( KL, M-J )
         JP = IPIV( J )
         JU = MAX( JU, MIN( JP+KU, N ) )
         IF( KM.GT.0 ) THEN
            MULTS = MULTS + KM*( 1+JU-J )
            ADDS = ADDS + KM*( JU-J )
         END IF
   10 CONTINUE
      DOPGB = MULFAC*MULTS + ADDFAC*ADDS
      RETURN
*
*     End of DOPGB
*
      END
