      SUBROUTINE ZLARTG( F, G, CS, SN, R )
*
*  -- LAPACK auxiliary routine (version 1.0b) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      DOUBLE PRECISION   CS
      COMPLEX*16         F, G, R, SN
*     ..
*
*  Purpose
*  =======
*
*     Generate a plane rotation so that
*
*     [  CS  SN  ]     [ F ]     [ R ]
*     [  __      ]  .  [   ]  =  [   ]   where CS**2 + |SN|**2 = 1.
*     [ -SN  CS  ]     [ G ]     [ 0 ]
*
*     This is a faster version of the BLAS1 routine ZROTG, except for
*     the following differences:
*        F and G are unchanged on return.
*        If G=0, then CS=1 and SN=0.
*        If F=0 and (G .ne. 0), then CS=0 and SN=1 without doing any
*           floating point operations.
*
*  Arguments
*  =========
*
*  F      (input) DOUBLE COMPLEX
*         The first component of vector to be rotated.
*
*  G      (input) DOUBLE COMPLEX
*         The second component of vector to be rotated.
*          Unchanged on output.
*
*  CS     (output) DOUBLE PRECISION
*         The cosine of the rotation.
*
*  SN     (output) DOUBLE COMPLEX
*         The sine of the rotation.
*
*  R      (output) DOUBLE COMPLEX
*         The nonzero component of the rotated vector.
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )
      COMPLEX*16         CZERO, CONE
      PARAMETER          ( CZERO = 0.0D0, CONE = 1.0D0 )
*     ..
*
*     .. Local Scalars ..
      DOUBLE PRECISION   D, DI, F1, F2, FA, G1, G2, GA
      COMPLEX*16         FS, GS, SS, T
*     ..
*
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, SQRT
*     ..
*
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1, ABS2
*     ..
*
*     .. Statement Function definitions ..
      ABS1( T ) = ABS( DBLE( T ) ) + ABS( DIMAG( T ) )
      ABS2( T ) = DBLE( T )**2 + DIMAG( T )**2
*     ..
*
*     .. Executable Statements ..
*
*     [ 25 vs. 38 ops for main paths ]
*
      F1 = ABS1( F )
      G1 = ABS1( G )
*
      IF( F1.GE.G1 ) THEN
         IF( F1.EQ.ZERO ) THEN
            CS = ONE
            SN = CZERO
            R = CZERO
         ELSE
            GS = G / F1
            G2 = ABS2( GS )
            FS = F / F1
            F2 = ABS2( FS )
            D = SQRT( ONE+G2 / F2 )
            CS = ONE / D
            R = F*D
            SN = DCONJG( GS )*FS*( CS / F2 )
         END IF
      ELSE
         FS = F / G1
         F2 = ABS2( FS )
         IF( F2.EQ.ZERO ) THEN
            CS = ZERO
            SN = CONE
            R = G
         ELSE
            FA = SQRT( F2 )
            GS = G / G1
            G2 = ABS2( GS )
            GA = SQRT( G2 )
            D = SQRT( ONE+F2 / G2 )
            DI = ONE / D
            SS = ( DCONJG( GS )*FS ) / ( FA*GA )
            SN = SS*DI
            CS = ( FA / GA )*DI
            R = G*SS*D
         END IF
      END IF
      RETURN
*
*     End of ZLARTG
*
      END
