      subroutine cdiv(ar,ai,br,bi,cr,ci)
      double precision ar,ai,br,bi,cr,ci
c
c     complex division, (cr,ci) = (ar,ai)/(br,bi)
c
      double precision s,ars,ais,brs,bis
      s = dabs(br) + dabs(bi)
      ars = ar/s
      ais = ai/s
      brs = br/s
      bis = bi/s
      s = brs**2 + bis**2
      cr = (ars*brs + ais*bis)/s
      ci = (ais*brs - ars*bis)/s
      return
      end
      subroutine cinvit(nm,n,ar,ai,wr,wi,select,mm,m,zr,zi,
     x                  ierr,rm1,rm2,rv1,rv2)
c
      integer i,j,k,m,n,s,ii,mm,mp,nm,uk,ip1,its,km1,ierr
      double precision ar(nm,n),ai(nm,n),wr(n),wi(n),zr(nm,mm),
     x       zi(nm,mm),rm1(n,n),rm2(n,n),rv1(n),rv2(n)
      double precision x,y,eps3,norm,normv,epslon,growto,ilambd,pythag,
     x       rlambd,ukroot
      logical select(n)
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common Blocks ..
      COMMON /LATIME/ OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION OPS, ITCNT, OPST
*     ..
c
c     this subroutine is a translation of the algol procedure cx invit
c     by peters and wilkinson.
c     handbook for auto. comp. vol.ii-linear algebra, 418-439(1971).
c
c     this subroutine finds those eigenvectors of a complex upper
c     hessenberg matrix corresponding to specified eigenvalues,
c     using inverse iteration.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        ar and ai contain the real and imaginary parts,
c          respectively, of the hessenberg matrix.
c
c        wr and wi contain the real and imaginary parts, respectively,
c          of the eigenvalues of the matrix.  the eigenvalues must be
c          stored in a manner identical to that of subroutine  comlr,
c          which recognizes possible splitting of the matrix.
c
c        select specifies the eigenvectors to be found.  the
c          eigenvector corresponding to the j-th eigenvalue is
c          specified by setting select(j) to .true..
c
c        mm should be set to an upper bound for the number of
c          eigenvectors to be found.
c
c     on output
c
c        ar, ai, wi, and select are unaltered.
c
c        wr may have been altered since close eigenvalues are perturbed
c          slightly in searching for independent eigenvectors.
c
c        m is the number of eigenvectors actually found.
c
c        zr and zi contain the real and imaginary parts, respectively,
c          of the eigenvectors.  the eigenvectors are normalized
c          so that the component of largest magnitude is 1.
c          any vector which fails the acceptance test is set to zero.
c
c        ierr is set to
c          zero       for normal return,
c          -(2*n+1)   if more than mm eigenvectors have been specified,
c          -k         if the iteration corresponding to the k-th
c                     value fails,
c          -(n+k)     if both error situations occur.
c
c        rm1, rm2, rv1, and rv2 are temporary storage arrays.
c
c     the algol procedure guessvec appears in cinvit in line.
c
c     calls cdiv for complex division.
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
*
*     Get ULP from DLAMCH for new small perturbation as in LAPACK
      EXTERNAL DLAMCH
      DOUBLE PRECISION DLAMCH, ULP
      if (n.le.0) return
      ULP = DLAMCH( 'Epsilon' )
c
*
*     Initialize
      OPST = 0
      ierr = 0
      uk = 0
      s = 1
c
      do 980 k = 1, n
         if (.not. select(k)) go to 980
         if (s .gt. mm) go to 1000
         if (uk .ge. k) go to 200
c     .......... check for possible splitting ..........
         do 120 uk = k, n
            if (uk .eq. n) go to 140
            if (ar(uk+1,uk) .eq. 0.0d0 .and. ai(uk+1,uk) .eq. 0.0d0)
     x         go to 140
  120    continue
c     .......... compute infinity norm of leading uk by uk
c                (hessenberg) matrix ..........
  140    norm = 0.0d0
         mp = 1
c
*
*        Increment opcount for loop 180
         OPS = OPS + 6*uk*(uk-1)
         do 180 i = 1, uk
            x = 0.0d0
c
            do 160 j = mp, uk
  160       x = x + pythag(ar(i,j),ai(i,j))
c
            if (x .gt. norm) norm = x
            mp = i
  180    continue
c     .......... eps3 replaces zero pivot in decomposition
c                and close roots are modified by eps3 ..........
         if (norm .eq. 0.0d0) norm = 1.0d0
*         eps3 = epslon(norm)
*
*        Increment opcount for eps3, ukroot
         OPST = OPST + 3
         eps3 = norm*ulp
c     .......... growto is the criterion for growth ..........
         ukroot = uk
         ukroot = dsqrt(ukroot)
         growto = 0.1d0 / ukroot
  200    rlambd = wr(k)
         ilambd = wi(k)
         if (k .eq. 1) go to 280
         km1 = k - 1
         go to 240
c     .......... perturb eigenvalue if it is close
c                to any previous eigenvalue ..........
  220    rlambd = rlambd + eps3
c     .......... for i=k-1 step -1 until 1 do -- ..........
  240    do 260 ii = 1, km1
            i = k - ii
            if (select(i) .and. dabs(wr(i)-rlambd) .lt. eps3 .and.
     x         dabs(wi(i)-ilambd) .lt. eps3) go to 220
  260    continue
c
*
*        Increment opcount for loop 260.
         OPST = OPST + 2*(K-1)
         wr(k) = rlambd
c     .......... form upper hessenberg (ar,ai)-(rlambd,ilambd)*i
c                and initial complex vector ..........
  280    mp = 1
c
*
*        Increment op count for loop 320
         OPS = OPS + 2*uk
         do 320 i = 1, uk
c
            do 300 j = mp, uk
               rm1(i,j) = ar(i,j)
               rm2(i,j) = ai(i,j)
  300       continue
c
            rm1(i,i) = rm1(i,i) - rlambd
            rm2(i,i) = rm2(i,i) - ilambd
            mp = i
            rv1(i) = eps3
  320    continue
c     .......... triangular decomposition with interchanges,
c                replacing zero pivots by eps3 ..........
         if (uk .eq. 1) go to 420
c
*
*        Increment op count for loop 400
         OPS = OPS + (52+4*uk)*(uk-1)
         do 400 i = 2, uk
            mp = i - 1
            if (pythag(rm1(i,mp),rm2(i,mp)) .le.
     x          pythag(rm1(mp,mp),rm2(mp,mp))) go to 360
c
            do 340 j = mp, uk
               y = rm1(i,j)
               rm1(i,j) = rm1(mp,j)
               rm1(mp,j) = y
               y = rm2(i,j)
               rm2(i,j) = rm2(mp,j)
               rm2(mp,j) = y
  340       continue
c
  360       if (rm1(mp,mp) .eq. 0.0d0 .and. rm2(mp,mp) .eq. 0.0d0)
     x         rm1(mp,mp) = eps3
            call cdiv(rm1(i,mp),rm2(i,mp),rm1(mp,mp),rm2(mp,mp),x,y)
            if (x .eq. 0.0d0 .and. y .eq. 0.0d0) go to 400
c
            do 380 j = i, uk
               rm1(i,j) = rm1(i,j) - x * rm1(mp,j) + y * rm2(mp,j)
               rm2(i,j) = rm2(i,j) - x * rm2(mp,j) - y * rm1(mp,j)
  380       continue
c
  400    continue
c
  420    if (rm1(uk,uk) .eq. 0.0d0 .and. rm2(uk,uk) .eq. 0.0d0)
     x      rm1(uk,uk) = eps3
         its = 0
c     .......... back substitution
c                for i=uk step -1 until 1 do -- ..........
  660    do 720 ii = 1, uk
            i = uk + 1 - ii
            x = rv1(i)
            y = 0.0d0
            if (i .eq. uk) go to 700
            ip1 = i + 1
c
            do 680 j = ip1, uk
               x = x - rm1(i,j) * rv1(j) + rm2(i,j) * rv2(j)
               y = y - rm1(i,j) * rv2(j) - rm2(i,j) * rv1(j)
  680       continue
c
  700       call cdiv(x,y,rm1(i,i),rm2(i,i),rv1(i),rv2(i))
  720    continue
*
*        Increment op count for back substitution loop 720
         OPS = OPS + 4*uk*(uk+3)
c     .......... acceptance test for eigenvector
c                and normalization ..........
         its = its + 1
         norm = 0.0d0
         normv = 0.0d0
c
*
*        Increment op count acceptance test
         OPS = OPS + 19*uk
         do 780 i = 1, uk
            x = pythag(rv1(i),rv2(i))
            if (normv .ge. x) go to 760
            normv = x
            j = i
  760       norm = norm + x
  780    continue
c
         if (norm .lt. growto) go to 840
c     .......... accept vector ..........
         x = rv1(j)
         y = rv2(j)
c
*
*        Increment op count accept vector loop 820
         OPS = OPS + 16*uk
         do 820 i = 1, uk
            call cdiv(rv1(i),rv2(i),x,y,zr(i,s),zi(i,s))
  820    continue
c
         if (uk .eq. n) go to 940
         j = uk + 1
         go to 900
c     .......... in-line procedure for choosing
c                a new starting vector ..........
  840    if (its .ge. uk) go to 880
         x = ukroot
         y = eps3 / (x + 1.0d0)
         rv1(1) = eps3
c
         do 860 i = 2, uk
  860    rv1(i) = y
c
         j = uk - its + 1
         rv1(j) = rv1(j) - eps3 * x
         go to 660
c     .......... set error -- unaccepted eigenvector ..........
  880    j = 1
         ierr = -k
c     .......... set remaining vector components to zero ..........
  900    do 920 i = j, n
            zr(i,s) = 0.0d0
            zi(i,s) = 0.0d0
  920    continue
c
  940    s = s + 1
  980 continue
c
      go to 1001
c     .......... set error -- underestimate of eigenvector
c                space required ..........
 1000 if (ierr .ne. 0) ierr = ierr - n
      if (ierr .eq. 0) ierr = -(2 * n + 1)
 1001 m = s - 1
*
*     Compute final op count
      OPS = OPS + OPST
      return
      end
      subroutine comqr(nm,n,low,igh,hr,hi,wr,wi,ierr)
c
      integer i,j,l,n,en,ll,nm,igh,itn,its,low,lp1,enm1,ierr
      double precision hr(nm,n),hi(nm,n),wr(n),wi(n)
      double precision si,sr,ti,tr,xi,xr,yi,yr,zzi,zzr,norm,tst1,tst2,
     x       pythag
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common Blocks ..
      COMMON /LATIME/ OPS, ITCNT
      COMMON /PYTHOP/ OPST
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION OPS, ITCNT, OPST
*     ..
c
c     this subroutine is a translation of a unitary analogue of the
c     algol procedure  comlr, num. math. 12, 369-376(1968) by martin
c     and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 396-403(1971).
c     the unitary analogue substitutes the qr algorithm of francis
c     (comp. jour. 4, 332-345(1962)) for the lr algorithm.
c
c     this subroutine finds the eigenvalues of a complex
c     upper hessenberg matrix by the qr method.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        low and igh are integers determined by the balancing
c          subroutine  cbal.  if  cbal  has not been used,
c          set low=1, igh=n.
c
c        hr and hi contain the real and imaginary parts,
c          respectively, of the complex upper hessenberg matrix.
c          their lower triangles below the subdiagonal contain
c          information about the unitary transformations used in
c          the reduction by  corth, if performed.
c
c     on output
c
c        the upper hessenberg portions of hr and hi have been
c          destroyed.  therefore, they must be saved before
c          calling  comqr  if subsequent calculation of
c          eigenvectors is to be performed.
c
c        wr and wi contain the real and imaginary parts,
c          respectively, of the eigenvalues.  if an error
c          exit is made, the eigenvalues should be correct
c          for indices ierr+1,...,n.
c
c        ierr is set to
c          zero       for normal return,
c          j          if the limit of 30*n iterations is exhausted
c                     while the j-th eigenvalue is being sought.
c
c     calls cdiv for complex division.
c     calls csroot for complex square root.
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
*
      EXTERNAL DLAMCH
      DOUBLE PRECISION DLAMCH, UNFL,OVFL,ULP,SMLNUM,SMALL
      intrinsic max, min
*
      if (n.le.0) return
*
*     Compute the 1-norm of matrix H
*
      norm = 0.0d0
      do 5 j = low, igh
         sr = 0.0d0
         do 4 i = low, min(igh,j+1)
              sr = sr + pythag(hr(i,j),hi(i,j))
  4      continue
         norm = max(norm, sr)
  5   continue
*
*     Get SMALL for new convergence criterion as in LAPACK
*
      UNFL = DLAMCH( 'Safe minimum' )
      OVFL = DLAMCH( 'Overflow' )
      ULP = DLAMCH( 'Epsilon' )*DLAMCH( 'Base' )
      SMLNUM = MAX( UNFL*( N / ULP ), N / ( ULP*OVFL ) )
      SMALL = MAX( SMLNUM, ULP*NORM )
*
*
*     Initialize
      ITCNT = 0
      OPST = 0
      ierr = 0
      if (low .eq. igh) go to 180
c     .......... create real subdiagonal elements ..........
      l = low + 1
c
*
*        Increment op count for loop 170
         OPS = OPS + (6*(igh-low+1)+32)*(igh-l+1)
      do 170 i = l, igh
         ll = min0(i+1,igh)
         if (hi(i,i-1) .eq. 0.0d0) go to 170
         norm = pythag(hr(i,i-1),hi(i,i-1))
         yr = hr(i,i-1) / norm
         yi = hi(i,i-1) / norm
         hr(i,i-1) = norm
         hi(i,i-1) = 0.0d0
c
         do 155 j = i, igh
            si = yr * hi(i,j) - yi * hr(i,j)
            hr(i,j) = yr * hr(i,j) + yi * hi(i,j)
            hi(i,j) = si
  155    continue
c
         do 160 j = low, ll
            si = yr * hi(j,i) + yi * hr(j,i)
            hr(j,i) = yr * hr(j,i) - yi * hi(j,i)
            hi(j,i) = si
  160    continue
c
  170 continue
c     .......... store roots isolated by cbal ..........
  180 do 200 i = 1, n
         if (i .ge. low .and. i .le. igh) go to 200
         wr(i) = hr(i,i)
         wi(i) = hi(i,i)
  200 continue
c
      en = igh
      tr = 0.0d0
      ti = 0.0d0
      itn = 30*n
c     .......... search for next eigenvalue ..........
  220 if (en .lt. low) go to 1001
      its = 0
      enm1 = en - 1
c     .......... look for single small sub-diagonal element
c                for l=en step -1 until low e0 -- ..........
  240 do 260 ll = low, en
         l = en + low - ll
         if (l .eq. low) go to 300
         tst1 = dabs(hr(l-1,l-1)) + dabs(hi(l-1,l-1))
     x            + dabs(hr(l,l)) + dabs(hi(l,l))
*         tst2 = tst1 + abs(hr(l,l-1))
*         if (tst2 .eq. tst1) go to 300
         tst2 = abs(hr(l,l-1))
         if ( tst2 .le. min(ulp*tst1,small) ) go to 300
  260 continue
c     .......... form shift ..........
  300 continue
*
*        Increment op count for convergence test
         OPS = OPS + 4*(en-l+1)
      if (l .eq. en) go to 660
      if (itn .eq. 0) go to 1000
      if (its .eq. 10 .or. its .eq. 20) go to 320
*
*        Increment opcount for foming shift
         OPST = OPST + 58
      sr = hr(en,en)
      si = hi(en,en)
      xr = hr(enm1,en) * hr(en,enm1)
      xi = hi(enm1,en) * hr(en,enm1)
      if (xr .eq. 0.0d0 .and. xi .eq. 0.0d0) go to 340
      yr = (hr(enm1,enm1) - sr) / 2.0d0
      yi = (hi(enm1,enm1) - si) / 2.0d0
      call csroot(yr**2-yi**2+xr,2.0d0*yr*yi+xi,zzr,zzi)
      if (yr * zzr + yi * zzi .ge. 0.0d0) go to 310
      zzr = -zzr
      zzi = -zzi
  310 call cdiv(xr,xi,yr+zzr,yi+zzi,xr,xi)
      sr = sr - xr
      si = si - xi
      go to 340
c     .......... form exceptional shift ..........
  320 sr = dabs(hr(en,enm1)) + dabs(hr(enm1,en-2))
      si = 0.0d0
c
  340 do 360 i = low, en
         hr(i,i) = hr(i,i) - sr
         hi(i,i) = hi(i,i) - si
  360 continue
*
*        Increment opcount for loop 360
         OPS = OPS + 2*EN
c
      tr = tr + sr
      ti = ti + si
      its = its + 1
      itn = itn - 1
*
*       Update iteration number
        ITCNT = 30*N - ITN
c     .......... reduce to triangle (rows) ..........
      lp1 = l + 1
c
*
*        Increment opcount for reducing to triangular, loop 500
         OPS = OPS + (en-lp1+1)*(61+10*(en-lp1))
      do 500 i = lp1, en
         sr = hr(i,i-1)
         hr(i,i-1) = 0.0d0
         norm = pythag(pythag(hr(i-1,i-1),hi(i-1,i-1)),sr)
         xr = hr(i-1,i-1) / norm
         wr(i-1) = xr
         xi = hi(i-1,i-1) / norm
         wi(i-1) = xi
         hr(i-1,i-1) = norm
         hi(i-1,i-1) = 0.0d0
         hi(i,i-1) = sr / norm
c
         do 490 j = i, en
            yr = hr(i-1,j)
            yi = hi(i-1,j)
            zzr = hr(i,j)
            zzi = hi(i,j)
            hr(i-1,j) = xr * yr + xi * yi + hi(i,i-1) * zzr
            hi(i-1,j) = xr * yi - xi * yr + hi(i,i-1) * zzi
            hr(i,j) = xr * zzr - xi * zzi - hi(i,i-1) * yr
            hi(i,j) = xr * zzi + xi * zzr - hi(i,i-1) * yi
  490    continue
c
  500 continue
c
      si = hi(en,en)
      if (si .eq. 0.0d0) go to 540
      norm = pythag(hr(en,en),si)
      sr = hr(en,en) / norm
      si = si / norm
      hr(en,en) = norm
      hi(en,en) = 0.0d0
*
*        Increment opcount
         OPST = OPST +20
c     .......... inverse operation (columns) ..........
  540 do 600 j = lp1, en
         xr = wr(j-1)
         xi = wi(j-1)
c
         do 580 i = l, j
            yr = hr(i,j-1)
            yi = 0.0d0
            zzr = hr(i,j)
            zzi = hi(i,j)
            if (i .eq. j) go to 560
            yi = hi(i,j-1)
            hi(i,j-1) = xr * yi + xi * yr + hi(j,j-1) * zzi
  560       hr(i,j-1) = xr * yr - xi * yi + hi(j,j-1) * zzr
            hr(i,j) = xr * zzr + xi * zzi - hi(j,j-1) * yr
            hi(i,j) = xr * zzi - xi * zzr - hi(j,j-1) * yi
  580    continue
c
  600 continue
*
*        Increment opcount for inverse operation loop 600
         OPS = OPS + 10*(en-lp1+1)*(en+lp1)
c
      if (si .eq. 0.0d0) go to 240
c
*
*        Increment op count for loop 630
         OPS = OPS + 6*(en-l+1)
      do 630 i = l, en
         yr = hr(i,en)
         yi = hi(i,en)
         hr(i,en) = sr * yr - si * yi
         hi(i,en) = sr * yi + si * yr
  630 continue
c
      go to 240
c     .......... a root found ..........
  660 wr(en) = hr(en,en) + tr
      wi(en) = hi(en,en) + ti
      en = enm1
      go to 220
c     .......... set error -- all eigenvalues have not
c                converged after 30*n iterations ..........
 1000 ierr = en
 1001 continue
*
*     Compute final op count
      OPS = OPS + OPST
      return
      end
      subroutine comqr2(nm,n,low,igh,ortr,orti,hr,hi,wr,wi,zr,zi,ierr)
c
      integer i,j,k,l,m,n,en,ii,jj,ll,nm,nn,igh,ip1,
     x        itn,its,low,lp1,enm1,iend,ierr
      double precision hr(nm,n),hi(nm,n),wr(n),wi(n),zr(nm,n),zi(nm,n),
     x       ortr(igh),orti(igh)
      double precision si,sr,ti,tr,xi,xr,yi,yr,zzi,zzr,norm,tst1,tst2,
     x       pythag
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common Blocks ..
      COMMON /LATIME/ OPS, ITCNT
      COMMON /PYTHOP/ OPST
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION OPS, ITCNT, OPST
*     ..
c
c     this subroutine is a translation of a unitary analogue of the
c     algol procedure  comlr2, num. math. 16, 181-204(1970) by peters
c     and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 372-395(1971).
c     the unitary analogue substitutes the qr algorithm of francis
c     (comp. jour. 4, 332-345(1962)) for the lr algorithm.
c
c     this subroutine finds the eigenvalues and eigenvectors
c     of a complex upper hessenberg matrix by the qr
c     method.  the eigenvectors of a complex general matrix
c     can also be found if  corth  has been used to reduce
c     this general matrix to hessenberg form.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        low and igh are integers determined by the balancing
c          subroutine  cbal.  if  cbal  has not been used,
c          set low=1, igh=n.
c
c        ortr and orti contain information about the unitary trans-
c          formations used in the reduction by  corth, if performed.
c          only elements low through igh are used.  if the eigenvectors
c          of the hessenberg matrix are desired, set ortr(j) and
c          orti(j) to 0.0d0 for these elements.
c
c        hr and hi contain the real and imaginary parts,
c          respectively, of the complex upper hessenberg matrix.
c          their lower triangles below the subdiagonal contain further
c          information about the transformations which were used in the
c          reduction by  corth, if performed.  if the eigenvectors of
c          the hessenberg matrix are desired, these elements may be
c          arbitrary.
c
c     on output
c
c        ortr, orti, and the upper hessenberg portions of hr and hi
c          have been destroyed.
c
c        wr and wi contain the real and imaginary parts,
c          respectively, of the eigenvalues.  if an error
c          exit is made, the eigenvalues should be correct
c          for indices ierr+1,...,n.
c
c        zr and zi contain the real and imaginary parts,
c          respectively, of the eigenvectors.  the eigenvectors
c          are unnormalized.  if an error exit is made, none of
c          the eigenvectors has been found.
c
c        ierr is set to
c          zero       for normal return,
c          j          if the limit of 30*n iterations is exhausted
c                     while the j-th eigenvalue is being sought.
c
c     calls cdiv for complex division.
c     calls csroot for complex square root.
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
*     The original DO statements
*
*         do 840 i = 1, enm1
*         do 820 j = ip1, n
*         do 880 jj = low, enm1
*
*     have been changed to
*
*         do 840 i = 1, N
*         do 820 j = I, n
*         do 880 jj = low, N
*
*     according to Burt Garbow's suggestion on NA-net.
*     Zhaojun Bai, Nov.28, 1989
c     ------------------------------------------------------------------
c
*
      EXTERNAL DLAMCH
      DOUBLE PRECISION DLAMCH, UNFL,OVFL,ULP,SMLNUM,SMALL
      intrinsic max, min
*
      if (n.le.0) return
*
*     Compute the 1-norm of matrix H
*
      norm = 0.0d0
      do 5 j = 1,n
         sr = 0.0d0
         do 4 i = 1, min(n,j+1)
              sr = sr + pythag(hr(i,j),hi(i,j))
  4      continue
         norm = max(norm, sr)
  5   continue
*
*     Get SMALL for new convergence criterion as in LAPACK
*
      UNFL = DLAMCH( 'Safe minimum' )
      OVFL = DLAMCH( 'Overflow' )
      ULP = DLAMCH( 'Epsilon' )*DLAMCH( 'Base' )
      SMLNUM = MAX( UNFL*( N / ULP ), N / ( ULP*OVFL ) )
      SMALL = MAX( SMLNUM, MIN( ( NORM*SMLNUM )*NORM, ULP*NORM ) )
*
*
*     Initialize
      ITCNT = 0
      OPST = 0
      ierr = 0
c     .......... initialize eigenvector matrix ..........
      do 101 j = 1, n
c
         do 100 i = 1, n
            zr(i,j) = 0.0d0
            zi(i,j) = 0.0d0
  100    continue
         zr(j,j) = 1.0d0
  101 continue
c     .......... form the matrix of accumulated transformations
c                from the information left by corth ..........
      iend = igh - low - 1
      if (iend) 180, 150, 105
c     .......... for i=igh-1 step -1 until low+1 do -- ..........
  105 do 140 ii = 1, iend
         i = igh - ii
         if (ortr(i) .eq. 0.0d0 .and. orti(i) .eq. 0.0d0) go to 140
         if (hr(i,i-1) .eq. 0.0d0 .and. hi(i,i-1) .eq. 0.0d0) go to 140
c     .......... norm below is negative of h formed in corth ..........
         norm = hr(i,i-1) * ortr(i) + hi(i,i-1) * orti(i)
         ip1 = i + 1
c
         do 110 k = ip1, igh
            ortr(k) = hr(k,i-1)
            orti(k) = hi(k,i-1)
  110    continue
c
*
*        Increment op count for loop 130
         OPS = OPS + (16*(igh-i+1)+2)*(igh-i+1)
         do 130 j = i, igh
            sr = 0.0d0
            si = 0.0d0
c
            do 115 k = i, igh
               sr = sr + ortr(k) * zr(k,j) + orti(k) * zi(k,j)
               si = si + ortr(k) * zi(k,j) - orti(k) * zr(k,j)
  115       continue
c
            sr = sr / norm
            si = si / norm
c
            do 120 k = i, igh
               zr(k,j) = zr(k,j) + sr * ortr(k) - si * orti(k)
               zi(k,j) = zi(k,j) + sr * orti(k) + si * ortr(k)
  120       continue
c
  130    continue
c
  140 continue
*
*        Increment op count for computing norm in loop 140
         OPS = OPS + 3*iend
c     .......... create real subdiagonal elements ..........
  150 l = low + 1
c
*
*        Increment op count for loop 170
         OPS = OPS + (12*(igh-low+1)+42)*(igh-l+1)
      do 170 i = l, igh
         ll = min0(i+1,igh)
         if (hi(i,i-1) .eq. 0.0d0) go to 170
         norm = pythag(hr(i,i-1),hi(i,i-1))
         yr = hr(i,i-1) / norm
         yi = hi(i,i-1) / norm
         hr(i,i-1) = norm
         hi(i,i-1) = 0.0d0
c
         do 155 j = i, n
            si = yr * hi(i,j) - yi * hr(i,j)
            hr(i,j) = yr * hr(i,j) + yi * hi(i,j)
            hi(i,j) = si
  155    continue
c
         do 160 j = 1, ll
            si = yr * hi(j,i) + yi * hr(j,i)
            hr(j,i) = yr * hr(j,i) - yi * hi(j,i)
            hi(j,i) = si
  160    continue
c
         do 165 j = low, igh
            si = yr * zi(j,i) + yi * zr(j,i)
            zr(j,i) = yr * zr(j,i) - yi * zi(j,i)
            zi(j,i) = si
  165    continue
c
  170 continue
c     .......... store roots isolated by cbal ..........
  180 do 200 i = 1, n
         if (i .ge. low .and. i .le. igh) go to 200
         wr(i) = hr(i,i)
         wi(i) = hi(i,i)
  200 continue
c
      en = igh
      tr = 0.0d0
      ti = 0.0d0
      itn = 30*n
c     .......... search for next eigenvalue ..........
  220 if (en .lt. low) go to 680
      its = 0
      enm1 = en - 1
c     .......... look for single small sub-diagonal element
c                for l=en step -1 until low do -- ..........
  240 do 260 ll = low, en
         l = en + low - ll
         if (l .eq. low) go to 300
         tst1 = dabs(hr(l-1,l-1)) + dabs(hi(l-1,l-1))
     x            + dabs(hr(l,l)) + dabs(hi(l,l))
*         tst2 = tst1 + abs(hr(l,l-1))
*         if (tst2 .eq. tst1) go to 300
         tst2 = abs(hr(l,l-1))
         if ( tst2 .le. min(ulp*tst1,small) ) go to 300
  260 continue
c     .......... form shift ..........
  300 continue
*
*        Increment op count for convergence test
         OPS = OPS + 4*(en-l+1)
      if (l .eq. en) go to 660
      if (itn .eq. 0) go to 1000
      if (its .eq. 10 .or. its .eq. 20) go to 320
*
*        Increment opcount for foming shift
         OPST = OPST + 58
      sr = hr(en,en)
      si = hi(en,en)
      xr = hr(enm1,en) * hr(en,enm1)
      xi = hi(enm1,en) * hr(en,enm1)
      if (xr .eq. 0.0d0 .and. xi .eq. 0.0d0) go to 340
      yr = (hr(enm1,enm1) - sr) / 2.0d0
      yi = (hi(enm1,enm1) - si) / 2.0d0
      call csroot(yr**2-yi**2+xr,2.0d0*yr*yi+xi,zzr,zzi)
      if (yr * zzr + yi * zzi .ge. 0.0d0) go to 310
      zzr = -zzr
      zzi = -zzi
  310 call cdiv(xr,xi,yr+zzr,yi+zzi,xr,xi)
      sr = sr - xr
      si = si - xi
      go to 340
c     .......... form exceptional shift ..........
  320 sr = dabs(hr(en,enm1)) + dabs(hr(enm1,en-2))
      si = 0.0d0
c
  340 do 360 i = low, en
         hr(i,i) = hr(i,i) - sr
         hi(i,i) = hi(i,i) - si
  360 continue
*
*        Increment opcount for loop 360
         OPS = OPS + 2*(en-low+1)
c
      tr = tr + sr
      ti = ti + si
      its = its + 1
      itn = itn - 1
*
*       Update iteration number
        ITCNT = 30*N - ITN
c     .......... reduce to triangle (rows) ..........
      lp1 = l + 1
c
*
*        Increment opcount for reducing to triangular, loop 500
         OPS = OPS + (en-lp1+1)*(61+10*(en-lp1))
      do 500 i = lp1, en
         sr = hr(i,i-1)
         hr(i,i-1) = 0.0d0
         norm = pythag(pythag(hr(i-1,i-1),hi(i-1,i-1)),sr)
         xr = hr(i-1,i-1) / norm
         wr(i-1) = xr
         xi = hi(i-1,i-1) / norm
         wi(i-1) = xi
         hr(i-1,i-1) = norm
         hi(i-1,i-1) = 0.0d0
         hi(i,i-1) = sr / norm
c
         do 490 j = i, n
            yr = hr(i-1,j)
            yi = hi(i-1,j)
            zzr = hr(i,j)
            zzi = hi(i,j)
            hr(i-1,j) = xr * yr + xi * yi + hi(i,i-1) * zzr
            hi(i-1,j) = xr * yi - xi * yr + hi(i,i-1) * zzi
            hr(i,j) = xr * zzr - xi * zzi - hi(i,i-1) * yr
            hi(i,j) = xr * zzi + xi * zzr - hi(i,i-1) * yi
  490    continue
c
  500 continue
c
      si = hi(en,en)
      if (si .eq. 0.0d0) go to 540
      norm = pythag(hr(en,en),si)
      sr = hr(en,en) / norm
      si = si / norm
      hr(en,en) = norm
      hi(en,en) = 0.0d0
*
*        Increment op count
         OPST = OPST +20
      if (en .eq. n) go to 540
      ip1 = en + 1
c
*
*        Increment op count for loop 520
         OPST = OPST + 6*(n-ip1+1)
      do 520 j = ip1, n
         yr = hr(en,j)
         yi = hi(en,j)
         hr(en,j) = sr * yr + si * yi
         hi(en,j) = sr * yi - si * yr
  520 continue
c     .......... inverse operation (columns) ..........
  540 do 600 j = lp1, en
         xr = wr(j-1)
         xi = wi(j-1)
c
         do 580 i = 1, j
            yr = hr(i,j-1)
            yi = 0.0d0
            zzr = hr(i,j)
            zzi = hi(i,j)
            if (i .eq. j) go to 560
            yi = hi(i,j-1)
            hi(i,j-1) = xr * yi + xi * yr + hi(j,j-1) * zzi
  560       hr(i,j-1) = xr * yr - xi * yi + hi(j,j-1) * zzr
            hr(i,j) = xr * zzr + xi * zzi - hi(j,j-1) * yr
            hi(i,j) = xr * zzi - xi * zzr - hi(j,j-1) * yi
  580    continue
c
         do 590 i = low, igh
            yr = zr(i,j-1)
            yi = zi(i,j-1)
            zzr = zr(i,j)
            zzi = zi(i,j)
            zr(i,j-1) = xr * yr - xi * yi + hi(j,j-1) * zzr
            zi(i,j-1) = xr * yi + xi * yr + hi(j,j-1) * zzi
            zr(i,j) = xr * zzr + xi * zzi - hi(j,j-1) * yr
            zi(i,j) = xr * zzi - xi * zzr - hi(j,j-1) * yi
  590    continue
c
  600 continue
*
*        Increment opcount for inverse operation loop 600
         OPS = OPS + ( 10*(en+lp1) + 20*(igh-low+1) )*(en-lp1+1)
c
      if (si .eq. 0.0d0) go to 240
c
*
*        Increment opcount for loop 630 and 640
         OPS = OPS + 6*en + 6*(igh-low+1)
      do 630 i = 1, en
         yr = hr(i,en)
         yi = hi(i,en)
         hr(i,en) = sr * yr - si * yi
         hi(i,en) = sr * yi + si * yr
  630 continue
c
      do 640 i = low, igh
         yr = zr(i,en)
         yi = zi(i,en)
         zr(i,en) = sr * yr - si * yi
         zi(i,en) = sr * yi + si * yr
  640 continue
c
      go to 240
c     .......... a root found ..........
  660 hr(en,en) = hr(en,en) + tr
      wr(en) = hr(en,en)
      hi(en,en) = hi(en,en) + ti
      wi(en) = hi(en,en)
      en = enm1
      go to 220
c     .......... all roots found.  backsubstitute to find
c                vectors of upper triangular form ..........
  680 norm = 0.0d0
c
*
*        Increment op count for loop 720
         OPS = OPS + n*(n+1)/2
      do 720 i = 1, n
c
         do 720 j = i, n
            tr = dabs(hr(i,j)) + dabs(hi(i,j))
            if (tr .gt. norm) norm = tr
  720 continue
c
      if (n .eq. 1 .or. norm .eq. 0.0d0) go to 1001
c     .......... for en=n step -1 until 2 do -- ..........
      do 800 nn = 2, n
         en = n + 2 - nn
         xr = wr(en)
         xi = wi(en)
         hr(en,en) = 1.0d0
         hi(en,en) = 0.0d0
         enm1 = en - 1
c     .......... for i=en-1 step -1 until 1 do -- ..........
*
*        Increment op count for comput yr, .. in loop 780
         OPS = OPS + 22*enm1
         do 780 ii = 1, enm1
            i = en - ii
            zzr = 0.0d0
            zzi = 0.0d0
            ip1 = i + 1
c
*
*        Increment op count for loop 740
         OPS = OPS + 7*(en-ip1+1)
            do 740 j = ip1, en
               zzr = zzr + hr(i,j) * hr(j,en) - hi(i,j) * hi(j,en)
               zzi = zzi + hr(i,j) * hi(j,en) + hi(i,j) * hr(j,en)
  740       continue
c
            yr = xr - wr(i)
            yi = xi - wi(i)
            if (yr .ne. 0.0d0 .or. yi .ne. 0.0d0) go to 765
               tst1 = norm
               yr = tst1
  760          yr = 0.01d0 * yr
               tst2 = norm + yr
               if (tst2 .gt. tst1) go to 760
  765       continue
            call cdiv(zzr,zzi,yr,yi,hr(i,en),hi(i,en))
*
*        Increment op count for cdiv
         OPST = OPST + 16
c     .......... overflow control ..........
            tr = dabs(hr(i,en)) + dabs(hi(i,en))
            if (tr .eq. 0.0d0) go to 780
            tst1 = tr
            tst2 = tst1 + 1.0d0/tst1
            if (tst2 .gt. tst1) go to 780
*
*        Increment op count for loop 770
         OPS = OPS + 2*(en-i+1)
            do 770 j = i, en
               hr(j,en) = hr(j,en)/tr
               hi(j,en) = hi(j,en)/tr
  770       continue
c
  780    continue
c
  800 continue
c     .......... end backsubstitution ..........
      enm1 = n - 1
c     .......... vectors of isolated roots ..........
      do  840 i = 1, n
         if (i .ge. low .and. i .le. igh) go to 840
         ip1 = i + 1
c
         do 820 j = i, n
            zr(i,j) = hr(i,j)
            zi(i,j) = hi(i,j)
  820    continue
c
  840 continue
c     .......... multiply by transformation matrix to give
c                vectors of original full matrix.
c                for j=n step -1 until low+1 do -- ..........
      do 880 jj = low, n
         j = n + low - jj
         m = min0(j,igh)
c
*
*        Increment op count for loop 880
         OPS = OPS + 8*(m-low+1)*(igh-low+1)
         do 880 i = low, igh
            zzr = 0.0d0
            zzi = 0.0d0
c
            do 860 k = low, m
               zzr = zzr + zr(i,k) * hr(k,j) - zi(i,k) * hi(k,j)
               zzi = zzi + zr(i,k) * hi(k,j) + zi(i,k) * hr(k,j)
  860       continue
c
            zr(i,j) = zzr
            zi(i,j) = zzi
  880 continue
c
      go to 1001
c     .......... set error -- all eigenvalues have not
c                converged after 30*n iterations ..........
 1000 ierr = en
 1001 continue
*
*     Compute final op count
      OPS = OPS + OPST
      return
      end
      subroutine corth(nm,n,low,igh,ar,ai,ortr,orti)
c
      integer i,j,m,n,ii,jj,la,mp,nm,igh,kp1,low
      double precision ar(nm,n),ai(nm,n),ortr(igh),orti(igh)
      double precision f,g,h,fi,fr,scale,pythag
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common Blocks ..
      COMMON /LATIME/ OPS, ITCNT
      COMMON /PYTHOP/ OPST
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION OPS, ITCNT, OPST
*     ..
c
c     this subroutine is a translation of a complex analogue of
c     the algol procedure orthes, num. math. 12, 349-368(1968)
c     by martin and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 339-358(1971).
c
c     given a complex general matrix, this subroutine
c     reduces a submatrix situated in rows and columns
c     low through igh to upper hessenberg form by
c     unitary similarity transformations.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        low and igh are integers determined by the balancing
c          subroutine  cbal.  if  cbal  has not been used,
c          set low=1, igh=n.
c
c        ar and ai contain the real and imaginary parts,
c          respectively, of the complex input matrix.
c
c     on output
c
c        ar and ai contain the real and imaginary parts,
c          respectively, of the hessenberg matrix.  information
c          about the unitary transformations used in the reduction
c          is stored in the remaining triangles under the
c          hessenberg matrix.
c
c        ortr and orti contain further information about the
c          transformations.  only elements low through igh are used.
c
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      if (n.le.0) return
***
*     Initialize
      OPST = 0
***
      la = igh - 1
      kp1 = low + 1
      if (la .lt. kp1) go to 200
c
      do 180 m = kp1, la
         h = 0.0d0
         ortr(m) = 0.0d0
         orti(m) = 0.0d0
         scale = 0.0d0
c     .......... scale column (algol tol then not needed) ..........
         do 90 i = m, igh
   90    scale = scale + dabs(ar(i,m-1)) + dabs(ai(i,m-1))
***
*        Increment opcount for loop 90
         OPS = OPS + 2*(igh-m+1)
***
c
         if (scale .eq. 0.0d0) go to 180
         mp = m + igh
c     .......... for i=igh step -1 until m do -- ..........
         do 100 ii = m, igh
            i = mp - ii
            ortr(i) = ar(i,m-1) / scale
            orti(i) = ai(i,m-1) / scale
            h = h + ortr(i) * ortr(i) + orti(i) * orti(i)
  100    continue
***
*        Increment op count for loop 100 and sqrt
         OPS = OPS + 6*(igh-m+1) + 1
***
c
         g = dsqrt(h)
         f = pythag(ortr(m),orti(m))
         if (f .eq. 0.0d0) go to 103
         h = h + f * g
         g = g / f
         ortr(m) = (1.0d0 + g) * ortr(m)
         orti(m) = (1.0d0 + g) * orti(m)
         OPST = OPST + 7
         go to 105
c
  103    ortr(m) = g
         ar(m,m-1) = scale
c     .......... form (i-(u*ut)/h) * a ..........
  105    do 130 j = m, n
            fr = 0.0d0
            fi = 0.0d0
c     .......... for i=igh step -1 until m do -- ..........
            do 110 ii = m, igh
               i = mp - ii
               fr = fr + ortr(i) * ar(i,j) + orti(i) * ai(i,j)
               fi = fi + ortr(i) * ai(i,j) - orti(i) * ar(i,j)
  110       continue
c
            fr = fr / h
            fi = fi / h
c
            do 120 i = m, igh
               ar(i,j) = ar(i,j) - fr * ortr(i) + fi * orti(i)
               ai(i,j) = ai(i,j) - fr * orti(i) - fi * ortr(i)
  120       continue
c
  130    continue
c     .......... form (i-(u*ut)/h)*a*(i-(u*ut)/h) ..........
         do 160 i = 1, igh
            fr = 0.0d0
            fi = 0.0d0
c     .......... for j=igh step -1 until m do -- ..........
            do 140 jj = m, igh
               j = mp - jj
               fr = fr + ortr(j) * ar(i,j) - orti(j) * ai(i,j)
               fi = fi + ortr(j) * ai(i,j) + orti(j) * ar(i,j)
  140       continue
c
            fr = fr / h
            fi = fi / h
c
            do 150 j = m, igh
               ar(i,j) = ar(i,j) - fr * ortr(j) - fi * orti(j)
               ai(i,j) = ai(i,j) + fr * orti(j) - fi * ortr(j)
  150       continue
c
  160    continue
***
*        Increment op count for loops 130 and 160
         OPS = OPS + (igh+n-m+1)*((igh-m+1)*16 + 2)
         OPST = OPST + 4
***
c
         ortr(m) = scale * ortr(m)
         orti(m) = scale * orti(m)
         ar(m,m-1) = -g * ar(m,m-1)
         ai(m,m-1) = -g * ai(m,m-1)
  180 continue
      OPS = OPS + OPST
c
  200 return
      end
      subroutine csroot(xr,xi,yr,yi)
      double precision xr,xi,yr,yi
c
c     (yr,yi) = complex sqrt(xr,xi)
c     branch chosen so that yr .ge. 0.0 and sign(yi) .eq. sign(xi)
c
      double precision s,tr,ti,pythag
      tr = xr
      ti = xi
      s = dsqrt(0.5d0*(pythag(tr,ti) + dabs(tr)))
      if (tr .ge. 0.0d0) yr = s
      if (ti .lt. 0.0d0) s = -s
      if (tr .le. 0.0d0) yi = s
      if (tr .lt. 0.0d0) yr = 0.5d0*(ti/yi)
      if (tr .gt. 0.0d0) yi = 0.5d0*(ti/yr)
      return
      end
      subroutine htribk(nm,n,ar,ai,tau,m,zr,zi)
c
      integer i,j,k,l,m,n,nm
      double precision ar(nm,n),ai(nm,n),tau(2,n),zr(nm,m),zi(nm,m)
      double precision h,s,si
*
*     Common block to return operation count and iteration count.
*     ITCNT is initialized to 0, OPS is only incremented.
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
c
c     this subroutine is a translation of a complex analogue of
c     the algol procedure trbak1, num. math. 11, 181-195(1968)
c     by martin, reinsch, and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 212-226(1971).
c
c     this subroutine forms the eigenvectors of a complex hermitian
c     matrix by back transforming those of the corresponding
c     real symmetric tridiagonal matrix determined by  htridi.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        ar and ai contain information about the unitary trans-
c          formations used in the reduction by  htridi  in their
c          full lower triangles except for the diagonal of ar.
c
c        tau contains further information about the transformations.
c
c        m is the number of eigenvectors to be back transformed.
c
c        zr contains the eigenvectors to be back transformed
c          in its first m columns.
c
c     on output
c
c        zr and zi contain the real and imaginary parts,
c          respectively, of the transformed eigenvectors
c          in their first m columns.
c
c     note that the last component of each returned vector
c     is real and that vector euclidean norms are preserved.
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      if (m .eq. 0) go to 200
*
      OPS = OPS + MAX( 0.0D0, 8*M*DBLE(N)**2 - 2*M*DBLE(N) - 4*M )
*
c     .......... transform the eigenvectors of the real symmetric
c                tridiagonal matrix to those of the hermitian
c                tridiagonal matrix. ..........
      do 50 k = 1, n
c
         do 50 j = 1, m
            zi(k,j) = -zr(k,j) * tau(2,k)
            zr(k,j) = zr(k,j) * tau(1,k)
   50 continue
c
      if (n .eq. 1) go to 200
c     .......... recover and apply the householder matrices ..........
      do 140 i = 2, n
         l = i - 1
         h = ai(i,i)
         if (h .eq. 0.0d0) go to 140
c
         do 130 j = 1, m
            s = 0.0d0
            si = 0.0d0
c
            do 110 k = 1, l
               s = s + ar(i,k) * zr(k,j) - ai(i,k) * zi(k,j)
               si = si + ar(i,k) * zi(k,j) + ai(i,k) * zr(k,j)
  110       continue
c     .......... double divisions avoid possible underflow ..........
            s = (s / h) / h
            si = (si / h) / h
c
            do 120 k = 1, l
               zr(k,j) = zr(k,j) - s * ar(i,k) - si * ai(i,k)
               zi(k,j) = zi(k,j) - si * ar(i,k) + s * ai(i,k)
  120       continue
c
  130    continue
c
  140 continue
c
  200 return
      end
      subroutine htridi(nm,n,ar,ai,d,e,e2,tau)
c
      integer i,j,k,l,n,ii,nm,jp1
      double precision ar(nm,n),ai(nm,n),d(n),e(n),e2(n),tau(2,n)
      double precision f,g,h,fi,gi,hh,si,scale,pythag
*
*     Common block to return operation count and iteration count.
*     ITCNT is initialized to 0, OPS is only incremented.
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
c
c     this subroutine is a translation of a complex analogue of
c     the algol procedure tred1, num. math. 11, 181-195(1968)
c     by martin, reinsch, and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 212-226(1971).
c
c     this subroutine reduces a complex hermitian matrix
c     to a real symmetric tridiagonal matrix using
c     unitary similarity transformations.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        ar and ai contain the real and imaginary parts,
c          respectively, of the complex hermitian input matrix.
c          only the lower triangle of the matrix need be supplied.
c
c     on output
c
c        ar and ai contain information about the unitary trans-
c          formations used in the reduction in their full lower
c          triangles.  their strict upper triangles and the
c          diagonal of ar are unaltered.
c
c        d contains the diagonal elements of the the tridiagonal matrix.
c
c        e contains the subdiagonal elements of the tridiagonal
c          matrix in its last n-1 positions.  e(1) is set to zero.
c
c        e2 contains the squares of the corresponding elements of e.
c          e2 may coincide with e if the squares are not needed.
c
c        tau contains further information about the transformations.
c
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
*
      OPS = OPS + MAX( 0.0D0, (16.0D0/3.0D0)*DBLE(N)**3 + 3*DBLE(N)**2
     $                      + (56.0D0/3.0D0)*N - 61 )
*
      tau(1,n) = 1.0d0
      tau(2,n) = 0.0d0
c
      do 100 i = 1, n
  100 d(i) = ar(i,i)
c     .......... for i=n step -1 until 1 do -- ..........
      do 300 ii = 1, n
         i = n + 1 - ii
         l = i - 1
         h = 0.0d0
         scale = 0.0d0
         if (l .lt. 1) go to 130
c     .......... scale row (algol tol then not needed) ..........
         do 120 k = 1, l
  120    scale = scale + dabs(ar(i,k)) + dabs(ai(i,k))
c
         if (scale .ne. 0.0d0) go to 140
         tau(1,l) = 1.0d0
         tau(2,l) = 0.0d0
  130    e(i) = 0.0d0
         e2(i) = 0.0d0
         go to 290
c
  140    do 150 k = 1, l
            ar(i,k) = ar(i,k) / scale
            ai(i,k) = ai(i,k) / scale
            h = h + ar(i,k) * ar(i,k) + ai(i,k) * ai(i,k)
  150    continue
c
         e2(i) = scale * scale * h
         g = dsqrt(h)
         e(i) = scale * g
         f = pythag(ar(i,l),ai(i,l))
c     .......... form next diagonal element of matrix t ..........
         if (f .eq. 0.0d0) go to 160
         tau(1,l) = (ai(i,l) * tau(2,i) - ar(i,l) * tau(1,i)) / f
         si = (ar(i,l) * tau(2,i) + ai(i,l) * tau(1,i)) / f
         h = h + f * g
         g = 1.0d0 + g / f
         ar(i,l) = g * ar(i,l)
         ai(i,l) = g * ai(i,l)
         if (l .eq. 1) go to 270
         go to 170
  160    tau(1,l) = -tau(1,i)
         si = tau(2,i)
         ar(i,l) = g
  170    f = 0.0d0
c
         do 240 j = 1, l
            g = 0.0d0
            gi = 0.0d0
c     .......... form element of a*u ..........
            do 180 k = 1, j
               g = g + ar(j,k) * ar(i,k) + ai(j,k) * ai(i,k)
               gi = gi - ar(j,k) * ai(i,k) + ai(j,k) * ar(i,k)
  180       continue
c
            jp1 = j + 1
            if (l .lt. jp1) go to 220
c
            do 200 k = jp1, l
               g = g + ar(k,j) * ar(i,k) - ai(k,j) * ai(i,k)
               gi = gi - ar(k,j) * ai(i,k) - ai(k,j) * ar(i,k)
  200       continue
c     .......... form element of p ..........
  220       e(j) = g / h
            tau(2,j) = gi / h
            f = f + e(j) * ar(i,j) - tau(2,j) * ai(i,j)
  240    continue
c
         hh = f / (h + h)
c     .......... form reduced a ..........
         do 260 j = 1, l
            f = ar(i,j)
            g = e(j) - hh * f
            e(j) = g
            fi = -ai(i,j)
            gi = tau(2,j) - hh * fi
            tau(2,j) = -gi
c
            do 260 k = 1, j
               ar(j,k) = ar(j,k) - f * e(k) - g * ar(i,k)
     x                           + fi * tau(2,k) + gi * ai(i,k)
               ai(j,k) = ai(j,k) - f * tau(2,k) - g * ai(i,k)
     x                           - fi * e(k) - gi * ar(i,k)
  260    continue
c
  270    do 280 k = 1, l
            ar(i,k) = scale * ar(i,k)
            ai(i,k) = scale * ai(i,k)
  280    continue
c
         tau(2,l) = -si
  290    hh = d(i)
         d(i) = ar(i,i)
         ar(i,i) = hh
         ai(i,i) = scale * dsqrt(h)
  300 continue
c
      return
      end
      subroutine imtql1(n,d,e,ierr)
*
*     EISPACK Routine
*     Modified for comparison with LAPACK routines.
*
*     Convergence test was modified to be the same as in DSTEQR.
*
c
      integer i,j,l,m,n,ii,mml,ierr
      double precision d(n),e(n)
      double precision b,c,f,g,p,r,s,tst1,tst2,pythag
      DOUBLE PRECISION EPS, TST
      DOUBLE PRECISION DLAMCH
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate contributions to OPS from
*     function pythag.  It is passed to and from pythag
*     through common block PYTHOP.
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
      COMMON             / PYTHOP / OPST
*
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS, OPST
*     ..
c
c     this subroutine is a translation of the algol procedure imtql1,
c     num. math. 12, 377-383(1968) by martin and wilkinson,
c     as modified in num. math. 15, 450(1970) by dubrulle.
c     handbook for auto. comp., vol.ii-linear algebra, 241-248(1971).
c
c     this subroutine finds the eigenvalues of a symmetric
c     tridiagonal matrix by the implicit ql method.
c
c     on input
c
c        n is the order of the matrix.
c
c        d contains the diagonal elements of the input matrix.
c
c        e contains the subdiagonal elements of the input matrix
c          in its last n-1 positions.  e(1) is arbitrary.
c
c      on output
c
c        d contains the eigenvalues in ascending order.  if an
c          error exit is made, the eigenvalues are correct and
c          ordered for indices 1,2,...ierr-1, but may not be
c          the smallest eigenvalues.
c
c        e has been destroyed.
c
c        ierr is set to
c          zero       for normal return,
c          j          if the j-th eigenvalue has not been
c                     determined after 40 iterations.
c
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      ierr = 0
      if (n .eq. 1) go to 1001
*
*        Initialize iteration count and OPST
            ITCNT = 0
            OPST = 0
*
*     Determine the unit roundoff for this environment.
*
      EPS = DLAMCH( 'Epsilon' )
c
      do 100 i = 2, n
  100 e(i-1) = e(i)
c
      e(n) = 0.0d0
c
      do 290 l = 1, n
         j = 0
c     .......... look for small sub-diagonal element ..........
  105    do 110 m = l, n
            if (m .eq. n) go to 120
            TST = ABS( E(M) )
            IF( TST .LE. EPS * ( ABS(D(M)) + ABS(D(M+1)) ) ) GO TO 120
*            tst1 = abs(d(m)) + abs(d(m+1))
*            tst2 = tst1 + abs(e(m))
*            if (tst2 .eq. tst1) go to 120
  110    continue
c
  120    p = d(l)
*
*        Increment opcount for finding small subdiagonal element.
            OPS = OPS + 2*( MIN(M,N-1)-L+1 )
         if (m .eq. l) go to 215
         if (j .eq. 40) go to 1000
         j = j + 1
c     .......... form shift ..........
         g = (d(l+1) - p) / (2.0d0 * e(l))
         r = pythag(g,1.0d0)
         g = d(m) - p + e(l) / (g + dsign(r,g))
*
*        Increment opcount for forming shift.
            OPS = OPS + 7
         s = 1.0d0
         c = 1.0d0
         p = 0.0d0
         mml = m - l
c     .......... for i=m-1 step -1 until l do -- ..........
         do 200 ii = 1, mml
            i = m - ii
            f = s * e(i)
            b = c * e(i)
            r = pythag(f,g)
            e(i+1) = r
            if (r .eq. 0.0d0) go to 210
            s = f / r
            c = g / r
            g = d(i+1) - p
            r = (d(i) - g) * s + 2.0d0 * c * b
            p = s * r
            d(i+1) = g + p
            g = c * r - b
  200    continue
c
         d(l) = d(l) - p
         e(l) = g
         e(m) = 0.0d0
*
*        Increment opcount for inner loop.
            OPS = OPS + MML*14 + 1
*
*        Increment iteration counter
            ITCNT = ITCNT + 1
         go to 105
c     .......... recover from underflow ..........
  210    d(i+1) = d(i+1) - p
         e(m) = 0.0d0
*
*        Increment opcount for inner loop, when underflow occurs.
            OPS = OPS + 2+(II-1)*14 + 1
         go to 105
c     .......... order eigenvalues ..........
  215    if (l .eq. 1) go to 250
c     .......... for i=l step -1 until 2 do -- ..........
         do 230 ii = 2, l
            i = l + 2 - ii
            if (p .ge. d(i-1)) go to 270
            d(i) = d(i-1)
  230    continue
c
  250    i = 1
  270    d(i) = p
  290 continue
c
      go to 1001
c     .......... set error -- no convergence to an
c                eigenvalue after 40 iterations ..........
 1000 ierr = l
 1001 continue
*
*     Compute final op count
      OPS = OPS + OPST
      return
      end
      subroutine imtql2(nm,n,d,e,z,ierr)
*
*     EISPACK routine.  Modified for comparison with LAPACK.
*
*     Convergence test was modified to be the same as in DSTEQR.
*
c
      integer i,j,k,l,m,n,ii,nm,mml,ierr
      double precision d(n),e(n),z(nm,n)
      double precision b,c,f,g,p,r,s,tst1,tst2,pythag
      DOUBLE PRECISION EPS, TST
      DOUBLE PRECISION DLAMCH
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate contributions to OPS from
*     function pythag.  It is passed to and from pythag
*     through common block PYTHOP.
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
      COMMON             / PYTHOP / OPST
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS, OPST
*     ..
c
c     this subroutine is a translation of the algol procedure imtql2,
c     num. math. 12, 377-383(1968) by martin and wilkinson,
c     as modified in num. math. 15, 450(1970) by dubrulle.
c     handbook for auto. comp., vol.ii-linear algebra, 241-248(1971).
c
c     this subroutine finds the eigenvalues and eigenvectors
c     of a symmetric tridiagonal matrix by the implicit ql method.
c     the eigenvectors of a full symmetric matrix can also
c     be found if  tred2  has been used to reduce this
c     full matrix to tridiagonal form.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        d contains the diagonal elements of the input matrix.
c
c        e contains the subdiagonal elements of the input matrix
c          in its last n-1 positions.  e(1) is arbitrary.
c
c        z contains the transformation matrix produced in the
c          reduction by  tred2, if performed.  if the eigenvectors
c          of the tridiagonal matrix are desired, z must contain
c          the identity matrix.
c
c      on output
c
c        d contains the eigenvalues in ascending order.  if an
c          error exit is made, the eigenvalues are correct but
c          unordered for indices 1,2,...,ierr-1.
c
c        e has been destroyed.
c
c        z contains orthonormal eigenvectors of the symmetric
c          tridiagonal (or full) matrix.  if an error exit is made,
c          z contains the eigenvectors associated with the stored
c          eigenvalues.
c
c        ierr is set to
c          zero       for normal return,
c          j          if the j-th eigenvalue has not been
c                     determined after 40 iterations.
c
c     calls pythag for  sqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      ierr = 0
      if (n .eq. 1) go to 1001
*
*        Initialize iteration count and OPST
            ITCNT = 0
            OPST = 0
*
*     Determine unit roundoff for this machine.
      EPS = DLAMCH( 'Epsilon' )
c
      do 100 i = 2, n
  100 e(i-1) = e(i)
c
      e(n) = 0.0d0
c
      do 240 l = 1, n
         j = 0
c     .......... look for small sub-diagonal element ..........
  105    do 110 m = l, n
            if (m .eq. n) go to 120
*            tst1 = abs(d(m)) + abs(d(m+1))
*            tst2 = tst1 + abs(e(m))
*            if (tst2 .eq. tst1) go to 120
            TST = ABS( E(M) )
            IF( TST .LE. EPS * ( ABS(D(M)) + ABS(D(M+1)) ) ) GO TO 120
  110    continue
c
  120    p = d(l)
*
*        Increment opcount for finding small subdiagonal element.
            OPS = OPS + 2*( MIN(M,N)-L+1 )
         if (m .eq. l) go to 240
         if (j .eq. 40) go to 1000
         j = j + 1
c     .......... form shift ..........
         g = (d(l+1) - p) / (2.0d0 * e(l))
         r = pythag(g,1.0d0)
         g = d(m) - p + e(l) / (g + dsign(r,g))
*
*        Increment opcount for forming shift.
            OPS = OPS + 7
         s = 1.0d0
         c = 1.0d0
         p = 0.0d0
         mml = m - l
c     .......... for i=m-1 step -1 until l do -- ..........
         do 200 ii = 1, mml
            i = m - ii
            f = s * e(i)
            b = c * e(i)
            r = pythag(f,g)
            e(i+1) = r
            if (r .eq. 0.0d0) go to 210
            s = f / r
            c = g / r
            g = d(i+1) - p
            r = (d(i) - g) * s + 2.0d0 * c * b
            p = s * r
            d(i+1) = g + p
            g = c * r - b
c     .......... form vector ..........
            do 180 k = 1, n
               f = z(k,i+1)
               z(k,i+1) = s * z(k,i) + c * f
               z(k,i) = c * z(k,i) - s * f
  180       continue
c
  200    continue
c
         d(l) = d(l) - p
         e(l) = g
         e(m) = 0.0d0
*
*        Increment opcount for inner loop.
            OPS = OPS + MML*( 14+6*N ) + 1
*
*        Increment iteration counter
            ITCNT = ITCNT + 1
         go to 105
c     .......... recover from underflow ..........
  210    d(i+1) = d(i+1) - p
         e(m) = 0.0d0
*
*        Increment opcount for inner loop, when underflow occurs.
            OPS = OPS + 2+(II-1)*(14+6*N) + 1
         go to 105
  240 continue
c     .......... order eigenvalues and eigenvectors ..........
      do 300 ii = 2, n
         i = ii - 1
         k = i
         p = d(i)
c
         do 260 j = ii, n
            if (d(j) .ge. p) go to 260
            k = j
            p = d(j)
  260    continue
c
         if (k .eq. i) go to 300
         d(k) = d(i)
         d(i) = p
c
         do 280 j = 1, n
            p = z(j,i)
            z(j,i) = z(j,k)
            z(j,k) = p
  280    continue
c
  300 continue
c
      go to 1001
c     .......... set error -- no convergence to an
c                eigenvalue after 40 iterations ..........
 1000 ierr = l
 1001 continue
*
*     Compute final op count
      OPS = OPS + OPST
      return
      end
      double precision function pythag(a,b)
      double precision a,b
c
c     finds sqrt(a**2+b**2) without overflow or destructive underflow
c
*
*     Common block to return operation count
*     OPST is only incremented here
*     .. Common blocks ..
      COMMON             / PYTHOP / OPST
*     ..
*     .. Scalars in Common
      DOUBLE PRECISION   OPST
*     ..
      double precision p,r,s,t,u
      p = dmax1(dabs(a),dabs(b))
      if (p .eq. 0.0d0) go to 20
      r = (dmin1(dabs(a),dabs(b))/p)**2
*
*     Increment OPST
      OPST = OPST + 2
   10 continue
         t = 4.0d0 + r
         if (t .eq. 4.0d0) go to 20
         s = r/t
         u = 1.0d0 + 2.0d0*s
         p = u*p
         r = (s/u)**2 * r
*
*        Increment OPST
            OPST = OPST + 8
      go to 10
   20 pythag = p
      return
      end
      double precision function epslon (x)
      double precision x
c
c     estimate unit roundoff in quantities of size x.
c
      double precision a,b,c,eps
c
c     this program should function properly on all systems
c     satisfying the following two assumptions,
c        1.  the base used in representing floating point
c            numbers is not a power of three.
c        2.  the quantity  a  in statement 10 is represented to
c            the accuracy used in floating point variables
c            that are stored in memory.
c     the statement number 10 and the go to 10 are intended to
c     force optimizing compilers to generate code satisfying
c     assumption 2.
c     under these assumptions, it should be true that,
c            a  is not exactly equal to four-thirds,
c            b  has a zero for its last bit or digit,
c            c  is not exactly equal to one,
c            eps  measures the separation of 1.0 from
c                 the next larger floating point number.
c     the developers of eispack would appreciate being informed
c     about any systems where these assumptions do not hold.
c
c     this version dated 4/6/83.
c
      a = 4.0d0/3.0d0
   10 b = a - 1.0d0
      c = b + b + b
      eps = dabs(c-1.0d0)
      if (eps .eq. 0.0d0) go to 10
      epslon = eps*dabs(x)
      return
      end
      subroutine bisect(n,eps1,d,e,e2,lb,ub,mm,m,w,ind,ierr,rv4,rv5)
*
*     EISPACK Routine.
*     Modified for comparison with LAPACK routines.
*
*     Convergence test was modified to be the same as in DSTEBZ.
*
c
      integer i,j,k,l,m,n,p,q,r,s,ii,mm,m1,m2,tag,ierr,isturm
      double precision d(n),e(n),e2(n),w(mm),rv4(n),rv5(n)
      double precision u,v,lb,t1,t2,ub,xu,x0,x1,eps1,tst1,tst2,epslon
      integer ind(mm)
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
c
c     this subroutine is a translation of the bisection technique
c     in the algol procedure tristurm by peters and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 418-439(1971).
c
c     this subroutine finds those eigenvalues of a tridiagonal
c     symmetric matrix which lie in a specified interval,
c     using bisection.
c
c     on input
c
c        n is the order of the matrix.
c
c        eps1 is an absolute error tolerance for the computed
c          eigenvalues.  if the input eps1 is non-positive,
c          it is reset for each submatrix to a default value,
c          namely, minus the product of the relative machine
c          precision and the 1-norm of the submatrix.
c
c        d contains the diagonal elements of the input matrix.
c
c        e contains the subdiagonal elements of the input matrix
c          in its last n-1 positions.  e(1) is arbitrary.
c
c        e2 contains the squares of the corresponding elements of e.
c          e2(1) is arbitrary.
c
c        lb and ub define the interval to be searched for eigenvalues.
c          if lb is not less than ub, no eigenvalues will be found.
c
c        mm should be set to an upper bound for the number of
c          eigenvalues in the interval.  warning. if more than
c          mm eigenvalues are determined to lie in the interval,
c          an error return is made with no eigenvalues found.
c
c     on output
c
c        eps1 is unaltered unless it has been reset to its
c          (last) default value.
c
c        d and e are unaltered.
c
c        elements of e2, corresponding to elements of e regarded
c          as negligible, have been replaced by zero causing the
c          matrix to split into a direct sum of submatrices.
c          e2(1) is also set to zero.
c
c        m is the number of eigenvalues determined to lie in (lb,ub).
c
c        w contains the m eigenvalues in ascending order.
c
c        ind contains in its first m positions the submatrix indices
c          associated with the corresponding eigenvalues in w --
c          1 for eigenvalues belonging to the first submatrix from
c          the top, 2 for those belonging to the second submatrix, etc..
c
c        ierr is set to
c          zero       for normal return,
c          3*n+1      if m exceeds mm.
c
c        rv4 and rv5 are temporary storage arrays.
c
c     the algol procedure sturmcnt contained in tristurm
c     appears in bisect in-line.
c
c     note that subroutine tql1 or imtql1 is generally faster than
c     bisect, if more than n/4 eigenvalues are to be found.
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      DOUBLE PRECISION ONE
      PARAMETER        ( ONE = 1.0D0 )
      DOUBLE PRECISION RELFAC
      PARAMETER        ( RELFAC = 2.0D0 )
      DOUBLE PRECISION ATOLI, RTOLI, SAFEMN, TMP1, TMP2, TNORM, ULP
      DOUBLE PRECISION DLAMCH, PIVMIN
      EXTERNAL DLAMCH
*        Initialize iteration count.
            ITCNT = 0
      SAFEMN = DLAMCH( 'S' )
      ULP = DLAMCH( 'E' )*DLAMCH( 'B' )
      RTOLI = ULP*RELFAC
      ierr = 0
      tag = 0
      t1 = lb
      t2 = ub
c     .......... look for small sub-diagonal entries ..........
      do 40 i = 1, n
         if (i .eq. 1) go to 20
ccc         tst1 = dabs(d(i)) + dabs(d(i-1))
ccc         tst2 = tst1 + dabs(e(i))
ccc         if (tst2 .gt. tst1) go to 40
         TMP1 = E( I )**2
         IF( ABS( D(I)*D(I-1) )*ULP**2+SAFEMN.LE.TMP1 )
     $      GO TO 40
   20    e2(i) = 0.0d0
   40 continue
*           Increment opcount for determining if matrix splits.
               OPS = OPS + 5*( N-1 )
C
C                Compute quantities needed for convergence test.
      TMP1 = D( 1 ) - ABS( E( 2 ) )
      TMP2 = D( 1 ) + ABS( E( 2 ) )
      PIVMIN = ONE
      DO 41 I = 2, N - 1
         TMP1 = MIN( TMP1, D( I )-ABS( E( I ) )-ABS( E( I+1 ) ) )
         TMP2 = MAX( TMP2, D( I )+ABS( E( I ) )+ABS( E( I+1 ) ) )
         PIVMIN = MAX( PIVMIN, E( I )**2 )
   41 CONTINUE
      TMP1 = MIN( TMP1, D( N )-ABS( E( N ) ) )
      TMP2 = MAX( TMP2, D( N )+ABS( E( N ) ) )
      PIVMIN = MAX( PIVMIN, E( N )**2 )
      PIVMIN = PIVMIN*SAFEMN
      TNORM = MAX( ABS(TMP1), ABS(TMP2) )
      ATOLI = ULP*TNORM
*        Increment opcount for computing these quantities.
            OPS = OPS + 4*( N-1 )
C
c     .......... determine the number of eigenvalues
c                in the interval ..........
      p = 1
      q = n
      x1 = ub
      isturm = 1
      go to 320
   60 m = s
      x1 = lb
      isturm = 2
      go to 320
   80 m = m - s
      if (m .gt. mm) go to 980
      q = 0
      r = 0
c     .......... establish and process next submatrix, refining
c                interval by the gerschgorin bounds ..........
  100 if (r .eq. m) go to 1001
      tag = tag + 1
      p = q + 1
      xu = d(p)
      x0 = d(p)
      u = 0.0d0
c
      do 120 q = p, n
         x1 = u
         u = 0.0d0
         v = 0.0d0
         if (q .eq. n) go to 110
         u = dabs(e(q+1))
         v = e2(q+1)
  110    xu = dmin1(d(q)-(x1+u),xu)
         x0 = dmax1(d(q)+(x1+u),x0)
         if (v .eq. 0.0d0) go to 140
  120 continue
*        Increment opcount for refining interval.
            OPS = OPS + ( N-P+1 )*2
c
  140 x1 = epslon(dmax1(dabs(xu),dabs(x0)))
      if (eps1 .le. 0.0d0) eps1 = -x1
      if (p .ne. q) go to 180
c     .......... check for isolated root within interval ..........
      if (t1 .gt. d(p) .or. d(p) .ge. t2) go to 940
      m1 = p
      m2 = p
      rv5(p) = d(p)
      go to 900
  180 x1 = x1 * (q - p + 1)
      lb = dmax1(t1,xu-x1)
      ub = dmin1(t2,x0+x1)
      x1 = lb
      isturm = 3
      go to 320
  200 m1 = s + 1
      x1 = ub
      isturm = 4
      go to 320
  220 m2 = s
      if (m1 .gt. m2) go to 940
c     .......... find roots by bisection ..........
      x0 = ub
      isturm = 5
c
      do 240 i = m1, m2
         rv5(i) = ub
         rv4(i) = lb
  240 continue
c     .......... loop for k-th eigenvalue
c                for k=m2 step -1 until m1 do --
c                (-do- not used to legalize -computed go to-) ..........
      k = m2
  250    xu = lb
c     .......... for i=k step -1 until m1 do -- ..........
         do 260 ii = m1, k
            i = m1 + k - ii
            if (xu .ge. rv4(i)) go to 260
            xu = rv4(i)
            go to 280
  260    continue
c
  280    if (x0 .gt. rv5(k)) x0 = rv5(k)
c     .......... next bisection step ..........
  300    x1 = (xu + x0) * 0.5d0
ccc         if ((x0 - xu) .le. dabs(eps1)) go to 420
ccc         tst1 = 2.0d0 * (dabs(xu) + dabs(x0))
ccc         tst2 = tst1 + (x0 - xu)
ccc         if (tst2 .eq. tst1) go to 420
         TMP1 = ABS( X0 - XU )
         TMP2 = MAX( ABS( X0 ), ABS( XU ) )
         IF( TMP1.LT.MAX( ATOLI, PIVMIN, RTOLI*TMP2 ) )
     $      GO TO 420
c     .......... in-line procedure for sturm sequence ..........
  320    s = p - 1
         u = 1.0d0
c
         do 340 i = p, q
            if (u .ne. 0.0d0) go to 325
            v = dabs(e(i)) / epslon(1.0d0)
            if (e2(i) .eq. 0.0d0) v = 0.0d0
            go to 330
  325       v = e2(i) / u
  330       u = d(i) - x1 - v
            if (u .lt. 0.0d0) s = s + 1
  340    continue
*           Increment opcount for Sturm sequence.
               OPS = OPS + ( Q-P+1 )*3
*           Increment iteration counter.
               ITCNT = ITCNT + 1
c
         go to (60,80,200,220,360), isturm
c     .......... refine intervals ..........
  360    if (s .ge. k) go to 400
         xu = x1
         if (s .ge. m1) go to 380
         rv4(m1) = x1
         go to 300
  380    rv4(s+1) = x1
         if (rv5(s) .gt. x1) rv5(s) = x1
         go to 300
  400    x0 = x1
         go to 300
c     .......... k-th eigenvalue found ..........
  420    rv5(k) = x1
      k = k - 1
      if (k .ge. m1) go to 250
c     .......... order eigenvalues tagged with their
c                submatrix associations ..........
  900 s = r
      r = r + m2 - m1 + 1
      j = 1
      k = m1
c
      do 920 l = 1, r
         if (j .gt. s) go to 910
         if (k .gt. m2) go to 940
         if (rv5(k) .ge. w(l)) go to 915
c
         do 905 ii = j, s
            i = l + s - ii
            w(i+1) = w(i)
            ind(i+1) = ind(i)
  905    continue
c
  910    w(l) = rv5(k)
         ind(l) = tag
         k = k + 1
         go to 920
  915    j = j + 1
  920 continue
c
  940 if (q .lt. n) go to 100
      go to 1001
c     .......... set error -- underestimate of number of
c                eigenvalues in interval ..........
  980 ierr = 3 * n + 1
 1001 lb = t1
      ub = t2
      return
      end
      subroutine tinvit(nm,n,d,e,e2,m,w,ind,z,
     x                  ierr,rv1,rv2,rv3,rv4,rv6)
*
*     EISPACK Routine.
*
*     Convergence test was not modified, since it should give
*     approximately the same level of accuracy as LAPACK routine,
*     although the eigenvectors may not be as close to orthogonal.
*
c
      integer i,j,m,n,p,q,r,s,ii,ip,jj,nm,its,tag,ierr,group
      double precision d(n),e(n),e2(n),w(m),z(nm,m),
     x       rv1(n),rv2(n),rv3(n),rv4(n),rv6(n)
      double precision u,v,uk,xu,x0,x1,eps2,eps3,eps4,norm,order,epslon,
     x       pythag
      integer ind(m)
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
      COMMON             / PYTHOP / OPST
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS, OPST
*     ..
c
c     this subroutine is a translation of the inverse iteration tech-
c     nique in the algol procedure tristurm by peters and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 418-439(1971).
c
c     this subroutine finds those eigenvectors of a tridiagonal
c     symmetric matrix corresponding to specified eigenvalues,
c     using inverse iteration.
c
c     on input
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement.
c
c        n is the order of the matrix.
c
c        d contains the diagonal elements of the input matrix.
c
c        e contains the subdiagonal elements of the input matrix
c          in its last n-1 positions.  e(1) is arbitrary.
c
c        e2 contains the squares of the corresponding elements of e,
c          with zeros corresponding to negligible elements of e.
c          e(i) is considered negligible if it is not larger than
c          the product of the relative machine precision and the sum
c          of the magnitudes of d(i) and d(i-1).  e2(1) must contain
c          0.0d0 if the eigenvalues are in ascending order, or 2.0d0
c          if the eigenvalues are in descending order.  if  bisect,
c          tridib, or  imtqlv  has been used to find the eigenvalues,
c          their output e2 array is exactly what is expected here.
c
c        m is the number of specified eigenvalues.
c
c        w contains the m eigenvalues in ascending or descending order.
c
c        ind contains in its first m positions the submatrix indices
c          associated with the corresponding eigenvalues in w --
c          1 for eigenvalues belonging to the first submatrix from
c          the top, 2 for those belonging to the second submatrix, etc.
c
c     on output
c
c        all input arrays are unaltered.
c
c        z contains the associated set of orthonormal eigenvectors.
c          any vector which fails to converge is set to zero.
c
c        ierr is set to
c          zero       for normal return,
c          -r         if the eigenvector corresponding to the r-th
c                     eigenvalue fails to converge in 5 iterations.
c
c        rv1, rv2, rv3, rv4, and rv6 are temporary storage arrays.
c
c     calls pythag for  dsqrt(a*a + b*b) .
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
*        Initialize iteration count.
            ITCNT = 0
      ierr = 0
      if (m .eq. 0) go to 1001
      tag = 0
      order = 1.0d0 - e2(1)
      q = 0
c     .......... establish and process next submatrix ..........
  100 p = q + 1
c
      do 120 q = p, n
         if (q .eq. n) go to 140
         if (e2(q+1) .eq. 0.0d0) go to 140
  120 continue
c     .......... find vectors by inverse iteration ..........
  140 tag = tag + 1
      s = 0
c
      do 920 r = 1, m
         if (ind(r) .ne. tag) go to 920
         its = 1
         x1 = w(r)
         if (s .ne. 0) go to 510
c     .......... check for isolated root ..........
         xu = 1.0d0
         if (p .ne. q) go to 490
         rv6(p) = 1.0d0
         go to 870
  490    norm = dabs(d(p))
         ip = p + 1
c
         do 500 i = ip, q
  500    norm = dmax1(norm, dabs(d(i))+dabs(e(i)))
c     .......... eps2 is the criterion for grouping,
c                eps3 replaces zero pivots and equal
c                roots are modified by eps3,
c                eps4 is taken very small to avoid overflow ..........
         eps2 = 1.0d-3 * norm
         eps3 = epslon(norm)
         uk = q - p + 1
         eps4 = uk * eps3
         uk = eps4 / dsqrt(uk)
*           Increment opcount for computing criteria.
               OPS = OPS + ( Q-IP+4 )
         s = p
  505    group = 0
         go to 520
c     .......... look for close or coincident roots ..........
  510    if (dabs(x1-x0) .ge. eps2) go to 505
         group = group + 1
         if (order * (x1 - x0) .le. 0.0d0) x1 = x0 + order * eps3
c     .......... elimination with interchanges and
c                initialization of vector ..........
  520    v = 0.0d0
c
         do 580 i = p, q
            rv6(i) = uk
            if (i .eq. p) go to 560
            if (dabs(e(i)) .lt. dabs(u)) go to 540
c     .......... warning -- a divide check may occur here if
c                e2 array has not been specified correctly ..........
            xu = u / e(i)
            rv4(i) = xu
            rv1(i-1) = e(i)
            rv2(i-1) = d(i) - x1
            rv3(i-1) = 0.0d0
            if (i .ne. q) rv3(i-1) = e(i+1)
            u = v - xu * rv2(i-1)
            v = -xu * rv3(i-1)
            go to 580
  540       xu = e(i) / u
            rv4(i) = xu
            rv1(i-1) = u
            rv2(i-1) = v
            rv3(i-1) = 0.0d0
  560       u = d(i) - x1 - xu * v
            if (i .ne. q) v = e(i+1)
  580    continue
*           Increment opcount for elimination.
               OPS = OPS + ( Q-P+1 )*5
c
         if (u .eq. 0.0d0) u = eps3
         rv1(q) = u
         rv2(q) = 0.0d0
         rv3(q) = 0.0d0
c     .......... back substitution
c                for i=q step -1 until p do -- ..........
  600    do 620 ii = p, q
            i = p + q - ii
            rv6(i) = (rv6(i) - u * rv2(i) - v * rv3(i)) / rv1(i)
            v = u
            u = rv6(i)
  620    continue
*           Increment opcount for back substitution.
               OPS = OPS + ( Q-P+1 )*5
c     .......... orthogonalize with respect to previous
c                members of group ..........
         if (group .eq. 0) go to 700
         j = r
c
         do 680 jj = 1, group
  630       j = j - 1
            if (ind(j) .ne. tag) go to 630
            xu = 0.0d0
c
            do 640 i = p, q
  640       xu = xu + rv6(i) * z(i,j)
c
            do 660 i = p, q
  660       rv6(i) = rv6(i) - xu * z(i,j)
c
*              Increment opcount for orthogonalizing.
                  OPS = OPS + ( Q-P+1 )*4
  680    continue
c
  700    norm = 0.0d0
c
         do 720 i = p, q
  720    norm = norm + dabs(rv6(i))
*           Increment opcount for computing norm.
               OPS = OPS + ( Q-P+1 )
c
         if (norm .ge. 1.0d0) go to 840
c     .......... forward substitution ..........
         if (its .eq. 5) go to 830
         if (norm .ne. 0.0d0) go to 740
         rv6(s) = eps4
         s = s + 1
         if (s .gt. q) s = p
         go to 780
  740    xu = eps4 / norm
c
         do 760 i = p, q
  760    rv6(i) = rv6(i) * xu
c     .......... elimination operations on next vector
c                iterate ..........
  780    do 820 i = ip, q
            u = rv6(i)
c     .......... if rv1(i-1) .eq. e(i), a row interchange
c                was performed earlier in the
c                triangularization process ..........
            if (rv1(i-1) .ne. e(i)) go to 800
            u = rv6(i-1)
            rv6(i-1) = rv6(i)
  800       rv6(i) = u - rv4(i) * rv6(i-1)
  820    continue
*           Increment opcount for forward substitution.
               OPS = OPS + ( Q-P+1 ) + ( Q-IP+1 )*2
c
         its = its + 1
*           Increment iteration counter.
               ITCNT = ITCNT + 1
         go to 600
c     .......... set error -- non-converged eigenvector ..........
  830    ierr = -r
         xu = 0.0d0
         go to 870
c     .......... normalize so that sum of squares is
c                1 and expand to full order ..........
  840    u = 0.0d0
c
         do 860 i = p, q
  860    u = pythag(u,rv6(i))
c
         xu = 1.0d0 / u
c
  870    do 880 i = 1, n
  880    z(i,r) = 0.0d0
c
         do 900 i = p, q
  900    z(i,r) = rv6(i) * xu
*           Increment opcount for normalizing.
               OPS = OPS + ( Q-P+1 )
c
         x0 = x1
  920 continue
c
      if (q .lt. n) go to 100
*        Increment opcount for use of function pythag.
            OPS = OPS + OPST
 1001 return
      end
      subroutine tridib(n,eps1,d,e,e2,lb,ub,m11,m,w,ind,ierr,rv4,rv5)
*
*     EISPACK Routine.
*     Modified for comparison with LAPACK routines.
*
*     Convergence test was modified to be the same as in DSTEBZ.
*
c
      integer i,j,k,l,m,n,p,q,r,s,ii,m1,m2,m11,m22,tag,ierr,isturm
      double precision d(n),e(n),e2(n),w(m),rv4(n),rv5(n)
      double precision u,v,lb,t1,t2,ub,xu,x0,x1,eps1,tst1,tst2,epslon
      integer ind(m)
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
c
c     this subroutine is a translation of the algol procedure bisect,
c     num. math. 9, 386-393(1967) by barth, martin, and wilkinson.
c     handbook for auto. comp., vol.ii-linear algebra, 249-256(1971).
c
c     this subroutine finds those eigenvalues of a tridiagonal
c     symmetric matrix between specified boundary indices,
c     using bisection.
c
c     on input
c
c        n is the order of the matrix.
c
c        eps1 is an absolute error tolerance for the computed
c          eigenvalues.  if the input eps1 is non-positive,
c          it is reset for each submatrix to a default value,
c          namely, minus the product of the relative machine
c          precision and the 1-norm of the submatrix.
c
c        d contains the diagonal elements of the input matrix.
c
c        e contains the subdiagonal elements of the input matrix
c          in its last n-1 positions.  e(1) is arbitrary.
c
c        e2 contains the squares of the corresponding elements of e.
c          e2(1) is arbitrary.
c
c        m11 specifies the lower boundary index for the desired
c          eigenvalues.
c
c        m specifies the number of eigenvalues desired.  the upper
c          boundary index m22 is then obtained as m22=m11+m-1.
c
c     on output
c
c        eps1 is unaltered unless it has been reset to its
c          (last) default value.
c
c        d and e are unaltered.
c
c        elements of e2, corresponding to elements of e regarded
c          as negligible, have been replaced by zero causing the
c          matrix to split into a direct sum of submatrices.
c          e2(1) is also set to zero.
c
c        lb and ub define an interval containing exactly the desired
c          eigenvalues.
c
c        w contains, in its first m positions, the eigenvalues
c          between indices m11 and m22 in ascending order.
c
c        ind contains in its first m positions the submatrix indices
c          associated with the corresponding eigenvalues in w --
c          1 for eigenvalues belonging to the first submatrix from
c          the top, 2 for those belonging to the second submatrix, etc..
c
c        ierr is set to
c          zero       for normal return,
c          3*n+1      if multiple eigenvalues at index m11 make
c                     unique selection impossible,
c          3*n+2      if multiple eigenvalues at index m22 make
c                     unique selection impossible.
c
c        rv4 and rv5 are temporary storage arrays.
c
c     note that subroutine tql1, imtql1, or tqlrat is generally faster
c     than tridib, if more than n/4 eigenvalues are to be found.
c
c     questions and comments should be directed to burton s. garbow,
c     mathematics and computer science div, argonne national laboratory
c
c     this version dated august 1983.
c
c     ------------------------------------------------------------------
c
      DOUBLE PRECISION ONE
      PARAMETER        ( ONE = 1.0D0 )
      DOUBLE PRECISION RELFAC
      PARAMETER        ( RELFAC = 2.0D0 )
      DOUBLE PRECISION ATOLI, RTOLI, SAFEMN, TMP1, TMP2, TNORM, ULP
      DOUBLE PRECISION DLAMCH, PIVMIN
      EXTERNAL DLAMCH
*        Initialize iteration count.
            ITCNT = 0
      SAFEMN = DLAMCH( 'S' )
      ULP = DLAMCH( 'E' )*DLAMCH( 'B' )
      RTOLI = ULP*RELFAC
      ierr = 0
      tag = 0
      xu = d(1)
      x0 = d(1)
      u = 0.0d0
c     .......... look for small sub-diagonal entries and determine an
c                interval containing all the eigenvalues ..........
      PIVMIN = ONE
      do 40 i = 1, n
         x1 = u
         u = 0.0d0
         if (i .ne. n) u = dabs(e(i+1))
         xu = dmin1(d(i)-(x1+u),xu)
         x0 = dmax1(d(i)+(x1+u),x0)
         if (i .eq. 1) go to 20
ccc         tst1 = dabs(d(i)) + dabs(d(i-1))
ccc         tst2 = tst1 + dabs(e(i))
ccc         if (tst2 .gt. tst1) go to 40
         TMP1 = E( I )**2
         IF( ABS( D(I)*D(I-1) )*ULP**2+SAFEMN.LE.TMP1 ) THEN
            PIVMIN = MAX( PIVMIN, TMP1 )
            GO TO 40
         END IF
   20    e2(i) = 0.0d0
   40 continue
      PIVMIN = PIVMIN*SAFEMN
      TNORM = MAX( ABS( XU ), ABS( X0 ) )
      ATOLI = ULP*TNORM
*        Increment opcount for determining if matrix splits.
            OPS = OPS + 9*( N-1 )
c
      x1 = n
      x1 = x1 * epslon(dmax1(dabs(xu),dabs(x0)))
      xu = xu - x1
      t1 = xu
      x0 = x0 + x1
      t2 = x0
c     .......... determine an interval containing exactly
c                the desired eigenvalues ..........
      p = 1
      q = n
      m1 = m11 - 1
      if (m1 .eq. 0) go to 75
      isturm = 1
   50 v = x1
      x1 = xu + (x0 - xu) * 0.5d0
      if (x1 .eq. v) go to 980
      go to 320
   60 if (s - m1) 65, 73, 70
   65 xu = x1
      go to 50
   70 x0 = x1
      go to 50
   73 xu = x1
      t1 = x1
   75 m22 = m1 + m
      if (m22 .eq. n) go to 90
      x0 = t2
      isturm = 2
      go to 50
   80 if (s - m22) 65, 85, 70
   85 t2 = x1
   90 q = 0
      r = 0
c     .......... establish and process next submatrix, refining
c                interval by the gerschgorin bounds ..........
  100 if (r .eq. m) go to 1001
      tag = tag + 1
      p = q + 1
      xu = d(p)
      x0 = d(p)
      u = 0.0d0
c
      do 120 q = p, n
         x1 = u
         u = 0.0d0
         v = 0.0d0
         if (q .eq. n) go to 110
         u = dabs(e(q+1))
         v = e2(q+1)
  110    xu = dmin1(d(q)-(x1+u),xu)
         x0 = dmax1(d(q)+(x1+u),x0)
         if (v .eq. 0.0d0) go to 140
  120 continue
*        Increment opcount for refining interval.
            OPS = OPS + ( N-P+1 )*2
c
  140 x1 = epslon(dmax1(dabs(xu),dabs(x0)))
      if (eps1 .le. 0.0d0) eps1 = -x1
      if (p .ne. q) go to 180
c     .......... check for isolated root within interval ..........
      if (t1 .gt. d(p) .or. d(p) .ge. t2) go to 940
      m1 = p
      m2 = p
      rv5(p) = d(p)
      go to 900
  180 x1 = x1 * (q - p + 1)
      lb = dmax1(t1,xu-x1)
      ub = dmin1(t2,x0+x1)
      x1 = lb
      isturm = 3
      go to 320
  200 m1 = s + 1
      x1 = ub
      isturm = 4
      go to 320
  220 m2 = s
      if (m1 .gt. m2) go to 940
c     .......... find roots by bisection ..........
      x0 = ub
      isturm = 5
c
      do 240 i = m1, m2
         rv5(i) = ub
         rv4(i) = lb
  240 continue
c     .......... loop for k-th eigenvalue
c                for k=m2 step -1 until m1 do --
c                (-do- not used to legalize -computed go to-) ..........
      k = m2
  250    xu = lb
c     .......... for i=k step -1 until m1 do -- ..........
         do 260 ii = m1, k
            i = m1 + k - ii
            if (xu .ge. rv4(i)) go to 260
            xu = rv4(i)
            go to 280
  260    continue
c
  280    if (x0 .gt. rv5(k)) x0 = rv5(k)
c     .......... next bisection step ..........
  300    x1 = (xu + x0) * 0.5d0
ccc         if ((x0 - xu) .le. dabs(eps1)) go to 420
ccc         tst1 = 2.0d0 * (dabs(xu) + dabs(x0))
ccc         tst2 = tst1 + (x0 - xu)
ccc         if (tst2 .eq. tst1) go to 420
         TMP1 = ABS( X0 - XU )
         TMP2 = MAX( ABS( X0 ), ABS( XU ) )
         IF( TMP1.LT.MAX( ATOLI, PIVMIN, RTOLI*TMP2 ) )
     $      GO TO 420
c     .......... in-line procedure for sturm sequence ..........
  320    s = p - 1
         u = 1.0d0
c
         do 340 i = p, q
            if (u .ne. 0.0d0) go to 325
            v = dabs(e(i)) / epslon(1.0d0)
            if (e2(i) .eq. 0.0d0) v = 0.0d0
            go to 330
  325       v = e2(i) / u
  330       u = d(i) - x1 - v
            if (u .lt. 0.0d0) s = s + 1
  340    continue
*           Increment opcount for Sturm sequence.
               OPS = OPS + ( Q-P+1 )*3
*           Increment iteration counter.
               ITCNT = ITCNT + 1
c
         go to (60,80,200,220,360), isturm
c     .......... refine intervals ..........
  360    if (s .ge. k) go to 400
         xu = x1
         if (s .ge. m1) go to 380
         rv4(m1) = x1
         go to 300
  380    rv4(s+1) = x1
         if (rv5(s) .gt. x1) rv5(s) = x1
         go to 300
  400    x0 = x1
         go to 300
c     .......... k-th eigenvalue found ..........
  420    rv5(k) = x1
      k = k - 1
      if (k .ge. m1) go to 250
c     .......... order eigenvalues tagged with their
c                submatrix associations ..........
  900 s = r
      r = r + m2 - m1 + 1
      j = 1
      k = m1
c
      do 920 l = 1, r
         if (j .gt. s) go to 910
         if (k .gt. m2) go to 940
         if (rv5(k) .ge. w(l)) go to 915
c
         do 905 ii = j, s
            i = l + s - ii
            w(i+1) = w(i)
            ind(i+1) = ind(i)
  905    continue
c
  910    w(l) = rv5(k)
         ind(l) = tag
         k = k + 1
         go to 920
  915    j = j + 1
  920 continue
c
  940 if (q .lt. n) go to 100
      go to 1001
c     .......... set error -- interval cannot be found containing
c                exactly the desired eigenvalues ..........
  980 ierr = 3 * n + isturm
 1001 lb = t1
      ub = t2
      return
      end
      subroutine zsvdc(x,ldx,n,p,s,e,u,ldu,v,ldv,work,job,info)
      integer ldx,n,p,ldu,ldv,job,info
      complex*16 x(ldx,*),s(*),e(*),u(ldu,*),v(ldv,*),work(*)
*
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, IOPS is only incremented
*     IOPST is used to accumulate small contributions to IOPS
*     to avoid roundoff error
*     .. Common Blocks ..
      COMMON /LATIME/ IOPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION IOPS, ITCNT, IOPST
*     ..
c
c
c     zsvdc is a subroutine to reduce a complex*16 nxp matrix x by
c     unitary transformations u and v to diagonal form.  the
c     diagonal elements s(i) are the singular values of x.  the
c     columns of u are the corresponding left singular vectors,
c     and the columns of v the right singular vectors.
c
c     on entry
c
c         x         complex*16(ldx,p), where ldx.ge.n.
c                   x contains the matrix whose singular value
c                   decomposition is to be computed.  x is
c                   destroyed by zsvdc.
c
c         ldx       integer.
c                   ldx is the leading dimension of the array x.
c
c         n         integer.
c                   n is the number of rows of the matrix x.
c
c         p         integer.
c                   p is the number of columns of the matrix x.
c
c         ldu       integer.
c                   ldu is the leading dimension of the array u
c                   (see below).
c
c         ldv       integer.
c                   ldv is the leading dimension of the array v
c                   (see below).
c
c         work      complex*16(n).
c                   work is a scratch array.
c
c         job       integer.
c                   job controls the computation of the singular
c                   vectors.  it has the decimal expansion ab
c                   with the following meaning
c
c                        a.eq.0    do not compute the left singular
c                                  vectors.
c                        a.eq.1    return the n left singular vectors
c                                  in u.
c                        a.ge.2    returns the first min(n,p)
c                                  left singular vectors in u.
c                        b.eq.0    do not compute the right singular
c                                  vectors.
c                        b.eq.1    return the right singular vectors
c                                  in v.
c
c     on return
c
c         s         complex*16(mm), where mm=min(n+1,p).
c                   the first min(n,p) entries of s contain the
c                   singular values of x arranged in descending
c                   order of magnitude.
c
c         e         complex*16(p).
c                   e ordinarily contains zeros.  however see the
c                   discussion of info for exceptions.
c
c         u         complex*16(ldu,k), where ldu.ge.n.  if joba.eq.1
c                                   then k.eq.n, if joba.ge.2 then
c                                   k.eq.min(n,p).
c                   u contains the matrix of left singular vectors.
c                   u is not referenced if joba.eq.0.  if n.le.p
c                   or if joba.gt.2, then u may be identified with x
c                   in the subroutine call.
c
c         v         complex*16(ldv,p), where ldv.ge.p.
c                   v contains the matrix of right singular vectors.
c                   v is not referenced if jobb.eq.0.  if p.le.n,
c                   then v may be identified whth x in the
c                   subroutine call.
c
c         info      integer.
c                   the singular values (and their corresponding
c                   singular vectors) s(info+1),s(info+2),...,s(m)
c                   are correct (here m=min(n,p)).  thus if
c                   info.eq.0, all the singular values and their
c                   vectors are correct.  in any event, the matrix
c                   b = ctrans(u)*x*v is the bidiagonal matrix
c                   with the elements of s on its diagonal and the
c                   elements of e on its super-diagonal (ctrans(u)
c                   is the conjugate-transpose of u).  thus the
c                   singular values of x and b are the same.
c
c     linpack. this version dated 03/19/79 .
c              correction to shift calculation made 2/85.
c     g.w. stewart, university of maryland, argonne national lab.
c
c     zsvdc uses the following functions and subprograms.
c
c     external zdrot
c     blas zaxpy,zdotc,zscal,zswap,dznrm2,drotg
c     fortran dabs,dmax1,cdabs,dcmplx
c     fortran dconjg,max0,min0,mod,dsqrt
c
c     internal variables
c
      integer i,iter,j,jobu,k,kase,kk,l,ll,lls,lm1,lp1,ls,lu,m,maxit,
     *        mm,mm1,mp1,nct,nctp1,ncu,nrt,nrtp1
      complex*16 zdotc,t,r
      double precision b,c,cs,el,emm1,f,g,dznrm2,scale,shift,sl,sm,sn,
     *                 smm1,t1,test
*     double precision ztest
      logical wantu,wantv
c
      complex*16 csign,zdum,zdum1,zdum2
      double precision cabs1
*
*     Declare EPS and DLAMCH for new stopping criterion
      EXTERNAL DLAMCH
      DOUBLE PRECISION DLAMCH, EPS
*
      double precision dreal,dimag
      complex*16 zdumr,zdumi
      dreal(zdumr) = zdumr
      dimag(zdumi) = (0.0d0,-1.0d0)*zdumi
      cabs1(zdum) = dabs(dreal(zdum)) + dabs(dimag(zdum))
      csign(zdum1,zdum2) = cdabs(zdum1)*(zdum2/cdabs(zdum2))
*
*     Get EPS from DLAMCH for new stopping criterion
      if (n.le.0 .or. p.le.0) return
      EPS = DLAMCH( 'Epsilon' )
*
c
c     set the maximum number of iterations.
c
      maxit = 50
c
c     determine what is to be computed.
c
      wantu = .false.
      wantv = .false.
      jobu = mod(job,100)/10
      ncu = n
      if (jobu .gt. 1) ncu = min0(n,p)
      if (jobu .ne. 0) wantu = .true.
      if (mod(job,10) .ne. 0) wantv = .true.
c
c     reduce x to bidiagonal form, storing the diagonal elements
c     in s and the super-diagonal elements in e.
c
*
*     Initialize op count
      IOPST = 0
      info = 0
      nct = min0(n-1,p)
      nrt = max0(0,min0(p-2,n))
      lu = max0(nct,nrt)
      if (lu .lt. 1) go to 170
      do 160 l = 1, lu
         lp1 = l + 1
         if (l .gt. nct) go to 20
c
c           compute the transformation for the l-th column and
c           place the l-th diagonal in s(l).
c
*
*           Increment op count
            IOPS = IOPS + (4*(n-l+1)+2)
            s(l) = dcmplx(dznrm2(n-l+1,x(l,l),1),0.0d0)
            if (cabs1(s(l)) .eq. 0.0d0) go to 10
               if (cabs1(x(l,l)) .ne. 0.0d0) s(l) = csign(s(l),x(l,l))
*
*              Increment op count
               IOPS = IOPS + (6*(n-l+1)+23)
               call zscal(n-l+1,1.0d0/s(l),x(l,l),1)
               x(l,l) = (1.0d0,0.0d0) + x(l,l)
   10       continue
            s(l) = -s(l)
   20    continue
         if (p .lt. lp1) go to 50
         do 40 j = lp1, p
            if (l .gt. nct) go to 30
            if (cabs1(s(l)) .eq. 0.0d0) go to 30
c
c              apply the transformation.
c
*
*              Increment op count
               IOPS = IOPS + (16*(n-l)+26)
               t = -zdotc(n-l+1,x(l,l),1,x(l,j),1)/x(l,l)
               call zaxpy(n-l+1,t,x(l,l),1,x(l,j),1)
   30       continue
c
c           place the l-th row of x into  e for the
c           subsequent calculation of the row transformation.
c
            e(j) = dconjg(x(l,j))
   40    continue
   50    continue
         if (.not.wantu .or. l .gt. nct) go to 70
c
c           place the transformation in u for subsequent back
c           multiplication.
c
            do 60 i = l, n
               u(i,l) = x(i,l)
   60       continue
   70    continue
         if (l .gt. nrt) go to 150
c
c           compute the l-th row transformation and place the
c           l-th super-diagonal in e(l).
c
*
*           Increment op count
            IOPS = IOPS + (4*(p-l)+3)
            e(l) = dcmplx(dznrm2(p-l,e(lp1),1),0.0d0)
            if (cabs1(e(l)) .eq. 0.0d0) go to 80
               if (cabs1(e(lp1)) .ne. 0.0d0) e(l) = csign(e(l),e(lp1))
*
*              Increment op count
               IOPS = IOPS + (6*(p-l)+23)
               call zscal(p-l,1.0d0/e(l),e(lp1),1)
               e(lp1) = (1.0d0,0.0d0) + e(lp1)
   80       continue
            e(l) = -dconjg(e(l))
            if (lp1 .gt. n .or. cabs1(e(l)) .eq. 0.0d0) go to 120
c
c              apply the transformation.
c
               do 90 i = lp1, n
                  work(i) = (0.0d0,0.0d0)
   90          continue
*
*              Increment op count
               IOPS = IOPS + DBLE(16*(n-l)+9)*(p-l)
               do 100 j = lp1, p
                  call zaxpy(n-l,e(j),x(lp1,j),1,work(lp1),1)
  100          continue
               do 110 j = lp1, p
                  call zaxpy(n-l,dconjg(-e(j)/e(lp1)),work(lp1),1,
     *                       x(lp1,j),1)
  110          continue
  120       continue
            if (.not.wantv) go to 140
c
c              place the transformation in v for subsequent
c              back multiplication.
c
               do 130 i = lp1, p
                  v(i,l) = e(i)
  130          continue
  140       continue
  150    continue
  160 continue
  170 continue
c
c     set up the final bidiagonal matrix or order m.
c
      m = min0(p,n+1)
      nctp1 = nct + 1
      nrtp1 = nrt + 1
      if (nct .lt. p) s(nctp1) = x(nctp1,nctp1)
      if (n .lt. m) s(m) = (0.0d0,0.0d0)
      if (nrtp1 .lt. m) e(nrtp1) = x(nrtp1,m)
      e(m) = (0.0d0,0.0d0)
c
c     if required, generate u.
c
      if (.not.wantu) go to 300
         if (ncu .lt. nctp1) go to 200
         do 190 j = nctp1, ncu
            do 180 i = 1, n
               u(i,j) = (0.0d0,0.0d0)
  180       continue
            u(j,j) = (1.0d0,0.0d0)
  190    continue
  200    continue
         if (nct .lt. 1) go to 290
         do 280 ll = 1, nct
            l = nct - ll + 1
            if (cabs1(s(l)) .eq. 0.0d0) go to 250
               lp1 = l + 1
               if (ncu .lt. lp1) go to 220
*
*              Increment op count
               IOPS = IOPS + (DBLE(16*(n-l)+25)*(ncu-l)+6*(n-l)+9)
               do 210 j = lp1, ncu
                  t = -zdotc(n-l+1,u(l,l),1,u(l,j),1)/u(l,l)
                  call zaxpy(n-l+1,t,u(l,l),1,u(l,j),1)
  210          continue
  220          continue
               call zscal(n-l+1,(-1.0d0,0.0d0),u(l,l),1)
               u(l,l) = (1.0d0,0.0d0) + u(l,l)
               lm1 = l - 1
               if (lm1 .lt. 1) go to 240
               do 230 i = 1, lm1
                  u(i,l) = (0.0d0,0.0d0)
  230          continue
  240          continue
            go to 270
  250       continue
               do 260 i = 1, n
                  u(i,l) = (0.0d0,0.0d0)
  260          continue
               u(l,l) = (1.0d0,0.0d0)
  270       continue
  280    continue
  290    continue
  300 continue
c
c     if it is required, generate v.
c
      if (.not.wantv) go to 350
         do 340 ll = 1, p
            l = p - ll + 1
            lp1 = l + 1
            if (l .gt. nrt) go to 320
            if (cabs1(e(l)) .eq. 0.0d0) go to 320
*
*              Increment op count
               IOPS = IOPS + (DBLE(16*(p-l)+9)*(p-l)+1)
               do 310 j = lp1, p
                  t = -zdotc(p-l,v(lp1,l),1,v(lp1,j),1)/v(lp1,l)
                  call zaxpy(p-l,t,v(lp1,l),1,v(lp1,j),1)
  310          continue
  320       continue
            do 330 i = 1, p
               v(i,l) = (0.0d0,0.0d0)
  330       continue
            v(l,l) = (1.0d0,0.0d0)
  340    continue
  350 continue
c
c     transform s and e so that they are double precision.
c
*
*     Increment op count
      IOPS = IOPS + (2*m-1)
      do 380 i = 1, m
         if (cabs1(s(i)) .eq. 0.0d0) go to 360
*
*           Increment op count
            IOPS = IOPS + 23
            IF (wantu) IOPS = IOPS + 6*n
            t = dcmplx(cdabs(s(i)),0.0d0)
            r = s(i)/t
            s(i) = t
            if (i .lt. m) e(i) = e(i)/r
            if (wantu) call zscal(n,r,u(1,i),1)
  360    continue
c     ...exit
         if (i .eq. m) go to 390
         if (cabs1(e(i)) .eq. 0.0d0) go to 370
*
*           Increment op count
            IOPS = IOPS + 20
            IF (wantv) IOPS = IOPS + 6*p
            t = dcmplx(cdabs(e(i)),0.0d0)
            r = t/e(i)
            e(i) = t
            s(i+1) = s(i+1)*r
            if (wantv) call zscal(p,r,v(1,i+1),1)
  370    continue
  380 continue
  390 continue
c
c     main iteration loop for the singular values.
c
      mm = m
*
*     Initialize iteration counter
      ITCNT = 0
      iter = 0
  400 continue
c
c        quit if all the singular values have been found.
c
c     ...exit
         if (m .eq. 0) go to 660
c
c        if too many iterations have been performed, set
c        flag and return.
c
*
*        Update iteration counter
         ITCNT = iter
         if (iter .lt. maxit) go to 410
            info = m
c     ......exit
            go to 660
  410    continue
c
c        this section of the program inspects for
c        negligible elements in the s and e arrays.  on
c        completion the variables kase and l are set as follows.
c
c           kase = 1     if s(m) and e(l-1) are negligible and l.lt.m
c           kase = 2     if s(l) is negligible and l.lt.m
c           kase = 3     if e(l-1) is negligible, l.lt.m, and
c                        s(l), ..., s(m) are not negligible (qr step).
c           kase = 4     if e(m-1) is negligible (convergence).
c
         do 430 ll = 1, m
            l = m - ll
c        ...exit
            if (l .eq. 0) go to 440
*
*           Increment op count
            IOPST = IOPST + 17
            test = cdabs(s(l)) + cdabs(s(l+1))
*
*           Replace stopping criterion with new one
*
*           ztest = test + cdabs(e(l))
*           if (ztest .ne. test) go to 420
            IF (cdabs(e(l)) .gt. EPS * test) GOTO 420
*
               e(l) = (0.0d0,0.0d0)
c        ......exit
               go to 440
  420       continue
  430    continue
  440    continue
         if (l .ne. m - 1) go to 450
            kase = 4
         go to 520
  450    continue
            lp1 = l + 1
            mp1 = m + 1
            do 470 lls = lp1, mp1
               ls = m - lls + lp1
c           ...exit
               if (ls .eq. l) go to 480
               test = 0.0d0
*
*              Increment op count
               IOPST = IOPST + 18
               if (ls .ne. m) test = test + cdabs(e(ls))
               if (ls .ne. l + 1) test = test + cdabs(e(ls-1))
*
*              Replace stopping criterion with new one as in LAPACK
*
*              ztest = test + cdabs(s(ls))
*              if (ztest .ne. test) go to 460
               IF (cdabs(s(ls))  .gt. EPS * test) GOTO 460
*
                  s(ls) = (0.0d0,0.0d0)
c           ......exit
                  go to 480
  460          continue
  470       continue
  480       continue
            if (ls .ne. l) go to 490
               kase = 3
            go to 510
  490       continue
            if (ls .ne. m) go to 500
               kase = 1
            go to 510
  500       continue
               kase = 2
               l = ls
  510       continue
  520    continue
         l = l + 1
c
c        perform the task indicated by kase.
c
         go to (530, 560, 580, 610), kase
c
c        deflate negligible s(m).
c
  530    continue
            mm1 = m - 1
            f = dreal(e(m-1))
            e(m-1) = (0.0d0,0.0d0)
*
*           Increment op count
            IOPS = IOPS + ((mm1-l+1)*14 - 3)
            IF (wantv) IOPS = IOPS + DBLE(mm1-l+1)*12*p
            do 550 kk = l, mm1
               k = mm1 - kk + l
               t1 = dreal(s(k))
               call drotg(t1,f,cs,sn)
               s(k) = dcmplx(t1,0.0d0)
               if (k .eq. l) go to 540
                  f = -sn*dreal(e(k-1))
                  e(k-1) = cs*e(k-1)
  540          continue
               if (wantv) call zdrot(p,v(1,k),1,v(1,m),1,cs,sn)
  550       continue
         go to 650
c
c        split at negligible s(l).
c
  560    continue
            f = dreal(e(l-1))
            e(l-1) = (0.0d0,0.0d0)
*
*           Increment op count
            IOPS = IOPS + (m-l+1)*14
            IF (wantu) IOPS = IOPS + DBLE(m-l+1)*12*n
            do 570 k = l, m
               t1 = dreal(s(k))
               call drotg(t1,f,cs,sn)
               s(k) = dcmplx(t1,0.0d0)
               f = -sn*dreal(e(k))
               e(k) = cs*e(k)
               if (wantu) call zdrot(n,u(1,k),1,u(1,l-1),1,cs,sn)
  570       continue
         go to 650
c
c        perform one qr step.
c
  580    continue
c
c           calculate the shift.
c
*
*           Increment op count
            IOPST = IOPST + 48
            scale = dmax1(cdabs(s(m)),cdabs(s(m-1)),cdabs(e(m-1)),
     *                    cdabs(s(l)),cdabs(e(l)))
            sm = dreal(s(m))/scale
            smm1 = dreal(s(m-1))/scale
            emm1 = dreal(e(m-1))/scale
            sl = dreal(s(l))/scale
            el = dreal(e(l))/scale
            b = ((smm1 + sm)*(smm1 - sm) + emm1**2)/2.0d0
            c = (sm*emm1)**2
            shift = 0.0d0
            if (b .eq. 0.0d0 .and. c .eq. 0.0d0) go to 590
               shift = dsqrt(b**2+c)
               if (b .lt. 0.0d0) shift = -shift
               shift = c/(b + shift)
  590       continue
            f = (sl + sm)*(sl - sm) + shift
            g = sl*el
c
c           chase zeros.
c
            mm1 = m - 1
*
*           Increment op count
            IOPS = IOPS + (mm1-l+1)*46
            IF (wantv) IOPS = IOPS+DBLE(mm1-l+1)*12*p
            IF (wantu) IOPS = IOPS+DBLE(max((min(mm1,n-1)-l+1),0))*12*n
            do 600 k = l, mm1
               call drotg(f,g,cs,sn)
               if (k .ne. l) e(k-1) = dcmplx(f,0.0d0)
               f = cs*dreal(s(k)) + sn*dreal(e(k))
               e(k) = cs*e(k) - sn*s(k)
               g = sn*dreal(s(k+1))
               s(k+1) = cs*s(k+1)
               if (wantv) call zdrot(p,v(1,k),1,v(1,k+1),1,cs,sn)
               call drotg(f,g,cs,sn)
               s(k) = dcmplx(f,0.0d0)
               f = cs*dreal(e(k)) + sn*dreal(s(k+1))
               s(k+1) = -sn*e(k) + cs*s(k+1)
               g = sn*dreal(e(k+1))
               e(k+1) = cs*e(k+1)
               if (wantu .and. k .lt. n)
     *            call zdrot(n,u(1,k),1,u(1,k+1),1,cs,sn)
  600       continue
            e(m-1) = dcmplx(f,0.0d0)
            iter = iter + 1
         go to 650
c
c        convergence.
c
  610    continue
c
c           make the singular value  positive
c
            if (dreal(s(l)) .ge. 0.0d0) go to 620
               s(l) = -s(l)
*
*              Increment op count
               IF (wantv) IOPS = IOPS + 6*p
               if (wantv) call zscal(p,(-1.0d0,0.0d0),v(1,l),1)
  620       continue
c
c           order the singular value.
c
  630       if (l .eq. mm) go to 640
c           ...exit
               if (dreal(s(l)) .ge. dreal(s(l+1))) go to 640
               t = s(l)
               s(l) = s(l+1)
               s(l+1) = t
               if (wantv .and. l .lt. p)
     *            call zswap(p,v(1,l),1,v(1,l+1),1)
               if (wantu .and. l .lt. n)
     *            call zswap(n,u(1,l),1,u(1,l+1),1)
               l = l + 1
            go to 630
  640       continue
            iter = 0
            m = m - 1
  650    continue
      go to 400
  660 continue
*
*     Compute final opcount
      IOPS = IOPS + IOPST
      return
      end
c
c     ------------------------------------------------------------------
c
      subroutine cqzhes(nm,n,ar,ai,br,bi,matz,zr,zi)
c
      integer i,j,k,l,n,k1,lb,l1,nm,nk1,nm1
      double precision ar(nm,n),ai(nm,n),br(nm,n),bi(nm,n),zr(nm,n),
     1       zi(nm,n)
      double precision r,s,t,ti,u1,u2,xi,xr,yi,yr,rho,u1i
cc      real sqrt,cabs,abs
      logical matz
cc      complex*16 dcmplx
*
*     ----------------------- Begin Timing Code ------------------------
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
      DOUBLE PRECISION   OPST
      INTEGER            IOPST
*     ------------------------ End Timing Code -------------------------
*
c
c     this subroutine is a complex analogue of the first step of the
c     qz algorithm for solving generalized matrix eigenvalue problems,
c     siam j. numer. anal. 10, 241-256(1973) by moler and stewart.
c
c     this subroutine accepts a pair of complex general matrices and
c     reduces one of them to upper hessenberg form with real (and non-
c     negative) subdiagonal elements and the other to upper triangular
c     form using unitary transformations.  it is usually followed by
c     cqzval  and possibly  cqzvec.
c
c     on input-
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement,
c
c        n is the order of the matrices,
c
c        a=(ar,ai) contains a complex general matrix,
c
c        b=(br,bi) contains a complex general matrix,
c
c        matz should be set to .true. if the right hand transformations
c          are to be accumulated for later use in computing
c          eigenvectors, and to .false. otherwise.
c
c     on output-
c
c        a has been reduced to upper hessenberg form.  the elements
c          below the first subdiagonal have been set to zero, and the
c          subdiagonal elements have been made real (and non-negative),
c
c        b has been reduced to upper triangular form.  the elements
c          below the main diagonal have been set to zero,
c
c        z=(zr,zi) contains the product of the right hand
c          transformations if matz has been set to .true.
c          otherwise, z is not referenced.
c
c     questions and comments should be directed to b. s. garbow,
c     applied mathematics division, argonne national laboratory
c
c     ------------------------------------------------------------------
c
c     ********** initialize z **********
      if (.not. matz) go to 10
c
      do 3 i = 1, n
c
         do 2 j = 1, n
            zr(i,j) = 0.0d0
            zi(i,j) = 0.0d0
    2    continue
c
         zr(i,i) = 1.0d0
    3 continue
c     ********** reduce b to upper triangular form with
c                temporarily real diagonal elements **********
   10 if (n .le. 1) go to 170
      nm1 = n - 1
c
      do 100 l = 1, nm1
*        ---------------------- Begin Timing Code ----------------------
         IOPST = 0
*        ----------------------- End Timing Code -----------------------
         l1 = l + 1
         s = 0.0d0
c
         do 20 i = l, n
            s = s + abs(br(i,l)) + abs(bi(i,l))
   20    continue
*        ---------------------- Begin Timing Code ----------------------
         IOPST = IOPST + 2*( N+1-L )
*        ----------------------- End Timing Code -----------------------
c
         if (s .eq. 0.0d0) go to 100
         rho = 0.0d0
c
         do 25 i = l, n
            br(i,l) = br(i,l) / s
            bi(i,l) = bi(i,l) / s
            rho = rho + br(i,l)**2 + bi(i,l)**2
   25    continue
c
         r = sqrt(rho)
         xr = abs(dcmplx(br(l,l),bi(l,l)))
         if (xr .eq. 0.0d0) go to 27
*        ---------------------- Begin Timing Code ----------------------
         IOPST = IOPST + 8
*        ----------------------- End Timing Code -----------------------
         rho = rho + xr * r
         u1 = -br(l,l) / xr
         u1i = -bi(l,l) / xr
         yr = r / xr + 1.0d0
         br(l,l) = yr * br(l,l)
         bi(l,l) = yr * bi(l,l)
         go to 28
c
   27    br(l,l) = r
         u1 = -1.0d0
         u1i = 0.0d0
c
   28    do 50 j = l1, n
            t = 0.0d0
            ti = 0.0d0
c
            do 30 i = l, n
               t = t + br(i,l) * br(i,j) + bi(i,l) * bi(i,j)
               ti = ti + br(i,l) * bi(i,j) - bi(i,l) * br(i,j)
   30       continue
c
            t = t / rho
            ti = ti / rho
c
            do 40 i = l, n
               br(i,j) = br(i,j) - t * br(i,l) + ti * bi(i,l)
               bi(i,j) = bi(i,j) - t * bi(i,l) - ti * br(i,l)
   40       continue
c
            xi = u1 * bi(l,j) - u1i * br(l,j)
            br(l,j) = u1 * br(l,j) + u1i * bi(l,j)
            bi(l,j) = xi
   50    continue
c
         do 80 j = 1, n
            t = 0.0d0
            ti = 0.0d0
c
            do 60 i = l, n
               t = t + br(i,l) * ar(i,j) + bi(i,l) * ai(i,j)
               ti = ti + br(i,l) * ai(i,j) - bi(i,l) * ar(i,j)
   60       continue
c
            t = t / rho
            ti = ti / rho
c
            do 70 i = l, n
               ar(i,j) = ar(i,j) - t * br(i,l) + ti * bi(i,l)
               ai(i,j) = ai(i,j) - t * bi(i,l) - ti * br(i,l)
   70       continue
c
            xi = u1 * ai(l,j) - u1i * ar(l,j)
            ar(l,j) = u1 * ar(l,j) + u1i * ai(l,j)
            ai(l,j) = xi
   80    continue
c
         br(l,l) = r * s
         bi(l,l) = 0.0d0
c
         do 90 i = l1, n
            br(i,l) = 0.0d0
            bi(i,l) = 0.0d0
   90    continue
*        ---------------------- Begin Timing Code ----------------------
         OPS = OPS + ( DBLE( 16*( N-L ) + 16*N + 30 )*DBLE( N-L ) +
     $                 DBLE( 24*N + 13 + IOPST ) )
*        ----------------------- End Timing Code -----------------------
c
  100 continue
c     ********** reduce a to upper hessenberg form with real subdiagonal
c                elements, while keeping b triangular **********
      do 160 k = 1, nm1
*        ---------------------- Begin Timing Code ----------------------
         OPST = 0.0d0
*        ----------------------- End Timing Code -----------------------
         k1 = k + 1
c     ********** set bottom element in k-th column of a real **********
         if (ai(n,k) .eq. 0.0d0) go to 105
         r = abs(dcmplx(ar(n,k),ai(n,k)))
         u1 = ar(n,k) / r
         u1i = ai(n,k) / r
         ar(n,k) = r
         ai(n,k) = 0.0d0
c
         do 103 j = k1, n
            xi = u1 * ai(n,j) - u1i * ar(n,j)
            ar(n,j) = u1 * ar(n,j) + u1i * ai(n,j)
            ai(n,j) = xi
  103    continue
c
         xi = u1 * bi(n,n) - u1i * br(n,n)
         br(n,n) = u1 * br(n,n) + u1i * bi(n,n)
         bi(n,n) = xi
*        ---------------------- Begin Timing Code ----------------------
         OPST = OPST + DBLE( 18 + 6*( N-K ) )
*        ----------------------- End Timing Code -----------------------
  105    if (k .eq. nm1) go to 170
         nk1 = nm1 - k
c     ********** for l=n-1 step -1 until k+1 do -- **********
         do 150 lb = 1, nk1
            l = n - lb
            l1 = l + 1
c     ********** zero a(l+1,k) **********
            s = abs(ar(l,k)) + abs(ai(l,k)) + ar(l1,k)
            if (s .eq. 0.0d0) go to 150
*           -------------------- Begin Timing Code ---------------------
            OPST = OPST + DBLE( 18 + 20*( 2*N-K-L ) )
*           --------------------- End Timing Code ----------------------
            u1 = ar(l,k) / s
            u1i = ai(l,k) / s
            u2 = ar(l1,k) / s
            r = sqrt(u1*u1+u1i*u1i+u2*u2)
            u1 = u1 / r
            u1i = u1i / r
            u2 = u2 / r
            ar(l,k) = r * s
            ai(l,k) = 0.0d0
            ar(l1,k) = 0.0d0
c
            do 110 j = k1, n
               xr = ar(l,j)
               xi = ai(l,j)
               yr = ar(l1,j)
               yi = ai(l1,j)
               ar(l,j) = u1 * xr + u1i * xi + u2 * yr
               ai(l,j) = u1 * xi - u1i * xr + u2 * yi
               ar(l1,j) = u1 * yr - u1i * yi - u2 * xr
               ai(l1,j) = u1 * yi + u1i * yr - u2 * xi
  110       continue
c
            xr = br(l,l)
            br(l,l) = u1 * xr
            bi(l,l) = -u1i * xr
            br(l1,l) = -u2 * xr
c
            do 120 j = l1, n
               xr = br(l,j)
               xi = bi(l,j)
               yr = br(l1,j)
               yi = bi(l1,j)
               br(l,j) = u1 * xr + u1i * xi + u2 * yr
               bi(l,j) = u1 * xi - u1i * xr + u2 * yi
               br(l1,j) = u1 * yr - u1i * yi - u2 * xr
               bi(l1,j) = u1 * yi + u1i * yr - u2 * xi
  120       continue
c     ********** zero b(l+1,l) **********
            s = abs(br(l1,l1)) + abs(bi(l1,l1)) + abs(br(l1,l))
            if (s .eq. 0.0d0) go to 150
*           -------------------- Begin Timing Code ---------------------
            OPST = OPST + DBLE( 13 + 20*( N+L ) )
*           --------------------- End Timing Code ----------------------
            u1 = br(l1,l1) / s
            u1i = bi(l1,l1) / s
            u2 = br(l1,l) / s
            r = sqrt(u1*u1+u1i*u1i+u2*u2)
            u1 = u1 / r
            u1i = u1i / r
            u2 = u2 / r
            br(l1,l1) = r * s
            bi(l1,l1) = 0.0d0
            br(l1,l) = 0.0d0
c
            do 130 i = 1, l
               xr = br(i,l1)
               xi = bi(i,l1)
               yr = br(i,l)
               yi = bi(i,l)
               br(i,l1) = u1 * xr + u1i * xi + u2 * yr
               bi(i,l1) = u1 * xi - u1i * xr + u2 * yi
               br(i,l) = u1 * yr - u1i * yi - u2 * xr
               bi(i,l) = u1 * yi + u1i * yr - u2 * xi
  130       continue
c
            do 140 i = 1, n
               xr = ar(i,l1)
               xi = ai(i,l1)
               yr = ar(i,l)
               yi = ai(i,l)
               ar(i,l1) = u1 * xr + u1i * xi + u2 * yr
               ai(i,l1) = u1 * xi - u1i * xr + u2 * yi
               ar(i,l) = u1 * yr - u1i * yi - u2 * xr
               ai(i,l) = u1 * yi + u1i * yr - u2 * xi
  140       continue
c
            if (.not. matz) go to 150
*           -------------------- Begin Timing Code ---------------------
            OPST = OPST + 20*N
*           --------------------- End Timing Code ----------------------
c
            do 145 i = 1, n
               xr = zr(i,l1)
               xi = zi(i,l1)
               yr = zr(i,l)
               yi = zi(i,l)
               zr(i,l1) = u1 * xr + u1i * xi + u2 * yr
               zi(i,l1) = u1 * xi - u1i * xr + u2 * yi
               zr(i,l) = u1 * yr - u1i * yi - u2 * xr
               zi(i,l) = u1 * yi + u1i * yr - u2 * xi
  145       continue
c
  150    continue
*        ---------------------- Begin Timing Code ----------------------
         OPS = OPS + ( OPST + DBLE( 2*( N-1-K ) ) )
*        ----------------------- End Timing Code -----------------------
c
  160 continue
c
  170 return
c     ********** last card of cqzhes **********
      end
      subroutine cqzval(nm,n,ar,ai,br,bi,eps1,alfr,alfi,beta,
     x                                       matz,zr,zi,ierr)
c
      integer i,j,k,l,n,en,k1,k2,ll,l1,na,nm,its,km1,lm1,
     x        enm2,ierr,lor1,enorn
      double precision ar(nm,n),ai(nm,n),br(nm,n),bi(nm,n),alfr(n),
     x       alfi(n),beta(n),zr(nm,n),zi(nm,n)
      double precision r,s,a1,a2,ep,sh,u1,u2,xi,xr,yi,yr,ani,a1i,a33,
     x       a34,a43,a44,bni,b11,b33,b44,shi,u1i,a33i,a34i,a43i,a44i,
     x       b33i,b44i,epsa,epsb,eps1,anorm,bnorm,b3344,b3344i
cc      real sqrt,csqrt,abs
      integer max0
      logical matz
      double complex z3
cc      complex csqrt,dcmplx
cc      real real,aimag
*
*     ----------------------- Begin Timing Code ------------------------
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
      DOUBLE PRECISION   OPST
      INTEGER            IOPST
*     ------------------------ End Timing Code -------------------------
*
c
c
c
c
c
c     this subroutine is a complex analogue of steps 2 and 3 of the
c     qz algorithm for solving generalized matrix eigenvalue problems,
c     siam j. numer. anal. 10, 241-256(1973) by moler and stewart,
c     as modified in technical note nasa tn e-7305(1973) by ward.
c
c     this subroutine accepts a pair of complex matrices, one of them
c     in upper hessenberg form and the other in upper triangular form,
c     the hessenberg matrix must further have real subdiagonal elements.
c     it reduces the hessenberg matrix to triangular form using
c     unitary transformations while maintaining the triangular form
c     of the other matrix and further making its diagonal elements
c     real and non-negative.  it then returns quantities whose ratios
c     give the generalized eigenvalues.  it is usually preceded by
c     cqzhes  and possibly followed by  cqzvec.
c
c     on input-
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement,
c
c        n is the order of the matrices,
c
c        a=(ar,ai) contains a complex upper hessenberg matrix
c          with real subdiagonal elements,
c
c        b=(br,bi) contains a complex upper triangular matrix,
c
c        eps1 is a tolerance used to determine negligible elements.
c          eps1 = 0.0 (or negative) may be input, in which case an
c          element will be neglected only if it is less than roundoff
c          error times the norm of its matrix.  if the input eps1 is
c          positive, then an element will be considered negligible
c          if it is less than eps1 times the norm of its matrix.  a
c          positive value of eps1 may result in faster execution,
c          but less accurate results,
c
c        matz should be set to .true. if the right hand transformations
c          are to be accumulated for later use in computing
c          eigenvectors, and to .false. otherwise,
c
c        z=(zr,zi) contains, if matz has been set to .true., the
c          transformation matrix produced in the reduction
c          by  cqzhes, if performed, or else the identity matrix.
c          if matz has been set to .false., z is not referenced.
c
c     on output-
c
c        a has been reduced to upper triangular form.  the elements
c          below the main diagonal have been set to zero,
c
c        b is still in upper triangular form, although its elements
c          have been altered.  in particular, its diagonal has been set
c          real and non-negative.  the location br(n,1) is used to
c          store eps1 times the norm of b for later use by  cqzvec,
c
c        alfr and alfi contain the real and imaginary parts of the
c          diagonal elements of the triangularized a matrix,
c
c        beta contains the real non-negative diagonal elements of the
c          corresponding b.  the generalized eigenvalues are then
c          the ratios ((alfr+i*alfi)/beta),
c
c        z contains the product of the right hand transformations
c          (for both steps) if matz has been set to .true.,
c
c        ierr is set to
c          zero       for normal return,
c          j          if ar(j,j-1) has not become
c                     zero after 50 iterations.
c
c     questions and comments should be directed to b. s. garbow,
c     applied mathematics division, argonne national laboratory
c
c     ------------------------------------------------------------------
c
      ierr = 0
c     ********** compute epsa,epsb **********
      anorm = 0.0d0
      bnorm = 0.0d0
c
      do 30 i = 1, n
         ani = 0.0d0
         if (i .ne. 1) ani = abs(ar(i,i-1))
         bni = 0.0d0
c
         do 20 j = i, n
            ani = ani + abs(ar(i,j)) + abs(ai(i,j))
            bni = bni + abs(br(i,j)) + abs(bi(i,j))
   20    continue
c
         if (ani .gt. anorm) anorm = ani
         if (bni .gt. bnorm) bnorm = bni
   30 continue
c
      if (anorm .eq. 0.0d0) anorm = 1.0d0
      if (bnorm .eq. 0.0d0) bnorm = 1.0d0
      ep = eps1
      if (ep .gt. 0.0d0) go to 50
c     ********** compute roundoff level if eps1 is zero **********
      ep = 1.0d0
   40 ep = ep / 2.0d0
      if (1.0d0 + ep .gt. 1.0d0) go to 40
   50 epsa = ep * anorm
      epsb = ep * bnorm
*     ----------------------- Begin Timing Code ------------------------
*     Count ops for norms, but not for calculation of "ep"
      OPS = OPS + DBLE( 2*N*( N+1 ) + 2 )
      OPST = 0.0d0
      ITCNT = 0.0d0
*     ------------------------ End Timing Code -------------------------
c     ********** reduce a to triangular form, while
c                keeping b triangular **********
      lor1 = 1
      enorn = n
      en = n
c     ********** begin qz step **********
   60 if (en .eq. 0) go to 1001
      if (.not. matz) enorn = en
      its = 0
      na = en - 1
      enm2 = na - 1
c     ********** check for convergence or reducibility.
c                for l=en step -1 until 1 do -- **********
   70 continue
*     ----------------------- Begin Timing Code ------------------------
      OPS = OPS + OPST
      OPST = 0.0d0
*     ------------------------ End Timing Code -------------------------
      do 80 ll = 1, en
         lm1 = en - ll
         l = lm1 + 1
         if (l .eq. 1) go to 95
         if (abs(ar(l,lm1)) .le. epsa) go to 90
   80 continue
c
   90 ar(l,lm1) = 0.0d0
c     ********** set diagonal element at top of b real **********
   95 b11 = abs(dcmplx(br(l,l),bi(l,l)))
      if (b11     .eq. 0.0d0) go to 98
      u1 = br(l,l) / b11
      u1i = bi(l,l) / b11
c
      do 97 j = l, enorn
         xi = u1 * ai(l,j) - u1i * ar(l,j)
         ar(l,j) = u1 * ar(l,j) + u1i * ai(l,j)
         ai(l,j) = xi
         xi = u1 * bi(l,j) - u1i * br(l,j)
         br(l,j) = u1 * br(l,j) + u1i * bi(l,j)
         bi(l,j) = xi
   97 continue
*     ----------------------- Begin Timing Code ------------------------
      OPST = OPST + DBLE( 7 + 12*( ENORN+1-L ) )
*     ------------------------ End Timing Code -------------------------
c
      bi(l,l) = 0.0d0
   98 if (l .ne. en) go to 100
c     ********** 1-by-1 block isolated **********
      alfr(en) = ar(en,en)
      alfi(en) = ai(en,en)
      beta(en) = b11
      en = na
      go to 60
c     ********** check for small top of b **********
  100 l1 = l + 1
      if (b11 .gt. epsb) go to 120
      br(l,l) = 0.0d0
      s = abs(ar(l,l)) + abs(ai(l,l)) + abs(ar(l1,l))
      u1 = ar(l,l) / s
      u1i = ai(l,l) / s
      u2 = ar(l1,l) / s
      r = sqrt(u1*u1+u1i*u1i+u2*u2)
      u1 = u1 / r
      u1i = u1i / r
      u2 = u2 / r
      ar(l,l) = r * s
      ai(l,l) = 0.0d0
c
      do 110 j = l1, enorn
         xr = ar(l,j)
         xi = ai(l,j)
         yr = ar(l1,j)
         yi = ai(l1,j)
         ar(l,j) = u1 * xr + u1i * xi + u2 * yr
         ai(l,j) = u1 * xi - u1i * xr + u2 * yi
         ar(l1,j) = u1 * yr - u1i * yi - u2 * xr
         ai(l1,j) = u1 * yi + u1i * yr - u2 * xi
         xr = br(l,j)
         xi = bi(l,j)
         yr = br(l1,j)
         yi = bi(l1,j)
         br(l1,j) = u1 * yr - u1i * yi - u2 * xr
         br(l,j) = u1 * xr + u1i * xi + u2 * yr
         bi(l,j) = u1 * xi - u1i * xr + u2 * yi
         bi(l1,j) = u1 * yi + u1i * yr - u2 * xi
  110 continue
*     ----------------------- Begin Timing Code ------------------------
      OPST = OPST + DBLE( 15 + 40*( ENORN-L ) )
*     ------------------------ End Timing Code -------------------------
c
      lm1 = l
      l = l1
      go to 90
c     ********** iteration strategy **********
  120 if (its .eq. 50) go to 1000
      if (its .eq. 10) go to 135
c     ********** determine shift **********
      b33 = br(na,na)
      b33i = bi(na,na)
      if (abs(dcmplx(b33,b33i)) .ge. epsb) go to 122
      b33 = epsb
      b33i = 0.0d0
  122 b44 = br(en,en)
      b44i = bi(en,en)
      if (abs(dcmplx(b44,b44i)) .ge. epsb) go to 124
      b44 = epsb
      b44i = 0.0d0
  124 b3344 = b33 * b44 - b33i * b44i
      b3344i = b33 * b44i + b33i * b44
      a33 = ar(na,na) * b44 - ai(na,na) * b44i
      a33i = ar(na,na) * b44i + ai(na,na) * b44
      a34 = ar(na,en) * b33 - ai(na,en) * b33i
     x    - ar(na,na) * br(na,en) + ai(na,na) * bi(na,en)
      a34i = ar(na,en) * b33i + ai(na,en) * b33
     x     - ar(na,na) * bi(na,en) - ai(na,na) * br(na,en)
      a43 = ar(en,na) * b44
      a43i = ar(en,na) * b44i
      a44 = ar(en,en) * b33 - ai(en,en) * b33i - ar(en,na) * br(na,en)
      a44i = ar(en,en) * b33i + ai(en,en) * b33 - ar(en,na) * bi(na,en)
      sh = a44
      shi = a44i
      xr = a34 * a43 - a34i * a43i
      xi = a34 * a43i + a34i * a43
*     ----------------------- Begin Timing Code ------------------------
      OPST = OPST + DBLE( 54 )
*     ------------------------ End Timing Code -------------------------
      if (xr .eq. 0.0d0 .and. xi .eq. 0.0d0) go to 140
      yr = (a33 - sh) / 2.0d0
      yi = (a33i - shi) / 2.0d0
      z3 = sqrt(dcmplx(yr**2-yi**2+xr,2.0d0*yr*yi+xi))
      u1 = dble(z3)
      u1i = dimag(z3)
      if (yr * u1 + yi * u1i .ge. 0.0d0) go to 125
      u1 = -u1
      u1i = -u1i
  125 z3 = (dcmplx(sh,shi) - dcmplx(xr,xi) / dcmplx(yr+u1,yi+u1i))
     x   / dcmplx(b3344,b3344i)
      sh = dble(z3)
      shi = dimag(z3)
*     ----------------------- Begin Timing Code ------------------------
      OPST = OPST + DBLE( 66 )
*     ------------------------ End Timing Code -------------------------
      go to 140
c     ********** ad hoc shift **********
  135 sh = ar(en,na) + ar(na,enm2)
      shi = 0.0d0
c     ********** determine zeroth column of a **********
  140 a1 = ar(l,l) / b11 - sh
      a1i = ai(l,l) / b11 - shi
      a2 = ar(l1,l) / b11
      its = its + 1
*     ----------------------- Begin Timing Code ------------------------
      ITCNT = ITCNT + 1.0d0
*     ------------------------ End Timing Code -------------------------
      if (.not. matz) lor1 = l
c     ********** main loop **********
      do 260 k = l, na
         k1 = k + 1
         k2 = k + 2
         km1 = max0(k-1,l)
c     ********** zero a(k+1,k-1) **********
         if (k .eq. l) go to 170
         a1 = ar(k,km1)
         a1i = ai(k,km1)
         a2 = ar(k1,km1)
  170    s = abs(a1) + abs(a1i) + abs(a2)
         u1 = a1 / s
         u1i = a1i / s
         u2 = a2 / s
         r = sqrt(u1*u1+u1i*u1i+u2*u2)
         u1 = u1 / r
         u1i = u1i / r
         u2 = u2 / r
c
         do 180 j = km1, enorn
            xr = ar(k,j)
            xi = ai(k,j)
            yr = ar(k1,j)
            yi = ai(k1,j)
            ar(k,j) = u1 * xr + u1i * xi + u2 * yr
            ai(k,j) = u1 * xi - u1i * xr + u2 * yi
            ar(k1,j) = u1 * yr - u1i * yi - u2 * xr
            ai(k1,j) = u1 * yi + u1i * yr - u2 * xi
            xr = br(k,j)
            xi = bi(k,j)
            yr = br(k1,j)
            yi = bi(k1,j)
            br(k,j) = u1 * xr + u1i * xi + u2 * yr
            bi(k,j) = u1 * xi - u1i * xr + u2 * yi
            br(k1,j) = u1 * yr - u1i * yi - u2 * xr
            bi(k1,j) = u1 * yi + u1i * yr - u2 * xi
  180    continue
c
         if (k .eq. l) go to 240
         ai(k,km1) = 0.0d0
         ar(k1,km1) = 0.0d0
         ai(k1,km1) = 0.0d0
c     ********** zero b(k+1,k) **********
  240    s = abs(br(k1,k1)) + abs(bi(k1,k1)) + abs(br(k1,k))
         u1 = br(k1,k1) / s
         u1i = bi(k1,k1) / s
         u2 = br(k1,k) / s
         r = sqrt(u1*u1+u1i*u1i+u2*u2)
         u1 = u1 / r
         u1i = u1i / r
         u2 = u2 / r
         if (k .eq. na) go to 245
         xr = ar(k2,k1)
         ar(k2,k1) = u1 * xr
         ai(k2,k1) = -u1i * xr
         ar(k2,k) = -u2 * xr
c
  245    do 250 i = lor1, k1
            xr = ar(i,k1)
            xi = ai(i,k1)
            yr = ar(i,k)
            yi = ai(i,k)
            ar(i,k1) = u1 * xr + u1i * xi + u2 * yr
            ai(i,k1) = u1 * xi - u1i * xr + u2 * yi
            ar(i,k) = u1 * yr - u1i * yi - u2 * xr
            ai(i,k) = u1 * yi + u1i * yr - u2 * xi
            xr = br(i,k1)
            xi = bi(i,k1)
            yr = br(i,k)
            yi = bi(i,k)
            br(i,k1) = u1 * xr + u1i * xi + u2 * yr
            bi(i,k1) = u1 * xi - u1i * xr + u2 * yi
            br(i,k) = u1 * yr - u1i * yi - u2 * xr
            bi(i,k) = u1 * yi + u1i * yr - u2 * xi
  250    continue
c
         bi(k1,k1) = 0.0d0
         br(k1,k) = 0.0d0
         bi(k1,k) = 0.0d0
         if (.not. matz) go to 260
c
         do 255 i = 1, n
            xr = zr(i,k1)
            xi = zi(i,k1)
            yr = zr(i,k)
            yi = zi(i,k)
            zr(i,k1) = u1 * xr + u1i * xi + u2 * yr
            zi(i,k1) = u1 * xi - u1i * xr + u2 * yi
            zr(i,k) = u1 * yr - u1i * yi - u2 * xr
            zi(i,k) = u1 * yi + u1i * yr - u2 * xi
  255    continue
c
  260 continue
*
*     ----------------------- Begin Timing Code ------------------------
*     Count ops for statements 140 -- 260
      IOPST = 29 + 40*( ENORN-LOR1+4 )
      IF( MATZ ) IOPST = IOPST + 20*N
      OPST = OPST + ( DBLE( N-L )*DBLE( IOPST ) + 2 )
      IF( L.LE.1 ) OPST = OPST - 40
*     ------------------------ End Timing Code -------------------------
*
c     ********** set last a subdiagonal real and end qz step **********
      if (ai(en,na) .eq. 0.0d0) go to 70
      r = abs(dcmplx(ar(en,na),ai(en,na)))
      u1 = ar(en,na) / r
      u1i = ai(en,na) / r
      ar(en,na) = r
      ai(en,na) = 0.0d0
c
      do 270 j = en, enorn
         xi = u1 * ai(en,j) - u1i * ar(en,j)
         ar(en,j) = u1 * ar(en,j) + u1i * ai(en,j)
         ai(en,j) = xi
         xi = u1 * bi(en,j) - u1i * br(en,j)
         br(en,j) = u1 * br(en,j) + u1i * bi(en,j)
         bi(en,j) = xi
  270 continue
*     ----------------------- Begin Timing Code ------------------------
      OPST = OPST + DBLE( 7 + 12*( EN+1-ENORN ) )
*     ------------------------ End Timing Code -------------------------
c
      go to 70
c     ********** set error -- bottom subdiagonal element has not
c                become negligible after 50 iterations **********
 1000 ierr = en
c     ********** save epsb for use by cqzvec **********
 1001 if (n .gt. 1) br(n,1) = epsb
*     ----------------------- Begin Timing Code ------------------------
      OPS = OPS + OPST
      OPST = 0.0d0
*     ------------------------ End Timing Code -------------------------
      return
c     ********** last card of cqzval **********
      end
      subroutine cqzvec(nm,n,ar,ai,br,bi,alfr,alfi,beta,zr,zi)
c
      integer i,j,k,m,n,en,ii,jj,na,nm,nn
      double precision ar(nm,n),ai(nm,n),br(nm,n),bi(nm,n),alfr(n),
     x       alfi(n),beta(n),zr(nm,n),zi(nm,n)
      double precision r,t,ri,ti,xi,almi,almr,betm,epsb
cc      real cabs
      double complex z3
cc      complex cmplx
cc      real real,aimag
c
c
*
*     ----------------------- Begin Timing Code ------------------------
*     Common block to return operation count and iteration count
*     ITCNT is initialized to 0, OPS is only incremented
*     OPST is used to accumulate small contributions to OPS
*     to avoid roundoff error
*     .. Common blocks ..
      COMMON             / LATIME / OPS, ITCNT
*     ..
*     .. Scalars in Common ..
      DOUBLE PRECISION   ITCNT, OPS
*     ..
*     ------------------------ End Timing Code -------------------------
*
c
c
c
c     this subroutine is a complex analogue of the fourth step of the
c     qz algorithm for solving generalized matrix eigenvalue problems,
c     siam j. numer. anal. 10, 241-256(1973) by moler and stewart.
c
c     this subroutine accepts a pair of complex matrices in upper
c     triangular form, where one of them further must have real diagonal
c     elements.  it computes the eigenvectors of the triangular problem
c     and transforms the results back to the original coordinate system.
c     it is usually preceded by  cqzhes  and  cqzval.
c
c     on input-
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement,
c
c        n is the order of the matrices,
c
c        a=(ar,ai) contains a complex upper triangular matrix,
c
c        b=(br,bi) contains a complex upper triangular matrix with real
c          diagonal elements.  in addition, location br(n,1) contains
c          the tolerance quantity (epsb) computed and saved in  cqzval,
c
c        alfr, alfi, and beta are vectors with components whose
c          ratios ((alfr+i*alfi)/beta) are the generalized
c          eigenvalues.  they are usually obtained from  cqzval,
c
c        z=(zr,zi) contains the transformation matrix produced in the
c          reductions by  cqzhes  and  cqzval, if performed.
c          if the eigenvectors of the triangular problem are
c          desired, z must contain the identity matrix.
c
c     on output-
c
c        a is unaltered,
c
c        b has been destroyed,
c
c        alfr, alfi, and beta are unaltered,
c
c        z contains the eigenvectors.  each eigenvector is normalized
c          so that the modulus of its largest component is 1.0 .
c
c     questions and comments should be directed to b. s. garbow,
c     applied mathematics division, argonne national laboratory
c
c     ------------------------------------------------------------------
c
      if (n .le. 1) go to 1001
      epsb = br(n,1)
c     ********** for en=n step -1 until 2 do -- **********
      do 800 nn = 2, n
         en = n + 2 - nn
         na = en - 1
         almr = alfr(en)
         almi = alfi(en)
         betm = beta(en)
c     ********** for i=en-1 step -1 until 1 do -- **********
         do 700 ii = 1, na
            i = en - ii
            r = 0.0d0
            ri = 0.0d0
            m = i + 1
c
            do 610 j = m, en
               t = betm * ar(i,j) - almr * br(i,j) + almi * bi(i,j)
               ti = betm * ai(i,j) - almr * bi(i,j) - almi * br(i,j)
               if (j .eq. en) go to 605
               xi = t * bi(j,en) + ti * br(j,en)
               t = t * br(j,en) - ti * bi(j,en)
               ti = xi
  605          r = r + t
               ri = ri + ti
  610       continue
c
            t = almr * beta(i) - betm * alfr(i)
            ti = almi * beta(i) - betm * alfi(i)
            if (t .eq. 0.0d0 .and. ti .eq. 0.0d0) t = epsb
            z3 = dcmplx(r,ri) / dcmplx(t,ti)
            br(i,en) = dble(z3)
            bi(i,en) = dimag(z3)
  700    continue
c
  800 continue
c     ********** end back substitution.
c                transform to original coordinate system.
c                for j=n step -1 until 2 do -- **********
      do 880 jj = 2, n
         j = n + 2 - jj
         m = j - 1
c
         do 880 i = 1, n
c
            do 860 k = 1, m
               zr(i,j) = zr(i,j) + zr(i,k) * br(k,j) - zi(i,k) * bi(k,j)
               zi(i,j) = zi(i,j) + zr(i,k) * bi(k,j) + zi(i,k) * br(k,j)
  860       continue
c
  880 continue
c     ********** normalize so that modulus of largest
c                component of each vector is 1 **********
      do 950 j = 1, n
         t = 0.0d0
c
         do 930 i = 1, n
            r = abs(dcmplx(zr(i,j),zi(i,j)))
            if (r .gt. t) t = r
  930    continue
c
         do 940 i = 1, n
            zr(i,j) = zr(i,j) / t
            zi(i,j) = zi(i,j) / t
  940    continue
c
  950 continue
c
 1001 continue
*
*     ----------------------- Begin Timing Code ------------------------
      OPS = OPS + DBLE( N )*DBLE( 14*N**2 + 15*N - 15 ) / DBLE( 2 )
*     ------------------------ End Timing Code -------------------------
*
      return
c     ********** last card of cqzvec **********
      end
