.TH  CHPGVX 1 "April 2011" " LAPACK driver routine (version 3.3.1) " " LAPACK driver routine (version 3.3.1) " 
.SH NAME
LAPACK-3 - computes selected eigenvalues and, optionally, eigenvectors of a complex generalized Hermitian-definite eigenproblem, of the form A*x=(lambda)*B*x, A*Bx=(lambda)*x, or B*A*x=(lambda)*x
.SH SYNOPSIS
.TP 19
SUBROUTINE CHPGVX(
ITYPE, JOBZ, RANGE, UPLO, N, AP, BP, VL, VU,
IL, IU, ABSTOL, M, W, Z, LDZ, WORK, RWORK,
IWORK, IFAIL, INFO )
.TP 19
.ti +4
CHARACTER
JOBZ, RANGE, UPLO
.TP 19
.ti +4
INTEGER
IL, INFO, ITYPE, IU, LDZ, M, N
.TP 19
.ti +4
REAL
ABSTOL, VL, VU
.TP 19
.ti +4
INTEGER
IFAIL( * ), IWORK( * )
.TP 19
.ti +4
REAL
RWORK( * ), W( * )
.TP 19
.ti +4
COMPLEX
AP( * ), BP( * ), WORK( * ), Z( LDZ, * )
.SH PURPOSE
CHPGVX computes selected eigenvalues and, optionally, eigenvectors
of a complex generalized Hermitian-definite eigenproblem, of the form
A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.  Here A and
 B are assumed to be Hermitian, stored in packed format, and B is also
 positive definite.  Eigenvalues and eigenvectors can be selected by
 specifying either a range of values or a range of indices for the
 desired eigenvalues.
.br
.SH ARGUMENTS
.TP 8
 ITYPE   (input) INTEGER
 Specifies the problem type to be solved:
.br
 = 1:  A*x = (lambda)*B*x
.br
 = 2:  A*B*x = (lambda)*x
.br
 = 3:  B*A*x = (lambda)*x
.TP 8
 JOBZ    (input) CHARACTER*1
.br
 = \(aqN\(aq:  Compute eigenvalues only;
.br
 = \(aqV\(aq:  Compute eigenvalues and eigenvectors.
.TP 8
 RANGE   (input) CHARACTER*1
.br
 = \(aqA\(aq: all eigenvalues will be found;
.br
 = \(aqV\(aq: all eigenvalues in the half-open interval (VL,VU]
 will be found;
 = \(aqI\(aq: the IL-th through IU-th eigenvalues will be found.
.TP 8
 UPLO    (input) CHARACTER*1
.br
 = \(aqU\(aq:  Upper triangles of A and B are stored;
.br
 = \(aqL\(aq:  Lower triangles of A and B are stored.
.TP 8
 N       (input) INTEGER
 The order of the matrices A and B.  N >= 0.
.TP 8
 AP      (input/output) COMPLEX array, dimension (N*(N+1)/2)
 On entry, the upper or lower triangle of the Hermitian matrix
 A, packed columnwise in a linear array.  The j-th column of A
 is stored in the array AP as follows:
 if UPLO = \(aqU\(aq, AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
 if UPLO = \(aqL\(aq, AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.
 On exit, the contents of AP are destroyed.
.TP 8
 BP      (input/output) COMPLEX array, dimension (N*(N+1)/2)
 On entry, the upper or lower triangle of the Hermitian matrix
 B, packed columnwise in a linear array.  The j-th column of B
 is stored in the array BP as follows:
 if UPLO = \(aqU\(aq, BP(i + (j-1)*j/2) = B(i,j) for 1<=i<=j;
 if UPLO = \(aqL\(aq, BP(i + (j-1)*(2*n-j)/2) = B(i,j) for j<=i<=n.
 On exit, the triangular factor U or L from the Cholesky
 factorization B = U**H*U or B = L*L**H, in the same storage
 format as B.
.TP 8
 VL      (input) REAL
 VU      (input) REAL
 If RANGE=\(aqV\(aq, the lower and upper bounds of the interval to
 be searched for eigenvalues. VL < VU.
 Not referenced if RANGE = \(aqA\(aq or \(aqI\(aq.
.TP 8
 IL      (input) INTEGER
 IU      (input) INTEGER
 If RANGE=\(aqI\(aq, the indices (in ascending order) of the
 smallest and largest eigenvalues to be returned.
 1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.
 Not referenced if RANGE = \(aqA\(aq or \(aqV\(aq.
.TP 8
 ABSTOL  (input) REAL
 The absolute error tolerance for the eigenvalues.
 An approximate eigenvalue is accepted as converged
 when it is determined to lie in an interval [a,b]
 of width less than or equal to
 ABSTOL + EPS *   max( |a|,|b| ) ,
 where EPS is the machine precision.  If ABSTOL is less than
 or equal to zero, then  EPS*|T|  will be used in its place,
 where |T| is the 1-norm of the tridiagonal matrix obtained
 by reducing AP to tridiagonal form.
 Eigenvalues will be computed most accurately when ABSTOL is
 set to twice the underflow threshold 2*SLAMCH(\(aqS\(aq), not zero.
 If this routine returns with INFO>0, indicating that some
 eigenvectors did not converge, try setting ABSTOL to
 2*SLAMCH(\(aqS\(aq).
.TP 8
 M       (output) INTEGER
 The total number of eigenvalues found.  0 <= M <= N.
 If RANGE = \(aqA\(aq, M = N, and if RANGE = \(aqI\(aq, M = IU-IL+1.
.TP 8
 W       (output) REAL array, dimension (N)
 On normal exit, the first M elements contain the selected
 eigenvalues in ascending order.
.TP 8
 Z       (output) COMPLEX array, dimension (LDZ, N)
 If JOBZ = \(aqN\(aq, then Z is not referenced.
 If JOBZ = \(aqV\(aq, then if INFO = 0, the first M columns of Z
 contain the orthonormal eigenvectors of the matrix A
 corresponding to the selected eigenvalues, with the i-th
 column of Z holding the eigenvector associated with W(i).
 The eigenvectors are normalized as follows:
 if ITYPE = 1 or 2, Z**H*B*Z = I;
 if ITYPE = 3, Z**H*inv(B)*Z = I.
 If an eigenvector fails to converge, then that column of Z
 contains the latest approximation to the eigenvector, and the
 index of the eigenvector is returned in IFAIL.
 Note: the user must ensure that at least max(1,M) columns are
 supplied in the array Z; if RANGE = \(aqV\(aq, the exact value of M
 is not known in advance and an upper bound must be used.
.TP 8
 LDZ     (input) INTEGER
 The leading dimension of the array Z.  LDZ >= 1, and if
 JOBZ = \(aqV\(aq, LDZ >= max(1,N).
.TP 8
 WORK    (workspace) COMPLEX array, dimension (2*N)
.TP 8
 RWORK   (workspace) REAL array, dimension (7*N)
.TP 8
 IWORK   (workspace) INTEGER array, dimension (5*N)
.TP 8
 IFAIL   (output) INTEGER array, dimension (N)
 If JOBZ = \(aqV\(aq, then if INFO = 0, the first M elements of
 IFAIL are zero.  If INFO > 0, then IFAIL contains the
 indices of the eigenvectors that failed to converge.
 If JOBZ = \(aqN\(aq, then IFAIL is not referenced.
.TP 8
 INFO    (output) INTEGER
 = 0:  successful exit
.br
 < 0:  if INFO = -i, the i-th argument had an illegal value
.br
 > 0:  CPPTRF or CHPEVX returned an error code:
.br
 <= N:  if INFO = i, CHPEVX failed to converge;
 i eigenvectors failed to converge.  Their indices
 are stored in array IFAIL.
 > N:   if INFO = N + i, for 1 <= i <= n, then the leading
 minor of order i of B is not positive definite.
 The factorization of B could not be completed and
 no eigenvalues or eigenvectors were computed.
.SH FURTHER DETAILS
 Based on contributions by
.br
    Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA
