      SUBROUTINE DGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
*
*  -- LAPACK routine (version 2.1) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     March 31, 1993
*
*  -- ESSL CCI enablement (version 1.1) --
*     Univ. of Tennessee, IBM Kingston and Yorktown,
*     August 1, 1994
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA, LWORK, N
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      DOUBLE PRECISION   A( LDA, * ), WORK( LWORK )
*     ..
*
*  Purpose
*  =======
*
*  DGETRI computes the inverse of a matrix using the LU factorization
*  computed by DGETRF.
*
*  This method inverts U and then computes inv(A) by solving the system
*  inv(A)*L = inv(U) for inv(A).
*
*  ESSL Enablement Comments
*  ==== ========== ========
*
*  This is a stub routine that calls the ESSL subroutine DGEICD.  In all
*  cases, the results returned will be identical in structure to those
*  of the normal LAPACK routine DGEICD.  Note that this stub will
*  allocate workspace needed by DGEICD that is not provided by
*  DGETRI.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
*          On entry, the factors L and U from the factorization
*          A = P*L*U as computed by DGETRF.
*          On exit, if INFO = 0, the inverse of the original matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  IPIV    (input) INTEGER array, dimension (N)
*          The pivot indices from DGETRF; for 1<=i<=N, row i of the
*          matrix was interchanged with row IPIV(i).
*
*  WORK    (workspace) DOUBLE PRECISION array, dimension (LWORK)
*          On exit, if INFO=0, then WORK(1) returns the optimal LWORK.
*
*  LWORK   (input) INTEGER
*          The dimension of the array WORK.  LWORK >= max(1,N).
*          For optimal performance LWORK >= N*NB, where NB is
*          the optimal blocksize returned by ILAENV.
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*          > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is
*                singular and its inverse could not be computed.
*
*  =====================================================================
*
*     .. Local Scalars ..
      CHARACTER*8        SV2105
      INTEGER            IERR1, IERR2
      DOUBLE PRECISION   DUM1, DUM2
*     ..
*     .. Local Arrays ..
      DOUBLE PRECISION, ALLOCATABLE  :: AUX( : )
*     ..
*     .. External Subroutines ..
      EXTERNAL           DCOPY, DGEICD, EINFO, ERRSAV, ERRSET, ERRSTR,
     $                   XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ALLOCATED, MAX
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      WORK( 1 ) = MAX( N, 1 )
      IF( N.LT.0 ) THEN
         INFO = -1
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -3
      ELSE IF( LWORK.LT.MAX( 1, N ) ) THEN
         INFO = -6
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'DGETRI', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Execute ESSL routine DGEICD
*
*     ESSL error-handling initialization
*
      CALL EINFO( 0, IERR1, IERR2 )
      CALL ERRSAV( 2105, SV2105 )
      CALL ERRSET( 2105, 256, -1, 0, 0, 2105 )
*
*     Call to appropriate ESSL routine
*
      IF( LWORK.GE.( 33*N ) ) THEN
         CALL DCOPY( N, IPIV, 1, WORK, 1 )
         CALL DGEICD( A, LDA, N, 4, DUM1, DUM2, WORK, LWORK, *20,
     $                *10 )
         GO TO 20
      ELSE
*
*        Allocate workspace not provided by LAPACK
*
         ALLOCATE( AUX( 100*N ) )
         CALL DCOPY( N, IPIV, 1, AUX, 1 )
         CALL DGEICD( A, LDA, N, 4, DUM1, DUM2, AUX, 100*N, *20,
     $                *10 )
         GO TO 20
      END IF
*
*     ESSL Run-time error:  save error information in INFO
*     and continue processing
*
   10 CONTINUE
      CALL EINFO( 2105, IERR1, IERR2 )
*
*     IERR1 gets the first occurrence of a pivot element that
*     cannot be reciprocated or is equal to zero.
*
      INFO = IERR1
*
*     Restore setting of parameters for error 2105
*
   20 CONTINUE
      CALL ERRSTR( 2105, SV2105 )
*
*     Deallocate workspace
*
      IF( ALLOCATED( AUX ) ) DEALLOCATE( AUX )
      RETURN
*
*     End of DGETRI
*
      END
