      SUBROUTINE CGETRF( M, N, A, LDA, IPIV, INFO )
*
*  -- LAPACK routine (version 2.1) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     March 31, 1993
*
*  -- ESSL CCI enablement (version 1.1) --
*     Univ. of Tennessee, IBM Kingston and Yorktown,
*     August 1, 1994
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      COMPLEX            A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  CGETRF computes an LU factorization of a general M-by-N matrix A
*  using partial pivoting with row interchanges.
*
*  The factorization has the form
*     A = P * L * U
*  where P is a permutation matrix, L is lower triangular with unit
*  diagonal elements (lower trapezoidal if m > n), and U is upper
*  triangular (upper trapezoidal if m < n).
*
*  This is the right-looking Level 3 BLAS version of the algorithm.
*
*  ESSL Enablement Comments
*  ==== ========== ========
*
*  This is a stub routine that calls the ESSL subroutine CGEF when
*  the input matrix is square (M = N).  If M.ne.N, CGETRF is the
*  LAPACK routine CGETRF (the right-looking Level 3 BLAS version of
*  the algorithm).  In all cases, the results returned will be identical
*  in structure to those of the normal LAPACK routine CGETRF.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the matrix A.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the matrix A.  N >= 0.
*
*  A       (input/output) COMPLEX array, dimension (LDA,N)
*          On entry, the M-by-N matrix to be factored.
*          On exit, the factors L and U from the factorization
*          A = P*L*U; the unit diagonal elements of L are not stored.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,M).
*
*  IPIV    (output) INTEGER array, dimension (min(M,N))
*          The pivot indices; for 1 <= i <= min(M,N), row i of the
*          matrix was interchanged with row IPIV(i).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*          > 0:  if INFO = i, U(i,i) is exactly zero. The factorization
*                has been completed, but the factor U is exactly
*                singular, and division by zero will occur if it is used
*                to solve a system of equations.
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX            ONE, ZERO
      PARAMETER          ( ONE = 1.0E+0, ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER*8        SV2103
      INTEGER            I, IERR1, IERR2, IINFO, J, JB, NB
*     ..
*     .. External Subroutines ..
      EXTERNAL           CGEF, CGEMM, CGETF2, CLASWP, CTRSM, EINFO,
     $                   ERRSAV, ERRSET, ERRSTR, XERBLA
*     ..
*     .. External Functions ..
      INTEGER            ILAENV
      EXTERNAL           ILAENV
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -4
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CGETRF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      IF( M.EQ.N ) THEN
*
*        Execute ESSL routine CGEF
*
*        ESSL error-handling initialization
*
         CALL EINFO( 0, IERR1, IERR2 )
         CALL ERRSAV( 2103, SV2103 )
         CALL ERRSET( 2103, 256, -1, 0, 0, 2103 )
*
*        Call to appropriate ESSL routine
*
         CALL CGEF( A, LDA, N, IPIV, *10 )
         GO TO 30
*
*        ESSL Run-time error:  use error information to
*        determine INFO and continue processing
*
   10    CONTINUE
         CALL EINFO( 2103, IERR1, IERR2 )
*
*        IERR1 gets the column number of the LAST zero diagonal element;
*        BUT, INFO needs to return the column number of the FIRST
*        zero diagonal element.  So, if an error is reported, we
*        re-examine all the elements on the diagonal up to IERR1
*        to find the correct value for INFO.
*
         DO 20 J = 1, IERR1
            IF( A( J, J ).EQ.ZERO ) THEN
               INFO = J
               GO TO 30
            END IF
   20    CONTINUE
*
*        Restore setting of parameters for error 2103
*
   30    CONTINUE
         CALL ERRSTR( 2103, SV2103 )
*
      ELSE
*
*        Execute LAPACK code for CGETRF
*
*        Determine the block size for this environment.
*
         NB = ILAENV( 1, 'CGETRF', ' ', M, N, -1, -1 )
         IF( NB.LE.1 .OR. NB.GE.MIN( M, N ) ) THEN
*
*           Use unblocked code.
*
            CALL CGETF2( M, N, A, LDA, IPIV, INFO )
         ELSE
*
*           Use blocked code.
*
            DO 50 J = 1, MIN( M, N ), NB
               JB = MIN( MIN( M, N )-J+1, NB )
*
*              Factor diagonal and subdiagonal blocks and test for exact
*              singularity.
*
               CALL CGETF2( M-J+1, JB, A( J, J ), LDA, IPIV( J ),
     $                      IINFO )
*
*              Adjust INFO and the pivot indices.
*
               IF( INFO.EQ.0 .AND. IINFO.GT.0 )
     $            INFO = IINFO + J - 1
               DO 40 I = J, MIN( M, J+JB-1 )
                  IPIV( I ) = J - 1 + IPIV( I )
   40          CONTINUE
*
*              Apply interchanges to columns 1:J-1.
*
               CALL CLASWP( J-1, A, LDA, J, J+JB-1, IPIV, 1 )
*
               IF( J+JB.LE.N ) THEN
*
*                 Apply interchanges to columns J+JB:N.
*
                  CALL CLASWP( N-J-JB+1, A( 1, J+JB ), LDA, J, J+JB-1,
     $                         IPIV, 1 )
*
*                 Compute block row of U.
*
                  CALL CTRSM( 'Left', 'Lower', 'No transpose', 'Unit',
     $                        JB, N-J-JB+1, ONE, A( J, J ), LDA,
     $                        A( J, J+JB ), LDA )
                  IF( J+JB.LE.M ) THEN
*
*                    Update trailing submatrix.
*
                     CALL CGEMM( 'No transpose', 'No transpose',
     $                           M-J-JB+1, N-J-JB+1, JB, -ONE,
     $                           A( J+JB, J ), LDA, A( J, J+JB ), LDA,
     $                           ONE, A( J+JB, J+JB ), LDA )
                  END IF
               END IF
   50       CONTINUE
         END IF
      END IF
      RETURN
*
*     End of CGETRF
*
      END
