/* raw2ras.c  --  routine to create an 8-bit grayscale rasterfile with */
/*                color map from a raw byte file.                      */
/* includes: main */

/* depends on: WriteRasterFile */

/* version 2.0     14 Jan 93 */

/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */


#include "stdio.h"
#include "malloc.h"
#include "rasterio.h"



char *Img;
struct rasterfile RasHd;	/* raster file header */



main( argc, argv )
   unsigned int argc;
   char * argv[];
   {
   int n = argc;
   int X = 512;
   int Y = 512;
   int i,N;
   byte *CMap;
   byte *C;


   /* check args */
   if ( argc > 1  && argv[1][0] == '?' )
      {
      fprintf(stderr, "usage:  raw2ras <In >Out [-X nnn] [-Y nnn]\n");
      exit(0);
      }


   /* get args */
   while ( --n )
      {
      if ( argv[n][0] == '-' )          /* then this is a switch */
         {
         if ( argv[n][1] == 'X' )  
            X = atoi( argv[n+1] );
         else if ( argv[n][1] == 'Y' )  
            Y = atoi( argv[n+1] );
         else
            {
            fprintf(stderr, "Invalid argument\n");
            fprintf(stderr, "usage:  raw2ras <In >Out [-X nnn] [-Y nnn]\n");
            exit(0);
            }
         }
      }


   /* calculate image data structure length */
   if ( X % 2 )
      {
      N = (X+1) * Y;
      }
   else
      {
      N = X * Y;
      }


   /* create rasterfile header */
   RasHd.ras_magic  = RAS_MAGIC;
   RasHd.ras_width  = X;
   RasHd.ras_height = Y;
   RasHd.ras_depth  = 8;
   RasHd.ras_length = N;
   RasHd.ras_type   = RT_STANDARD;
   RasHd.ras_maptype   = RMT_EQUAL_RGB;
   RasHd.ras_maplength = CMAPSZ;


   /* create a gray color map */
   if ( !(CMap = (byte *)malloc( CMAPSZ )) )
      {
      fprintf(stderr,"Unable to allocate space for colormap\n");
      exit( 0 );
      }
   C = CMap;
   N = CMAPSZ / 3;
   for ( i=0; i<N; ++i )
      {
      *C = i;
      *(C+N) = i;
      *(C+2*N) = i;
      ++C;
      }

   /* allocate and input raw image */
   if ( !(Img = calloc( X*Y, sizeof(char) )) )
      {
      fprintf(stderr,"Unable to allocate space for input image\n");
      exit(0);
      }
   if ( fread( Img, sizeof(char), X*Y, stdin ) != X*Y )
         {
         fprintf(stderr,"Error reading input image\n");
         exit(0);
         }

 
   /* write out rasterfile */
   WriteRasterFile( stdout, &RasHd, CMap, Img, 0, 0, 0, 0 );
   }




 
