/*
 * HeNCE wrapper generator
 *
 * Written by Jim Plank, September 1991
 * Modifications by Keith Moore
 */


%{
#include <sys/types.h>
#include <stdio.h>
#include "std.h"
#include "dlist.h"
#include "htypes.h"
#ifdef IMA_CRAY
#include <ctype.h>
#endif

static char yy_last_id[500];
static int yy_last_type;
static int n_inds = 0;

typedef struct {
  int t;
  int ind;
} Type;

static char *name;
static Type *ret_type;
static Type *type;
static Dlist args;
static nargs;

static int language;
#define LANG_C		0
#define LANG_FORTRAN	1
%}

%start all

/* identifiers and constants */
%token  TK_id TK_type TK_VOID

%%

all    : wrdecl
       | all wrdecl
       ;

wrdecl : first_type name call ';' {
	FILE *f;
	char *fname;
	int rv;
	int i, n;
	Dlist a;
	Type *t;
	char *s;

	fname = talloc(char, strlen(name) + 6);
         
	if (language == LANG_C)
		strcpy (fname, "cw_");
	else
		strcpy (fname, "fw_");
	strcat(fname, name);
	strcat(fname, ".c");

	rv = (ret_type->t != -1);

	f = fopen(fname, "w");
	if (f == NULL) {
		fprintf(stderr, "Couldn't open %s\n", fname);
		exit(1);
	}
	fprintf(f, "/* %s Wrapper for %s, created by HeNCE */\n\n",
			language == LANG_C ? "C" : "FORTRAN", name);
	fprintf(f, "#include <stdio.h>\n");
	fprintf(f, "#include \"std.h\"\n");
	fprintf(f, "#include \"rb.h\"\n");
	fprintf(f, "#include \"dlist.h\"\n");
	fprintf(f, "#include \"hence.h\"\n");
	fprintf(f, "#include \"htypes.h\"\n");
	fprintf(f, "\n");
	if (rv) {
		fprintf(f, "extern %s ", types[ret_type->t]);
		for (i = 0; i < ret_type->ind; i++) fprintf(f, "*");
		fprintf(f, "%s();\n\n", name);
	}

	fprintf(f, "hence_wrapper_call(nargs, args, ret_param)\n");
	fprintf(f, "int nargs;\n");
	fprintf(f, "Exp *args;\n");
	fprintf(f, "Param ret_param;\n");
	fprintf(f, "{\n");
	if (rv) {
		fftype(f, ret_type, 2);
		fprintf(f, "rv;\n");
		fprintf(f, "  int i;\n");
	} 
           
	n = 0;
	dl_traverse(a, args) {
		t = (Type *) a->val;
		fftype(f, t, 2);
		fprintf(f, "arg%d;\n", n);
		n++;
	}
	fprintf(f, "\n");

	fprintf(f, "  hence_narg_check(%d, nargs, \"%s\");\n\n", nargs, name);
         
	fprintf(f, "  hence_check_retp(ret_param, \"%s\", ", name); 
	if (!rv) 
		fprintf(f, "-1, -1);\n\n");
	else
		fprintf(f, "%s, %d);\n\n", TYPES[ret_type->t], ret_type->ind);

     
	fprintf(f, "  /* Perform type checking */\n\n");
	n = 0;
	dl_traverse(a, args) {
		t = (Type *) a->val;
		fprintf(f, "  hence_check_arg(%d, args, %s, %d, \"%s\");\n", 
				n, TYPES[t->t], t->ind, name);
		n++;
	}
	fprintf(f, "\n  /* Set arguments to their proper types */\n\n");
	n = 0;
	dl_traverse(a, args) {
		t = (Type *) a->val;
		fprintf(f, "  hence_exp_coerce((void *) (&arg%d), ", n);
		fprintf(f, "%s, %d, args[%d]);\n", TYPES[t->t], t->ind, n);
		n++;
	}

	fprintf(f, "\n  /* Make the call */\n\n");
	
	fprintf(f, "  ");
	if (rv) 
		fprintf(f, "rv = ");

	/*
	 * Most UNIX Fortran compilers append a _ to the name of
	 * the function to distingish it from similarly named
	 * functions written in C.  The CRAY compilers under
	 * Unicos uppercase the function name instead.
	 *
	 * The IMA_$(ARCH) variable is used here to adapt this
	 * to the host machine's arg passing convention.
	 *
	 * XXX should probably look at a command-line option or
	 * an ARCH variable and generate code for that machine.
	 */
	if (language == LANG_C)
		fprintf(f, "%s (", name);
	else if (language == LANG_FORTRAN) {
#ifdef IMA_CRAY
		/* CRAY requires that name be upper cased */
		char *s;

		for (s = name; *s; ++s)
			putc (islower (*s) ? toupper(*s) : *s, f);
		putc (' ', f);
		putc ('(' , f);
#else
		fprintf (f, "%s_ (", name);
#endif
	}
	if (language == LANG_C ) {
		for (i = 0; i < nargs; i++) {
			if (i > 0)
				fprintf(f, ", ");
			fprintf(f, "arg%d", i);
		}
	}
	else if (language == LANG_FORTRAN) {
		n = 0;
		dl_traverse (a, args) {
			t = (Type *) a->val;
			fprintf (f, "%s%sarg%d",
					 n > 0 ? ", " : "", /* comma arg separator */
					 t->ind ? "" : "&",	/* ampersand if scalar */
					 n);
			++n;
		}
	}
	fprintf(f, ");\n");

	if (rv) {
		fprintf(f, "\n  /* Set the return parameter */\n\n");
		if (ret_type->ind > 0) 
			s = ""; 
		else 
			s = "&";
		fprintf(f, "  set_returned_param((void *) %srv, ", s);
		fprintf(f, "%s, %d, ", TYPES[ret_type->t], ret_type->ind);
		fprintf(f, "ret_param, \"%s\");\n\n", name);
	}

	fprintf(f, "}\n\n");
	
	/* XXX need to call a FORTRAN-specific slave routine */

	if (language == LANG_C)
		fprintf(f, "main()\n{\n  slave();\n}\n\n");
	else if (language == LANG_FORTRAN)
#ifdef IMA_CRAY
		fprintf(f, "SLAVE ()\n{\n  slave(); \n}\n\n");
#else
		fprintf(f, "slave_ ()\n{\n  slave(); \n}\n\n");
#endif	
	dl_delete_list(args);
} ;

first_type: type
            { ret_type = type; args = make_dl(); nargs = 0; }
          ;

type: type_decl
      { type = talloc(Type, 1);
        type->t = yy_last_type;
        type->ind = n_inds;
        n_inds = 0;
      }
    | TK_VOID
      { type = talloc(Type, 1);
        type->t = -1;
        type->ind = 0;
        n_inds = 0;
      }
    ;
 
type_decl: TK_type
         | TK_type inds
         ;

inds: '*'
      { n_inds++; }
    | inds '*'
      { n_inds++; }
    ;

name: TK_id {
	      name = talloc (char, strlen (yy_last_id) + 1);
		  if (name == NULL) {
			  fprintf (stderr, "mkwrap: out of memory\n");
			  exit (0);
		  }
		  strcpy (name, yy_last_id);
	  }
      ;

call: '(' ')'
    | '(' args ')'
    ;

args: arg
    | args ',' arg
    ;

arg: type
     { dl_insert_b(args, type); nargs++; }
   ;

%%
	
#include "lex.yy.c"
	
yyerror()
{
	printf("syntax error at line %d token <%s>\n", yylineno, yytext);
	exit(1);
}

yywrap()
{ 
	return 1;
}

fftype(f, t, indent)
FILE *f;
Type *t;
int indent;
{
	int i;
	for (i = 0; i < indent; i++) fputc(' ', f);
	fprintf(f, "%s ", types[t->t]);
	for (i = 0; i < t->ind; i++) fprintf(f, "*");
}

ffstart(f, s, indent, newline)
FILE *f;
char *s;
int indent, newline;
{
	int i;
	for (i = 0; i < indent; i++) fputc(' ', f);
	fprintf(f, "fprintf(stderr, \"%s", s);
	if (newline) fprintf(f, "\\n");
	fprintf(f, "\"");
}

ffend(f)
FILE *f;
{
	fprintf(f, ");\n");
}

ffnarg(f, d)
FILE *f;
int d;
{
	fprintf(f, ", %d", d);
}

ffarg(f, s)
FILE *f;
char *s;
{
	fprintf(f, ", %s", s);
}

ffsarg(f, s)
FILE *f;
char *s;
{
	fprintf(f, ", \"%s\"", s);
}


main(argc, argv)
int argc;
char **argv;
{
	FILE *ff, *fp;
	
	while (argc > 1 && *argv[1] == '-') {
		if (strcmp (argv[1], "-c") == 0)
			language = LANG_C;
		else if (strcmp (argv[1], "-f") == 0)
			language = LANG_FORTRAN;
		--argc;
		++argv;
	}
	if (argc > 2) {
		fputs("usage: wrap [-c|-f] <file>\n", stderr);
		exit(1);
	}
	else if (argc == 1)
		ff = stdin;
	else {
		if ((ff = fopen (argv[1], "r")) == NULL) {
			fprintf (stderr, "%s: can't read file\n", argv[1]);
			exit (1);
		}
	}
	yyin = ff;
	yyparse ();
	
	if (language == LANG_FORTRAN) {
		if ((fp = fopen ("fmain.f", "w")) == NULL) {
			fprintf (stderr, "Can't create fmain.f\n");
			exit (1);
		}
		fprintf (fp, "c     FORTRAN meta-wrapper for HeNCE subroutine\n");
		fprintf (fp, "      call slave\n");
		fprintf (fp, "      stop\n");
		fprintf (fp, "      end\n");
		fclose (fp);
	}
	exit (0);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
