/*
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/RCS/req.c,v $
 * $Revision: 1.4 $
 * $Date: 1993/05/16 23:18:26 $
 * $Author: moore $
 */

/* Req.c contains the routines for requesting, and servicing requests for
 * array parameters.  */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

#ifdef PVM3
#include <pvm3.h>
#endif

typedef struct {
	Param p;
	int oth_pnum;
	int *starts;
	int *sizes;
} array_request;
typedef array_request *Array_request;

#define ARNULL ((Array_request)0)

static Param Sending;
#ifdef PVM3
static int To_node_tid;
#else
static char *To_node_proc;
static int To_node_inum;
#endif

void
bail_while_sending(signo)
int signo;						/* not used */
{
	fprintf(stderr, "%sERROR: Caught a segmentation violation:\n", sl_id());
	fprintf(stderr, "%s  While trying to send the array parameter: ", sl_id());
	fprint_param_brief(stderr, Sending);
#ifdef PVM3
	fprintf(stderr, "\n%s  to pvm process %x.\n%s\n", 
			sl_id(), To_node_tid, sl_id());
#else
	fprintf(stderr, "\n%s  to pvm process %s/%d.\n%s\n", 
			sl_id(), To_node_proc, To_node_inum, sl_id());
#endif
	fprintf(stderr, "%s  Hence has assumed that %s is ", 
			sl_id(), Sending->name);
	if (Sending->val == ENULL) {
		fprintf(stderr, "null.\n");
	} else if (Sending->val->type != ARRAY) {
		fprintf(stderr, "a constant %s.\n", types[Sending->val->type]);
	} else if (Sending->val->val.a->refd.ptr) {
		fprintf(stderr, "\n%s    a multi-dimensional array %s.\n", sl_id(),
				"(a tree of indirection pointers)");
		fprintf(stderr, "%s  This seg fault might have been caused by you\n",
				sl_id());
		fprintf(stderr, "%s    assuming that %s should be one large %s\n",
				sl_id(), Sending->name, "chunk of bytes.");
	} else {
		fprintf(stderr, "\n%s    a one-dimensional chunk of bytes %s.\n", sl_id());
		fprintf(stderr, "%s  This seg fault might have been caused by you\n",
				sl_id());
		fprintf(stderr, "%s    assuming that %s should be %s\n",
				sl_id(), Sending->name, "a multidimensional array.");
		fprintf(stderr, "%s    (i.e. a tree of indirection pointers)\n", sl_id());
	} bail(CNULL);
}

service_array_requests(parray)
Param parray;
{
	int msgtypes[2];
	int len, type;
#ifdef PVM3
	int tid;
	int bufid;
#else
	int inum;
	char proc[64];
#endif
	Array_request ar;
	
	Dlist reqs, d;
#if defined(IMA_RT) || defined(IMA_SYMM)
	int (*oldsig)();
#else
	void (*oldsig)();
#endif
	
	msgtypes[0] = HENCE_DIE;
	msgtypes[1] = HENCE_REQ;
	
	while(1) {
		reqs = make_dl();
#ifdef PVM3
		bufid = retro_rcvmulti (2, msgtypes);
		pvm_bufinfo (bufid, &len, &type, &tid);
#else
		rcvmulti(2, msgtypes);
		rcvinfo(&len, &type, proc, &inum);
#endif
		/*     printf("%sRcvd req for send (%d) from %s/%d\n",  */
		/*         sl_id(), type, proc, inum);  */
		/*     fflush(stdout); */
#ifdef PVM3
		To_node_tid = tid;
#else
		To_node_proc = proc;
		To_node_inum = inum;
#endif
		if (type == HENCE_DIE) {
			return;
		}
		
		/* Create the reqs list */
		unpack_array_requests(parray, reqs);
		
		oldsig = signal(SIGSEGV, bail_while_sending);
		/* Traverse the reqs list, and send out the junk */
#ifdef PVM3
		pvm_initsend (PvmDataDefault);
#else
		initsend();
#endif
		dl_traverse(d, reqs) {
			ar = (Array_request) d->val;
			pack_array_send(ar);
#ifdef PVM3
			trace_msg_send(ar->p->num, ar->oth_pnum, tid);
#else
			trace_msg_send(ar->p->num, ar->oth_pnum, proc, inum);
#endif
			free_ar(ar);
		}
		putint(-1);
		/*     printf("%sSending HENCE_SEND to %s/%d\n", sl_id(), proc, inum); */
		/*     fflush(stdout); */
#ifdef PVM3
		send_or_gripe (NULL, tid, HENCE_SEND);
#else
		send_or_gripe (proc, inum, HENCE_SEND);
#endif
		(void) signal(SIGSEGV, oldsig);
		dl_delete_list(reqs);
	}
}

get_arrays(aalist, parray, pva)
Dlist aalist;
Param parray;
Exp *pva;
{
	Dlist d;
	Array_anc aa, last_aa;
	
	last_aa = (Array_anc) 0;
	
	dl_traverse(d, aalist) {
		aa = (Array_anc) d->val;
		if (last_aa == (Array_anc) 0) {
			last_aa = aa;
#ifdef PVM3
			pvm_initsend (PvmDataDefault);
#else
			initsend();
#endif
		}
		if (aa->anc != last_aa->anc) {
			finish_array_request(last_aa, parray, pva);
			last_aa = aa;
#ifdef PVM3
			pvm_initsend (PvmDataDefault);
#else
			initsend();
#endif
		}
		pack_array_request(aa, parray);
	}
	if (last_aa != (Array_anc) 0) {
		finish_array_request(last_aa, parray, pva);
	}
}


pack_array_request(aa, parray)
Array_anc aa;
Param parray;
{
	Param p;
	int i;
	
#ifdef PVM3
	trace_msg_req(aa->sub_name, aa->pvmtid, aa->apnum, aa->mypnum);
#else
	trace_msg_req(aa->sub_name, aa->pvminum, aa->apnum, aa->mypnum);
#endif
	putint(aa->apnum);
	putint(aa->mypnum);
	p = &(parray[aa->mypnum]);
	for (i = 0; i < p->a->ndims; i++) {
		putint(h_l_bnd(p->a->dims[i]));
		putint(h_h_bnd(p->a->dims[i]));
	}
}

finish_array_request(last_aa, parray, pva)
Array_anc last_aa;
Param parray;
Exp *pva;
{
	int pnum;
	Param p;
	
	/* Send off the request */
	
	putint(-1);
	/*   printf("%sSending req\n", sl_id()); */
#ifdef PVM3
	send_or_gripe (last_aa->sub_name, last_aa->pvmtid, HENCE_REQ); 
	pvm_recv (-1, HENCE_SEND);
#else
	send_or_gripe (last_aa->sub_name, last_aa->pvminum, HENCE_REQ); 
	rcv(HENCE_SEND);
#endif
	/*   printf("%sReq recvd\n", sl_id()); */
	/*   fflush(stdout); */
	
	/* Receive the values */
	
	for (pnum = getint(); pnum != -1; pnum = getint()) {
		p = &(parray[pnum]);
		unpack_array_send(p, pva[pnum]);
	}
}

static
unpack_array_requests(parray, reqs)
Param parray;
Dlist reqs;
{
	Array_request ar;
	int mx, mn, pnum, i, j, k, ok;
	Parray a;
	
	for (pnum = getint(); pnum != -1; pnum = getint()) {
		ar = talloc(array_request, 1);
		ar->p = &(parray[pnum]);
		a = ar->p->a;
		ar->oth_pnum = getint();
		if (ar->p->type != ARRAY)
			bail("INTE: service_array_requests: ar->p->type != ARRAY\n");
		if (a->nadims > 0) {
			ar->starts = talloc(int, a->nadims);
			ar->sizes = talloc(int, a->nadims);
		} else {
			ar->starts = (int *) 0;
			ar->sizes = (int *) 0;
		}
		ok = (ar->p->val != ENULL);
		k = 0;
		for (i = 0; i < a->ndims; i++) {
			mn = h_l_bnd(a->dims[i]);
			mx = h_h_bnd(a->dims[i]);
			j = getint();
			if (j > mn) mn = j;
			j = getint();
			if (j < mx) mx = j;
			if (mx < mn) {
				ok = 0;
			} else if (a->dims[i]->elt_type == ']') {
				/* Do nothing */
			} else {
				if (k >= a->nadims) bail("INTE: unpack_array_requests: Bad k\n");
				ar->starts[k] = mn - h_l_bnd(a->dims[i]);
				ar->sizes[k] = mx - mn + 1;
				k++;
			}
		}
		if (k != a->nadims) bail("INTE: unpack_array_requests: Indeed Bad k\n");
		if (!ok) free_ar(ar); else dl_insert_b(reqs, (char *) ar);
	}
}

static
free_ar(ar)
Array_request ar;
{
	if (ar->sizes != (int *) 0) free(ar->sizes);
	if (ar->starts != (int *) 0) free(ar->starts);
	free(ar);
}

pack_array_send(ar)
Array_request ar;
{
	int i, j;
	int *ct;
	int ind;
	int ndm1, asm1;
	Array a;
	Param p;
	void ***ptrs;
	int *is;
	char *cs;
	float *fs;
	double *ds;
	
	/* Put the number of the receiving node's parameter */
	putint(ar->oth_pnum);
	
	ind = 0;
	j = 0;
	p = ar->p;
	Sending = p;
	
	/* For each dimension, put the starting elt & the # of elts */
	
	for(i = 0; i < p->a->ndims; i++) {
		if (p->a->dims[i]->elt_type == ']') {
			putint(h_l_bnd(p->a->dims[i]));
			putint(1);
		} else {
			putint(h_l_bnd(p->a->dims[i]) + ar->starts[j]);
			putint(ar->sizes[j]);
			j++;
		}
	}
	
	/* If the array is a constant, put its val & return */
	
	if (p->a->nadims == 0) {
		switch(p->val->type) {
		case INT: putint(p->val->val.i); break;
		case CHAR: putbyte(p->val->val.c); break;
		case FLOAT: putfloat(p->val->val.f); break;
		case DOUBLE: putdouble(p->val->val.d); break;
		default: bail("INTE: pack_array_send: Unknown type\n");
		}
		return;
	}
	
	if (p->val->type != ARRAY)
		bail("INTE: pack_array_send: p->val->type != ARRAY\n");
	if (p->val->val.a->ndims != p->a->nadims)
		bail("INTE: pack_array_send: p->val->val.a->ndims != p->nadims\n");
	
	/* Otherwise, put all the values.  There are two cases here:
	 * First, if the parameter is io or it is just a large chunk
	 * of bytes, calculate the correct indices, and send the bytes
	 * from p->val->val.a->v.x.  Otherwise, the pointer tree must
	 * be traversed to find the values */
	
	ind = 0;
	a = p->val->val.a;
	ndm1 = a->ndims - 1;
	asm1 = ar->starts[ndm1];
	ct = talloc(int, p->a->nadims);
	if (a->refd.ptr) {
		ptrs = talloc(void **, a->ndims);
		ptrs[0] = (void **) a->ptr;
	} else {
		ind = 0;
	}
	
	for(i = 0; i < a->ndims; i++) {
		ct[i] = 0;
		if (!a->refd.ptr) {
			ind += a->indsize[i] * ar->starts[i];
		}
	}
	
	if (a->refd.ptr) {
		i = 0;
		while(ct[0] < ar->sizes[0]) {
			for (i++ ; i < a->ndims ; i++ ) {
				ptrs[i] = (void **) (ptrs[i-1][ar->starts[i-1]+ct[i-1]]);
			}
			switch(a->type) {
			case INT: 
				is = (int *) (ptrs[ndm1]);
				putint(is[asm1 + ct[ndm1]]);
				break;
			case CHAR: 
				cs = (char *) (ptrs[ndm1]);
				putbyte(cs[asm1 + ct[ndm1]]);
				break;
			case FLOAT: 
				fs = (float *) (ptrs[ndm1]);
				putfloat(fs[asm1 + ct[ndm1]]);
				break;
			case DOUBLE: 
				ds = (double *) (ptrs[ndm1]);
				putdouble(ds[asm1 + ct[ndm1]]);
				break;
			default: bail("INTE: pack_array_send: Unknown a->type\n");
			}
			ct[a->ndims - 1] += 1;
			for(i = ndm1; i > 0 && ct[i] == ar->sizes[i]; i--) {
				ct[i] = 0;
				ct[i-1] += 1;
			}
		}
		free(ptrs);
	} else {
		while(ct[0] < ar->sizes[0]) {
			switch(a->type) {
			case INT: putint(a->v.i[ind]); break;
			case CHAR: putbyte(a->v.c[ind]); break;
			case FLOAT: putfloat(a->v.f[ind]); break;
			case DOUBLE: putdouble(a->v.d[ind]); break;
			default: bail("INTE: pack_array_send: Unknown a->type\n");
			}
			ind += a->indsize[a->ndims - 1];
			ct[a->ndims - 1] += 1;
			for(i = a->ndims - 1; i > 0 && ct[i] == ar->sizes[i]; i--) {
				ind -= a->indsize[i] * ct[i];
				ct[i] = 0;
				ind += a->indsize[i-1];
				ct[i-1] += 1;
			}
		}
	}
	free(ct);
}

unpack_array_send(p, e)
Param p;
Exp e;
{
	int i, j, k, *starts, *sizes, *ct, mn, mx, ind;
	Array a;
	
	/* Get the starts & sizes */
	
	if (p->a->nadims > 0) {
		starts = talloc(int, p->a->nadims);
		sizes = talloc(int, p->a->nadims);
	}
	
	k = 0;
	for (i = 0; i < p->a->ndims; i++) {
		mn = h_l_bnd(p->a->dims[i]);
		mx = h_h_bnd(p->a->dims[i]);
		j = getint();
		if (j < mn || j > mx)
			bail("INTE: unpack_array_send: j < mn || j > mx\n");
		mn = j;
		j = getint();
		if (mn + j - 1 > mx || j <= 0)
			bail("INTE: unpack_array_send: mn + j - 1 > mx || j <= 0");
		if (p->a->dims[i]->elt_type == '.') {
			starts[k] = mn - h_l_bnd(p->a->dims[i]);
			sizes[k] = j;
			k++;
		}
	}
	
	if (k != p->a->nadims)
		bail("INTE: unpack_array_send: k != p->a->ndims\n");

	if (p->a->nadims == 0) {
		switch(e->type) {
		case INT: e->val.i = getint(); break;
		case CHAR: e->val.d = getbyte(); break;
		case FLOAT: e->val.f = getfloat(); break;
		case DOUBLE: e->val.d = getdouble(); break;
		default: bail("INTE: unpack_array_send: Unknown type\n");
		}
		return;
	}
	
	a = e->val.a;
	if (a->ndims != p->a->nadims) 
		bail("INTE: unpack_array_send: a->ndims != p->a->nadims\n");
	
	ct = talloc(int, a->ndims);
	ind = 0;
	
	for(i = 0; i < a->ndims; i++) {
		ct[i] = 0;
		ind += a->indsize[i] * starts[i];
	}
	
	while(ct[0] < sizes[0]) {
		switch(a->type) {
		case INT: a->v.i[ind] = getint(); break;
		case CHAR: a->v.c[ind] = getbyte(); break;
		case FLOAT: a->v.f[ind] = getfloat(); break;
		case DOUBLE: a->v.d[ind] = getdouble(); break;
		default: bail("INTE: unpack_array_send: Unknown a->type\n");
		}
		ind += a->indsize[a->ndims - 1];
		ct[a->ndims - 1] += 1;
		for(i = a->ndims - 1; i > 0 && ct[i] == sizes[i]; i--) {
			ind -= a->indsize[i] * ct[i];
			ct[i] = 0;
			ind += a->indsize[i-1];
			ct[i-1] += 1;
		}
	}
	free(ct);
	free(sizes);
	free(starts);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
