/*
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/RCS/pvmhelp.c,v $
 * $Revision: 1.3 $
 * $Date: 1993/05/16 23:17:39 $
 * $Author: moore $
 */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

#ifdef PVM3
#include <pvm3.h>
#endif

void segv_catch()
{
  bail("Caught a segv\n");
}

static int is_slave = 0;
#ifdef PVM3
static int Mas_tid;
#else
static char *Mas_name;
static int Mas_num;
#endif
static Rb_node Alive = (Rb_node) 0;
static int ispvmon = 0;

pvmon()
{
  ispvmon = 1;
}

pvmoff()
{
  ispvmon = 0;
}

set_master(a)
Rb_node a;
{
  is_slave = 0;
  Alive = a;
}

#ifdef PVM3
set_slave(mas_tid)
int mas_tid;
{
  Mas_tid = mas_tid;
  is_slave = 1;
  ispvmon = 1;
}
#else
set_slave(mas_name, mas_num)
char *mas_name;
int mas_num;
{
  Mas_name = copy_string(mas_name);
  Mas_num = mas_num;
  is_slave = 1;
  ispvmon = 1;
}
#endif

nice_bail(s)
char *s;
{
  (void) fflush(stdout);
  trace_flush();
  if (s != CNULL) fprintf(stderr, s);
  (void) fflush(stderr);
  if (is_slave) {
#ifdef PVM3
    pvm_initsend (PvmDataDefault);
    send_or_gripe (NULL, Mas_tid, HENCE_DIE);
#else
    initsend();
    send_or_gripe (Mas_name, Mas_num, HENCE_DIE);
#endif
  } else {
    master_death(Alive);
  }
#ifdef PVM3
  if (ispvmon) pvm_exit ();
#else
  if (ispvmon) leave();
#endif
  (void) exit((int)1);
}

bail(s)
char *s;
{
  (void) signal(SIGSEGV, SIG_DFL);
  (void) fflush(stdout);
  trace_flush();
  if (s != CNULL) fprintf(stderr, s);
  if (is_slave) {
    fprintf(stderr, "\n\n%sBailing\n\n", sl_id());
    (void) fflush(stderr);
#ifdef PVM3
    pvm_initsend (PvmDataDefault);
    send_or_gripe (NULL, Mas_tid, HENCE_DIE);
#else
    initsend();
    send_or_gripe (Mas_name, Mas_num, HENCE_DIE);
#endif
#ifdef PVM3
    pvm_exit ();
#else
    leave();
#endif
    { char *a = (char *)0; a[0] = 0; }
/*     exit(1); */
  } else {
    fprintf(stderr, "\n\nBailing\n\n");
    (void) fflush(stderr);
    if (ispvmon) {
#ifdef PVM3
	pvm_exit ();
#else
	leave();
#endif
	master_death(Alive);
    }
    { char *a = (char *)0; a[0] = 0; }
  }
}

master_death(alive)
Rb_node alive;
{
  Rb_node r;
  Node n;

  if (alive == (Rb_node) 0) return;
  rb_traverse(r, alive) {
    n = (Node) r->v.val;
/*     printf("Sending Die message to %d/%d (%s/%d)\n", n->id, n->inst, */
/*       n->sub_name, n->pvminum); */
/*     fflush(stdout); */
#ifdef PVM3
    pvm_initsend (PvmDataDefault);
    send_or_gripe (n->sub_name, n->pvmtid, HENCE_DIE);
#else
    initsend();
    send_or_gripe (n->sub_name, n->pvminum, HENCE_DIE);
#endif
  }
}

putint(n)
int n;
{
#ifdef PVM3
  pvm_pkint (&n, 1, 1);
#else
  putnint(&n, 1);
#endif
}

int getint()
{
  int n;
#ifdef PVM3
  pvm_upkint (&n, 1, 1);
#else
  getnint(&n, 1);
#endif
  return n;
}

putfloat(n)
float n;
{
  float f = n;
#ifdef PVM3
  pvm_pkfloat (&f, 1, 1);
#else
  putnfloat(&f, 1);
#endif
}

float getfloat()
{
  float n[1];
#ifdef PVM3
  pvm_upkfloat (n, 1, 1);
#else
  getnfloat(n, 1);
#endif
  return n[0];
}

putdouble(n)
double n;
{
#ifdef PVM3
    pvm_pkdouble (&n, 1, 1);
#else
    putndfloat(&n, 1);
#endif
}

double getdouble()
{
    double n[1];
#ifdef PVM3
    pvm_upkdouble (n, 1, 1);
#else
    getndfloat(n, 1);
#endif
    return n[0];
}

putbyte(n)
char n;
{
#ifdef PVM3
    pvm_pkbyte (&n, 1, 1);
#else
    putbytes(&n, 1);
#endif
}

char getbyte()
{
  char n;
#ifdef PVM3
  pvm_upkbyte (&n, 1, 1);
#else
  getbytes(&n, 1);
#endif
  return n;
}

putlstring(s)
char *s;
{
  putint(strlen(s));
#ifdef PVM3
  pvm_pkstr (s);
#else
  putstring(s);
#endif
}

char *getlstring()
{
  char *s;
  int len;
#ifdef PVM3
  pvm_upkint (&len, 1, 1);
#else
  getnint(&len, 1);
#endif
  s = talloc(char, len);
#ifdef PVM3
  pvm_upkstr (s);
#else
  getstring (s);
#endif
  return s;
}

put_array(a)
Array a;
{
  int i;

  putint(a->type);
  putint(a->ndims);
  for (i = 0; i < a->ndims; i++) {
    putint(a->size[i]);
    putint(a->indsize[i]);
  }
  putint(a->tsize);
#ifdef PVM3
  switch(a->type) {
    case INT: pvm_pkint (a->v.i, a->tsize, 1); break;
    case FLOAT: pvm_pkfloat (a->v.f, a->tsize, 1); break;
    case CHAR: pvm_pkbyte (a->v.c, a->tsize, 1); break;
    case DOUBLE: pvm_pkdouble (a->v.d, a->tsize, 1); break;
    default: bail("INT ERROR: put_array: bad type\n"); break;
  }
#else
  switch(a->type) {
    case INT: putnint(a->v.i, a->tsize); break;
    case FLOAT: putnfloat(a->v.f, a->tsize); break;
    case CHAR: putbytes(a->v.c, a->tsize); break;
    case DOUBLE: putndfloat(a->v.d, a->tsize); break;
    default: bail("INT ERROR: put_array: bad type\n"); break;
  }
#endif
}
  
Array get_array()
{
  Array a;
  int i;
  int tp, ndims;

  tp = getint();
  ndims = getint();
  a = brand_new_array(tp, ndims);
  a->refd.init = 1;
  for (i = 0; i < a->ndims; i++) {
    a->size[i] = getint();
    a->indsize[i] = getint();
  }
  a->tsize = getint();
#ifdef PVM3
  switch(a->type) {
    case INT: 
      a->v.i = talloc(int, a->tsize); 
      pvm_upkint (a->v.i, a->tsize, 1); 
      break;
    case FLOAT: 
      a->v.f = talloc(float, a->tsize); 
      pvm_upkfloat (a->v.f, a->tsize, 1); 
      break;
    case CHAR: 
      a->v.c = talloc(char, a->tsize); 
      pvm_upkbyte (a->v.c, a->tsize, 1);
      break;
    case DOUBLE: 
      a->v.d = talloc(double, a->tsize); 
      pvm_upkdouble (a->v.d, a->tsize, 1); 
      break;
    default:
      bail("INT ERROR: get_array: bad type\n"); break;
      break;
  }
#else
  switch(a->type) {
    case INT: 
      a->v.i = talloc(int, a->tsize); 
      getnint(a->v.i, a->tsize); 
      break;
    case FLOAT: 
      a->v.f = talloc(float, a->tsize); 
      getnfloat(a->v.f, a->tsize); 
      break;
    case CHAR: 
      a->v.c = talloc(char, a->tsize); 
      getbytes(a->v.c, a->tsize); 
      break;
    case DOUBLE: 
      a->v.d = talloc(double, a->tsize); 
      getndfloat(a->v.d, a->tsize); 
      break;
    default:
      bail("INT ERROR: get_array: bad type\n"); break;
      break;
  }
#endif
  build_ptr_tree(a);
  return a;
}
  
  
put_exp(e)
Exp e;
{
  int i;

  if (e == ENULL) {
    putint(0);
    return;
  }
  putint(e->elt_type);
  putint(e->type);
  switch (e->elt_type) {
  case 'P': putint(e->val.p->num); break;
  case 'c': 
#ifdef PVM3
    switch(e->type) {
      case INT: putint(e->val.i); break;
      case FLOAT: pvm_pkfloat (&(e->val.f), 1, 1); break;
      case CHAR: putbyte(e->val.c); break;
      case DOUBLE: putdouble(e->val.d); break;
      case ARRAY: put_array(e->val.a); break;
      default: fprintf(stderr, "PUT_EXP: Unknown 'c' type %d\n", e->type);
               bail(CNULL);
               break;
      }
#else
    switch(e->type) {
      case INT: putint(e->val.i); break;
      case FLOAT: putnfloat(&(e->val.f), 1); break;
      case CHAR: putbyte(e->val.c); break;
      case DOUBLE: putdouble(e->val.d); break;
      case ARRAY: put_array(e->val.a); break;
      default: fprintf(stderr, "PUT_EXP: Unknown 'c' type %d\n", e->type);
               bail(CNULL);
               break;
      }
#endif
      break;
  case 'p':
  case 't':
    fprintf(stderr, "ERROR: Can't put expression with type '%c':\n", 
            e->elt_type);
    fprint_exp(stderr, e);
    bail(CNULL);
    break;
  case '[':
  case 'M':
  case 'I':
  case 'N':
  case 'C':
  case 'A':
  case ']':
  case '*':
  case '/':
  case '%':
  case '+':
  case '-':
  case 'L':
  case 'R':
  case '<':
  case '>':
  case 'l':
  case 'g':
  case '!':
  case '=':
  case '&':
  case '^':
  case '|':
  case 'a':
  case 'o':
  case '.':
  case '?':
    break;
  default:
    fprintf(stderr, "Putting EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }
  for (i = 0; i < e->nargs; i++) put_exp(e->args[i]);
}

Exp get_exp(parray)
Param parray;
{
  Exp e;
  int elt_type, i;

  elt_type = getint();
  if (elt_type == 0) return ENULL;
  e = talloc(struct expression, 1);
  e->elt_type = elt_type;
  e->type = getint();
  
  switch (e->elt_type) {
  case 'P': e->nargs = 0; i = getint(); e->val.p = &(parray[i]); break;
  case 'c': 
    e->nargs = 0;
    switch(e->type) {
      case INT: e->val.i = getint(); break;
      case FLOAT: e->val.f = getfloat(); break; 
      case CHAR: e->val.c = getbyte(); break;
      case DOUBLE: e->val.d = getdouble(); break;
      case ARRAY: e->val.a = get_array(); break;
      default: fprintf(stderr, "GET_EXP: Unknown 'c' type %d\n", e->type);
               bail(CNULL);
               break;
      }
    break;
  case 'p':
  case 't':
    fprintf(stderr, "ERROR: Can't get expression with type '%c':\n", 
            e->elt_type);
    fprint_exp(stderr, e);
    bail(CNULL);
    break;
  case '[':
    e->nargs = 0;
    break;
  case 'M':
  case 'I':
  case 'N':
  case 'C':
  case 'A':
  case ']':
    e->nargs = 1;
    break;
  case '*':
  case '/':
  case '%':
  case '+':
  case '-':
  case 'L':
  case 'R':
  case '<':
  case '>':
  case 'l':
  case 'g':
  case '!':
  case '=':
  case '&':
  case '^':
  case '|':
  case 'a':
  case 'o':
  case '.':
    e->nargs = 2;
    break;
  case '?':
    e->nargs = 3;
    break;
  default:
    fprintf(stderr, "Getting EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }

  for (i = 0; i < e->nargs; i++) e->args[i] = get_exp(parray);
  return e;
}



put_param(p)
Param p;
{
  int i;

  putint(p->num);
  putlstring(p->name);
  putbyte((char) p->io.in);
  putbyte((char) p->io.out);
  putbyte((char) p->io.used);
  putbyte((char) p->io.main);
  putint(p->type);
  if (p->type == ARRAY) {
    putint(p->a->type);
    putint(p->a->ndims); 
    putint(p->a->nadims); 
    putint(p->a->n_level2);
    if (p->a->main == PNULL) bail("INTE: put_param: p->a->main == PNULL\n");
    putint(p->a->main->num);
    for (i = 0; i < p->a->ndims; i++) put_exp(p->a->dims[i]); 
  }
  put_exp(p->val);
}

get_param(parray)  /* For get_param, the parameter is put into its slot in
                      the array parray */
Param parray;
{
  Param p;
  int pnum, i, t, nd;

  pnum = getint();
  p = &(parray[pnum]);
  p->num = pnum;
  p->name = getlstring();
  p->io.in = getbyte();
  p->io.out = getbyte();
  p->io.used = getbyte();
  p->io.main = getbyte();
  p->type = getint();
  if (p->type == ARRAY) {
    t = getint();
    nd = getint();
    p->a = new_parray(t, nd);
    p->a->nadims = getint();
    p->a->n_level2 = getint();
    p->a->main = &(parray[getint()]);
    for (i = 0; i < p->a->ndims; i++) p->a->dims[i] = get_exp(parray);
  }
  p->val = get_exp(parray);
}

put_aa(n)
Node n;
{
  Dlist d;
  Array_anc aa;

  dl_traverse(d, n->aa) {
    aa = (Array_anc) d->val;
    putint((int)aa->anc);
    putlstring(aa->sub_name);
#ifdef PVM3
    putint(aa->pvmtid);
#else
    putint(aa->pvminum);
#endif
    putint(aa->apnum);
    putint(aa->mypnum);
  }
  putint(0);
}

Dlist get_aa()
{
  Dlist d;
  Array_anc aa;
  int i;

  d = make_dl();
  for (i = getint(); i != 0; i = getint()) {
    aa = talloc(array_anc, 1);
    aa->anc = (void *) i;
    aa->sub_name = getlstring();
#ifdef PVM3
    aa->pvmtid = getint();
#else
    aa->pvminum = getint();
#endif
    aa->apnum = getint();
    aa->mypnum = getint();
    dl_insert_b_aa(d, aa);
  }
  return d;
}

char *
pvm_strerror (x)
int x;
{
    extern int pvm_nerr;
    extern char *pvm_errlist[];

    if (x < 0)
	x = -x;
    if (x >= pvm_nerr)
	return "unknown";
    return pvm_errlist[x];
}

#ifdef PVM3
send_or_gripe (name, tid, code)
char *name;
int tid;
int code;
{
    int foo;
    extern int pvm_aerr;
    int bar;

    bar = pvm_serror (0);

    if ((foo = pvm_send (tid, code)) < 0) {
	if (code == HENCE_DIE && foo == PvmNoTask)
	    ;
	else {
	    if (name)
		fprintf (stderr,
			 "pvm_send (%x,%d) [to \"%s\"] failed. (%s)\n",
			 tid, code, name, pvm_strerror (foo));
	    else
		fprintf (stderr,
			 "pvm_send (%x,%d) failed.  (%s)\n",
			 tid, code, pvm_strerror (foo));
	}
    }
    pvm_serror (bar);
#if 0
    abort ();
#endif
}
#else
#define PvmNoComp -8		/* from pvm2.4.1/src/pvmuser.h */

send_or_gripe (name, inst, code)
char *name;
int inst;
int code;
{
    int foo;
    extern int pvm_aerr;
    int bar;

    bar = pvm_aerr;		/* HACK! temp. disable pvm error msgs */
    pvm_aerr = 0;

    if ((foo = snd (name, inst, code)) < 0) {
	if (code == HENCE_DIE && foo == PvmNoComp)
	    ;
	else
	    fprintf (stderr, "snd(%s,%d,%d) failed.  pvm error=%s\n",
		 name, inst, code, pvm_strerror (foo));
    }
    pvm_aerr = bar;
}
#endif /*PVM3*/

#ifdef PVM3
/*
 * implement pvm2-style rcvmulti() function
 */

static int *saved_types;
static int num_saved_types;

static int
rcvmatch (mid, tid, code)
int mid, tid, code;
{
    int i;
    int tag, x;

    if ((x = pvm_bufinfo (mid, (int *) 0, &tag, &tid)) < 0)
	return x;
    for (i = 0; i < num_saved_types; ++i)
	if (saved_types[i] == tag)
	    return 1;
    return 0;
}

retro_rcvmulti (ntypes, types)
int ntypes;
int types[];
{
    int x;
    int (*old)();

    num_saved_types = ntypes;
    saved_types = types;
    old = pvm_recvf (rcvmatch);
    x = pvm_recv (-1, -1);
    pvm_recvf (old);
    return x;
}

int
add_machine (machine)
char *machine;
{
    char *av[2];
    int sv[2];
    int x;

    x = pvm_serror (0);
    av[1] = NULL;
    av[0] = machine;
    if (pvm_addhosts (av, 1, sv) < 0) {
	if (*sv == PvmDupHost)
	    return 0;
	else
	    return *sv;
    }
    pvm_serror (x);
}
#endif
