/*
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/RCS/print.c,v $
 * $Revision: 1.1 $
 * $Date: 1992/04/08 05:53:15 $
 * $Author: moore $
 */

#include <stdio.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

#define fputcv(a, b) (void) fputc(a, b)

static int print_pointers = 0;

set_trace_param_pointers(i)
int i;
{
  print_pointers = i;
}

print_node(n)
Node n;
{
  fprint_node(stdout, n);
}

fprint_node(f, n)
FILE *f;
Node n;
{
  Rb_node r, rp;

  int i;
  fprintf(f, "%s Node %d/%d:\n", node_types[n->node_type], n->id, n->inst);
  if (n->xy.set) {
    fprintf(f, "  x=%d y=%d\n", n->xy.x, n->xy.y);
  }
  if (n->pair != NNULL) {
    fprintf(f, "  pair: %d\n", n->pair->id);
  }
  if (n->scope != NNULL) {
    fprintf(f, "  scope: %d\n", n->scope->id);
  }
  rb_traverse(rp, n->params) {
    Param p;
    Rb_node rp2;
    p = (Param) rp->v.val;
    if (p->io.used) {
      fprintf(f, "  PARAM: ");
      fprint_param(f, p);
      fprintf(f, ";\n");
    } 
    if (p->type == ARRAY) {
      rb_traverse(rp2, p->a->p) {
        fprintf(f, "  PARAM: ");
        fprint_param(f, (Param) rp2->v.val);
        fprintf(f, ";\n");
      }
    }
  }
  switch(n->node_type) {
  case NORMAL:
    fprintf(f, "  CALL: ");
    if (n->ret_param != PNULL) {
      fprint_param(f, n->ret_param);
      fprintf(f, " = ");
    }
    fprintf(f, "%s(", n->sub_name);
    for (i = 0; i < n->nargs; i++) {
      if (i > 0) fprintf(f, ", ");
      fprint_exp(f, n->args[i]);
    }
    fprintf(f, ");\n");
    break;
  case END_COND:
  case END_LOOP:
  case END_PIPE:
  case FANIN:
    break;
  case COND:
    fprintf(f, "  EXPRESSION: ");
    fprint_exp(f, n->args[0]);
    fprintf(f, "\n");
    break;
  case LOOP:
    fprintf(f, "  VAR: ");
    fprint_param(f, n->ret_param);
    fprintf(f, "\n  INIT: ");
    fprint_exp(f, n->args[0]);
    fprintf(f, "\n  EXP:  ");
    fprint_exp(f, n->args[1]);
    fprintf(f, "\n  UPD:  ");
    fprint_exp(f,n->args[2]);
    fprintf(f, "\n");
    break;
  case PIPE:
  case FANOUT:
    fprintf(f, "  VAR: ");
    fprint_param(f,n->ret_param);
    fprintf(f, "\n  LOW: ");
    fprint_exp(f,n->args[0]);
    fprintf(f, "\n  HIGH: ");
    fprint_exp(f,n->args[1]);
    fprintf(f, "\n");
    break;
  default:
    fprintf(stderr, "ERROR: Print_node: Unknown node type: %d\n",
      n->node_type);
    bail(CNULL);
    break;
  }
  fprintf(f, "Parents:");
  rb_traverse(r, n->parents) fprintf(f, " %d/%d", 
              ((Node)r->v.val)->id, ((Node)r->v.val)->inst);
  fprintf(f, "\nChildren:");
  rb_traverse(r, n->children) fprintf(f, " %d/%d", 
              ((Node)r->v.val)->id, ((Node)r->v.val)->inst);
  fprintf(f, "\n\n");
}

fprint_param_brief(f, p)
FILE *f;
Param p;
{
  int i;
  if (print_pointers) fprintf(f, "(0x%x): ", p);
  fprintf(f, "%s", p->name);
  if (p->type == ARRAY) {
    for (i = 0; i < p->a->ndims; i++) {
      if (p->a->dims[i] != ENULL) fprint_exp(f, p->a->dims[i]); 
      else fprintf(f, "[?]"); 
    }
    fprintf(f, "{%d}", p->a->nadims);
  }
}

print_param_brief(p)
Param p;
{
  fprint_param_brief(stdout, p);
}

fprint_type(f, t)
int t;
FILE *f;
{
  if (t == -1) fprintf(f, " INH "); else fprintf(f, " %s ", types[t]);
}

fprint_param(f, p)
FILE *f;
Param p;
{
  int i;

  if (print_pointers) fprintf(f, "(0x%x): ", p);
  if (p->io.new) fprintf(f, "NEW ");
  if (p->io.inj) fprintf(f, "INJ");
  switch(p->io.in + p->io.out) {
    case 0: fprintf(f, " ?"); break;
    case 1: if (p->io.in) fprintf(f, " <"); else fprintf(f, " >"); break;
    case 2: fprintf(f, "<>"); break;
    default: bail("INTERNAL fprint_param error: p->io.in + p->io.out\n");
  }
  if (p->type == ARRAY) {
    fprint_type(f, p->a->type); 
  } else {
    fprint_type(f, p->type);
  }
  fprintf(f, "%s", p->name);
  if (p->type == ARRAY) {
    for (i = 0; i < p->a->ndims; i++) {
      if (p->a->dims[i] == ENULL) fprintf(f, "[?]");
      else fprint_exp(f, p->a->dims[i]); 
    }
    fprintf(f, "{%d}", p->a->nadims);
  }
  if (p->val != ENULL) {
    fprintf(f, " = ");
    fprint_exp(f, p->val);
  }
}

print_param(p)
Param p;
{
  fprint_param(stdout, p);
}

fprint_lbracket(f, nspaces)
FILE *f;
int nspaces;
{
  fputcv('\n', f);
  while(nspaces-- > 0) fputcv(' ', f);
  fprintf(f, "{ ");
}

fprint_rbracket(f, nspaces)
FILE *f;
int nspaces;
{
  fputcv('\n', f);
  while(nspaces-- > 0) fputcv(' ', f);
  fputcv('}', f);
}

fprint_array(f, a)
FILE *f;
Array a;
{
  int i, ind, ok, zero;
  int *ct;

  if (!a->refd.init) return;

  if (a->ndims == 1) {
    fprint_1d(f, a, 0);
  } else {
    if (a->refd.ptr) {
      fprintf(f, "Pointer-referenced array");
      return;
    }
    ct = talloc(int, a->ndims);
    for (i = 0; i < a->ndims; i++) ct[i] = 0;
    ind = 0;
    ok = 1;
    while(ok) {
      zero = 0;
      for(i = a->ndims - 2; i >= 0; i--) {
        if (ct[i] != 0) {
          zero = i;
          i = 0;
        }
      }
      for (i = zero; i < a->ndims - 2; i++) fprint_lbracket(f, i * 2);
      fprint_1d(f, a, ind);
      ind += a->indsize[a->ndims - 2];
      ct[a->ndims - 2] += 1;
      for(i = a->ndims - 2; i > 0 && ct[i] == a->size[i]; i--) {
        fprint_rbracket(f, i * 2);
        ind -= ct[i] * a->indsize[i];
        ct[i] = 0;
        ct[i-1] += 1;
        ind += a->indsize[i - 1];
      }
      if (ct[i] == a->size[i]) {  /* i should = 0 */
        if (i != 0) bail("INT ERROR: fprint_array: i != 0\n");
        fprint_rbracket(f, 0);
        fputcv('\n', f);
        free(ct);
        ok = 0;
      } else fputcv(',', f);
    }              
  }
}

fprint_1d(f, a, ind)
FILE *f;
Array a;
int ind;
{
  int i, sz;

  if (a->type == CHAR) {
    for (i = 0; i < a->ndims; i++) fprintf(f, "  ");
    fprint_string(f, &(a->v.c[ind]));
  } else {
    fprint_lbracket(f, a->ndims*2);
    i = 0;
    sz = 7;
    if (i == sz) {
      fputcv('\n', f);
      /* Indent */
      for (i = 0; i < a->ndims + 1; i++) fprintf(f, "  ");
      sz += 7;
    }
    for (i = 0; i < a->size[a->ndims - 1]; i++) {
      switch(a->type) {
        case INT:    fprintf(f, "%d", a->v.i[ind+i]); break;
        case FLOAT:  fprintf(f, "%f", a->v.f[ind+i]); break;
        case DOUBLE: fprintf(f, "%f", a->v.d[ind+i]); break;
        default: bail("INT ERR: fprint_1d: Bad type\n"); break;
      }
      if (i == a->size[a->ndims - 1] - 1) fprintf(f, " }");
      else fprintf(f, ", ");
    }
  }
}

fprint_string(f, s) 
FILE *f;
char *s;
{
  int i;
  fputcv('"', f);
  for(i = 0; s[i] != '\0'; i++) {
    if (s[i] == '\n') { fputcv('\\', f); fputcv('n', f); }
    else if (s[i] == '\t') { fputcv('\\', f); fputcv('t', f); }
    else if (s[i] == '\b') { fputcv('\\', f); fputcv('b', f); }
    else if (s[i] == '"') { fputcv('\\', f); fputcv('"', f); }
    else if (s[i] == '\\') { fputcv('\\', f); fputcv('\\', f); }
    else fputcv(s[i], f);
  }
  fputcv('"', f);
}


fprint_exp(f, e)
FILE *f;
Exp e;
{
  int lp;
  char *s;

  if (e == ENULL) return;
  switch (e->elt_type) {
  case 'c':
    lp = 0;
    switch(e->type) {
    case INT: fprintf(f, "%d", e->val.i); break;
    case FLOAT: fprintf(f, "%f", e->val.f); break;
    case DOUBLE: fprintf(f, "%lf", e->val.d); break;
    case CHAR: fprintf(f, "%c", e->val.c); break;
    case ARRAY: fprint_array(f, e->val.a); break;
    default: 
      fprintf(stderr, "FPRINT_EXP: unknown 'c' type %d\n", e->type);
      bail(CNULL);
      break;
    }

    break;
  case 'p':
    lp = 0;
    fprintf(f, "%s", e->val.s);
    break;
  case 'T':
    lp = 0;
    fprintf(f, "(%s)", e->val.s);
    break;
  case 'P':
    lp = 0;
    fprint_param_brief(f, e->val.p);
    break;
  case 'M': s = "-";
    lp = 1; fprintf(f, "(");
    fprintf(f, "%s", s);
    fprint_exp(f, e->args[0]);
    break;
  case 'I': s = "*";
    lp = 1; fprintf(f, "(");
    fprintf(f, "%s", s);
    fprint_exp(f, e->args[0]);
    break;
  case 'N': s = "!";
    lp = 1; fprintf(f, "(");
    fprintf(f, "%s", s);
    fprint_exp(f, e->args[0]);
    break;
  case 'C': s = "~";
    lp = 1; fprintf(f, "(");
    fprintf(f, "%s", s);
    fprint_exp(f, e->args[0]);
    break;
  case 'A': s = "&";
    lp = 1; fprintf(f, "(");
    fprintf(f, "%s", s);
    fprint_exp(f, e->args[0]);
    break;
  case '*':
  case '/':
  case '%':
  case '+':
  case '-':
  case '<':
  case '>':
  case '&':
  case '^':
  case '|':
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]);
    fprintf(f, "%c", e->elt_type);
    fprint_exp(f, e->args[1]);
    break;
  case 'L': s = "<<";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case 'R': s = ">>";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case 'l': s = "<=";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case 'g': s = ">=";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case '!': s = "!=";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case '=': s = "==";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case 'a': s = "&&";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case 'o': s = "||";
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]); fprintf(f, "%s", s); fprint_exp(f, e->args[1]);
    break;
  case '?':
    lp = 1; fprintf(f, "(");
    fprint_exp(f, e->args[0]);
    fprintf(f, "?");
    fprint_exp(f, e->args[1]);
    fprintf(f, ":");
    fprint_exp(f, e->args[2]);
    break;
  case '[':
    lp = 0;
    fprintf(f, "[]");
    break;
  case ']':
    lp = 0;
    fprintf(f, "[");
    fprint_exp(f, e->args[0]);
    fprintf(f, "]");
    break;
  case '.':
    lp = 0;
    fprintf(f, "[");
    fprint_exp(f, e->args[0]);
    fprintf(f, " TO ");
    fprint_exp(f, e->args[1]);
    fprintf(f, "]");
    break;
  default:
    fprintf(stderr, "Printing EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }
  if (lp) fprintf(f, ")");
}

print_exp(e)
Exp e;
{
  fprint_exp(stdout, e);
}

print_anc_list(a)
Anc a;
{
  Rb_node r;
  Node n;
  int i;

  i = 7;
  rb_traverse(r, a->order) {
    n = (Node) r->v.val;
    if (i == 0) (void) printf("\n            ");
    (void) printf(" %d:%d/%d", r->k.ikey, n->id, n->inst);
    i = (i + 1) % 7;
  }
  (void) printf("\n");
}

fprint_node_id(f, n) 
FILE *f;
Node n;
{
  if (n == NNULL) return;
  fprintf(f, "%7s Node %d/%d: ", node_types[n->node_type], n->id, n->inst);
}

