/*
 * private red/black tree glarp
 *
 * 19 Sep 1991
 */

struct status {
	unsigned red : 1 ;
	unsigned internal : 1 ;
	unsigned left : 1 ;
	unsigned root : 1 ;
	unsigned head : 1 ;
};

struct rb_node {
	union {
		struct {
			struct rb_node *flink;
			struct rb_node *blink;
		} list;
		struct {
			struct rb_node *left;
			struct rb_node *right;
		} child;
	} c;
	union {
		struct rb_node *parent;
		struct rb_node *root;
	} p;
	struct status s;
	union rb_key k;
	struct rb_node *lext;
	union {
		void *val;
		struct rb_node *rext;
	} v;
};

#define rb_first(n) ((n)->c.list.flink)
#define rb_last(n) ((n)->c.list.blink)
#define rb_next(n) ((n)->c.list.flink)
#define rb_prev(n) ((n)->c.list.blink)
#define rb_empty(t) ((t)->c.list.flink == (t))

#if 0
#define rb_traverse(ptr, lst) \
	for((ptr) = rb_first(lst); (ptr) != (lst); (ptr) = rb_next(ptr))
#endif

/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
