/*
 * Public interface to deal with red/black trees
 *
 * 19 Sep 1991
 */

#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(X) X
#else
#define __(X) ()
#endif

/* The list of key types available */

union rb_key {
	int ikey;
	void *pkey;
	float fkey;
	double dkey;
};

typedef union rb_key Key;

/* XXX change the name to have similar spelling to other data types */

typedef struct rb_node *Tree;
typedef struct rb_node *TreeNode;

/*
 * Create an empty tree
 */

extern Tree rb_MakeTree();  /* sorry, Joyce */

/*
 * Free all storage associated with tree.
 * Does not free keys or values.  To do that it is necessary
 * to call rb_Traverse and free any keys or values associated
 * with each TreeNode before calling rb_FreeTree
 */

extern void rb_FreeTree __((Tree tree));

/*
 * Find node with key equal to or immediately greater than given key
 *
 * There is one find function, rather than separate ones
 * for each data type.  Other modules may build
 * on top of rb, and supply a comparison function.
 *
 * if 'found' is non-NULL, rb_Find returns 1 in the location
 * it points to if the key was matched; otherwise a 0.
 */

extern TreeNode rb_Find __((Tree tree, Key *key, int (*comp)(Key*, Key*),
							int *found));

/*
 * Delete a node in a tree
 * Does not free keys or values.
 */

extern void rb_DeleteNode __((TreeNode tn));

/*
 * Insert a node (key/value pair) in a tree.  Must provide a
 * comparison function for the key.
 */

extern void rb_Insert __((Tree tree, Key *key, void *value,
						  int ((*comp)(Key*, Key*))));

/*
 * Insert a node immediately {before,after} a given one.
 * Does not check to see that the node is in proper order
 */

extern TreeNode rb_InsertBefore __((TreeNode tn, Key *key, void *value));
extern TreeNode rb_InsertAfter __((TreeNode tn, Key *key, void *value));

/*
 * Given a node pointer, extract key or value
 */

extern void *rb_Value __((TreeNode tn));
extern void rb_SetValue __((TreeNode tn, void *v));
extern Key *rb_Key __((TreeNode tn));

/*
 * Traverse a tree in order and call this function for each
 * node.  Stop traversal if function returns nonzero.
 */

extern int rb_Traverse __((Tree t, int (*fn)(TreeNode tn)));
extern int rb_TraverseX __((Tree t, int (*fn)(TreeNode, void *),void *arg));


/*
 * Return number of black nodes on path to external node.
 */

extern int rb_NBlack __((TreeNode t));

/*
 * Return length of path to external node.
 */

extern int rb_PathLen __((TreeNode t));

extern TreeNode rb_First __((TreeNode n));

extern TreeNode rb_Last __((TreeNode n));

extern TreeNode rb_Next __((TreeNode n));

extern TreeNode rb_Prev __((TreeNode n));

extern int rb_Empty __((Tree t));

#undef __

/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
