#include <stdio.h>
#include "rb.h"

/* an example -- this allocates a red-black tree for integers.	For a 
 * user-specified number of iterations, it does the following:

 * delete a random element in the tree.
 * make two new random elements, and insert them into the tree
 
 * At the end, it prints the sorted list of elements, and then prints
 * stats of the number of black nodes in any path in the tree, and 
 * the minimum and maximum path lengths.
	
 */

int ikcomp(i, j)
	Key *i, *j;
{
	return i->ikey - j->ikey;
}

main(argc, argv)
	int argc;
	char **argv;
{
	int i, j, tb, nb, mxp, mnp, p;
	int iterations;	/* how many operations to do */
	Tree argt;		/* the tree */
	TreeNode n;
	Key sk;			/* for searching */
	Key *kp;
	int *a;

	if (argc != 2) {
		fprintf(stderr, "usage: main #iterations\n");
		exit(1);
	}
	iterations = atoi(argv[1]);
	argt = rb_MakeTree();
	srandom(time(0));
	a = (int*)malloc(iterations * sizeof(int));

	for (i = 0; i < iterations; i++) {
		if (i > 0) {
			j = random() % i;
		
			sk.ikey = a[j];
			rb_DeleteNode(rb_Find(argt, &sk, ikcomp, (int*)0));
			a[j] = random() % 1000;
			sk.ikey = a[j];
			rb_Insert(argt, &sk, 0, ikcomp);
		}
		a[i] = random() % 1000;
		sk.ikey = a[i];
		rb_Insert(argt, &sk, 0, ikcomp);
	}

	printf("tree contents:\n");
	tb = 0;
	mxp = mnp = 0;
	for (n = rb_First(argt); n != argt; n = rb_Next(n)) {
		kp = rb_Key(n);
		printf("%4d ", kp->ikey);
		nb = rb_NBlack(n);
		p = rb_PathLen(n);
		if (tb == 0) {
			tb = nb;
		} else if (tb != nb) {
			printf("Conflict: tb=%d, nb=%d\n", tb, nb);
			exit(1);
		}
		if (p > mxp)
			mxp = p;
		if (p = -p, p < mnp)
			mnp = p;
	}
	printf("\n");	
	printf("Nblack = %d\n", tb);
	printf("Max	= %d\n", mxp);
	printf("Min	= %d\n", -mnp);
	exit(0);
}

