#include <stdio.h>
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "misc.h"


/*
 * alloc a new parameter.  If non-NULL, s is the name of the
 * parameter, which will be copied into newly-malloc'ed space.
 * otherwise the caller is expected to malloc space for the
 * name and do the assignment.
 */

Param 
param_New (s)
char *s;
{
	Param p;
	p = talloc (1, struct parameter);
	p->name = (s == (char *) NULL) ? (char *) NULL : strsave (s);
	p->io.in = 0;
	p->io.out = 0;
	p->io.inj = 0;
	p->io.new = 0;
	p->io.main = 0;
	p->io.used = 0;
	p->val = (Expr) NULL;
	p->mirror = p;
	p->state = 0;
	p->type = -1;
	p->num = -1;
	p->a = NULL;
	p->inj = NULL;
#if 0
	p->nodeWhereDeclared = NULL;
#endif
	return p;
}

Parray 
param_NewArrayParams ()
{
	Parray p;
	p = talloc (1, struct param_array);
	p->type = -1;
	p->nadims = 0;
	p->ndims = 0;
	p->dims = (Expr *) 0;
	p->p = (Tree) 0;
	p->n_level2 = 0;
	p->main = (Param) 0;
	return p;
}

void
param_AddArrayDim (p, e)
Parray p;
struct expression *e;
{
	if (p->dims == (Expr *) NULL) {
		p->ndims = 0;
		p->dims = talloc (8,  struct expression *);
		p->ndims = 1;			/* XXX is this right? should it be nadims? */
		p->dims[0] = e;
	}
	else {
		int cur_dims_space = (p->ndims | 0x7) + 1;
		int need_dims_space = ((p->ndims + 1) | 0x7) + 1;

		if (need_dims_space > cur_dims_space)
			p->dims = (Expr *) realloc (p->dims, need_dims_space * sizeof (Expr));
		p->dims[p->ndims++] = e;
	}
}

void
param_Free (p)
Param p;
{
	free (p);
}

void
param_FreeArrayParams (p)
Parray p;
{
	free (p);
}

/*
 * Local Variables:
 * comment-column:32
 * tab-width:4
 * End:
 */
