#include <stdio.h>
#include "misc.h"

char *
strsave (
#if FuncPr
	char *s)
#else
	s)
	char *s;
#endif
{
    char *p;
    int len;
	char *malloc();
	
    if (s == NULL)
	return NULL;
    p = malloc (len = (strlen(s) + 1));
    bcopy (s, p, len);
    return p;
}

#if defined(IMA_SYMM) || defined(IMA_NEXT)
/*
 * getcwd() implemented in terms of getwd().
 */

#include <errno.h>
#include <sys/param.h>

char *
getcwd (buf, size)
char *buf;
int size;
{
	char mybuf[MAXPATHLEN];
	int length;

	if (size <= 0) {
		errno = EINVAL;
		return NULL;
	}
	(void) getwd (mybuf);
	length = strlen (mybuf);

	if (length + 1 > size){
		errno = ERANGE;
		return NULL;
	}
	if (buf == NULL)
		buf = malloc (length + 1);
	if (buf == NULL)
		return NULL;
	strcpy (buf, mybuf);
	return buf;
}
#endif

#if defined(IMA_SYMM) || defined(IMA_RT)
#include <varargs.h>

int
vsprintf (buf, format, args)
char *buf, *format;
va_list args;
{
	FILE f;
	int length;

	f._flag = _IOWRT|_IOSTRG;
	f._ptr = buf;
	f._cnt = 32767;
	length = _doprnt (format, args, &f);
	*(f._ptr) = '\0';
	return (length);
}
#endif

#if defined(IMA_SYMM) || defined(IMA_SUN4) || defined (IMA_SUN3) || defined(IMA_RT)
/*
 * POSIX-style strerror() function
 */

char *
strerror (err)
int err;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char msg[25];

	if (err >= 0 && err < sys_nerr)
		return sys_errlist[err];

	sprintf (msg, "Error %d", err);
	return msg;
}
#endif

#ifdef IMA_HP9K
#include <unistd.h>

int
getdtablesize ()
{
	return sysconf(_SC_OPEN_MAX);
}
#endif


#if defined(IMA_SUN3) || defined(IMA_SUN4) || defined(IMA_RIOS) || \
    defined(IMA_RT) || defined(IMA_HP9K) || defined(IMA_NEXT) || \
	defined(IMA_SGI)
void
setenv (name, value, overwrite)
char *name;
char *value;
int overwrite;
{
	extern char **environ;
	static char **new_environ = NULL;
	int slot;
	int namelen;
	int vallen;
	char *dst;

	if ((namelen = strlen (name)) == 0)
		return;
	if (name[namelen-1] == '=')
		--namelen;

	if (*value == '=')
		++value;
	vallen = strlen (value);

	/*
	 * find name in current environment
	 */
	for (slot = 0; environ[slot] != NULL; ++slot) {
		if ((strncmp (name, environ[slot], namelen) == 0) &&
			(environ[slot][namelen] == '=')) {
			if (overwrite) {
				if (strlen (environ[slot] + namelen + 1) >= vallen) {
					/* enough room there already...just copy over old value */
					strcpy (environ[slot] + namelen + 1, value);
					return;
				}
				else
					goto add_entry;		/* NB:  slot == where to add entry */
			}
			else
				return;
		}
	}
	/*
	 * not found -- allocate new environment and copy
	 * If new_environ is non-NULL, it means we have already alloced an
	 * environment.  If that is the same as the current value of environ,
	 * we know it is from heap space and can use realloc.  Otherwise,
	 * malloc a new one to be sure.
	 */
	if (environ == new_environ) {
		new_environ = (char **) realloc (environ,
										 (slot + 2) * sizeof (char *));
	}
	else {
		new_environ = (char **) malloc ((slot + 2) * sizeof (char *));
		new_environ[slot + 1] = NULL;
		for (slot = 0; environ[slot] != NULL; ++slot)
			new_environ[slot] = strsave (environ[slot]);
	}
	environ = new_environ;
	/* fall through to... */
 add_entry:
	/* allocate enuf space for (NAME + '=' + VALUE + '\0') */
	environ[slot] = (char *) malloc (namelen + 1 + vallen + 1);
	dst = environ[slot];
	while (*name && *name != '=')
		*dst++ = *name++;
	*dst++ = '=';
	while (*dst++ = *value++);
}
#endif


#ifdef IMA_U370
/* horrible hack to get around link errors on atlantis.psu.edu */
struct NLctab *_NLctab;
#endif

/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
