#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include "xincl.h"
#include "xcomn.h"
#include "comn.h"
#include "msg.h"
#include "patchlevel.h"
#include "tilde.h"

#ifndef errno
extern int errno;
#endif

char *hlibs[] = {
#ifdef PVM3
    "libslave3.a", "libhence3.a", "librb.a", "libdl.a", "liballoc.a",
#else
    "libslave.a", "libhence.a", "librb.a", "libdl.a", "liballoc.a",
#endif
};

char *ifiles[] = {
    "dlist.h", "hence.h", "htypes.h", "imalloc.h", "list.h", "rb.h", "std.h",
}

void
checkInstall ()
{
    char buf[1024];
    int i;
    int missing_hlibs = 0;
    int missing_ifile = 0;
    int missing_pvmlib = 0;
    char *applresdir;

    
    applresdir = getenv ("XAPPLRESDIR");
    if (applresdir == NULL)
	applresdir = getenv ("HOME");

    /*
     * make sure include files are installed
     */
    for (i = 0; i < XtNumber (ifiles); ++i) {
	sprintf (buf, "%s/%s", includeDir, ifiles[i]);
	if (stat (buf, &sbuf) < 0) {
	    msg_Format ("WARNING: can't find HeNCE include file %s: %s\n",
			buf, strerror (errno));
	    ++missing_ifile;
	}
    }
    if (missing_ifile) {
	msg_Format ("Either install the HeNCE include files in %s, or\n",
		    henceIncludeDir);
	msg_Format ("change the defintion of htool.includeDir in either\n");
	msg_Format ("%s/htool (preferably) or ~/.Xdefaults\n",
		    applresdir);
	++cant_make_pgms;
    }
    /*
     * make sure HeNCE libraries are installed
     */
    for (i = 0 ; i < XtNumber (hlibs); ++i) {
	sprintf (buf, "%s/%s", henceLibDir, hlibs[i]);
	if (stat (buf, &sbuf) < 0) {
	    msg_Format ("WARNING: can't find HeNCE library %s: %s\n",
			buf, strerror (errno));
	    ++missing_hlibs;
	}
    }
    if (missing_hlib) {
	msg_Format ("Either install the HeNCE libraries in %s, or\n",
		    henceLibDir);
	msg_Format ("change the definition of htool.henceLibDir in either");
	msg_Format ("%s/htool (preferably) or ~/.Xdefaults\n",
		    applresdir);
	++cant_make_pgms;
    }
    /*
     * make sure PVM library is installed
     */
    if (stat (pvmLib, &sbuf) < 0) {
	msg_Format ("WARNING: can't find PVM library %s: %s\n",
		    pvmLib, strerror (errno));
	msg_Format (
#ifdef PVM3
"Either install libpvm.a in %s, or change the definition of htool.pvmlib",
#else
"Either install libpvm.a in %s, or change the definition of htool.pvm3lib",
#endif
		    pvmLib);
	msg_Format ("in either %s/htool (preferably) or ~/.Xdefaults\n",
		    applresdir);
	++cant_make_pgms;
    }
    /*
     * check pvmdExecPath (make sure pvmd exists and is executable)
     */

    must_be_able_to_exec (pvmdExecPath) || cant_run_pgms++;
#if 0
    /*
     * check pvmConsoleExecPath (make sure console exists and is executable)
     */
    must_be_able_to_exec (pvmConsoleExecPath) || cant_run_pgms++;
#endif
    /*
     * check binDir (must exist and be writable)
     */
    if (stat (binDir, &sbuf) < 0) {
	msg_Format ("WARNING: can't find binDir %s: %s\n" binDir,
		    strerror (errno));
	cant_run_pgms++;
    }
    /*
     * make sure "master", "mkwrap", "pvmrsh", and "make"
     * are present somewhere in the PATH
     */
    must_be_able_to_exec (master) || cant_run_pgms++;
    must_be_able_to_exec (make) || cant_make_pgms++;
    must_be_able_to_exec (pvmrsh) || cant_remote_install;
    /*
     * check pvmHostFile (must exist and be readable)
     */
    must_be_able_to_read (pvmHostFile) || cant_run_pgms++;
    /*
     * check iconList
     */
    must_be_able_to_read (pvmHostFile) || cant_show_icons++;
    /*
     * check editorCommand
     */
    must_be_able_to_spawn (editorCommand) || cant_edit_pgms++;
    /*
     * check xtermCommand
     */
    must_be_able_to_spawn (xtermCommand) || cant_run_pgms++;

    if (cant_make_pgms > 0)
	msg_Format ("WARNING: You won't be able to build HeNCE programs.\n");
    if (cant_remote_install > 0) {
	msg_Format ("WARNING: You won't be able to build HeNCE programs.\n");
	msg_Format ("         on remote machines.\n");
    }
    if (cant_run_pgms > 0)
	msg_Format ("WARNING: You won't be able to run HeNCE programs.\n");
    if (cant_edit_pgms > 0)
	msg_Format ("WARNING: You won't be able to edit HeNCE programs.\n");
    if (cant_show_icons > 0)
	msg_Format ("WARNING: When tracing, only the default machine icon will appear.\n");
}
