
/*
*	MatrixP.h - Private Defs for Matrix Widget
*
*	Jul 1991 Robert Manchek  manchek@CS.UTK.EDU.
*/

#ifndef _HgwMatrixP_h
#define _HgwMatrixP_h

#include "Matrix.h"
#include <X11/Xaw/SimpleP.h>


/********************
*  Class Structure  *
*                   *
********************/

typedef struct _MatrixClass {
	int borkbork;  /* not used */
} MatrixClassPart;

/* Full class record declaration */

typedef struct _MatrixClassRec {
	CoreClassPart core_class;
	SimpleClassPart simple_class;
	MatrixClassPart matrix_class;
} MatrixClassRec;

extern MatrixClassRec matrixClassRec;


/***********************
*  Instance structure  *
*                      *
***********************/

typedef struct {

	/* resources */
    Pixel foreground;
    XFontStruct *font;
	XtCallbackList callbacks;
	int rows, cols;			/* matrix size */
	int row_spc;			/* row pixel spacing */
	int col_spc;			/* column pixel spacing */
	int rowoff, coloff;		/* display row, col begin */
	XtPointer base;			/* base address of data */
	Boolean editable;		/* can we touch matrix? */
	Boolean numeric;		/* elements are ints not char*s */

	/* private state */
	GC normal_GC;
	GC inverse_GC;
	int hl_row, hl_col;		/* highlighted row, col */
	int flag;				/* gp */

} MatrixPart;

/* Full widget declaration */

typedef struct _MatrixRec {
    CorePart core;
    SimplePart simple;
    MatrixPart matrix;
} MatrixRec;

#define	IOwnMatrix	1		/* flag that we mallocd the matrix */

#endif /* _HgwMatrixP_h */

