#include <stdio.h>
#include <math.h>
#include "parameters.h"

init(trap, step, beta0, betap, kL, numpoints)
double  *trap, *step;
double  *beta0, *betap, *kL;
int     numpoints;
{
    register int  i;
    double        g0, maxE;

    /* constants */
    *beta0 = sqrt(1.0 - 1.0/(INITENG*INITENG));
    *kL = TWOPI*CAVILEN;
    *betap = *beta0*(1.0 - 2.0*OFFSET/(*kL));
    g0 = *kL/(INITENG*INITENG*INITENG*(*beta0)*(*beta0));
    *trap = 0.5*sepx((*beta0), (*betap));
    maxE = 80.0/g0;
    *step = maxE/(double)numpoints;
}
