#include <math.h>
#include "parameters.h"

double engLost(field, beta0, betap, kL)
double  field, beta0, betap, kL;
{
    register int  i;
    double        gamma[NUMPART], phi[NUMPART];
    double        dphi, gamsum, z, dz;

    /* initialization */
    dphi = TWOPI/(double)NUMPART;
    for (i = 0; i < NUMPART; i++) {
        gamma[i] = gam(beta0);
        phi[i] = i*dphi;
    }

    /* now do the integration */
    dz = STEP;
    for (z = 0.0; z < 1.0; z += dz) {
        for (i = 0; i < NUMPART; i++) {
            gamma[i] -= field*sin(phi[i])*dz;
            phi[i] += kL*(1.0-betap/beta(gamma[i]))*dz;
        }
    }
    gamsum = 0.0;
    for (i = 0; i < NUMPART; i++)
        gamsum += gamma[i];
    return (INITENG-gamsum/(double)NUMPART);
}
