#include <stdio.h>

void
tile (pix, x1, y1, x2, y2, wd, ht)
	double x1, y1, x2, y2;	/* tile corner coords */
	int wd, ht;				/* size of tile */
	char *pix;				/* calculated image */
{
	int ix, iy;				/* loop indices */
	double x, y;			/* pixel coords */
	double ar, ai, a;		/* accums */
	int ite;				/* number of iter until divergence */

	fprintf (stderr, 
		"tile(pix, x1=%f, y1=%f, x2=%f, y2=%f, wd=%d, ht=%d)\n",
		x1, y1, x2, y2, wd, ht);

	if (wd < 1 || wd > 1024 || ht < 1 || ht > 1024) {
		fputs("insane wd/ht\n", stderr);
#ifndef PVM3
		leave();
#endif
		exit(1);
	}
	x2 -= x1;
	y2 -= y1;
	for (iy = 0; iy < ht; iy++) {
		y = (iy * y2) / ht + y1;
		for (ix = 0; ix < wd; ix++) {
			x = (ix * x2) / wd + x1;
			ar = x;
			ai = y;
			for (ite = 0; ite < 255; ite++) {
				a = (ar * ar) + (ai * ai);
				if (a > 4.0) break;
				a = ar * ar - ai * ai;
				ai *= 2 * ar;
				ar = a + x;
				ai += y;
			}
			/* was pix[iy * wd + ht] - fix it back */
			pix[ix * ht + iy] = ~ite;
		}
	}
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
